/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.metrics2.impl;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nullable;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.SubsetConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.metrics2.AbstractMetric;
import org.apache.hadoop.metrics2.MetricsException;
import org.apache.hadoop.metrics2.MetricsInfo;
import org.apache.hadoop.metrics2.MetricsRecord;
import org.apache.hadoop.metrics2.MetricsSink;
import org.apache.hadoop.metrics2.MetricsSource;
import org.apache.hadoop.metrics2.MetricsTag;
import org.apache.hadoop.metrics2.annotation.Metric;
import org.apache.hadoop.metrics2.annotation.Metrics;
import org.apache.hadoop.metrics2.impl.ConfigBuilder;
import org.apache.hadoop.metrics2.impl.MetricGaugeInt;
import org.apache.hadoop.metrics2.impl.MetricsConfig;
import org.apache.hadoop.metrics2.impl.MetricsLists;
import org.apache.hadoop.metrics2.impl.MetricsSystemImpl;
import org.apache.hadoop.metrics2.impl.MsInfo;
import org.apache.hadoop.metrics2.impl.TestMetricsConfig;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.metrics2.lib.Interns;
import org.apache.hadoop.metrics2.lib.MetricsRegistry;
import org.apache.hadoop.metrics2.lib.MutableCounterLong;
import org.apache.hadoop.metrics2.lib.MutableGaugeLong;
import org.apache.hadoop.metrics2.lib.MutableRate;
import org.apache.hadoop.test.MoreAsserts;
import org.apache.hadoop.util.StringUtils;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class TestMetricsSystemImpl {
    private static final Log LOG = LogFactory.getLog(TestMetricsSystemImpl.class);
    @Captor
    private ArgumentCaptor<MetricsRecord> r1;
    @Captor
    private ArgumentCaptor<MetricsRecord> r2;
    private static String hostname;

    @Test
    public void testInitFirstVerifyStopInvokedImmediately() throws Exception {
        DefaultMetricsSystem.shutdown();
        new ConfigBuilder().add("*.period", 8).add("test.sink.test.class", TestSink.class.getName()).add("test.*.source.filter.exclude", "s0").add("test.source.s1.metric.filter.exclude", "X*").add("test.sink.sink1.metric.filter.exclude", "Y*").add("test.sink.sink2.metric.filter.exclude", "Y*").save(TestMetricsConfig.getTestFilename("hadoop-metrics2-test"));
        MetricsSystemImpl ms = new MetricsSystemImpl("Test");
        ms.start();
        ms.register("s0", "s0 desc", (Object)new TestSource("s0rec"));
        TestSource s1 = (TestSource)ms.register("s1", "s1 desc", (Object)new TestSource("s1rec"));
        s1.c1.incr();
        s1.xxx.incr();
        s1.g1.set(2L);
        s1.yyy.incr(2L);
        s1.s1.add(0L);
        MetricsSink sink1 = (MetricsSink)Mockito.mock(MetricsSink.class);
        MetricsSink sink2 = (MetricsSink)Mockito.mock(MetricsSink.class);
        ms.registerSink("sink1", "sink1 desc", sink1);
        ms.registerSink("sink2", "sink2 desc", sink2);
        ms.publishMetricsNow();
        ms.stop();
        ms.shutdown();
        ((MetricsSink)Mockito.verify((Object)sink1, (VerificationMode)Mockito.atMost((int)2))).putMetrics((MetricsRecord)this.r1.capture());
        List mr1 = this.r1.getAllValues();
        ((MetricsSink)Mockito.verify((Object)sink2, (VerificationMode)Mockito.atMost((int)2))).putMetrics((MetricsRecord)this.r2.capture());
        List mr2 = this.r2.getAllValues();
        if (mr1.size() != 0 && mr2.size() != 0) {
            this.checkMetricsRecords(mr1);
            MoreAsserts.assertEquals("output", mr1, mr2);
        } else if (mr1.size() != 0) {
            this.checkMetricsRecords(mr1);
        } else if (mr2.size() != 0) {
            this.checkMetricsRecords(mr2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInitFirstVerifyCallBacks() throws Exception {
        DefaultMetricsSystem.shutdown();
        new ConfigBuilder().add("*.period", 8).add("test.sink.test.class", TestSink.class.getName()).add("test.*.source.filter.exclude", "s0").add("test.source.s1.metric.filter.exclude", "X*").add("test.sink.sink1.metric.filter.exclude", "Y*").add("test.sink.sink2.metric.filter.exclude", "Y*").save(TestMetricsConfig.getTestFilename("hadoop-metrics2-test"));
        MetricsSystemImpl ms = new MetricsSystemImpl("Test");
        ms.start();
        ms.register("s0", "s0 desc", (Object)new TestSource("s0rec"));
        TestSource s1 = (TestSource)ms.register("s1", "s1 desc", (Object)new TestSource("s1rec"));
        s1.c1.incr();
        s1.xxx.incr();
        s1.g1.set(2L);
        s1.yyy.incr(2L);
        s1.s1.add(0L);
        MetricsSink sink1 = (MetricsSink)Mockito.mock(MetricsSink.class);
        MetricsSink sink2 = (MetricsSink)Mockito.mock(MetricsSink.class);
        ms.registerSink("sink1", "sink1 desc", sink1);
        ms.registerSink("sink2", "sink2 desc", sink2);
        ms.publishMetricsNow();
        try {
            ((MetricsSink)Mockito.verify((Object)sink1, (VerificationMode)Mockito.timeout((int)200).times(2))).putMetrics((MetricsRecord)this.r1.capture());
            ((MetricsSink)Mockito.verify((Object)sink2, (VerificationMode)Mockito.timeout((int)200).times(2))).putMetrics((MetricsRecord)this.r2.capture());
        }
        finally {
            ms.stop();
            ms.shutdown();
        }
        List mr1 = this.r1.getAllValues();
        List mr2 = this.r2.getAllValues();
        this.checkMetricsRecords(mr1);
        MoreAsserts.assertEquals("output", mr1, mr2);
    }

    @Test
    public void testMultiThreadedPublish() throws Exception {
        new ConfigBuilder().add("*.period", 80).add("test.sink.Collector.queue.capacity", "20").save(TestMetricsConfig.getTestFilename("hadoop-metrics2-test"));
        final MetricsSystemImpl ms = new MetricsSystemImpl("Test");
        ms.start();
        int numThreads = 10;
        final CollectingSink sink = new CollectingSink(10);
        ms.registerSink("Collector", "Collector of values from all threads.", (MetricsSink)sink);
        final TestSource[] sources = new TestSource[10];
        Thread[] threads = new Thread[10];
        final String[] results = new String[10];
        final CyclicBarrier barrier1 = new CyclicBarrier(10);
        final CyclicBarrier barrier2 = new CyclicBarrier(10);
        for (int i = 0; i < 10; ++i) {
            sources[i] = (TestSource)ms.register("threadSource" + i, "A source of my threaded goodness.", (Object)new TestSource("threadSourceRec" + i));
            threads[i] = new Thread(new Runnable(){

                private boolean safeAwait(int mySource, CyclicBarrier barrier) {
                    try {
                        barrier1.await(2L, TimeUnit.SECONDS);
                    }
                    catch (InterruptedException e) {
                        results[mySource] = "Interrupted";
                        return false;
                    }
                    catch (BrokenBarrierException e) {
                        results[mySource] = "Broken Barrier";
                        return false;
                    }
                    catch (TimeoutException e) {
                        results[mySource] = "Timed out on barrier";
                        return false;
                    }
                    return true;
                }

                @Override
                public void run() {
                    int mySource = Integer.parseInt(Thread.currentThread().getName());
                    if (sink.collected[mySource].get() != 0L) {
                        results[mySource] = "Someone else collected my metric!";
                        return;
                    }
                    if (!this.safeAwait(mySource, barrier1)) {
                        return;
                    }
                    sources[mySource].g1.set(230L);
                    ms.publishMetricsNow();
                    if (!this.safeAwait(mySource, barrier2)) {
                        return;
                    }
                    if (sink.collected[mySource].get() != 230L) {
                        results[mySource] = "Metric not collected!";
                        return;
                    }
                    results[mySource] = "Passed";
                }
            }, "" + i);
        }
        for (Thread t : threads) {
            t.start();
        }
        for (Thread t : threads) {
            t.join();
        }
        Assert.assertEquals((long)0L, (long)ms.droppedPubAll.value());
        Assert.assertTrue((String)StringUtils.join((CharSequence)"\n", Arrays.asList(results)), (boolean)Iterables.all(Arrays.asList(results), (Predicate)new Predicate<String>(){

            public boolean apply(@Nullable String input) {
                return input.equalsIgnoreCase("Passed");
            }
        }));
        ms.stop();
        ms.shutdown();
    }

    @Test
    public void testHangingSink() {
        new ConfigBuilder().add("*.period", 8).add("test.sink.test.class", TestSink.class.getName()).add("test.sink.hanging.retry.delay", "1").add("test.sink.hanging.retry.backoff", "1.01").add("test.sink.hanging.retry.count", "0").save(TestMetricsConfig.getTestFilename("hadoop-metrics2-test"));
        MetricsSystemImpl ms = new MetricsSystemImpl("Test");
        ms.start();
        TestSource s = (TestSource)ms.register("s3", "s3 desc", (Object)new TestSource("s3rec"));
        s.c1.incr();
        HangingSink hanging = new HangingSink();
        ms.registerSink("hanging", "Hang the sink!", (MetricsSink)hanging);
        ms.publishMetricsNow();
        Assert.assertEquals((long)1L, (long)ms.droppedPubAll.value());
        Assert.assertFalse((boolean)hanging.getInterrupted());
        ms.stop();
        ms.shutdown();
        Assert.assertTrue((boolean)hanging.getInterrupted());
        Assert.assertTrue((String)"The sink didn't get called after its first hang for subsequent records.", (boolean)hanging.getGotCalledSecondTime());
    }

    @Test
    public void testRegisterDups() {
        MetricsSystemImpl ms = new MetricsSystemImpl();
        TestSource ts1 = new TestSource("ts1");
        TestSource ts2 = new TestSource("ts2");
        ms.register("ts1", "", (Object)ts1);
        MetricsSource s1 = ms.getSource("ts1");
        Assert.assertNotNull((Object)s1);
        ms.register("ts1", "", (Object)ts2);
        MetricsSource s2 = ms.getSource("ts1");
        Assert.assertNotNull((Object)s2);
        Assert.assertNotSame((Object)s1, (Object)s2);
        ms.shutdown();
    }

    @Test(expected=MetricsException.class)
    public void testRegisterDupError() {
        MetricsSystemImpl ms = new MetricsSystemImpl("test");
        TestSource ts = new TestSource("ts");
        ms.register((Object)ts);
        ms.register((Object)ts);
    }

    private void checkMetricsRecords(List<MetricsRecord> recs) {
        LOG.debug(recs);
        MetricsRecord r = recs.get(0);
        Assert.assertEquals((String)"name", (Object)"s1rec", (Object)r.name());
        MoreAsserts.assertEquals("tags", new MetricsTag[]{Interns.tag((MetricsInfo)MsInfo.Context, (String)"test"), Interns.tag((MetricsInfo)MsInfo.Hostname, (String)hostname)}, r.tags());
        MoreAsserts.assertEquals("metrics", MetricsLists.builder("").addCounter(Interns.info((String)"C1", (String)"C1 desc"), 1L).addGauge(Interns.info((String)"G1", (String)"G1 desc"), 2L).addCounter(Interns.info((String)"S1NumOps", (String)"Number of ops for s1"), 1L).addGauge(Interns.info((String)"S1AvgTime", (String)"Average time for s1"), 0.0).metrics(), r.metrics());
        r = recs.get(1);
        Assert.assertTrue((String)"NumActiveSinks should be 3", (boolean)Iterables.contains((Iterable)r.metrics(), (Object)new MetricGaugeInt((MetricsInfo)MsInfo.NumActiveSinks, 3)));
    }

    private static String getPluginUrlsAsString() {
        return "file:metrics2-test-plugin.jar";
    }

    static {
        DefaultMetricsSystem.setMiniClusterMode((boolean)true);
        hostname = MetricsSystemImpl.getHostname();
    }

    @Metrics(context="test")
    private static class TestSource {
        @Metric(value={"C1 desc"})
        MutableCounterLong c1;
        @Metric(value={"XXX desc"})
        MutableCounterLong xxx;
        @Metric(value={"G1 desc"})
        MutableGaugeLong g1;
        @Metric(value={"YYY desc"})
        MutableGaugeLong yyy;
        @Metric
        MutableRate s1;
        final MetricsRegistry registry;

        TestSource(String recName) {
            this.registry = new MetricsRegistry(recName);
        }
    }

    private static class HangingSink
    implements MetricsSink {
        private volatile boolean interrupted;
        private boolean gotCalledSecondTime;
        private boolean firstTime = true;

        private HangingSink() {
        }

        public boolean getGotCalledSecondTime() {
            return this.gotCalledSecondTime;
        }

        public boolean getInterrupted() {
            return this.interrupted;
        }

        public void init(SubsetConfiguration conf) {
        }

        public void putMetrics(MetricsRecord record) {
            if (!this.firstTime) {
                this.gotCalledSecondTime = true;
                return;
            }
            this.firstTime = false;
            try {
                Thread.sleep(10000L);
            }
            catch (InterruptedException ex) {
                this.interrupted = true;
            }
        }

        public void flush() {
        }
    }

    private static class CollectingSink
    implements MetricsSink {
        private final AtomicLong[] collected;

        public CollectingSink(int capacity) {
            this.collected = new AtomicLong[capacity];
            for (int i = 0; i < capacity; ++i) {
                this.collected[i] = new AtomicLong();
            }
        }

        public void init(SubsetConfiguration conf) {
        }

        public void putMetrics(MetricsRecord record) {
            String prefix = "threadSourceRec";
            if (record.name().startsWith("threadSourceRec")) {
                int recordNumber = Integer.parseInt(record.name().substring("threadSourceRec".length()));
                ArrayList<String> names = new ArrayList<String>();
                for (AbstractMetric m : record.metrics()) {
                    if (m.name().equalsIgnoreCase("g1")) {
                        this.collected[recordNumber].set(m.value().longValue());
                        return;
                    }
                    names.add(m.name());
                }
            }
        }

        public void flush() {
        }
    }

    public static class TestSink
    implements MetricsSink {
        public void putMetrics(MetricsRecord record) {
            LOG.debug((Object)record);
        }

        public void flush() {
        }

        public void init(SubsetConfiguration conf) {
            LOG.debug((Object)MetricsConfig.toString((Configuration)conf));
        }
    }
}

