/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.util.Arrays;
import org.apache.commons.logging.impl.Log4JLogger;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.FileContextTestHelper;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.util.StringUtils;
import org.apache.log4j.Level;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public abstract class FileContextUtilBase {
    protected final FileContextTestHelper fileContextTestHelper = new FileContextTestHelper();
    protected FileContext fc;

    public FileContextUtilBase() {
        try {
            ((Log4JLogger)FileSystem.LOG).getLogger().setLevel(Level.DEBUG);
        }
        catch (Exception e) {
            System.out.println("Cannot change log level\n" + StringUtils.stringifyException((Throwable)e));
        }
    }

    @Before
    public void setUp() throws Exception {
        this.fc.mkdir(this.fileContextTestHelper.getTestRootPath(this.fc), FileContext.DEFAULT_PERM, true);
    }

    @After
    public void tearDown() throws Exception {
        this.fc.delete(this.fileContextTestHelper.getTestRootPath(this.fc), true);
    }

    @Test
    public void testFcCopy() throws Exception {
        String ts = "some random text";
        Path file1 = this.fileContextTestHelper.getTestRootPath(this.fc, "file1");
        Path file2 = this.fileContextTestHelper.getTestRootPath(this.fc, "file2");
        FileContextTestHelper.writeFile(this.fc, file1, "some random text".getBytes());
        Assert.assertTrue((boolean)this.fc.util().exists(file1));
        this.fc.util().copy(file1, file2);
        Assert.assertTrue((String)"Failed to copy file2  ", (boolean)this.fc.util().exists(file2));
        Assert.assertTrue((String)"Copied files does not match ", (boolean)Arrays.equals("some random text".getBytes(), FileContextTestHelper.readFile(this.fc, file2, "some random text".getBytes().length)));
    }

    @Test
    public void testRecursiveFcCopy() throws Exception {
        String ts = "some random text";
        Path dir1 = this.fileContextTestHelper.getTestRootPath(this.fc, "dir1");
        Path dir2 = this.fileContextTestHelper.getTestRootPath(this.fc, "dir2");
        Path file1 = new Path(dir1, "file1");
        this.fc.mkdir(dir1, null, false);
        FileContextTestHelper.writeFile(this.fc, file1, "some random text".getBytes());
        Assert.assertTrue((boolean)this.fc.util().exists(file1));
        Path file2 = new Path(dir2, "file1");
        this.fc.util().copy(dir1, dir2);
        Assert.assertTrue((String)"Failed to copy file2  ", (boolean)this.fc.util().exists(file2));
        Assert.assertTrue((String)"Copied files does not match ", (boolean)Arrays.equals("some random text".getBytes(), FileContextTestHelper.readFile(this.fc, file2, "some random text".getBytes().length)));
    }
}

