/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security.authentication.server;

import java.io.File;
import java.io.IOException;
import java.security.PrivilegedActionException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Pattern;
import javax.security.auth.Subject;
import javax.security.auth.kerberos.KerberosPrincipal;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.binary.Base64;
import org.apache.hadoop.security.authentication.client.AuthenticationException;
import org.apache.hadoop.security.authentication.server.AuthenticationHandler;
import org.apache.hadoop.security.authentication.server.AuthenticationToken;
import org.apache.hadoop.security.authentication.server.KerberosAuthenticationHandler;
import org.apache.hadoop.security.authentication.util.KerberosName;
import org.apache.hadoop.security.authentication.util.KerberosUtil;
import org.ietf.jgss.GSSManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KerberosAuthenticationHandler
implements AuthenticationHandler {
    private static Logger LOG = LoggerFactory.getLogger(KerberosAuthenticationHandler.class);
    public static final String TYPE = "kerberos";
    public static final String PRINCIPAL = "kerberos.principal";
    public static final String KEYTAB = "kerberos.keytab";
    public static final String NAME_RULES = "kerberos.name.rules";
    private String keytab;
    private GSSManager gssManager;
    private Subject serverSubject = new Subject();
    private List<LoginContext> loginContexts = new ArrayList();

    public void init(Properties config) throws ServletException {
        try {
            String nameRules;
            String[] spnegoPrincipals;
            String principal = config.getProperty(PRINCIPAL);
            if (principal == null || principal.trim().length() == 0) {
                throw new ServletException("Principal not defined in configuration");
            }
            this.keytab = config.getProperty(KEYTAB, this.keytab);
            if (this.keytab == null || this.keytab.trim().length() == 0) {
                throw new ServletException("Keytab not defined in configuration");
            }
            if (!new File(this.keytab).exists()) {
                throw new ServletException("Keytab does not exist: " + this.keytab);
            }
            if (principal.equals("*")) {
                spnegoPrincipals = KerberosUtil.getPrincipalNames((String)this.keytab, (Pattern)Pattern.compile("HTTP/.*"));
                if (spnegoPrincipals.length == 0) {
                    throw new ServletException("Principals do not exist in the keytab");
                }
            } else {
                spnegoPrincipals = new String[]{principal};
            }
            if ((nameRules = config.getProperty(NAME_RULES, null)) != null) {
                KerberosName.setRules((String)nameRules);
            }
            for (String spnegoPrincipal : spnegoPrincipals) {
                LOG.info("Login using keytab {}, for principal {}", (Object)this.keytab, (Object)spnegoPrincipal);
                KerberosConfiguration kerberosConfiguration = new KerberosConfiguration(this.keytab, spnegoPrincipal);
                LoginContext loginContext = new LoginContext("", this.serverSubject, null, (Configuration)kerberosConfiguration);
                try {
                    loginContext.login();
                }
                catch (LoginException le) {
                    LOG.warn("Failed to login as [{}]", (Object)spnegoPrincipal, (Object)le);
                    throw new AuthenticationException((Throwable)le);
                }
                this.loginContexts.add(loginContext);
            }
            try {
                this.gssManager = (GSSManager)Subject.doAs(this.serverSubject, new /* Unavailable Anonymous Inner Class!! */);
            }
            catch (PrivilegedActionException ex) {
                throw ex.getException();
            }
        }
        catch (Exception ex) {
            KerberosUtil.checkJCEKeyStrength();
            throw new ServletException((Throwable)ex);
        }
    }

    public void destroy() {
        this.keytab = null;
        this.serverSubject = null;
        for (LoginContext loginContext : this.loginContexts) {
            try {
                loginContext.logout();
            }
            catch (LoginException ex) {
                LOG.warn(ex.getMessage(), (Throwable)ex);
            }
        }
        this.loginContexts.clear();
    }

    public String getType() {
        return TYPE;
    }

    protected Set<KerberosPrincipal> getPrincipals() {
        return this.serverSubject.getPrincipals(KerberosPrincipal.class);
    }

    protected String getKeytab() {
        return this.keytab;
    }

    public boolean managementOperation(AuthenticationToken token, HttpServletRequest request, HttpServletResponse response) throws IOException, AuthenticationException {
        return true;
    }

    public AuthenticationToken authenticate(HttpServletRequest request, HttpServletResponse response) throws IOException, AuthenticationException {
        AuthenticationToken token = null;
        String authorization = request.getHeader("Authorization");
        if (authorization == null || !authorization.startsWith("Negotiate")) {
            response.setHeader("WWW-Authenticate", "Negotiate");
            response.setStatus(401);
            if (authorization == null) {
                LOG.trace("SPNEGO starting");
            } else {
                LOG.warn("'Authorization' does not start with 'Negotiate' :  {}", (Object)authorization);
            }
        } else {
            authorization = authorization.substring("Negotiate".length()).trim();
            Base64 base64 = new Base64(0);
            byte[] clientToken = base64.decode(authorization);
            String serverName = request.getServerName();
            try {
                token = (AuthenticationToken)Subject.doAs(this.serverSubject, new /* Unavailable Anonymous Inner Class!! */);
            }
            catch (PrivilegedActionException ex) {
                if (ex.getException() instanceof IOException) {
                    throw (IOException)ex.getException();
                }
                throw new AuthenticationException((Throwable)ex.getException());
            }
        }
        return token;
    }

    static /* synthetic */ Logger access$000() {
        return LOG;
    }

    static /* synthetic */ GSSManager access$100(KerberosAuthenticationHandler x0) {
        return x0.gssManager;
    }
}

