/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security.authentication.server;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.Principal;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Random;
import java.util.TimeZone;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.security.authentication.client.AuthenticationException;
import org.apache.hadoop.security.authentication.server.AuthenticationHandler;
import org.apache.hadoop.security.authentication.server.AuthenticationToken;
import org.apache.hadoop.security.authentication.server.CookieSignatureSecretFactory;
import org.apache.hadoop.security.authentication.server.KerberosAuthenticationHandler;
import org.apache.hadoop.security.authentication.server.PseudoAuthenticationHandler;
import org.apache.hadoop.security.authentication.util.Signer;
import org.apache.hadoop.security.authentication.util.SignerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class AuthenticationFilter
implements Filter {
    private static Logger LOG = LoggerFactory.getLogger(AuthenticationFilter.class);
    public static final String CONFIG_PREFIX = "config.prefix";
    public static final String DEFAULT_CONFIG_PREFIX_VALUE = "hadoop.http.authentication.";
    public static final String AUTH_TYPE = "type";
    public static final String SIGNATURE_SECRET = "signature.secret";
    public static final String AUTH_TOKEN_VALIDITY = "token.validity";
    public static final String COOKIE_DOMAIN = "cookie.domain";
    public static final String COOKIE_PATH = "cookie.path";
    private static final Random RAN = new Random();
    private Signer signer;
    private AuthenticationHandler authHandler;
    private boolean randomSecret;
    private long validity;
    private String cookieDomain;
    private String cookiePath;
    protected String configPrefix;

    public void init(FilterConfig filterConfig) throws ServletException {
        this.configPrefix = filterConfig.getInitParameter(CONFIG_PREFIX);
        this.configPrefix = this.configPrefix != null ? this.configPrefix + "." : DEFAULT_CONFIG_PREFIX_VALUE;
        Properties config = this.getConfiguration(this.configPrefix, filterConfig);
        String authHandlerName = config.getProperty(AUTH_TYPE, null);
        if (authHandlerName == null) {
            throw new ServletException("Authentication type must be specified: simple|kerberos|<class>");
        }
        String authHandlerClassName = authHandlerName.equals("simple") ? PseudoAuthenticationHandler.class.getName() : (authHandlerName.equals("kerberos") ? KerberosAuthenticationHandler.class.getName() : authHandlerName);
        try {
            Class<?> klass = Thread.currentThread().getContextClassLoader().loadClass(authHandlerClassName);
            this.authHandler = (AuthenticationHandler)klass.newInstance();
            this.authHandler.init(config);
        }
        catch (ClassNotFoundException ex) {
            throw new ServletException((Throwable)ex);
        }
        catch (InstantiationException ex) {
            throw new ServletException((Throwable)ex);
        }
        catch (IllegalAccessException ex) {
            throw new ServletException((Throwable)ex);
        }
        String signatureSecret = config.getProperty(SIGNATURE_SECRET);
        if (signatureSecret != null) {
            try {
                Class<?> signatureFactoryClass = Thread.currentThread().getContextClassLoader().loadClass(signatureSecret);
                Object signatureFactory = signatureFactoryClass.newInstance();
                if (!(signatureFactory instanceof CookieSignatureSecretFactory)) {
                    throw new ServletException("The cookie signature secret factory class should implement " + CookieSignatureSecretFactory.class.getName() + " interface");
                }
                signatureSecret = ((CookieSignatureSecretFactory)signatureFactory).getSignatureSecret();
            }
            catch (ClassNotFoundException e) {
                if (signatureSecret != null) {
                    LOG.warn("'signature.secret' configuration was set to " + signatureSecret + ". But no class with that name was found in the classpath. " + "Will use it as is to sign the hadoop auth cookie.");
                }
            }
            catch (InstantiationException e) {
            }
            catch (IllegalAccessException e) {
                // empty catch block
            }
        }
        if (signatureSecret == null) {
            signatureSecret = Long.toString(RAN.nextLong());
            this.randomSecret = true;
            LOG.warn("'signature.secret' configuration not set, using a random value as secret");
        }
        this.signer = new Signer(signatureSecret.getBytes());
        this.validity = Long.parseLong(config.getProperty(AUTH_TOKEN_VALIDITY, "36000")) * 1000L;
        String domainName = null;
        try {
            InetAddress localHost = InetAddress.getLocalHost();
            String fqdn = localHost.getCanonicalHostName();
            if (fqdn != null && !fqdn.isEmpty() && fqdn.contains(".")) {
                domainName = fqdn.substring(fqdn.indexOf("."));
            }
        }
        catch (UnknownHostException e) {
            // empty catch block
        }
        this.cookieDomain = config.getProperty(COOKIE_DOMAIN, domainName);
        this.cookiePath = config.getProperty(COOKIE_PATH, "/");
    }

    protected AuthenticationHandler getAuthenticationHandler() {
        return this.authHandler;
    }

    protected boolean isRandomSecret() {
        return this.randomSecret;
    }

    protected long getValidity() {
        return this.validity / 1000L;
    }

    protected String getCookieDomain() {
        return this.cookieDomain;
    }

    protected String getCookiePath() {
        return this.cookiePath;
    }

    public void destroy() {
        if (this.authHandler != null) {
            this.authHandler.destroy();
            this.authHandler = null;
        }
    }

    protected Properties getConfiguration(String configPrefix, FilterConfig filterConfig) throws ServletException {
        Properties props = new Properties();
        Enumeration names = filterConfig.getInitParameterNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            if (!name.startsWith(configPrefix)) continue;
            String value = filterConfig.getInitParameter(name);
            props.put(name.substring(configPrefix.length()), value);
        }
        return props;
    }

    protected String getRequestURL(HttpServletRequest request) {
        StringBuffer sb = request.getRequestURL();
        if (request.getQueryString() != null) {
            sb.append("?").append(request.getQueryString());
        }
        return sb.toString();
    }

    protected AuthenticationToken getToken(HttpServletRequest request) throws IOException, AuthenticationException {
        AuthenticationToken token = null;
        String tokenStr = null;
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!cookie.getName().equals("hadoop.auth")) continue;
                tokenStr = cookie.getValue();
                try {
                    tokenStr = this.signer.verifyAndExtract(tokenStr);
                    break;
                }
                catch (SignerException ex) {
                    throw new AuthenticationException(ex);
                }
            }
        }
        if (tokenStr != null) {
            token = AuthenticationToken.parse(tokenStr);
            if (!token.getType().equals(this.authHandler.getType())) {
                throw new AuthenticationException("Invalid AuthenticationToken type");
            }
            if (token.isExpired()) {
                throw new AuthenticationException("AuthenticationToken expired");
            }
        }
        return token;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        boolean unauthorizedResponse = true;
        int errCode = 401;
        AuthenticationException authenticationEx = null;
        Object httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        boolean isHttps = "https".equals(httpRequest.getScheme());
        try {
            AuthenticationToken token;
            boolean newToken = false;
            try {
                token = this.getToken((HttpServletRequest)httpRequest);
            }
            catch (AuthenticationException ex) {
                LOG.warn("AuthenticationToken ignored: " + ex.getMessage());
                authenticationEx = ex;
                token = null;
            }
            if (this.authHandler.managementOperation(token, (HttpServletRequest)httpRequest, httpResponse)) {
                if (token == null) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Request [{}] triggering authentication", (Object)this.getRequestURL((HttpServletRequest)httpRequest));
                    }
                    if ((token = this.authHandler.authenticate((HttpServletRequest)httpRequest, httpResponse)) != null && token.getExpires() != 0L && token != AuthenticationToken.ANONYMOUS) {
                        token.setExpires(System.currentTimeMillis() + this.getValidity() * 1000L);
                    }
                    newToken = true;
                }
                if (token != null) {
                    unauthorizedResponse = false;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Request [{}] user [{}] authenticated", (Object)this.getRequestURL((HttpServletRequest)httpRequest), (Object)token.getUserName());
                    }
                    final AuthenticationToken authToken = token;
                    httpRequest = new HttpServletRequestWrapper((HttpServletRequest)httpRequest){

                        public String getAuthType() {
                            return authToken.getType();
                        }

                        public String getRemoteUser() {
                            return authToken.getUserName();
                        }

                        public Principal getUserPrincipal() {
                            return authToken != AuthenticationToken.ANONYMOUS ? authToken : null;
                        }
                    };
                    if (newToken && !token.isExpired() && token != AuthenticationToken.ANONYMOUS) {
                        String signedToken = this.signer.sign(token.toString());
                        AuthenticationFilter.createAuthCookie(httpResponse, signedToken, this.getCookieDomain(), this.getCookiePath(), token.getExpires(), isHttps);
                    }
                    filterChain.doFilter((ServletRequest)httpRequest, (ServletResponse)httpResponse);
                }
            } else {
                unauthorizedResponse = false;
            }
        }
        catch (AuthenticationException ex) {
            errCode = 403;
            authenticationEx = ex;
            LOG.warn("Authentication exception: " + ex.getMessage(), (Throwable)ex);
        }
        if (unauthorizedResponse && !httpResponse.isCommitted()) {
            AuthenticationFilter.createAuthCookie(httpResponse, "", this.getCookieDomain(), this.getCookiePath(), 0L, isHttps);
            if (authenticationEx == null) {
                httpResponse.sendError(errCode, "Authentication required");
            } else {
                httpResponse.sendError(errCode, authenticationEx.getMessage());
            }
        }
    }

    public static void createAuthCookie(HttpServletResponse resp, String token, String domain, String path, long expires, boolean isSecure) {
        StringBuilder sb = new StringBuilder("hadoop.auth").append("=").append(token);
        if (path != null) {
            sb.append("; Path=").append(path);
        }
        if (domain != null) {
            sb.append("; Domain=").append(domain);
        }
        if (expires >= 0L) {
            Date date = new Date(expires);
            SimpleDateFormat df = new SimpleDateFormat("EEE, dd-MMM-yyyy HH:mm:ss zzz");
            df.setTimeZone(TimeZone.getTimeZone("GMT"));
            sb.append("; Expires=").append(df.format(date));
        }
        if (isSecure) {
            sb.append("; Secure");
        }
        sb.append("; HttpOnly");
        resp.addHeader("Set-Cookie", sb.toString());
    }
}

