/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security.authentication.server;

import java.io.File;
import java.io.IOException;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Properties;
import javax.security.auth.Subject;
import javax.security.auth.kerberos.KerberosPrincipal;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.binary.Base64;
import org.apache.hadoop.security.authentication.client.AuthenticationException;
import org.apache.hadoop.security.authentication.server.AuthenticationHandler;
import org.apache.hadoop.security.authentication.server.AuthenticationToken;
import org.apache.hadoop.security.authentication.util.KerberosName;
import org.apache.hadoop.security.authentication.util.KerberosUtil;
import org.apache.hadoop.util.PlatformName;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.Oid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KerberosAuthenticationHandler
implements AuthenticationHandler {
    private static Logger LOG = LoggerFactory.getLogger(KerberosAuthenticationHandler.class);
    public static final String TYPE = "kerberos";
    public static final String PRINCIPAL = "kerberos.principal";
    public static final String KEYTAB = "kerberos.keytab";
    public static final String NAME_RULES = "kerberos.name.rules";
    private String principal;
    private String keytab;
    private GSSManager gssManager;
    private LoginContext loginContext;

    @Override
    public void init(Properties config) throws ServletException {
        try {
            this.principal = config.getProperty(PRINCIPAL, this.principal);
            if (this.principal == null || this.principal.trim().length() == 0) {
                throw new ServletException("Principal not defined in configuration");
            }
            this.keytab = config.getProperty(KEYTAB, this.keytab);
            if (this.keytab == null || this.keytab.trim().length() == 0) {
                throw new ServletException("Keytab not defined in configuration");
            }
            if (!new File(this.keytab).exists()) {
                throw new ServletException("Keytab does not exist: " + this.keytab);
            }
            String nameRules = config.getProperty(NAME_RULES, null);
            if (nameRules != null) {
                KerberosName.setRules(nameRules);
            }
            HashSet<KerberosPrincipal> principals = new HashSet<KerberosPrincipal>();
            principals.add(new KerberosPrincipal(this.principal));
            Subject subject = new Subject(false, principals, new HashSet(), new HashSet());
            KerberosConfiguration kerberosConfiguration = new KerberosConfiguration(this.keytab, this.principal);
            LOG.info("Login using keytab " + this.keytab + ", for principal " + this.principal);
            this.loginContext = new LoginContext("", subject, null, kerberosConfiguration);
            this.loginContext.login();
            Subject serverSubject = this.loginContext.getSubject();
            try {
                this.gssManager = Subject.doAs(serverSubject, new PrivilegedExceptionAction<GSSManager>(){

                    @Override
                    public GSSManager run() throws Exception {
                        return GSSManager.getInstance();
                    }
                });
            }
            catch (PrivilegedActionException ex) {
                throw ex.getException();
            }
            LOG.info("Initialized, principal [{}] from keytab [{}]", (Object)this.principal, (Object)this.keytab);
        }
        catch (Exception ex) {
            KerberosUtil.checkJCEKeyStrength();
            throw new ServletException((Throwable)ex);
        }
    }

    @Override
    public void destroy() {
        try {
            if (this.loginContext != null) {
                this.loginContext.logout();
                this.loginContext = null;
            }
        }
        catch (LoginException ex) {
            LOG.warn(ex.getMessage(), (Throwable)ex);
        }
    }

    @Override
    public String getType() {
        return TYPE;
    }

    protected String getPrincipal() {
        return this.principal;
    }

    protected String getKeytab() {
        return this.keytab;
    }

    @Override
    public boolean managementOperation(AuthenticationToken token, HttpServletRequest request, HttpServletResponse response) throws IOException, AuthenticationException {
        return true;
    }

    @Override
    public AuthenticationToken authenticate(HttpServletRequest request, final HttpServletResponse response) throws IOException, AuthenticationException {
        AuthenticationToken token = null;
        String authorization = request.getHeader("Authorization");
        if (authorization == null || !authorization.startsWith("Negotiate")) {
            response.setHeader("WWW-Authenticate", "Negotiate");
            response.setStatus(401);
            if (authorization == null) {
                LOG.trace("SPNEGO starting");
            } else {
                LOG.warn("'Authorization' does not start with 'Negotiate' :  {}", (Object)authorization);
            }
        } else {
            authorization = authorization.substring("Negotiate".length()).trim();
            final Base64 base64 = new Base64(0);
            final byte[] clientToken = base64.decode(authorization);
            Subject serverSubject = this.loginContext.getSubject();
            try {
                token = Subject.doAs(serverSubject, new PrivilegedExceptionAction<AuthenticationToken>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public AuthenticationToken run() throws Exception {
                        AuthenticationToken token = null;
                        GSSContext gssContext = null;
                        GSSCredential gssCreds = null;
                        try {
                            byte[] serverToken;
                            if (PlatformName.IBM_JAVA) {
                                gssCreds = KerberosAuthenticationHandler.this.gssManager.createCredential(null, Integer.MAX_VALUE, new Oid[]{KerberosUtil.getOidInstance("GSS_SPNEGO_MECH_OID"), KerberosUtil.getOidInstance("GSS_KRB5_MECH_OID")}, 2);
                            }
                            if ((serverToken = (gssContext = KerberosAuthenticationHandler.this.gssManager.createContext(gssCreds)).acceptSecContext(clientToken, 0, clientToken.length)) != null && serverToken.length > 0) {
                                String authenticate = base64.encodeToString(serverToken);
                                response.setHeader("WWW-Authenticate", "Negotiate " + authenticate);
                            }
                            if (!gssContext.isEstablished()) {
                                response.setStatus(401);
                                LOG.trace("SPNEGO in progress");
                            } else {
                                String clientPrincipal = gssContext.getSrcName().toString();
                                KerberosName kerberosName = new KerberosName(clientPrincipal);
                                String userName = kerberosName.getShortName();
                                token = new AuthenticationToken(userName, clientPrincipal, KerberosAuthenticationHandler.this.getType());
                                response.setStatus(200);
                                LOG.trace("SPNEGO completed for principal [{}]", (Object)clientPrincipal);
                            }
                        }
                        finally {
                            if (gssContext != null) {
                                gssContext.dispose();
                            }
                            if (gssCreds != null) {
                                gssCreds.dispose();
                            }
                        }
                        return token;
                    }
                });
            }
            catch (PrivilegedActionException ex) {
                if (ex.getException() instanceof IOException) {
                    throw (IOException)ex.getException();
                }
                throw new AuthenticationException(ex.getException());
            }
        }
        return token;
    }

    private static class KerberosConfiguration
    extends Configuration {
        private String keytab;
        private String principal;

        public KerberosConfiguration(String keytab, String principal) {
            this.keytab = keytab;
            this.principal = principal;
        }

        @Override
        public AppConfigurationEntry[] getAppConfigurationEntry(String name) {
            HashMap<String, String> options = new HashMap<String, String>();
            if (PlatformName.IBM_JAVA) {
                options.put("useKeytab", this.keytab.startsWith("file://") ? this.keytab : "file://" + this.keytab);
                options.put("principal", this.principal);
                options.put("credsType", "acceptor");
            } else {
                options.put("keyTab", this.keytab);
                options.put("principal", this.principal);
                options.put("useKeyTab", "true");
                options.put("storeKey", "true");
                options.put("doNotPrompt", "true");
                options.put("useTicketCache", "true");
                options.put("renewTGT", "true");
                options.put("isInitiator", "false");
            }
            options.put("refreshKrb5Config", "true");
            String ticketCache = System.getenv("KRB5CCNAME");
            if (ticketCache != null) {
                if (PlatformName.IBM_JAVA) {
                    options.put("useDefaultCcache", "true");
                    System.setProperty("KRB5CCNAME", ticketCache);
                    options.put("renewTGT", "true");
                    options.put("credsType", "both");
                } else {
                    options.put("ticketCache", ticketCache);
                }
            }
            if (LOG.isDebugEnabled()) {
                options.put("debug", "true");
            }
            return new AppConfigurationEntry[]{new AppConfigurationEntry(KerberosUtil.getKrb5LoginModuleName(), AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, options)};
        }
    }
}

