/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.logging.impl.Log4JLogger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FsShell;
import org.apache.hadoop.fs.HarFileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.security.Groups;
import org.apache.hadoop.tools.HadoopArchives;
import org.apache.hadoop.util.JarFinder;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.log4j.Level;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

/*
 * Exception performing whole class analysis ignored.
 */
public class TestHadoopArchives {
    public static final String HADOOP_ARCHIVES_JAR = JarFinder.getJar(HadoopArchives.class);
    private static final String inputDir = "input";
    private Path inputPath;
    private Path archivePath;
    private final List<String> fileList;
    private MiniDFSCluster dfscluster;
    private Configuration conf;
    private FileSystem fs;

    public TestHadoopArchives() {
        ((Log4JLogger)LogFactory.getLog(Groups.class)).getLogger().setLevel(Level.ERROR);
        this.fileList = new ArrayList();
    }

    private static String createFile(Path root, FileSystem fs, String ... dirsAndFile) throws IOException {
        String fileBaseName = dirsAndFile[dirsAndFile.length - 1];
        return TestHadoopArchives.createFile((Path)root, (FileSystem)fs, (byte[])fileBaseName.getBytes("UTF-8"), (String[])dirsAndFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String createFile(Path root, FileSystem fs, byte[] fileContent, String ... dirsAndFile) throws IOException {
        StringBuilder sb = new StringBuilder();
        for (String segment : dirsAndFile) {
            if (sb.length() > 0) {
                sb.append("/");
            }
            sb.append(segment);
        }
        Path f = new Path(root, sb.toString());
        FSDataOutputStream out = fs.create(f);
        try {
            out.write(fileContent);
        }
        finally {
            out.close();
        }
        return sb.toString();
    }

    @Before
    public void setUp() throws Exception {
        this.conf = new Configuration();
        this.conf.set("yarn.scheduler.capacity.root.queues", "default");
        this.conf.set("yarn.scheduler.capacity.root.default.capacity", "100");
        this.dfscluster = new MiniDFSCluster.Builder(this.conf).checkExitOnShutdown(true).numDataNodes(2).format(true).racks(null).build();
        this.fs = this.dfscluster.getFileSystem();
        this.archivePath = new Path(this.fs.getHomeDirectory(), "archive");
        this.fs.delete(this.archivePath, true);
        this.inputPath = new Path(this.fs.getHomeDirectory(), "input");
        this.fs.delete(this.inputPath, true);
        this.fs.mkdirs(this.inputPath);
        this.fileList.add(TestHadoopArchives.createFile((Path)this.inputPath, (FileSystem)this.fs, (String[])new String[]{"a"}));
        this.fileList.add(TestHadoopArchives.createFile((Path)this.inputPath, (FileSystem)this.fs, (String[])new String[]{"b"}));
        this.fileList.add(TestHadoopArchives.createFile((Path)this.inputPath, (FileSystem)this.fs, (String[])new String[]{"c"}));
    }

    @After
    public void tearDown() throws Exception {
        if (this.dfscluster != null) {
            this.dfscluster.shutdown();
        }
    }

    @Test
    public void testRelativePath() throws Exception {
        Path sub1 = new Path(this.inputPath, "dir1");
        this.fs.mkdirs(sub1);
        TestHadoopArchives.createFile((Path)this.inputPath, (FileSystem)this.fs, (String[])new String[]{sub1.getName(), "a"});
        FsShell shell = new FsShell(this.conf);
        List originalPaths = TestHadoopArchives.lsr((FsShell)shell, (String)"input");
        System.out.println("originalPaths: " + originalPaths);
        String fullHarPathStr = this.makeArchive();
        List harPaths = TestHadoopArchives.lsr((FsShell)shell, (String)fullHarPathStr);
        Assert.assertEquals((Object)originalPaths, (Object)harPaths);
    }

    @Test
    public void testPathWithSpaces() throws Exception {
        TestHadoopArchives.createFile((Path)this.inputPath, (FileSystem)this.fs, (String[])new String[]{"c c"});
        Path sub1 = new Path(this.inputPath, "sub 1");
        this.fs.mkdirs(sub1);
        TestHadoopArchives.createFile((Path)sub1, (FileSystem)this.fs, (String[])new String[]{"file x y z"});
        TestHadoopArchives.createFile((Path)sub1, (FileSystem)this.fs, (String[])new String[]{"file"});
        TestHadoopArchives.createFile((Path)sub1, (FileSystem)this.fs, (String[])new String[]{"x"});
        TestHadoopArchives.createFile((Path)sub1, (FileSystem)this.fs, (String[])new String[]{"y"});
        TestHadoopArchives.createFile((Path)sub1, (FileSystem)this.fs, (String[])new String[]{"z"});
        Path sub2 = new Path(this.inputPath, "sub 1 with suffix");
        this.fs.mkdirs(sub2);
        TestHadoopArchives.createFile((Path)sub2, (FileSystem)this.fs, (String[])new String[]{"z"});
        FsShell shell = new FsShell(this.conf);
        String inputPathStr = this.inputPath.toUri().getPath();
        List originalPaths = TestHadoopArchives.lsr((FsShell)shell, (String)inputPathStr);
        String fullHarPathStr = this.makeArchive();
        List harPaths = TestHadoopArchives.lsr((FsShell)shell, (String)fullHarPathStr);
        Assert.assertEquals((Object)originalPaths, (Object)harPaths);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<String> lsr(FsShell shell, String dir) throws Exception {
        String results;
        System.out.println("lsr root=" + dir);
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        PrintStream out = new PrintStream(bytes);
        PrintStream oldOut = System.out;
        PrintStream oldErr = System.err;
        System.setOut(out);
        System.setErr(out);
        try {
            Assert.assertEquals((long)0L, (long)shell.run(new String[]{"-lsr", dir}));
            results = bytes.toString();
        }
        finally {
            IOUtils.closeStream((Closeable)out);
            System.setOut(oldOut);
            System.setErr(oldErr);
        }
        System.out.println("lsr results:\n" + results);
        String dirname = dir;
        if (dir.lastIndexOf("/") != -1) {
            dirname = dir.substring(dir.lastIndexOf("/"));
        }
        ArrayList<String> paths = new ArrayList<String>();
        StringTokenizer t = new StringTokenizer(results, "\n");
        while (t.hasMoreTokens()) {
            String s = t.nextToken();
            int i = s.indexOf(dirname);
            if (i < 0) continue;
            paths.add(s.substring(i + dirname.length()));
        }
        Collections.sort(paths);
        System.out.println("lsr paths = " + ((Object)paths).toString().replace(", ", ",\n  "));
        return paths;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReadFileContent() throws Exception {
        this.fileList.add(TestHadoopArchives.createFile((Path)this.inputPath, (FileSystem)this.fs, (String[])new String[]{"c c"}));
        Path sub1 = new Path(this.inputPath, "sub 1");
        this.fs.mkdirs(sub1);
        this.fileList.add(TestHadoopArchives.createFile((Path)this.inputPath, (FileSystem)this.fs, (String[])new String[]{sub1.getName(), "file x y z"}));
        this.fileList.add(TestHadoopArchives.createFile((Path)this.inputPath, (FileSystem)this.fs, (String[])new String[]{sub1.getName(), "file"}));
        this.fileList.add(TestHadoopArchives.createFile((Path)this.inputPath, (FileSystem)this.fs, (String[])new String[]{sub1.getName(), "x"}));
        this.fileList.add(TestHadoopArchives.createFile((Path)this.inputPath, (FileSystem)this.fs, (String[])new String[]{sub1.getName(), "y"}));
        this.fileList.add(TestHadoopArchives.createFile((Path)this.inputPath, (FileSystem)this.fs, (String[])new String[]{sub1.getName(), "z"}));
        Path sub2 = new Path(this.inputPath, "sub 1 with suffix");
        this.fs.mkdirs(sub2);
        this.fileList.add(TestHadoopArchives.createFile((Path)this.inputPath, (FileSystem)this.fs, (String[])new String[]{sub2.getName(), "z"}));
        byte[] binContent = TestHadoopArchives.prepareBin();
        this.fileList.add(TestHadoopArchives.createFile((Path)this.inputPath, (FileSystem)this.fs, (byte[])binContent, (String[])new String[]{sub2.getName(), "bin"}));
        this.fileList.add(TestHadoopArchives.createFile((Path)this.inputPath, (FileSystem)this.fs, (byte[])new byte[0], (String[])new String[]{sub2.getName(), "zero-length"}));
        String fullHarPathStr = this.makeArchive();
        HarFileSystem harFileSystem = new HarFileSystem(this.fs);
        try {
            URI harUri = new URI(fullHarPathStr);
            harFileSystem.initialize(harUri, this.fs.getConf());
            int readFileCount = 0;
            for (String pathStr0 : this.fileList) {
                Path path = new Path(fullHarPathStr + "/" + pathStr0);
                String baseName = path.getName();
                FileStatus status = harFileSystem.getFileStatus(path);
                if (!status.isFile()) continue;
                byte[] actualContentSimple = TestHadoopArchives.readAllSimple((FSDataInputStream)harFileSystem.open(path), (boolean)true);
                byte[] actualContentBuffer = TestHadoopArchives.readAllWithBuffer((FSDataInputStream)harFileSystem.open(path), (boolean)true);
                Assert.assertArrayEquals((byte[])actualContentSimple, (byte[])actualContentBuffer);
                byte[] actualContentFully = TestHadoopArchives.readAllWithReadFully((int)actualContentSimple.length, (FSDataInputStream)harFileSystem.open(path), (boolean)true);
                Assert.assertArrayEquals((byte[])actualContentSimple, (byte[])actualContentFully);
                byte[] actualContentSeek = TestHadoopArchives.readAllWithSeek((int)actualContentSimple.length, (FSDataInputStream)harFileSystem.open(path), (boolean)true);
                Assert.assertArrayEquals((byte[])actualContentSimple, (byte[])actualContentSeek);
                byte[] actualContentRead4 = TestHadoopArchives.readAllWithRead4((FSDataInputStream)harFileSystem.open(path), (boolean)true);
                Assert.assertArrayEquals((byte[])actualContentSimple, (byte[])actualContentRead4);
                byte[] actualContentSkip = TestHadoopArchives.readAllWithSkip((int)actualContentSimple.length, (FSDataInputStream)harFileSystem.open(path), (FSDataInputStream)harFileSystem.open(path), (boolean)true);
                Assert.assertArrayEquals((byte[])actualContentSimple, (byte[])actualContentSkip);
                if ("bin".equals(baseName)) {
                    Assert.assertArrayEquals((byte[])binContent, (byte[])actualContentSimple);
                } else if ("zero-length".equals(baseName)) {
                    Assert.assertEquals((long)0L, (long)actualContentSimple.length);
                } else {
                    String actual = new String(actualContentSimple, "UTF-8");
                    Assert.assertEquals((Object)baseName, (Object)actual);
                }
                ++readFileCount;
            }
            Assert.assertEquals((long)this.fileList.size(), (long)readFileCount);
        }
        finally {
            harFileSystem.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] readAllSimple(FSDataInputStream fsdis, boolean close) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            int b;
            while ((b = fsdis.read()) >= 0) {
                baos.write(b);
            }
            baos.close();
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
        finally {
            if (close) {
                fsdis.close();
            }
        }
    }

    private static byte[] readAllWithBuffer(FSDataInputStream fsdis, boolean close) throws IOException {
        try {
            ByteArrayOutputStream baos;
            byte[] buffer;
            int available = fsdis.available();
            if (available < 0) {
                buffer = new byte[1024];
                baos = new ByteArrayOutputStream(buffer.length * 2);
            } else {
                buffer = new byte[available];
                baos = new ByteArrayOutputStream(available);
            }
            int readIntoBuffer = 0;
            while (true) {
                int read;
                if ((read = fsdis.read(buffer, readIntoBuffer, buffer.length - readIntoBuffer)) < 0) {
                    if (readIntoBuffer > 0) {
                        baos.write(buffer, 0, readIntoBuffer);
                    }
                    byte[] byArray = baos.toByteArray();
                    return byArray;
                }
                if ((readIntoBuffer += read) == buffer.length) {
                    baos.write(buffer);
                    readIntoBuffer = 0;
                    continue;
                }
                if (readIntoBuffer > buffer.length) break;
            }
            throw new IOException("Read more than the buffer length: " + readIntoBuffer + ", buffer length = " + buffer.length);
        }
        finally {
            if (close) {
                fsdis.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] readAllWithReadFully(int totalLength, FSDataInputStream fsdis, boolean close) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buffer = new byte[17];
        int times = totalLength / buffer.length;
        int remainder = totalLength % buffer.length;
        int position = 0;
        try {
            for (int i = 0; i < times; ++i) {
                fsdis.readFully((long)position, buffer);
                position += buffer.length;
                baos.write(buffer);
            }
            if (remainder > 0) {
                fsdis.readFully((long)position, buffer, 0, remainder);
                position += remainder;
                baos.write(buffer, 0, remainder);
            }
            try {
                fsdis.readFully((long)position, buffer, 0, 1);
                Assert.assertTrue((boolean)false);
            }
            catch (IOException ioe) {
                // empty catch block
            }
            Assert.assertEquals((long)totalLength, (long)position);
            byte[] result = baos.toByteArray();
            Assert.assertEquals((long)totalLength, (long)result.length);
            byte[] byArray = result;
            return byArray;
        }
        finally {
            if (close) {
                fsdis.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] readAllWithRead4(FSDataInputStream fsdis, boolean close) throws IOException {
        try {
            byte[] result;
            int read;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] buffer = new byte[17];
            int totalRead = 0;
            while ((read = fsdis.read((long)totalRead, buffer, 0, buffer.length)) > 0) {
                totalRead += read;
                baos.write(buffer, 0, read);
            }
            if (read >= 0) {
                throw new AssertionError((Object)("FSDataInputStream#read(4) returned 0, while  the 4th method parameter is " + buffer.length + "."));
            }
            byte[] byArray = result = baos.toByteArray();
            return byArray;
        }
        finally {
            if (close) {
                fsdis.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] readAllWithSeek(int totalLength, FSDataInputStream fsdis, boolean close) throws IOException {
        byte[] result = new byte[totalLength];
        try {
            int times;
            byte[] buffer = new byte[17];
            for (int i = times = totalLength / buffer.length; i >= 0; --i) {
                int expectedRead;
                long pos = i * buffer.length;
                fsdis.seek(pos);
                Assert.assertEquals((long)pos, (long)fsdis.getPos());
                int read = fsdis.read(buffer);
                if (i == times) {
                    expectedRead = totalLength % buffer.length;
                    if (expectedRead == 0) {
                        expectedRead = -1;
                    }
                } else {
                    expectedRead = buffer.length;
                }
                Assert.assertEquals((long)expectedRead, (long)read);
                if (read <= 0) continue;
                System.arraycopy(buffer, 0, result, (int)pos, read);
            }
            TestHadoopArchives.expectSeekIOE((FSDataInputStream)fsdis, (long)Long.MAX_VALUE, (String)"Seek to Long.MAX_VALUE should lead to IOE.");
            TestHadoopArchives.expectSeekIOE((FSDataInputStream)fsdis, (long)Long.MIN_VALUE, (String)"Seek to Long.MIN_VALUE should lead to IOE.");
            long pp = -1L;
            TestHadoopArchives.expectSeekIOE((FSDataInputStream)fsdis, (long)pp, (String)("Seek to " + pp + " should lead to IOE."));
            fsdis.seek((long)totalLength);
            Assert.assertEquals((long)totalLength, (long)fsdis.getPos());
            pp = totalLength + 1;
            TestHadoopArchives.expectSeekIOE((FSDataInputStream)fsdis, (long)pp, (String)("Seek to the length position + 1 (" + pp + ") should lead to IOE."));
            byte[] byArray = result;
            return byArray;
        }
        finally {
            if (close) {
                fsdis.close();
            }
        }
    }

    private static void expectSeekIOE(FSDataInputStream fsdis, long seekPos, String message) {
        try {
            fsdis.seek(seekPos);
            Assert.assertTrue((String)(message + " (Position = " + fsdis.getPos() + ")"), (boolean)false);
        }
        catch (IOException ioe) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] readAllWithSkip(int totalLength, FSDataInputStream fsdis1, FSDataInputStream fsdis2, boolean close) throws IOException {
        Assert.assertEquals((long)0L, (long)fsdis1.skip(-1L));
        Assert.assertEquals((long)0L, (long)fsdis1.skip(0L));
        ByteArrayOutputStream baos = new ByteArrayOutputStream(totalLength);
        try {
            byte[] buffer = new byte[17];
            int times = totalLength / buffer.length;
            int remainder = totalLength % buffer.length;
            for (int i = 0; i <= times; ++i) {
                long expectedPosition;
                long skipped;
                int toGo;
                int n = toGo = i < times ? buffer.length : remainder;
                if (i % 2 == 0) {
                    fsdis1.readFully(buffer, 0, toGo);
                    skipped = TestHadoopArchives.skipUntilZero((FilterInputStream)fsdis2, (long)toGo);
                } else {
                    fsdis2.readFully(buffer, 0, toGo);
                    skipped = TestHadoopArchives.skipUntilZero((FilterInputStream)fsdis1, (long)toGo);
                }
                if (i < times) {
                    Assert.assertEquals((long)buffer.length, (long)skipped);
                    expectedPosition = (i + 1) * buffer.length;
                } else {
                    if (remainder > 0) {
                        Assert.assertEquals((long)remainder, (long)skipped);
                    } else {
                        Assert.assertEquals((long)0L, (long)skipped);
                    }
                    expectedPosition = totalLength;
                }
                Assert.assertEquals((long)expectedPosition, (long)fsdis1.getPos());
                Assert.assertEquals((long)expectedPosition, (long)fsdis2.getPos());
                if (toGo <= 0) continue;
                baos.write(buffer, 0, toGo);
            }
            Assert.assertEquals((long)0L, (long)fsdis1.skip(-1L));
            Assert.assertEquals((long)0L, (long)fsdis1.skip(0L));
            Assert.assertEquals((long)0L, (long)fsdis1.skip(1L));
            Assert.assertEquals((long)0L, (long)fsdis1.skip(Long.MAX_VALUE));
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
        finally {
            if (close) {
                fsdis1.close();
                fsdis2.close();
            }
        }
    }

    private static long skipUntilZero(FilterInputStream fis, long toSkip) throws IOException {
        long skipped = 0L;
        long remainsToSkip = toSkip;
        while (skipped < toSkip) {
            long s = fis.skip(remainsToSkip);
            if (s == 0L) {
                return skipped;
            }
            skipped += s;
            remainsToSkip -= s;
        }
        return skipped;
    }

    private static byte[] prepareBin() {
        byte[] bb = new byte[77777];
        for (int i = 0; i < bb.length; ++i) {
            double d = Math.log(i + 2);
            long bits = Double.doubleToLongBits(d);
            bb[i] = (byte)bits;
        }
        return bb;
    }

    private String makeArchive() throws Exception {
        String inputPathStr = this.inputPath.toUri().getPath();
        System.out.println("inputPathStr = " + inputPathStr);
        URI uri = this.fs.getUri();
        String prefix = "har://hdfs-" + uri.getHost() + ":" + uri.getPort() + this.archivePath.toUri().getPath() + "/";
        String harName = "foo.har";
        String fullHarPathStr = prefix + "foo.har";
        String[] args = new String[]{"-archiveName", "foo.har", "-p", inputPathStr, "*", this.archivePath.toString()};
        System.setProperty("test.hadoop.archives.jar", HADOOP_ARCHIVES_JAR);
        HadoopArchives har = new HadoopArchives(this.conf);
        Assert.assertEquals((long)0L, (long)ToolRunner.run((Tool)har, (String[])args));
        return fullHarPathStr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCopyToLocal() throws Exception {
        String fullHarPathStr = this.makeArchive();
        String tmpDir = System.getProperty("test.build.data", "build/test/data") + "/work-dir/har-fs-tmp";
        Path tmpPath = new Path(tmpDir);
        LocalFileSystem localFs = FileSystem.getLocal((Configuration)new Configuration());
        localFs.delete(tmpPath, true);
        localFs.mkdirs(tmpPath);
        Assert.assertTrue((boolean)localFs.exists(tmpPath));
        HarFileSystem harFileSystem = new HarFileSystem(this.fs);
        try {
            URI harUri = new URI(fullHarPathStr);
            harFileSystem.initialize(harUri, this.fs.getConf());
            Path sourcePath = new Path(fullHarPathStr + "/" + "a");
            Path targetPath = new Path(tmpPath, "straus");
            harFileSystem.copyToLocalFile(false, sourcePath, targetPath);
            FileStatus straus = localFs.getFileStatus(targetPath);
            Assert.assertEquals((long)1L, (long)straus.getLen());
        }
        finally {
            harFileSystem.close();
            localFs.delete(tmpPath, true);
        }
    }
}

