/*
 * Decompiled with CFR 0.152.
 */
package hidden.bkjournal.org.jboss.netty.channel;

import hidden.bkjournal.org.jboss.netty.channel.ChannelDownstreamHandler;
import hidden.bkjournal.org.jboss.netty.channel.ChannelEvent;
import hidden.bkjournal.org.jboss.netty.channel.ChannelHandlerContext;
import hidden.bkjournal.org.jboss.netty.channel.ChannelStateEvent;
import hidden.bkjournal.org.jboss.netty.channel.ChannelUpstreamHandler;
import hidden.bkjournal.org.jboss.netty.channel.ChildChannelStateEvent;
import hidden.bkjournal.org.jboss.netty.channel.ExceptionEvent;
import hidden.bkjournal.org.jboss.netty.channel.MessageEvent;
import hidden.bkjournal.org.jboss.netty.channel.WriteCompletionEvent;
import hidden.bkjournal.org.jboss.netty.logging.InternalLogger;
import hidden.bkjournal.org.jboss.netty.logging.InternalLoggerFactory;

public class SimpleChannelHandler
implements ChannelUpstreamHandler,
ChannelDownstreamHandler {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(SimpleChannelHandler.class.getName());

    public void handleUpstream(ChannelHandlerContext ctx, ChannelEvent e) throws Exception {
        if (e instanceof MessageEvent) {
            this.messageReceived(ctx, (MessageEvent)e);
        } else if (e instanceof WriteCompletionEvent) {
            WriteCompletionEvent evt = (WriteCompletionEvent)e;
            this.writeComplete(ctx, evt);
        } else if (e instanceof ChildChannelStateEvent) {
            ChildChannelStateEvent evt = (ChildChannelStateEvent)e;
            if (evt.getChildChannel().isOpen()) {
                this.childChannelOpen(ctx, evt);
            } else {
                this.childChannelClosed(ctx, evt);
            }
        } else if (e instanceof ChannelStateEvent) {
            ChannelStateEvent evt = (ChannelStateEvent)e;
            switch (evt.getState()) {
                case OPEN: {
                    if (Boolean.TRUE.equals(evt.getValue())) {
                        this.channelOpen(ctx, evt);
                        break;
                    }
                    this.channelClosed(ctx, evt);
                    break;
                }
                case BOUND: {
                    if (evt.getValue() != null) {
                        this.channelBound(ctx, evt);
                        break;
                    }
                    this.channelUnbound(ctx, evt);
                    break;
                }
                case CONNECTED: {
                    if (evt.getValue() != null) {
                        this.channelConnected(ctx, evt);
                        break;
                    }
                    this.channelDisconnected(ctx, evt);
                    break;
                }
                case INTEREST_OPS: {
                    this.channelInterestChanged(ctx, evt);
                    break;
                }
                default: {
                    ctx.sendUpstream(e);
                    break;
                }
            }
        } else if (e instanceof ExceptionEvent) {
            this.exceptionCaught(ctx, (ExceptionEvent)e);
        } else {
            ctx.sendUpstream(e);
        }
    }

    public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
        ctx.sendUpstream(e);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) throws Exception {
        if (this == ctx.getPipeline().getLast()) {
            logger.warn("EXCEPTION, please implement " + this.getClass().getName() + ".exceptionCaught() for proper handling.", e.getCause());
        }
        ctx.sendUpstream(e);
    }

    public void channelOpen(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        ctx.sendUpstream(e);
    }

    public void channelBound(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        ctx.sendUpstream(e);
    }

    public void channelConnected(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        ctx.sendUpstream(e);
    }

    public void channelInterestChanged(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        ctx.sendUpstream(e);
    }

    public void channelDisconnected(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        ctx.sendUpstream(e);
    }

    public void channelUnbound(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        ctx.sendUpstream(e);
    }

    public void channelClosed(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        ctx.sendUpstream(e);
    }

    public void writeComplete(ChannelHandlerContext ctx, WriteCompletionEvent e) throws Exception {
        ctx.sendUpstream(e);
    }

    public void childChannelOpen(ChannelHandlerContext ctx, ChildChannelStateEvent e) throws Exception {
        ctx.sendUpstream(e);
    }

    public void childChannelClosed(ChannelHandlerContext ctx, ChildChannelStateEvent e) throws Exception {
        ctx.sendUpstream(e);
    }

    public void handleDownstream(ChannelHandlerContext ctx, ChannelEvent e) throws Exception {
        block10: {
            block11: {
                block9: {
                    if (!(e instanceof MessageEvent)) break block9;
                    this.writeRequested(ctx, (MessageEvent)e);
                    break block10;
                }
                if (!(e instanceof ChannelStateEvent)) break block11;
                ChannelStateEvent evt = (ChannelStateEvent)e;
                switch (evt.getState()) {
                    case OPEN: {
                        if (!Boolean.TRUE.equals(evt.getValue())) {
                            this.closeRequested(ctx, evt);
                            break;
                        }
                        break block10;
                    }
                    case BOUND: {
                        if (evt.getValue() != null) {
                            this.bindRequested(ctx, evt);
                            break;
                        }
                        this.unbindRequested(ctx, evt);
                        break;
                    }
                    case CONNECTED: {
                        if (evt.getValue() != null) {
                            this.connectRequested(ctx, evt);
                            break;
                        }
                        this.disconnectRequested(ctx, evt);
                        break;
                    }
                    case INTEREST_OPS: {
                        this.setInterestOpsRequested(ctx, evt);
                        break;
                    }
                    default: {
                        ctx.sendDownstream(e);
                        break;
                    }
                }
                break block10;
            }
            ctx.sendDownstream(e);
        }
    }

    public void writeRequested(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
        ctx.sendDownstream(e);
    }

    public void bindRequested(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        ctx.sendDownstream(e);
    }

    public void connectRequested(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        ctx.sendDownstream(e);
    }

    public void setInterestOpsRequested(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        ctx.sendDownstream(e);
    }

    public void disconnectRequested(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        ctx.sendDownstream(e);
    }

    public void unbindRequested(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        ctx.sendDownstream(e);
    }

    public void closeRequested(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        ctx.sendDownstream(e);
    }
}

