/*
 * Decompiled with CFR 0.152.
 */
package hidden.bkjournal.org.jboss.netty.channel.socket.http;

import hidden.bkjournal.org.jboss.netty.buffer.ChannelBuffer;
import hidden.bkjournal.org.jboss.netty.buffer.ChannelBuffers;
import hidden.bkjournal.org.jboss.netty.channel.AbstractChannel;
import hidden.bkjournal.org.jboss.netty.channel.ChannelException;
import hidden.bkjournal.org.jboss.netty.channel.ChannelFactory;
import hidden.bkjournal.org.jboss.netty.channel.ChannelFuture;
import hidden.bkjournal.org.jboss.netty.channel.ChannelFutureListener;
import hidden.bkjournal.org.jboss.netty.channel.ChannelHandlerContext;
import hidden.bkjournal.org.jboss.netty.channel.ChannelPipeline;
import hidden.bkjournal.org.jboss.netty.channel.ChannelSink;
import hidden.bkjournal.org.jboss.netty.channel.ChannelStateEvent;
import hidden.bkjournal.org.jboss.netty.channel.Channels;
import hidden.bkjournal.org.jboss.netty.channel.DefaultChannelPipeline;
import hidden.bkjournal.org.jboss.netty.channel.ExceptionEvent;
import hidden.bkjournal.org.jboss.netty.channel.MessageEvent;
import hidden.bkjournal.org.jboss.netty.channel.SimpleChannelUpstreamHandler;
import hidden.bkjournal.org.jboss.netty.channel.socket.ClientSocketChannelFactory;
import hidden.bkjournal.org.jboss.netty.channel.socket.SocketChannel;
import hidden.bkjournal.org.jboss.netty.channel.socket.http.HttpTunnelingSocketChannelConfig;
import hidden.bkjournal.org.jboss.netty.handler.codec.http.DefaultHttpChunk;
import hidden.bkjournal.org.jboss.netty.handler.codec.http.DefaultHttpRequest;
import hidden.bkjournal.org.jboss.netty.handler.codec.http.HttpChunk;
import hidden.bkjournal.org.jboss.netty.handler.codec.http.HttpMethod;
import hidden.bkjournal.org.jboss.netty.handler.codec.http.HttpRequestEncoder;
import hidden.bkjournal.org.jboss.netty.handler.codec.http.HttpResponse;
import hidden.bkjournal.org.jboss.netty.handler.codec.http.HttpResponseDecoder;
import hidden.bkjournal.org.jboss.netty.handler.codec.http.HttpResponseStatus;
import hidden.bkjournal.org.jboss.netty.handler.codec.http.HttpVersion;
import hidden.bkjournal.org.jboss.netty.handler.ssl.SslHandler;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.channels.NotYetConnectedException;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;

class HttpTunnelingClientSocketChannel
extends AbstractChannel
implements SocketChannel {
    final HttpTunnelingSocketChannelConfig config;
    volatile boolean requestHeaderWritten;
    final Object interestOpsLock = new Object();
    final SocketChannel realChannel;
    private final ServletChannelHandler handler = new ServletChannelHandler();

    HttpTunnelingClientSocketChannel(ChannelFactory factory, ChannelPipeline pipeline, ChannelSink sink, ClientSocketChannelFactory clientSocketChannelFactory) {
        super(null, factory, pipeline, sink);
        this.config = new HttpTunnelingSocketChannelConfig(this);
        DefaultChannelPipeline channelPipeline = new DefaultChannelPipeline();
        channelPipeline.addLast("decoder", new HttpResponseDecoder());
        channelPipeline.addLast("encoder", new HttpRequestEncoder());
        channelPipeline.addLast("handler", this.handler);
        this.realChannel = clientSocketChannelFactory.newChannel(channelPipeline);
        Channels.fireChannelOpen(this);
    }

    public HttpTunnelingSocketChannelConfig getConfig() {
        return this.config;
    }

    public InetSocketAddress getLocalAddress() {
        return this.realChannel.getLocalAddress();
    }

    public InetSocketAddress getRemoteAddress() {
        return this.realChannel.getRemoteAddress();
    }

    public boolean isBound() {
        return this.realChannel.isBound();
    }

    public boolean isConnected() {
        return this.realChannel.isConnected();
    }

    public int getInterestOps() {
        return this.realChannel.getInterestOps();
    }

    public boolean isWritable() {
        return this.realChannel.isWritable();
    }

    protected boolean setClosed() {
        return super.setClosed();
    }

    public ChannelFuture write(Object message, SocketAddress remoteAddress) {
        if (remoteAddress == null || remoteAddress.equals(this.getRemoteAddress())) {
            return super.write(message, null);
        }
        return this.getUnsupportedOperationFuture();
    }

    void bindReal(SocketAddress localAddress, final ChannelFuture future) {
        this.realChannel.bind(localAddress).addListener(new ChannelFutureListener(){

            public void operationComplete(ChannelFuture f) {
                if (f.isSuccess()) {
                    future.setSuccess();
                } else {
                    future.setFailure(f.getCause());
                }
            }
        });
    }

    void connectReal(final SocketAddress remoteAddress, final ChannelFuture future) {
        final HttpTunnelingClientSocketChannel virtualChannel = this;
        this.realChannel.connect(remoteAddress).addListener(new ChannelFutureListener(){

            public void operationComplete(ChannelFuture f) {
                String serverName = HttpTunnelingClientSocketChannel.this.config.getServerName();
                int serverPort = ((InetSocketAddress)remoteAddress).getPort();
                String serverPath = HttpTunnelingClientSocketChannel.this.config.getServerPath();
                if (f.isSuccess()) {
                    SSLContext sslContext = HttpTunnelingClientSocketChannel.this.config.getSslContext();
                    ChannelFuture sslHandshakeFuture = null;
                    if (sslContext != null) {
                        String[] enabledProtocols;
                        SSLEngine engine = serverName != null ? sslContext.createSSLEngine(serverName, serverPort) : sslContext.createSSLEngine();
                        engine.setUseClientMode(true);
                        engine.setEnableSessionCreation(HttpTunnelingClientSocketChannel.this.config.isEnableSslSessionCreation());
                        String[] enabledCipherSuites = HttpTunnelingClientSocketChannel.this.config.getEnabledSslCipherSuites();
                        if (enabledCipherSuites != null) {
                            engine.setEnabledCipherSuites(enabledCipherSuites);
                        }
                        if ((enabledProtocols = HttpTunnelingClientSocketChannel.this.config.getEnabledSslProtocols()) != null) {
                            engine.setEnabledProtocols(enabledProtocols);
                        }
                        SslHandler sslHandler = new SslHandler(engine);
                        HttpTunnelingClientSocketChannel.this.realChannel.getPipeline().addFirst("ssl", sslHandler);
                        sslHandshakeFuture = sslHandler.handshake();
                    }
                    final DefaultHttpRequest req = new DefaultHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.POST, serverPath);
                    if (serverName != null) {
                        req.setHeader("Host", serverName);
                    }
                    req.setHeader("Content-Type", "application/octet-stream");
                    req.setHeader("Transfer-Encoding", "chunked");
                    req.setHeader("Content-Transfer-Encoding", "binary");
                    req.setHeader("User-Agent", HttpTunnelingClientSocketChannel.class.getName());
                    if (sslHandshakeFuture == null) {
                        HttpTunnelingClientSocketChannel.this.realChannel.write(req);
                        HttpTunnelingClientSocketChannel.this.requestHeaderWritten = true;
                        future.setSuccess();
                        Channels.fireChannelConnected(virtualChannel, remoteAddress);
                    } else {
                        sslHandshakeFuture.addListener(new ChannelFutureListener(){

                            public void operationComplete(ChannelFuture f) {
                                if (f.isSuccess()) {
                                    HttpTunnelingClientSocketChannel.this.realChannel.write(req);
                                    HttpTunnelingClientSocketChannel.this.requestHeaderWritten = true;
                                    future.setSuccess();
                                    Channels.fireChannelConnected(virtualChannel, remoteAddress);
                                } else {
                                    future.setFailure(f.getCause());
                                    Channels.fireExceptionCaught(virtualChannel, f.getCause());
                                }
                            }
                        });
                    }
                } else {
                    future.setFailure(f.getCause());
                    Channels.fireExceptionCaught(virtualChannel, f.getCause());
                }
            }
        });
    }

    void writeReal(ChannelBuffer a, final ChannelFuture future) {
        if (!this.requestHeaderWritten) {
            throw new NotYetConnectedException();
        }
        final int size = a.readableBytes();
        ChannelFuture f = size == 0 ? this.realChannel.write(ChannelBuffers.EMPTY_BUFFER) : this.realChannel.write(new DefaultHttpChunk(a));
        f.addListener(new ChannelFutureListener(){

            public void operationComplete(ChannelFuture f) {
                if (f.isSuccess()) {
                    future.setSuccess();
                    if (size != 0) {
                        Channels.fireWriteComplete(HttpTunnelingClientSocketChannel.this, (long)size);
                    }
                } else {
                    future.setFailure(f.getCause());
                }
            }
        });
    }

    private ChannelFuture writeLastChunk() {
        if (!this.requestHeaderWritten) {
            throw new NotYetConnectedException();
        }
        return this.realChannel.write(HttpChunk.LAST_CHUNK);
    }

    void setInterestOpsReal(int interestOps, final ChannelFuture future) {
        this.realChannel.setInterestOps(interestOps).addListener(new ChannelFutureListener(){

            public void operationComplete(ChannelFuture f) {
                if (f.isSuccess()) {
                    future.setSuccess();
                } else {
                    future.setFailure(f.getCause());
                }
            }
        });
    }

    void disconnectReal(final ChannelFuture future) {
        this.writeLastChunk().addListener(new ChannelFutureListener(){

            public void operationComplete(ChannelFuture f) {
                HttpTunnelingClientSocketChannel.this.realChannel.disconnect().addListener(new ChannelFutureListener(){

                    public void operationComplete(ChannelFuture f) {
                        if (f.isSuccess()) {
                            future.setSuccess();
                        } else {
                            future.setFailure(f.getCause());
                        }
                    }
                });
            }
        });
    }

    void unbindReal(final ChannelFuture future) {
        this.writeLastChunk().addListener(new ChannelFutureListener(){

            public void operationComplete(ChannelFuture f) {
                HttpTunnelingClientSocketChannel.this.realChannel.unbind().addListener(new ChannelFutureListener(){

                    public void operationComplete(ChannelFuture f) {
                        if (f.isSuccess()) {
                            future.setSuccess();
                        } else {
                            future.setFailure(f.getCause());
                        }
                    }
                });
            }
        });
    }

    void closeReal(final ChannelFuture future) {
        this.writeLastChunk().addListener(new ChannelFutureListener(){

            public void operationComplete(ChannelFuture f) {
                HttpTunnelingClientSocketChannel.this.realChannel.close().addListener(new ChannelFutureListener(){

                    public void operationComplete(ChannelFuture f) {
                        if (f.isSuccess()) {
                            future.setSuccess();
                        } else {
                            future.setFailure(f.getCause());
                        }
                        HttpTunnelingClientSocketChannel.this.setClosed();
                    }
                });
            }
        });
    }

    final class ServletChannelHandler
    extends SimpleChannelUpstreamHandler {
        private volatile boolean readingChunks;
        final SocketChannel virtualChannel;

        ServletChannelHandler() {
            this.virtualChannel = HttpTunnelingClientSocketChannel.this;
        }

        public void channelBound(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
            Channels.fireChannelBound(this.virtualChannel, (SocketAddress)e.getValue());
        }

        public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
            if (!this.readingChunks) {
                HttpResponse res = (HttpResponse)e.getMessage();
                if (res.getStatus().getCode() != HttpResponseStatus.OK.getCode()) {
                    throw new ChannelException("Unexpected HTTP response status: " + res.getStatus());
                }
                if (res.isChunked()) {
                    this.readingChunks = true;
                } else {
                    ChannelBuffer content = res.getContent();
                    if (content.readable()) {
                        Channels.fireMessageReceived(HttpTunnelingClientSocketChannel.this, (Object)content);
                    }
                    HttpTunnelingClientSocketChannel.this.closeReal(Channels.succeededFuture(this.virtualChannel));
                }
            } else {
                HttpChunk chunk = (HttpChunk)e.getMessage();
                if (!chunk.isLast()) {
                    Channels.fireMessageReceived(HttpTunnelingClientSocketChannel.this, (Object)chunk.getContent());
                } else {
                    this.readingChunks = false;
                    HttpTunnelingClientSocketChannel.this.closeReal(Channels.succeededFuture(this.virtualChannel));
                }
            }
        }

        public void channelInterestChanged(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
            Channels.fireChannelInterestChanged(this.virtualChannel);
        }

        public void channelDisconnected(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
            Channels.fireChannelDisconnected(this.virtualChannel);
        }

        public void channelUnbound(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
            Channels.fireChannelUnbound(this.virtualChannel);
        }

        public void channelClosed(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
            Channels.fireChannelClosed(this.virtualChannel);
        }

        public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) throws Exception {
            Channels.fireExceptionCaught(this.virtualChannel, e.getCause());
            HttpTunnelingClientSocketChannel.this.realChannel.close();
        }
    }
}

