/*
 * Decompiled with CFR 0.152.
 */
package hidden.bkjournal.org.apache.bookkeeper.client;

import hidden.bkjournal.org.apache.bookkeeper.client.AsyncCallback;
import hidden.bkjournal.org.apache.bookkeeper.client.BKException;
import hidden.bkjournal.org.apache.bookkeeper.client.DigestManager;
import hidden.bkjournal.org.apache.bookkeeper.client.LedgerEntry;
import hidden.bkjournal.org.apache.bookkeeper.client.LedgerHandle;
import hidden.bkjournal.org.apache.bookkeeper.proto.BookkeeperInternalCallbacks;
import hidden.bkjournal.org.apache.zookeeper.KeeperException;
import hidden.bkjournal.org.jboss.netty.buffer.ChannelBuffer;
import java.util.Enumeration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class LedgerRecoveryOp
implements BookkeeperInternalCallbacks.ReadEntryCallback,
AsyncCallback.ReadCallback,
AsyncCallback.AddCallback {
    static final Logger LOG = LoggerFactory.getLogger(LedgerRecoveryOp.class);
    LedgerHandle lh;
    int numResponsesPending;
    boolean proceedingWithRecovery = false;
    long maxAddPushed = -1L;
    long maxAddConfirmed = -1L;
    long maxLength = 0L;
    BookkeeperInternalCallbacks.GenericCallback<Void> cb;

    public LedgerRecoveryOp(LedgerHandle lh, BookkeeperInternalCallbacks.GenericCallback<Void> cb) {
        this.cb = cb;
        this.lh = lh;
        this.numResponsesPending = lh.metadata.ensembleSize;
    }

    public void initiate() {
        int flags = 1;
        for (int i = 0; i < this.lh.metadata.currentEnsemble.size(); ++i) {
            this.lh.bk.bookieClient.readEntry(this.lh.metadata.currentEnsemble.get(i), this.lh.ledgerId, -1L, this, i, flags);
        }
    }

    @Override
    public synchronized void readEntryComplete(int rc, long ledgerId, long entryId, ChannelBuffer buffer, Object ctx) {
        if (this.proceedingWithRecovery) {
            return;
        }
        int bookieIndex = (Integer)ctx;
        --this.numResponsesPending;
        boolean heardValidResponse = false;
        if (rc == 0) {
            try {
                DigestManager.RecoveryData recoveryData = this.lh.macManager.verifyDigestAndReturnLastConfirmed(buffer);
                this.maxAddConfirmed = Math.max(this.maxAddConfirmed, recoveryData.lastAddConfirmed);
                this.maxAddPushed = Math.max(this.maxAddPushed, recoveryData.entryId);
                heardValidResponse = true;
            }
            catch (BKException.BKDigestMatchException e) {
                LOG.error("Mac mismatch while reading last entry from bookie: " + this.lh.metadata.currentEnsemble.get(bookieIndex));
            }
        }
        if (rc == -7 || rc == -13) {
            heardValidResponse = true;
        }
        if (heardValidResponse && this.lh.distributionSchedule.canProceedWithRecovery(bookieIndex)) {
            this.proceedingWithRecovery = true;
            this.lh.lastAddPushed = this.lh.lastAddConfirmed = this.maxAddConfirmed;
            this.lh.length = this.maxLength;
            this.doRecoveryRead();
            return;
        }
        if (this.numResponsesPending == 0) {
            LOG.error("While recovering ledger: " + ledgerId + " did not hear success responses from all quorums");
            this.cb.operationComplete(-10, null);
        }
    }

    private void doRecoveryRead() {
        ++this.lh.lastAddConfirmed;
        this.lh.asyncReadEntries(this.lh.lastAddConfirmed, this.lh.lastAddConfirmed, this, null);
    }

    @Override
    public void readComplete(int rc, LedgerHandle lh, Enumeration<LedgerEntry> seq, Object ctx) {
        --lh.lastAddConfirmed;
        if (rc == 0) {
            LedgerEntry entry = seq.nextElement();
            byte[] data = entry.getEntry();
            lh.length = entry.getLength() - (long)data.length;
            lh.asyncRecoveryAddEntry(data, 0, data.length, this, null);
            return;
        }
        if (rc == -13 || rc == -7) {
            lh.asyncCloseInternal(new AsyncCallback.CloseCallback(){

                @Override
                public void closeComplete(int rc, LedgerHandle lh, Object ctx) {
                    if (rc != KeeperException.Code.OK.intValue()) {
                        LOG.warn("Close failed: " + BKException.getMessage(rc));
                        LedgerRecoveryOp.this.cb.operationComplete(-9, null);
                    } else {
                        LedgerRecoveryOp.this.cb.operationComplete(0, null);
                        LOG.debug("After closing length is: " + lh.getLength());
                    }
                }
            }, null, -11);
            return;
        }
        LOG.error("Failure " + BKException.getMessage(rc) + " while reading entry: " + lh.lastAddConfirmed + 1 + " ledger: " + lh.ledgerId + " while recovering ledger");
        this.cb.operationComplete(rc, null);
    }

    @Override
    public void addComplete(int rc, LedgerHandle lh, long entryId, Object ctx) {
        if (rc != 0) {
            LOG.error("Failure " + BKException.getMessage(rc) + " while writing entry: " + lh.lastAddConfirmed + 1 + " ledger: " + lh.ledgerId + " while recovering ledger");
            this.cb.operationComplete(rc, null);
            return;
        }
        this.doRecoveryRead();
    }
}

