/*
 * Decompiled with CFR 0.152.
 */
package hidden.bkjournal.org.jboss.netty.channel.socket;

import hidden.bkjournal.org.jboss.netty.channel.ChannelException;
import hidden.bkjournal.org.jboss.netty.channel.DefaultServerChannelConfig;
import hidden.bkjournal.org.jboss.netty.channel.socket.ServerSocketChannelConfig;
import hidden.bkjournal.org.jboss.netty.util.internal.ConversionUtil;
import java.net.ServerSocket;
import java.net.SocketException;

public class DefaultServerSocketChannelConfig
extends DefaultServerChannelConfig
implements ServerSocketChannelConfig {
    private final ServerSocket socket;
    private volatile int backlog;

    public DefaultServerSocketChannelConfig(ServerSocket socket) {
        if (socket == null) {
            throw new NullPointerException("socket");
        }
        this.socket = socket;
    }

    public boolean setOption(String key, Object value) {
        if (super.setOption(key, value)) {
            return true;
        }
        if (key.equals("receiveBufferSize")) {
            this.setReceiveBufferSize(ConversionUtil.toInt(value));
        } else if (key.equals("reuseAddress")) {
            this.setReuseAddress(ConversionUtil.toBoolean(value));
        } else if (key.equals("backlog")) {
            this.setBacklog(ConversionUtil.toInt(value));
        } else {
            return false;
        }
        return true;
    }

    public boolean isReuseAddress() {
        try {
            return this.socket.getReuseAddress();
        }
        catch (SocketException e) {
            throw new ChannelException(e);
        }
    }

    public void setReuseAddress(boolean reuseAddress) {
        try {
            this.socket.setReuseAddress(reuseAddress);
        }
        catch (SocketException e) {
            throw new ChannelException(e);
        }
    }

    public int getReceiveBufferSize() {
        try {
            return this.socket.getReceiveBufferSize();
        }
        catch (SocketException e) {
            throw new ChannelException(e);
        }
    }

    public void setReceiveBufferSize(int receiveBufferSize) {
        try {
            this.socket.setReceiveBufferSize(receiveBufferSize);
        }
        catch (SocketException e) {
            throw new ChannelException(e);
        }
    }

    public void setPerformancePreferences(int connectionTime, int latency, int bandwidth) {
        this.socket.setPerformancePreferences(connectionTime, latency, bandwidth);
    }

    public int getBacklog() {
        return this.backlog;
    }

    public void setBacklog(int backlog) {
        if (backlog < 0) {
            throw new IllegalArgumentException("backlog: " + backlog);
        }
        this.backlog = backlog;
    }
}

