/*
 * Decompiled with CFR 0.152.
 */
package hidden.bkjournal.org.jboss.netty.handler.codec.protobuf;

import com.google.protobuf.ExtensionRegistry;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.MessageLite;
import hidden.bkjournal.org.jboss.netty.buffer.ChannelBuffer;
import hidden.bkjournal.org.jboss.netty.buffer.ChannelBufferInputStream;
import hidden.bkjournal.org.jboss.netty.channel.Channel;
import hidden.bkjournal.org.jboss.netty.channel.ChannelHandler;
import hidden.bkjournal.org.jboss.netty.channel.ChannelHandlerContext;
import hidden.bkjournal.org.jboss.netty.handler.codec.oneone.OneToOneDecoder;
import java.io.InputStream;

@ChannelHandler.Sharable
public class ProtobufDecoder
extends OneToOneDecoder {
    private final MessageLite prototype;
    private final ExtensionRegistry extensionRegistry;

    public ProtobufDecoder(MessageLite prototype) {
        this(prototype, null);
    }

    public ProtobufDecoder(MessageLite prototype, ExtensionRegistry extensionRegistry) {
        if (prototype == null) {
            throw new NullPointerException("prototype");
        }
        this.prototype = prototype.getDefaultInstanceForType();
        this.extensionRegistry = extensionRegistry;
    }

    protected Object decode(ChannelHandlerContext ctx, Channel channel, Object msg) throws Exception {
        if (!(msg instanceof ChannelBuffer)) {
            return msg;
        }
        ChannelBuffer buf = (ChannelBuffer)msg;
        if (buf.hasArray()) {
            int offset = buf.readerIndex();
            if (this.extensionRegistry == null) {
                return this.prototype.newBuilderForType().mergeFrom(buf.array(), buf.arrayOffset() + offset, buf.readableBytes()).build();
            }
            return this.prototype.newBuilderForType().mergeFrom(buf.array(), buf.arrayOffset() + offset, buf.readableBytes(), (ExtensionRegistryLite)this.extensionRegistry).build();
        }
        if (this.extensionRegistry == null) {
            return this.prototype.newBuilderForType().mergeFrom((InputStream)new ChannelBufferInputStream((ChannelBuffer)msg)).build();
        }
        return this.prototype.newBuilderForType().mergeFrom((InputStream)new ChannelBufferInputStream((ChannelBuffer)msg), (ExtensionRegistryLite)this.extensionRegistry).build();
    }
}

