/*
 * Decompiled with CFR 0.152.
 */
package hidden.bkjournal.org.jboss.netty.channel.socket.nio;

import hidden.bkjournal.org.jboss.netty.channel.ChannelPipeline;
import hidden.bkjournal.org.jboss.netty.channel.socket.DatagramChannel;
import hidden.bkjournal.org.jboss.netty.channel.socket.DatagramChannelFactory;
import hidden.bkjournal.org.jboss.netty.channel.socket.nio.NioDatagramChannel;
import hidden.bkjournal.org.jboss.netty.channel.socket.nio.NioDatagramPipelineSink;
import hidden.bkjournal.org.jboss.netty.channel.socket.nio.SelectorUtil;
import hidden.bkjournal.org.jboss.netty.util.internal.ExecutorUtil;
import java.util.concurrent.Executor;

public class NioDatagramChannelFactory
implements DatagramChannelFactory {
    private final Executor workerExecutor;
    private final NioDatagramPipelineSink sink;

    public NioDatagramChannelFactory(Executor workerExecutor) {
        this(workerExecutor, SelectorUtil.DEFAULT_IO_THREADS);
    }

    public NioDatagramChannelFactory(Executor workerExecutor, int workerCount) {
        if (workerCount <= 0) {
            throw new IllegalArgumentException(String.format("workerCount (%s) must be a positive integer.", workerCount));
        }
        if (workerExecutor == null) {
            throw new NullPointerException("workerExecutor argument must not be null");
        }
        this.workerExecutor = workerExecutor;
        this.sink = new NioDatagramPipelineSink(workerExecutor, workerCount);
    }

    public DatagramChannel newChannel(ChannelPipeline pipeline) {
        return new NioDatagramChannel(this, pipeline, this.sink, this.sink.nextWorker());
    }

    public void releaseExternalResources() {
        ExecutorUtil.terminate(this.workerExecutor);
    }
}

