/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.security;

import com.google.protobuf.MessageLite;
import com.mapr.baseutils.BaseUtilsHelper;
import com.mapr.baseutils.Errno;
import com.mapr.baseutils.cldbutils.CLDBRpcCommonUtils;
import com.mapr.fs.cldb.proto.CLDBProto;
import com.mapr.fs.proto.Common;
import com.mapr.fs.proto.Security;
import com.mapr.security.MutableInt;
import com.mapr.security.Security;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.apache.log4j.Logger;

public class ClusterServerTicketGeneration {
    private static final Logger LOG = Logger.getLogger(ClusterServerTicketGeneration.class);
    private static String maprHome = BaseUtilsHelper.getPathToMaprHome();
    private String maprUser;
    private String maprGroup;
    private static ClusterServerTicketGeneration s_instance = new ClusterServerTicketGeneration();

    private ClusterServerTicketGeneration() {
        Properties daemonConfProperties = new Properties();
        String daemonConfName = maprHome + "/conf/daemon.conf";
        try {
            FileReader dataReader = new FileReader(daemonConfName);
            daemonConfProperties.load(dataReader);
            ((Reader)dataReader).close();
            this.maprUser = daemonConfProperties.getProperty("mapr.daemon.user");
            this.maprGroup = daemonConfProperties.getProperty("mapr.daemon.group");
        }
        catch (FileNotFoundException nfe) {
            LOG.warn((Object)("File not found: " + daemonConfName));
        }
        catch (IOException e) {
            LOG.warn((Object)("Exception while trying to read properties from: " + daemonConfName), (Throwable)e);
        }
        catch (Throwable t) {
            LOG.warn((Object)("Exception while trying to read properties from: " + daemonConfName), t);
        }
    }

    public static ClusterServerTicketGeneration getInstance() {
        return s_instance;
    }

    public void generateTicketAndSetServerKey() throws IOException {
        String currentClusterName = CLDBRpcCommonUtils.getInstance().getCurrentClusterName();
        if (currentClusterName == null) {
            throw new IOException("Current cluster name is not found");
        }
        this.generateTicketAndSetServerKey(currentClusterName);
    }

    public void generateTicketAndSetServerKey(String clusterName) throws IOException {
        String ticketPath = maprHome + "/conf/maprserverticket";
        if (!new File(ticketPath).exists()) {
            throw new FileNotFoundException("Security is enabled, but userTicketFile can not be found.");
        }
        Security.SetTicketAndKeyFile(ticketPath);
        MutableInt err = new MutableInt();
        Security.TicketAndKey ticketKey = Security.GetTicketAndKeyForCluster(Security.ServerKeyType.CldbKey, clusterName, err);
        if (err.GetValue() != 0) {
            throw new IOException("Could not get the ticket: " + err.GetValue());
        }
        long ticketExpTime = ticketKey.getExpiryTime();
        if (ticketExpTime * 1000L < System.currentTimeMillis()) {
            throw new IOException("My Ticket Expired");
        }
        Security.CredentialsMsg userCreds = ticketKey.getUserCreds();
        Security.CredentialsMsg.Builder newCreds = Security.CredentialsMsg.newBuilder((Security.CredentialsMsg)userCreds);
        if (userCreds.getUserName() == null || userCreds.getUserName().isEmpty()) {
            if (this.maprUser != null) {
                newCreds.setUserName(this.maprUser);
            } else {
                LOG.warn((Object)"UserName is not known and will create issues later on");
            }
        }
        CLDBProto.GetServerKeyRequest.Builder bldSK = CLDBProto.GetServerKeyRequest.newBuilder();
        bldSK.setCreds(userCreds);
        bldSK.setSendBlacklistInfo(true);
        byte[] data = null;
        try {
            data = CLDBRpcCommonUtils.getInstance().sendRequest(clusterName, Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.GetServerKeyProc.getNumber(), (MessageLite)bldSK.build(), CLDBProto.GetServerKeyResponse.class, Security.ServerKeyType.CldbKey);
        }
        catch (Throwable t) {
            throw new IOException("RPC Request to get ServerKey. No data returned", t);
        }
        if (data == null) {
            throw new IOException("userKey is null from CLDB!");
        }
        CLDBProto.GetServerKeyResponse keyResp = CLDBProto.GetServerKeyResponse.parseFrom((byte[])data);
        if (keyResp.getStatus() != 0) {
            LOG.error((Object)("Request to get ServerKey failed with error: " + Errno.toString(keyResp.getStatus())));
            throw new IOException("Request to get ServerKey failed with error: " + Errno.toString(keyResp.getStatus()));
        }
        if (!keyResp.hasServerKey()) {
            throw new IOException("key from CLDB does not contain a server key!");
        }
        Security.Key serverKey = keyResp.getServerKey();
        int[] gids = new int[newCreds.getGidsCount()];
        for (int i = 0; i < newCreds.getGidsCount(); ++i) {
            gids[i] = newCreds.getGids(i);
        }
        Security.SetKey(Security.ServerKeyType.ServerKey, serverKey);
        Security.TicketAndKey localTicketAndKey = Security.GenerateTicketAndKey(Security.ServerKeyType.ServerKey, newCreds.getUserName(), newCreds.getUid(), gids, ticketExpTime, 0L, true, err);
        if (err.GetValue() != 0) {
            throw new IOException("Could not generate ticket: " + err.GetValue());
        }
        Security.SetTicketAndKey(Security.ServerKeyType.ServerKey, clusterName, localTicketAndKey);
        this.updateBlacklistInfo(keyResp);
        LOG.info((Object)("Server key was cached for cluster: " + clusterName));
    }

    private void updateBlacklistInfo(CLDBProto.GetServerKeyResponse keyResp) {
        int numOfBlacklistedAes = keyResp.getBlacklistedaesCount();
        if (numOfBlacklistedAes > 0) {
            List blacklistedAes = keyResp.getBlacklistedaesList();
            int[] uids = new int[numOfBlacklistedAes];
            long[] blacklistTimes = new long[numOfBlacklistedAes];
            Iterator iterator = blacklistedAes.iterator();
            int index = 0;
            CLDBProto.BlacklistedAeMsg blacklistedAe = null;
            while (iterator.hasNext()) {
                blacklistedAe = (CLDBProto.BlacklistedAeMsg)iterator.next();
                uids[index] = blacklistedAe.getId();
                blacklistTimes[index] = blacklistedAe.getBlacklistTime();
                ++index;
            }
            Security.BlacklistAndCloseConnections(uids, blacklistTimes, true);
        }
    }
}

