/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.baseutils.metric;

import com.mapr.baseutils.metric.MetricRepo;
import com.mapr.baseutils.metric.MetricRepoBase;
import com.mapr.fs.proto.clustermetrics.ClusterMetricsProto;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class NodeMetricRepo
extends MetricRepoBase
implements MetricRepo {
    private static final Logger LOG = Logger.getLogger(NodeMetricRepo.class);
    private static final String NODE_INSERT_SQL = "insert into metrics.NODE (NODE_ID, HOSTNAME, HOSTID, CLUSTER_ID) values(?, ?, ?, ?)";
    private ClusterMetricsProto.NodeMetric nodeMetric;

    public NodeMetricRepo(ClusterMetricsProto.NodeMetric nodeMetric) {
        this.nodeMetric = nodeMetric;
    }

    @Override
    public List<ClusterMetricsProto.Counters> prepareTransactions() {
        ArrayList<ClusterMetricsProto.Counters> metricTransactions = new ArrayList<ClusterMetricsProto.Counters>();
        if (this.nodeMetric.hasMetricAttrs()) {
            if (this.nodeMetric.hasCpuUptime()) {
                metricTransactions.add(ClusterMetricsProto.Counters.newBuilder().setCounterName("CPUUPTIME").setCounterValue(this.nodeMetric.getCpuUptime()).build());
            }
            if (this.nodeMetric.hasMemoryUsed()) {
                metricTransactions.add(ClusterMetricsProto.Counters.newBuilder().setCounterName("MEMORYUSED").setCounterValue(this.nodeMetric.getMemoryUsed()).build());
            }
            if (this.nodeMetric.hasCpuIdle()) {
                metricTransactions.add(ClusterMetricsProto.Counters.newBuilder().setCounterName("CPUIDLE").setCounterValue(this.nodeMetric.getCpuIdle()).build());
            }
            if (this.nodeMetric.hasReadOps()) {
                metricTransactions.add(ClusterMetricsProto.Counters.newBuilder().setCounterName("READOPS").setCounterValue(this.nodeMetric.getReadOps()).build());
            }
            if (this.nodeMetric.hasReadKBytes()) {
                metricTransactions.add(ClusterMetricsProto.Counters.newBuilder().setCounterName("READKBYTES").setCounterValue(this.nodeMetric.getReadKBytes()).build());
            }
            if (this.nodeMetric.hasWriteOps()) {
                metricTransactions.add(ClusterMetricsProto.Counters.newBuilder().setCounterName("WRITEOPS").setCounterValue(this.nodeMetric.getWriteOps()).build());
            }
            if (this.nodeMetric.hasWriteKBytes()) {
                metricTransactions.add(ClusterMetricsProto.Counters.newBuilder().setCounterName("WRITEKBYTES").setCounterValue(this.nodeMetric.getWriteKBytes()).build());
            }
            if (this.nodeMetric.hasBytesIn()) {
                metricTransactions.add(ClusterMetricsProto.Counters.newBuilder().setCounterName("BYTESIN").setCounterValue(this.nodeMetric.getBytesIn()).build());
            }
            if (this.nodeMetric.hasBytesOut()) {
                metricTransactions.add(ClusterMetricsProto.Counters.newBuilder().setCounterName("BYTESOUT").setCounterValue(this.nodeMetric.getBytesOut()).build());
            }
            if (this.nodeMetric.hasServerUsedSizeMB()) {
                metricTransactions.add(ClusterMetricsProto.Counters.newBuilder().setCounterName("SERVUSEDSIZEMB").setCounterValue(this.nodeMetric.getServerUsedSizeMB()).build());
            }
            if (this.nodeMetric.hasServerAvailableSizeMB()) {
                metricTransactions.add(ClusterMetricsProto.Counters.newBuilder().setCounterName("SERVAVAILSIZEMB").setCounterValue(this.nodeMetric.getServerAvailableSizeMB()).build());
            }
            if (this.nodeMetric.hasRpcCount()) {
                metricTransactions.add(ClusterMetricsProto.Counters.newBuilder().setCounterName("RPCCOUNT").setCounterValue(this.nodeMetric.getRpcCount()).build());
            }
            if (this.nodeMetric.hasRpcInBytes()) {
                metricTransactions.add(ClusterMetricsProto.Counters.newBuilder().setCounterName("RPCINBYTES").setCounterValue(this.nodeMetric.getRpcInBytes()).build());
            }
            if (this.nodeMetric.hasRpcOutBytes()) {
                metricTransactions.add(ClusterMetricsProto.Counters.newBuilder().setCounterName("RPCOUTBYTES").setCounterValue(this.nodeMetric.getRpcOutBytes()).build());
            }
            if (this.nodeMetric.hasCpuNice()) {
                metricTransactions.add(ClusterMetricsProto.Counters.newBuilder().setCounterName("CPUNICE").setCounterValue(this.nodeMetric.getCpuNice()).build());
            }
            if (this.nodeMetric.hasCpuSystem()) {
                metricTransactions.add(ClusterMetricsProto.Counters.newBuilder().setCounterName("CPUSYSTEM").setCounterValue(this.nodeMetric.getCpuSystem()).build());
            }
            if (this.nodeMetric.hasCpuUser()) {
                metricTransactions.add(ClusterMetricsProto.Counters.newBuilder().setCounterName("CPUUSER").setCounterValue(this.nodeMetric.getCpuUser()).build());
            }
            if (this.nodeMetric.hasMemoryCached()) {
                metricTransactions.add(ClusterMetricsProto.Counters.newBuilder().setCounterName("MEMORYCACHED").setCounterValue(this.nodeMetric.getMemoryCached()).build());
            }
            if (this.nodeMetric.hasMemoryShared()) {
                metricTransactions.add(ClusterMetricsProto.Counters.newBuilder().setCounterName("MEMORYSHARED").setCounterValue(this.nodeMetric.getMemoryShared()).build());
            }
            if (this.nodeMetric.hasMemoryBuffers()) {
                metricTransactions.add(ClusterMetricsProto.Counters.newBuilder().setCounterName("MEMORYBUFFERS").setCounterValue(this.nodeMetric.getMemoryBuffers()).build());
            }
            if (this.nodeMetric.hasSwapFree()) {
                metricTransactions.add(ClusterMetricsProto.Counters.newBuilder().setCounterName("SWAPFREE").setCounterValue(this.nodeMetric.getSwapFree()).build());
            }
            if (this.nodeMetric.hasPktsIn()) {
                metricTransactions.add(ClusterMetricsProto.Counters.newBuilder().setCounterName("PKTSIN").setCounterValue(this.nodeMetric.getPktsIn()).build());
            }
            if (this.nodeMetric.hasPktsOut()) {
                metricTransactions.add(ClusterMetricsProto.Counters.newBuilder().setCounterName("PKTSOUT").setCounterValue(this.nodeMetric.getPktsOut()).build());
            }
            if (this.nodeMetric.hasLoadOnePerc()) {
                metricTransactions.add(ClusterMetricsProto.Counters.newBuilder().setCounterName("LOAD1PERCENT").setCounterValue(this.nodeMetric.getLoadOnePerc()).build());
            }
            if (this.nodeMetric.hasLoadFivePerc()) {
                metricTransactions.add(ClusterMetricsProto.Counters.newBuilder().setCounterName("LOAD5PERCENT").setCounterValue(this.nodeMetric.getLoadFivePerc()).build());
            }
            if (this.nodeMetric.hasLoadFifteenPerc()) {
                metricTransactions.add(ClusterMetricsProto.Counters.newBuilder().setCounterName("LOAD15PERCENT").setCounterValue(this.nodeMetric.getLoadFifteenPerc()).build());
            }
            if (this.nodeMetric.hasProcRun()) {
                metricTransactions.add(ClusterMetricsProto.Counters.newBuilder().setCounterName("PROCRUN").setCounterValue(this.nodeMetric.getProcRun()).build());
            }
            if (this.nodeMetric.hasTtmapused()) {
                metricTransactions.add(ClusterMetricsProto.Counters.newBuilder().setCounterName("TTMAPUSED").setCounterValue(this.nodeMetric.getTtmapused()).build());
            }
            if (this.nodeMetric.hasTtreduceused()) {
                metricTransactions.add(ClusterMetricsProto.Counters.newBuilder().setCounterName("TTREDUCEUSED").setCounterValue(this.nodeMetric.getTtreduceused()).build());
            }
        }
        return metricTransactions;
    }

    @Override
    public ClusterMetricsProto.MetricAttributes getMetricAttributes() {
        if (this.nodeMetric.hasMetricAttrs()) {
            return this.nodeMetric.getMetricAttrs();
        }
        return null;
    }

    @Override
    public MetricRepo.MetricType getMetricType() {
        return MetricRepo.MetricType.NODE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void executeDBOperations(Connection dbConnection) throws SQLException {
        block12: {
            if (!this.nodeMetric.hasMetricAttrs()) {
                LOG.error((Object)"Missing Node Metric Attributes. Node data won't be inserted");
                return;
            }
            ClusterMetricsProto.MetricAttributes metricAttrs = this.nodeMetric.getMetricAttrs();
            if (!metricAttrs.hasNodeId()) {
                LOG.error((Object)"Node ID is missing from request. Node data won't be inserted");
                return;
            }
            try (PreparedStatement nodeInsertPrepStmt = dbConnection.prepareStatement(NODE_INSERT_SQL);){
                if (!this.nodeMetric.hasFinalMetric()) break block12;
                ClusterMetricsProto.NodeMetric.FinalMetric nFinalMetric = this.nodeMetric.getFinalMetric();
                nodeInsertPrepStmt.setString(1, metricAttrs.getNodeId());
                if (nFinalMetric.hasHostname()) {
                    nodeInsertPrepStmt.setString(2, nFinalMetric.getHostname());
                }
                if (nFinalMetric.hasHostid()) {
                    nodeInsertPrepStmt.setString(3, nFinalMetric.getHostid());
                }
                if (nFinalMetric.hasCluster() && !nFinalMetric.getCluster().isEmpty()) {
                    nodeInsertPrepStmt.setString(4, nFinalMetric.getCluster());
                } else {
                    nodeInsertPrepStmt.setString(4, this.getClusterId());
                }
                try {
                    nodeInsertPrepStmt.executeUpdate();
                }
                catch (SQLException e) {
                    if (e.getErrorCode() == 1062) {
                        break block12;
                    }
                    LOG.error((Object)"Exception while trying to insert Node data: ", (Throwable)e);
                }
            }
        }
    }

    @Override
    public List<ClusterMetricsProto.Pair> prepareEvents() {
        ArrayList<ClusterMetricsProto.Pair> events = new ArrayList<ClusterMetricsProto.Pair>();
        if (this.nodeMetric.hasEventMetric() && this.nodeMetric.hasMetricAttrs()) {
            ClusterMetricsProto.NodeMetric.EventMetric nEventMetric = this.nodeMetric.getEventMetric();
            if (nEventMetric.hasDiskCount()) {
                events.add(ClusterMetricsProto.Pair.newBuilder().setName("DISKCOUNT").setValue(Integer.toString(nEventMetric.getDiskCount())).build());
            }
            if (nEventMetric.hasCpuCount()) {
                events.add(ClusterMetricsProto.Pair.newBuilder().setName("CPUCOUNT").setValue(Integer.toString(nEventMetric.getCpuCount())).build());
            }
            if (nEventMetric.hasTotalMB()) {
                events.add(ClusterMetricsProto.Pair.newBuilder().setName("TOTALMEMORY").setValue(Long.toString(nEventMetric.getTotalMB())).build());
            }
            if (nEventMetric.hasRootFull()) {
                events.add(ClusterMetricsProto.Pair.newBuilder().setName("ROOTFULLSTATUS").setValue(Boolean.toString(nEventMetric.getRootFull())).build());
            }
            if (nEventMetric.hasOptMaprFull()) {
                events.add(ClusterMetricsProto.Pair.newBuilder().setName("MAPRFULLSTATUS").setValue(Boolean.toString(nEventMetric.getOptMaprFull())).build());
            }
            if (nEventMetric.hasCorePresent()) {
                events.add(ClusterMetricsProto.Pair.newBuilder().setName("COREPRESENTSTATUS").setValue(Boolean.toString(nEventMetric.getCorePresent())).build());
            }
            if (nEventMetric.hasNicCount()) {
                events.add(ClusterMetricsProto.Pair.newBuilder().setName("TOTALNICS").setValue(Integer.toString(nEventMetric.getNicCount())).build());
            }
            if (nEventMetric.hasFaileddisks()) {
                events.add(ClusterMetricsProto.Pair.newBuilder().setName("FAILEDDISKS").setValue(Integer.toString(nEventMetric.getFaileddisks())).build());
            }
            if (nEventMetric.hasMaprdiskCount()) {
                events.add(ClusterMetricsProto.Pair.newBuilder().setName("MAPRDISKCOUNT").setValue(Integer.toString(nEventMetric.getMaprdiskCount())).build());
            }
            if (nEventMetric.hasServerCapacitySizeMB()) {
                events.add(ClusterMetricsProto.Pair.newBuilder().setName("SERVCAPACITYSIZEMB").setValue(Long.toString(nEventMetric.getServerCapacitySizeMB())).build());
            }
            if (nEventMetric.hasSwapTotal()) {
                events.add(ClusterMetricsProto.Pair.newBuilder().setName("SWAPTOTAL").setValue(Long.toString(nEventMetric.getSwapTotal())).build());
            }
            if (nEventMetric.hasTtmapslots()) {
                events.add(ClusterMetricsProto.Pair.newBuilder().setName("TTMAPSLOTS").setValue(Long.toString(nEventMetric.getTtmapslots())).build());
            }
            if (nEventMetric.hasTtreduceslots()) {
                events.add(ClusterMetricsProto.Pair.newBuilder().setName("TTREDUCESLOTS").setValue(Long.toString(nEventMetric.getTtreduceslots())).build());
            }
            events.addAll(nEventMetric.getConfServiceList());
            events.addAll(nEventMetric.getRunningServiceList());
            events.addAll(nEventMetric.getServiceFailedList());
            events.addAll(nEventMetric.getServiceStoppedList());
            events.addAll(nEventMetric.getAlarmsList());
        }
        return events;
    }
}

