/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.baseutils;

import com.mapr.baseutils.cldbutils.CLDBRpcCommonUtils;
import com.mapr.security.JNISecurity;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import org.apache.log4j.Logger;

public class BaseUtilsHelper {
    private static final String MAPR_ENV_VAR = "MAPR_HOME";
    private static final String MAPR_PROPERTY_HOME = "mapr.home.dir";
    private static final String MAPR_HOME_PATH_DEFAULT = "/opt/mapr";
    public static final String HOST_NAME_FILE_PATH = BaseUtilsHelper.getPathToMaprHome() + "/hostname";
    private static final Logger LOG = Logger.getLogger(BaseUtilsHelper.class);
    public static String clusterId = null;
    private static String hostname = null;

    public static synchronized String getClusterId() {
        if (clusterId != null) {
            return clusterId;
        }
        String maprHome = BaseUtilsHelper.getPathToMaprHome();
        if (maprHome != null) {
            BufferedReader fis = null;
            try {
                fis = new BufferedReader(new FileReader(maprHome + "/conf/clusterid"));
                String clusterString = fis.readLine();
                String[] clusterNames = clusterString.split("\\s");
                clusterId = clusterNames[0];
                fis.close();
            }
            catch (FileNotFoundException fne) {
                LOG.error((Object)"Exception while trying to get info from clusterid file", (Throwable)fne);
            }
            catch (IOException ioe) {
                LOG.error((Object)("Exception while trying to read file: " + maprHome + "/conf/clusterid"), (Throwable)ioe);
            }
        }
        return clusterId;
    }

    public static String getPathToMaprHome() {
        String maprHome = System.getenv(MAPR_ENV_VAR);
        if (maprHome == null && (maprHome = System.getProperty(MAPR_PROPERTY_HOME)) == null) {
            maprHome = MAPR_HOME_PATH_DEFAULT;
        }
        return maprHome;
    }

    public static synchronized String getMapRHostName() {
        if (hostname == null) {
            hostname = BaseUtilsHelper.readMapRHostNameFromFile(HOST_NAME_FILE_PATH);
        }
        return hostname;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readMapRHostNameFromFile(String filePath) {
        if (!new File(filePath).exists()) {
            LOG.debug((Object)(filePath + " does not exist. Assuming client-only installation.."));
            return "MAPR_CLIENT";
        }
        BufferedReader breader = null;
        FileReader freader = null;
        try {
            freader = new FileReader(filePath);
            breader = new BufferedReader(freader);
            String string = breader.readLine();
            return string;
        }
        catch (Exception e) {
            LOG.warn((Object)("Error while reading " + filePath), (Throwable)e);
        }
        finally {
            try {
                if (breader != null) {
                    breader.close();
                }
            }
            catch (Throwable t) {
                LOG.error((Object)"Failed to close buffered reader", t);
            }
            try {
                if (freader != null) {
                    freader.close();
                }
            }
            catch (Throwable t) {
                LOG.error((Object)("Failed to close " + filePath), t);
            }
        }
        return null;
    }

    public static synchronized void setMapRHostName(String host) {
        if (hostname == null) {
            hostname = host;
        }
    }

    public static String getUrlScheme() {
        return JNISecurity.IsSecurityEnabled(CLDBRpcCommonUtils.getInstance().getCurrentClusterName()) ? "https://" : "http://";
    }
}

