/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.fs;

import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

public class BlockLocationFileReadTest {
    static long fsize = 0x28000000L;
    static long chunksize = 0x4000000L;
    static String filePath = "/maprtbl";
    static Configuration conf;
    static FileSystem fs;
    public static final String MAPRFS_URI = "maprfs://localhost:7222/";

    public static void Usage() {
        System.err.println("usage: BlockLocationFileGen [-fsize filesize] [-csize chunksize] [-fpath /file/path]");
        System.exit(1);
    }

    public static void SetMaprFilesystemConfig() throws Exception {
        conf = new Configuration();
        conf.set("fs.maprfs.impl", "com.mapr.fs.MapRFileSystem");
        fs = FileSystem.get((URI)URI.create(conf.get("fs.default.name", MAPRFS_URI)), (Configuration)conf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void ReadFile() throws Exception {
        Path f = new Path(filePath);
        long counter = 1L;
        try (FSDataInputStream in = fs.open(f);){
            in.seek(0L);
            while (in.getPos() < fsize) {
                char tempc;
                if (in.readChar() != '<') continue;
                System.out.print(in.getPos() + "\t");
                char[] data = new char[2000];
                int i = 0;
                while ((tempc = in.readChar()) != '>') {
                    data[i] = tempc;
                    ++i;
                }
                String hostnames = new String(data);
                System.out.print("hostnames = " + hostnames + "\t");
                System.out.println(in.getPos());
                in.seek(counter * chunksize);
                ++counter;
            }
        }
    }

    public static void ParseArgs(String[] args) throws Exception {
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equalsIgnoreCase("-fsize")) {
                fsize = Long.parseLong(args[++i]);
                continue;
            }
            if (args[i].equalsIgnoreCase("-csize")) {
                chunksize = Long.parseLong(args[++i]);
                continue;
            }
            if (args[i].equalsIgnoreCase("-fpath")) {
                filePath = args[++i];
                continue;
            }
            BlockLocationFileReadTest.Usage();
        }
        System.out.println("fsize = " + fsize + "\n" + "chunksize = " + chunksize + "\n" + "filePath = " + filePath + "\n");
    }

    public static void main(String[] args) throws Exception {
        BlockLocationFileReadTest.ParseArgs(args);
        BlockLocationFileReadTest.SetMaprFilesystemConfig();
        BlockLocationFileReadTest.ReadFile();
        System.out.println("BlockLocationFileReadTest completed.");
    }
}

