/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.fs;

import com.mapr.fs.MapRFileStatus;
import com.mapr.fs.MapRFileSystem;
import java.io.IOException;
import java.net.URI;
import junit.framework.TestCase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;

public class TestCompression
extends TestCase {
    private byte[] data;
    MapRFileSystem fs;
    Configuration conf;
    public static final Log LOG = LogFactory.getLog(TestCompression.class);
    Path top;
    Path p1;
    Path p2;
    Path p3;
    FsPermission perm;

    protected void setUp() throws Exception {
        this.fs = new MapRFileSystem();
        this.conf = new Configuration();
        try {
            URI uri = new URI("maprfs://127.0.0.1:7222");
            this.fs.initialize(uri, this.conf);
        }
        catch (Exception e) {
            System.out.println("Exception " + e + " occurred");
        }
        this.data = new byte[65536];
        for (int i = 0; i < this.data.length; ++i) {
            this.data[i] = (byte)(i % 10);
        }
        this.perm = new FsPermission(502);
        this.top = new Path("/testdir");
        this.fs.mkdirs(this.top, this.perm, true);
        this.p1 = new Path("testdir/dirCompress");
        this.p2 = new Path("testdir/dirNoCompress");
        this.p3 = new Path("testdir/dirChunkSize32M");
    }

    protected void tearDown() throws Exception {
    }

    public void testCreate() throws IOException {
        FSDataOutputStream os;
        Path p;
        this.fs.mkdirs(this.p1, this.perm, true);
        try {
            p = new Path(this.p1 + "/xyz");
            os = this.fs.create(p, 0, this.perm, true, false, true, 4096, (short)1, 0L, null, true);
            os.write(this.data, 0, 65536);
            os.close();
        }
        catch (Exception e) {
            TestCompression.assertTrue((boolean)false);
        }
        this.fs.mkdirs(this.p2, this.perm, false);
        try {
            p = new Path(this.p2 + "/xyz");
            os = this.fs.create(p, 0, this.perm, true, false, true, 4096, (short)1, 0L, null, true);
            os.write(this.data, 0, 65536);
            os.close();
        }
        catch (Exception e) {
            TestCompression.assertTrue((boolean)false);
        }
        this.fs.mkdirs(this.p3, this.perm, 0x2000000L);
        try {
            p = new Path(this.p3 + "/xyz");
            os = this.fs.create(p, 0, this.perm, true, false, true, 4096, (short)1, 0L, null, true);
            os.write(this.data, 0, 65536);
            os.close();
        }
        catch (Exception e) {
            TestCompression.assertTrue((boolean)false);
        }
    }

    public void testListStatus() throws IOException {
        for (MapRFileStatus s : this.fs.listStatus(this.p1)) {
            System.out.println("path = " + s.getPath());
            System.out.println("FileLen " + s.getLen());
            System.out.println("BlockSize " + s.getBlockSize());
            System.out.println("IsDir " + s.isDir());
            System.out.println("Permission " + s.getPermission());
            System.out.println("");
        }
        for (MapRFileStatus s : this.fs.listStatus(this.p2)) {
            System.out.println("path = " + s.getPath());
            System.out.println("FileLen " + s.getLen());
            System.out.println("BlockSize " + s.getBlockSize());
            System.out.println("IsDir " + s.isDir());
            System.out.println("Permission " + s.getPermission());
            System.out.println("");
        }
        for (MapRFileStatus s : this.fs.listStatus(this.p3)) {
            System.out.println("path = " + s.getPath());
            System.out.println("FileLen " + s.getLen());
            System.out.println("BlockSize " + s.getBlockSize());
            System.out.println("IsDir " + s.isDir());
            System.out.println("Permission " + s.getPermission());
            System.out.println("");
        }
        this.fs.delete(this.top, true);
        this.fs.close();
    }
}

