/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.conf;

import com.mapr.baseutils.cldbutils.CLDBRpcCommonUtils;
import com.mapr.hadoop.yarn.util.MapRFSLoggingHandler;
import com.mapr.security.JNISecurity;
import java.util.Properties;
import org.apache.hadoop.http.HttpConfig;

public class YarnDefaultProperties
extends Properties {
    private static final long serialVersionUID = 42L;
    public static final String MAPR_TICKET_EXPIRY = "yarn.mapr.ticket.expiration";
    public static final String DEFAULT_MAPR_TICKET_EXPIRY = "604800000";
    public static final String RM_DIR = "yarn.resourcemanager.dir";
    public static final String DEFAULT_RM_DIR = "/var/mapr/cluster/yarn/rm";
    public static final String RM_STAGING_DIR = "yarn.resourcemanager.staging";
    public static final String DEFAULT_RM_STAGING_DIR = "/var/mapr/cluster/yarn/rm/staging";
    public static final String RM_SYSTEM_DIR = "yarn.resourcemanager.system";
    public static final String DEFAULT_RM_SYSTEM_DIR = "/var/mapr/cluster/yarn/rm/system";
    public static final String RM_VOLUME_MANAGER_SERVICE = "RMVolumeManager";
    public static final String APP_HISTORY_VOLUME_MANAGER_SERVICE = "HSVolumeManager";
    public static final String APACHE_SHUFFLE_SERVICE_ID = "mapreduce_shuffle";
    public static final String MAPR_SHUFFLE_SERVICE_ID = "mapr_direct_shuffle";
    public static final String FAIR_SCHEDULER_CLASS = "org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FairScheduler";
    private static final boolean isSecurityEnabled = JNISecurity.IsSecurityEnabled((String)CLDBRpcCommonUtils.getInstance().getCurrentClusterName());

    public YarnDefaultProperties() {
        this.put("yarn.resourcemanager.principal", "mapr");
        this.put(MAPR_TICKET_EXPIRY, DEFAULT_MAPR_TICKET_EXPIRY);
        this.put(RM_DIR, DEFAULT_RM_DIR);
        this.put(RM_STAGING_DIR, DEFAULT_RM_STAGING_DIR);
        this.put(RM_SYSTEM_DIR, DEFAULT_RM_SYSTEM_DIR);
        if (isSecurityEnabled) {
            this.put("yarn.http.policy", HttpConfig.Policy.HTTPS_ONLY.name());
        }
        this.put("yarn.nodemanager.external.token.localizer", "com.mapr.hadoop.yarn.nodemanager.MapRTicketLocalizer");
        this.put("yarn.external.token.manager", "com.mapr.hadoop.yarn.security.MapRTicketManager");
        this.put("yarn.resourcemanager.aux-services", RM_VOLUME_MANAGER_SERVICE);
        this.put(String.format("yarn.resourcemanager.aux-services.%s.class", RM_VOLUME_MANAGER_SERVICE), "com.mapr.hadoop.yarn.resourcemanager.RMVolumeManager");
        this.put("yarn.timeline-service.generic-application-history.aux-services", APP_HISTORY_VOLUME_MANAGER_SERVICE);
        this.put(String.format("yarn.resourcemanager.aux-services.%s.class", APP_HISTORY_VOLUME_MANAGER_SERVICE), "com.mapr.hadoop.yarn.resourcemanager.RMVolumeManager");
        this.put("yarn.resourcemanager.address", "${yarn.resourcemanager.hostname}:8032");
        this.put("yarn.resourcemanager.scheduler.address", "${yarn.resourcemanager.hostname}:8030");
        this.put("yarn.resourcemanager.resource-tracker.address", "${yarn.resourcemanager.hostname}:8031");
        this.put("yarn.nodemanager.resource.memory-mb", "${nodemanager.resource.memory-mb}");
        this.put("yarn.nodemanager.resource.cpu-vcores", "${nodemanager.resource.cpu-vcores}");
        this.put("yarn.nodemanager.resource.io-spindles", "${nodemanager.resource.io-spindles}");
        this.put("yarn.nodemanager.aux-services", "mapreduce_shuffle,mapr_direct_shuffle");
        this.put("yarn.nodemanager.aux-services.mapreduce_shuffle.class", "org.apache.hadoop.mapred.ShuffleHandler");
        this.put("yarn.nodemanager.aux-services.mapr_direct_shuffle.class", "com.mapr.hadoop.mapred.LocalVolumeAuxService");
        this.put("yarn.nodemanager.container-executor.class", "org.apache.hadoop.yarn.server.nodemanager.LinuxContainerExecutor");
        this.put("yarn.resourcemanager.store.class", "org.apache.hadoop.yarn.server.resourcemanager.recovery.FileSystemRMStateStore");
        this.put("yarn.resourcemanager.fs.state-store.uri", DEFAULT_RM_SYSTEM_DIR);
        this.put("yarn.resourcemanager.scheduler.class", FAIR_SCHEDULER_CLASS);
        this.put("yarn.log-aggregation-enable", "false");
        this.put("yarn.dfs-logging.enable", "true");
        this.put("yarn.dfs-logging.handler-class", MapRFSLoggingHandler.class.getName());
        this.put("yarn.dfs-logging.dir-glob", "maprfs:////var/mapr/local/*/logs/yarn/userlogs");
        this.put("yarn.log-aggregation.retain-seconds", "2592000");
    }
}

