/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.hadoop.yarn.nodemanager;

import com.mapr.hadoop.yarn.util.YarnAppUtil;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.server.nodemanager.LocalDirsHandlerService;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.localizer.LocalizerContext;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.localizer.security.ExternalTokenLocalizer;

public class MapRTicketLocalizer
implements ExternalTokenLocalizer {
    private static final Log LOG = LogFactory.getLog(MapRTicketLocalizer.class);

    public void run(LocalizerContext context, Configuration conf, LocalDirsHandlerService localDirsHandlerService) {
        if (!UserGroupInformation.isSecurityEnabled()) {
            return;
        }
        try {
            this.localizeUserTicket(context.getContainerId(), context.getUser(), conf, localDirsHandlerService);
        }
        catch (IOException e) {
            throw new YarnRuntimeException((Throwable)e);
        }
    }

    public Path getTokenPath(String appIdStr, Configuration conf) {
        return UserGroupInformation.isSecurityEnabled() ? YarnAppUtil.getNMPrivateTicketPath(appIdStr, conf) : null;
    }

    public String getTokenEnvVar() {
        return "MAPR_TICKETFILE_LOCATION";
    }

    private void localizeUserTicket(ContainerId containerId, String username, Configuration conf, LocalDirsHandlerService localDirsHandlerService) throws IOException {
        String appIdStr = containerId.getApplicationAttemptId().getApplicationId().toString();
        FileSystem fs = FileSystem.get((Configuration)conf);
        Path ticketPath = YarnAppUtil.getRMSystemMapRTicketPath(appIdStr, fs, conf);
        FileStatus status = fs.getFileStatus(ticketPath);
        long tokenSize = status.getLen();
        Path localTicketPath = localDirsHandlerService.getLocalPathForWrite(YarnAppUtil.getNMPrivateRelativeTicketLocation(appIdStr), tokenSize, true);
        fs.copyToLocalFile(ticketPath, localTicketPath);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Localized user ticket file from " + ticketPath.toUri().getPath() + " to " + localTicketPath.toUri().getPath()));
        }
    }
}

