/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.fs.hbase.mapreduce;

import com.mapr.fs.BulkLoadHelper;
import java.io.IOException;
import java.net.URI;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeSet;
import java.util.UUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.filecache.DistributedCache;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.HFileOutputFormat;
import org.apache.hadoop.hbase.mapreduce.TableMapReduceUtil;
import org.apache.hadoop.hbase.mapreduce.TableMapper;
import org.apache.hadoop.hbase.mapreduce.hadoopbackport.TotalOrderPartitioner;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

public class CopyTable
extends Configured
implements Tool {
    private static final Log LOG = LogFactory.getLog(CopyTable.class);
    static final String NAME = "CopyTable";
    String srcTableName;
    String dstTableName;
    static boolean isSuccess = false;

    private void usage() {
        System.err.println("Usage: CopyTable -src srcTable -dst dstTable -outputDir outputDir");
        System.exit(1);
    }

    private void parseArgs(String[] args) throws Exception {
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equalsIgnoreCase("-src")) {
                this.srcTableName = args[++i];
                continue;
            }
            if (args[i].equalsIgnoreCase("-dst")) {
                this.dstTableName = args[++i];
                continue;
            }
            this.usage();
        }
        if (this.srcTableName == null || this.dstTableName == null) {
            this.usage();
        }
    }

    private static List<ImmutableBytesWritable> getRegionStartKeys(HTable table) throws IOException {
        byte[][] byteKeys = table.getStartKeys();
        ArrayList<ImmutableBytesWritable> ret = new ArrayList<ImmutableBytesWritable>(byteKeys.length);
        for (byte[] byteKey : byteKeys) {
            ret.add(new ImmutableBytesWritable(byteKey));
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writePartitions(Configuration conf, Path partitionsPath, List<ImmutableBytesWritable> startKeys) throws IOException {
        if (startKeys.isEmpty()) {
            throw new IllegalArgumentException("No regions passed");
        }
        TreeSet<ImmutableBytesWritable> sorted = new TreeSet<ImmutableBytesWritable>(startKeys);
        ImmutableBytesWritable first = sorted.first();
        if (!first.equals((Object)HConstants.EMPTY_BYTE_ARRAY)) {
            throw new IllegalArgumentException("First region of table should have empty start key. Instead has: " + Bytes.toStringBinary((byte[])first.get()));
        }
        sorted.remove(first);
        FileSystem fs = partitionsPath.getFileSystem(conf);
        try (SequenceFile.Writer writer = SequenceFile.createWriter((FileSystem)fs, (Configuration)conf, (Path)partitionsPath, ImmutableBytesWritable.class, NullWritable.class);){
            for (ImmutableBytesWritable startKey : sorted) {
                writer.append((Writable)startKey, (Writable)NullWritable.get());
            }
        }
    }

    public int run(String[] args) throws Exception {
        this.parseArgs(args);
        Job job = new Job(this.getConf(), "CopyTable_" + this.dstTableName);
        Configuration conf = job.getConfiguration();
        job.setJarByClass(CopyTable.class);
        HBaseAdmin hbaseAdmin = new HBaseAdmin(conf);
        if (!hbaseAdmin.tableExists(this.dstTableName)) {
            BulkLoadHelper.createTableForCopy(conf, this.srcTableName, this.dstTableName);
        }
        hbaseAdmin.close();
        Scan scan = new Scan();
        scan.setMaxVersions();
        TableMapReduceUtil.initTableMapperJob((String)this.srcTableName, (Scan)scan, CopyTableMapper.class, ImmutableBytesWritable.class, KeyValue.class, (Job)job);
        LOG.info((Object)("Looking up current regions for table " + this.srcTableName));
        HTable srcTable = new HTable(conf, this.srcTableName);
        List<ImmutableBytesWritable> startKeys = CopyTable.getRegionStartKeys(srcTable);
        String uuid = UUID.randomUUID().toString();
        job.setPartitionerClass(TotalOrderPartitioner.class);
        Path partitionFile = new Path(job.getWorkingDirectory(), "partitions_" + uuid);
        TotalOrderPartitioner.setPartitionFile((Configuration)conf, (Path)partitionFile);
        CopyTable.writePartitions(conf, partitionFile, startKeys);
        URI partitionUri = new URI(partitionFile.toString());
        DistributedCache.addCacheFile((URI)partitionUri, (Configuration)conf);
        job.setNumReduceTasks(0);
        FileOutputFormat.setOutputPath((Job)job, (Path)new Path(job.getWorkingDirectory(), "output_" + uuid));
        job.setOutputKeyClass(ImmutableBytesWritable.class);
        job.setOutputValueClass(KeyValue.class);
        job.setOutputFormatClass(HFileOutputFormat.class);
        HFileOutputFormat.configureMapRTablePath((Job)job, (String)this.dstTableName);
        job.submit();
        System.out.println("job_id: " + job.getJobID().toString());
        int ret = job.waitForCompletion(true) ? 0 : 1;
        BulkLoadHelper.clearBulkLoad(conf, this.dstTableName);
        return ret;
    }

    public static void main(String[] args) throws Exception {
        int ret = 0;
        try {
            ret = ToolRunner.run((Configuration)new Configuration(), (Tool)new CopyTable(), (String[])args);
        }
        catch (Exception e) {
            ret = 1;
            e.printStackTrace();
        }
        System.exit(ret);
    }

    public static boolean copy(final String[] args, String user) throws Exception {
        UserGroupInformation ugi = CopyTable.createUser(user);
        ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                try {
                    int status = ToolRunner.run((Configuration)new Configuration(), (Tool)new CopyTable(), (String[])args);
                    if (status == 0) {
                        CopyTable.setJobSuccessful();
                    }
                }
                catch (Exception e) {
                    LOG.error((Object)("Exception while running copytable job: " + e));
                    throw new Exception(e.getMessage());
                }
                return null;
            }
        });
        return isSuccess;
    }

    public static void setJobSuccessful() {
        isSuccess = true;
    }

    public static void clearBulkLoad(String tableName) throws Exception {
        try {
            BulkLoadHelper.clearBulkLoad(new Configuration(), tableName);
        }
        catch (Exception e) {
            LOG.error((Object)("Exception while finishing copytable job: " + e));
            throw new Exception(e.getMessage());
        }
    }

    private static UserGroupInformation createUser(String user) throws IOException {
        return UserGroupInformation.createRemoteUser((String)user);
    }

    static class CopyTableMapper
    extends TableMapper<ImmutableBytesWritable, KeyValue> {
        CopyTableMapper() {
        }

        public void map(ImmutableBytesWritable row, Result value, Mapper.Context context) throws IOException {
            try {
                for (KeyValue kv : value.raw()) {
                    context.write((Object)row, (Object)kv);
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }
}

