/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.fs.hbase;

import com.mapr.fs.MapRFileSystem;
import com.mapr.fs.hbase.MapRDBConstants;
import com.mapr.fs.hbase.TableProperties;
import com.mapr.fs.proto.Common;
import com.mapr.fs.proto.Dbserver;
import java.io.IOException;
import java.util.List;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.io.compress.Compression;
import org.apache.hadoop.hbase.regionserver.BloomType;

public class SchemaHelper
implements MapRDBConstants {
    private static final long MILLISECONDS_TO_SECONDS = 1000L;
    private static final String COMPRESSION_RAW = "compression_raw";

    public static HColumnDescriptor toHColumnDescriptor(Dbserver.SchemaFamily schemaFamily) {
        return new HColumnDescriptor(schemaFamily.getName()).setValueInt("BLOCKSIZE", 8192).setValueBool("IN_MEMORY", schemaFamily.getInMemory()).setValueInt("VERSIONS", schemaFamily.getMaxVersions()).setValueInt("MIN_VERSIONS", schemaFamily.getMinVersions()).setValueStr("BLOOMFILTER", BloomType.ROW.toString()).setValueStr("COMPRESSION", SchemaHelper.toAlgorithmStr(schemaFamily.getCompression())).setValueInt("TTL", schemaFamily.hasTtl() ? (int)(schemaFamily.getTtl() / 1000L) : Integer.MAX_VALUE).setValue(COMPRESSION_RAW, Integer.toString(schemaFamily.getCompression().getNumber()));
    }

    public static Dbserver.ColumnFamilyAttr toColumnFamilyAttr(HColumnDescriptor newcf, boolean setName) {
        return SchemaHelper.toColumnFamilyAttr(null, newcf, setName);
    }

    public static Dbserver.ColumnFamilyAttr toColumnFamilyAttr(HColumnDescriptor oldcf, HColumnDescriptor newcf, boolean setName) {
        return Dbserver.ColumnFamilyAttr.newBuilder().setSchFamily(SchemaHelper.toSchemaFamily(oldcf, newcf, setName)).build();
    }

    private static Dbserver.SchemaFamily toSchemaFamily(HColumnDescriptor oldcf, HColumnDescriptor newcf, boolean setName) {
        Dbserver.SchemaFamily.Builder builder = Dbserver.SchemaFamily.newBuilder();
        if (setName && (oldcf == null || !oldcf.getNameAsString().equals(newcf.getNameAsString()))) {
            builder.setName(newcf.getNameAsString());
        }
        if (oldcf == null || oldcf.isInMemory() != newcf.isInMemory()) {
            builder.setInMemory(newcf.isInMemory());
        }
        if (oldcf == null || oldcf.getMinVersions() != newcf.getMinVersions()) {
            builder.setMinVersions(newcf.getMinVersions());
        }
        if (oldcf == null || oldcf.getMaxVersions() != newcf.getMaxVersions()) {
            builder.setMaxVersions(newcf.getMaxVersions());
        }
        if (oldcf == null || oldcf.getTimeToLive() != newcf.getTimeToLive()) {
            builder.setTtl((long)newcf.getTimeToLive() * 1000L);
        }
        if (newcf.getValue(COMPRESSION_RAW) != null) {
            builder.setCompression(Common.FileCompressionType.valueOf((int)Integer.parseInt(newcf.getValue(COMPRESSION_RAW))));
        } else if (oldcf == null || oldcf.getCompression() != newcf.getCompression()) {
            builder.setCompression(SchemaHelper.toFileCompressionType(newcf.getCompression()));
        }
        return builder.build();
    }

    public boolean validCompressionType(Compression.Algorithm algorithm) {
        switch (algorithm) {
            case NONE: 
            case GZ: 
            case LZO: 
            case LZ4: {
                return true;
            }
        }
        return false;
    }

    public static Common.FileCompressionType toFileCompressionType(Compression.Algorithm algorithm) {
        switch (algorithm) {
            case NONE: {
                return Common.FileCompressionType.FCT_OFF;
            }
            case GZ: {
                return Common.FileCompressionType.FCT_ZLIB;
            }
        }
        return Common.FileCompressionType.FCT_LZ4;
    }

    public static Compression.Algorithm toAlgorithm(Common.FileCompressionType fct) {
        switch (fct) {
            case FCT_ZLIB: {
                return Compression.Algorithm.GZ;
            }
            case FCT_OFF: {
                return Compression.Algorithm.NONE;
            }
        }
        return Compression.Algorithm.LZ4;
    }

    public static String toAlgorithmStr(Common.FileCompressionType fct) {
        switch (fct) {
            case FCT_ZLIB: {
                return "GZ";
            }
            case FCT_OFF: {
                return "NONE";
            }
        }
        return "LZ4";
    }

    public static HTableDescriptor toHTableDescriptor(MapRFileSystem mfs, Path path) throws IOException {
        return SchemaHelper.toHTableDescriptor(mfs, path, false);
    }

    public static HTableDescriptor toHTableDescriptor(MapRFileSystem mfs, Path path, boolean useName) throws IOException {
        HTableDescriptor desc = new HTableDescriptor(useName ? path.getName() : path.toUri().getPath());
        desc.setValue("IS_META", FALSE);
        desc.setValue("IS_ROOT", FALSE);
        MapRFileSystem.TableProperties tableProp = mfs.getTableAttr(path);
        if (tableProp.getUuid() != null) {
            String key = "UUID";
            desc.setValue(key.getBytes(), tableProp.getUuid());
        }
        SchemaHelper.fromTableAttr(tableProp.getAttr(), desc);
        List cfAttributes = mfs.listColumnFamily(mfs.resolveTablePath(path), false);
        for (Dbserver.ColumnFamilyAttr cfAttr : cfAttributes) {
            desc.addFamily(SchemaHelper.toHColumnDescriptor(cfAttr.getSchFamily()));
        }
        TableProperties.addPropertiesToTableDescriptor(path, desc);
        return desc;
    }

    public static void fromTableAttr(Dbserver.TableAttr attr, HTableDescriptor desc) {
        desc.setValue("BULKLOAD", attr.getBulkLoad() ? "true" : "false");
        desc.setValue("AUTOSPLIT", attr.getAutoSplit() ? "true" : "false");
        desc.setValue("MAX_FILE_SIZE", Long.toString(attr.getRegionSizeMB()));
        desc.setValue("MAX_VALUE_SIZE_IN_MEM", Integer.toString(attr.getMaxValueSzInMemIndex()));
        desc.setValue("RECLAIM_THRESH_PCNT_FOR_PACK", Integer.toString(attr.getReclaimThreshPcntForPack()));
        desc.setValue("MAXSPILLS", Integer.toString(attr.getMaxSpills()));
        desc.setValue("MINIPACK", attr.getMiniPack() ? "true" : "false");
        desc.setValue("SIZE_THRESH_PCNT_FOR_PACK", Integer.toString(attr.getSizeThreshPcntForPack()));
    }

    public static enum Compression {
        LZF,
        LZO,
        LZ4,
        ZLIB,
        GZ,
        OFF,
        NONE;

    }
}

