/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.fs.hbase;

import com.mapr.fs.hbase.CFPermissions;
import com.mapr.fs.hbase.HBaseAdminImpl;
import com.mapr.fs.proto.Dbserver;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.ArrayUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.mapr.BaseTableMappingRules;
import org.apache.hadoop.hbase.client.mapr.TableMappingRulesFactory;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.util.Bytes;

public class CopyMetaHelper {
    public static final int METATYPE_CFS = 1;
    public static final int METATYPE_ATTRS = 2;
    public static final int METATYPE_ACES = 4;
    public static final int METATYPE_SPLITS = 8;
    public static final int METATYPE_ALL = 15;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createTable(String src, String dst, int metaTypeMask, Dbserver.TableAttr attr) throws IOException {
        HBaseAdminImpl hadminImpl = null;
        HBaseAdmin hbaseAdmin = null;
        HTable htSrc = null;
        try {
            Class<?> c = Class.forName("org.apache.hadoop.hbase.HBaseConfiguration");
        }
        catch (ClassNotFoundException e) {
            throw new IOException("HBase not configured");
        }
        try {
            Configuration conf = HBaseConfiguration.create();
            hbaseAdmin = new HBaseAdmin(conf);
            HTableDescriptor htdDst = new HTableDescriptor();
            if (hbaseAdmin.tableExists(dst.getBytes())) {
                throw new IOException("Table " + dst + " already exists");
            }
            htSrc = new HTable(conf, src);
            HTableDescriptor htdSrc = new HTableDescriptor(htSrc.getTableDescriptor());
            htdDst.setName(dst.getBytes());
            if ((metaTypeMask & 1) > 0) {
                for (HColumnDescriptor hcdDst : htdSrc.getColumnFamilies()) {
                    htdDst.addFamily(hcdDst);
                }
            }
            if ((metaTypeMask & 2) > 0) {
                CopyMetaHelper.copyConfigValues(htdSrc, htdDst);
                if (attr != null && attr.hasBulkLoad()) {
                    htdDst.setValue("BULKLOAD", attr.getBulkLoad() ? "true" : "false");
                }
            }
            if ((metaTypeMask & 8) > 0) {
                byte[][] regionEndKeys = (byte[][])ArrayUtils.remove((Object[])htSrc.getEndKeys(), (int)(htSrc.getEndKeys().length - 1));
                hbaseAdmin.createTable(htdDst, regionEndKeys);
            } else {
                hbaseAdmin.createTable(htdDst);
            }
            if ((metaTypeMask & 4) > 0) {
                conf.set("hbase.table.namespace.mappings", "");
                BaseTableMappingRules tableMappingRule = TableMappingRulesFactory.create((Configuration)conf);
                hadminImpl = new HBaseAdminImpl(conf, tableMappingRule);
                Map<String, String> tablePerms = hadminImpl.getTablePermissions(src);
                hadminImpl.setTablePermissions(dst, tablePerms);
                if ((metaTypeMask & 1) > 0) {
                    List<CFPermissions> cfPerms = hadminImpl.getFamilyPermissions(src);
                    for (CFPermissions cfPerm : cfPerms) {
                        hadminImpl.setFamilyPermissions(dst, cfPerm.getFamily(), cfPerm);
                    }
                }
            }
        }
        finally {
            if (hadminImpl != null) {
                hadminImpl.close();
            }
            if (hbaseAdmin != null) {
                hbaseAdmin.close();
            }
            if (htSrc != null) {
                htSrc.close();
            }
        }
    }

    private static void copyConfigValues(HTableDescriptor src, HTableDescriptor dst) {
        Map srcMap = src.getValues();
        for (Map.Entry pairs : srcMap.entrySet()) {
            String key = Bytes.toString((byte[])((ImmutableBytesWritable)pairs.getKey()).get());
            String value = Bytes.toString((byte[])((ImmutableBytesWritable)pairs.getValue()).get());
            dst.setValue(key, value);
        }
    }
}

