/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.livy.rsc;

import com.cloudera.livy.client.common.ClientConf;
import java.io.IOException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RSCConf
extends ClientConf<RSCConf> {
    public static final String SPARK_CONF_PREFIX = "spark.";
    public static final String LIVY_SPARK_PREFIX = "spark.__livy__.";
    private static final Logger LOG = LoggerFactory.getLogger(RSCConf.class);

    public RSCConf(Properties config) {
        super(config);
    }

    public Map<String, String> getSaslOptions() {
        HashMap<String, String> opts = new HashMap<String, String>();
        String qop = this.get(Entry.SASL_QOP);
        if (qop != null) {
            opts.put("javax.security.sasl.qop", qop);
        }
        return opts;
    }

    public String findLocalAddress() throws IOException {
        InetAddress address = InetAddress.getLocalHost();
        if (address.isLoopbackAddress()) {
            Enumeration<NetworkInterface> ifaces = NetworkInterface.getNetworkInterfaces();
            while (ifaces.hasMoreElements()) {
                NetworkInterface ni = ifaces.nextElement();
                Enumeration<InetAddress> addrs = ni.getInetAddresses();
                while (addrs.hasMoreElements()) {
                    InetAddress addr = addrs.nextElement();
                    if (addr.isLinkLocalAddress() || addr.isLoopbackAddress() || !(addr instanceof Inet4Address)) continue;
                    LOG.warn("Your hostname, {}, resolves to a loopback address; using {}  instead (on interface {})", new Object[]{address.getHostName(), addr.getHostAddress(), ni.getName()});
                    LOG.warn("Set '{}' if you need to bind to another address.", (Object)Entry.RPC_SERVER_ADDRESS.key);
                    return addr.getHostAddress();
                }
            }
        }
        LOG.warn("Your hostname, {}, resolves to a loopback address, but we couldn't find any external IP address!", (Object)address.getCanonicalHostName());
        LOG.warn("Set {} if you need to bind to another address.", (Object)Entry.RPC_SERVER_ADDRESS.key);
        return address.getCanonicalHostName();
    }

    public static enum Entry implements ClientConf.ConfEntry
    {
        CLIENT_ID("client.auth.id", null),
        CLIENT_SECRET("client.auth.secret", null),
        CLIENT_IN_PROCESS("client.do_not_use.run_driver_in_process", false),
        CLIENT_SHUTDOWN_TIMEOUT("client.shutdown_timeout", "10s"),
        DRIVER_CLASS("driver_class", null),
        SESSION_KIND("session.kind", null),
        LIVY_JARS("jars", null),
        SPARKR_PACKAGE("sparkr.package", null),
        PYSPARK_ARCHIVES("pyspark.archives", null),
        LAUNCHER_ADDRESS("launcher.address", null),
        LAUNCHER_PORT("launcher.port", -1),
        SERVER_IDLE_TIMEOUT("server.idle_timeout", "10m"),
        PROXY_USER("proxy_user", null),
        RPC_SERVER_ADDRESS("rpc.server.address", null),
        RPC_CLIENT_HANDSHAKE_TIMEOUT("server.connect.timeout", "90s"),
        RPC_CLIENT_CONNECT_TIMEOUT("client.connect.timeout", "10s"),
        RPC_CHANNEL_LOG_LEVEL("channel.log.level", null),
        RPC_MAX_MESSAGE_SIZE("rpc.max.size", 0x3200000),
        RPC_MAX_THREADS("rpc.threads", 8),
        RPC_SECRET_RANDOM_BITS("secret.bits", 256),
        SASL_MECHANISMS("rpc.sasl.mechanisms", "DIGEST-MD5"),
        SASL_QOP("rpc.sasl.qop", null),
        TEST_STUCK_END_SESSION("test.do_not_use.stuck_end_session", false);

        private final String key;
        private final Object dflt;

        private Entry(String key, Object dflt) {
            this.key = "livy.rsc." + key;
            this.dflt = dflt;
        }

        public String key() {
            return this.key;
        }

        public Object dflt() {
            return this.dflt;
        }
    }
}

