/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.livy.rsc;

import com.cloudera.livy.LivyClient;
import com.cloudera.livy.LivyClientFactory;
import com.cloudera.livy.rsc.ContextInfo;
import com.cloudera.livy.rsc.ContextLauncher;
import com.cloudera.livy.rsc.RSCClient;
import com.cloudera.livy.rsc.RSCConf;
import com.cloudera.livy.rsc.Utils;
import com.cloudera.livy.rsc.rpc.RpcServer;
import io.netty.util.concurrent.ImmediateEventExecutor;
import io.netty.util.concurrent.Promise;
import java.io.IOException;
import java.net.URI;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;

public final class RSCClientFactory
implements LivyClientFactory {
    private final AtomicInteger refCount = new AtomicInteger();
    private RpcServer server = null;

    public LivyClient createClient(URI uri, Properties config) {
        if (!"rsc".equals(uri.getScheme())) {
            return null;
        }
        RSCConf lconf = new RSCConf(config);
        boolean needsServer = false;
        try {
            Promise<ContextInfo> info;
            if (uri.getUserInfo() != null && uri.getHost() != null && uri.getPort() > 0) {
                info = RSCClientFactory.createContextInfo(uri);
            } else {
                needsServer = true;
                this.ref(lconf);
                info = ContextLauncher.create(this, lconf);
            }
            return new RSCClient(lconf, info);
        }
        catch (Exception e) {
            if (needsServer) {
                this.unref();
            }
            throw Utils.propagate(e);
        }
    }

    RpcServer getServer() {
        return this.server;
    }

    private synchronized void ref(RSCConf config) throws IOException {
        if (this.refCount.get() != 0) {
            this.refCount.incrementAndGet();
            return;
        }
        Utils.checkState(this.server == null, "Server already running but ref count is 0.", new Object[0]);
        if (this.server == null) {
            try {
                this.server = new RpcServer(config);
            }
            catch (InterruptedException ie) {
                throw Utils.propagate(ie);
            }
        }
        this.refCount.incrementAndGet();
    }

    synchronized void unref() {
        if (this.refCount.decrementAndGet() == 0) {
            this.server.close();
            this.server = null;
        }
    }

    private static Promise<ContextInfo> createContextInfo(URI uri) {
        String[] userInfo = uri.getUserInfo().split(":", 2);
        ImmediateEventExecutor executor = ImmediateEventExecutor.INSTANCE;
        Promise promise = executor.newPromise();
        promise.setSuccess((Object)new ContextInfo(uri.getHost(), uri.getPort(), userInfo[0], userInfo[1]));
        return promise;
    }
}

