/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.livy.rsc;

import com.cloudera.livy.JobHandle;
import com.cloudera.livy.client.common.AbstractJobHandle;
import com.cloudera.livy.rsc.RSCClient;
import io.netty.util.concurrent.Promise;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

class JobHandleImpl<T>
extends AbstractJobHandle<T> {
    private final RSCClient client;
    private final String jobId;
    private final Promise<T> promise;
    private volatile JobHandle.State state;

    JobHandleImpl(RSCClient client, Promise<T> promise, String jobId) {
        this.client = client;
        this.jobId = jobId;
        this.promise = promise;
    }

    public boolean cancel(boolean mayInterrupt) {
        if (this.changeState(JobHandle.State.CANCELLED)) {
            this.client.cancel(this.jobId);
            this.promise.cancel(mayInterrupt);
            return true;
        }
        return false;
    }

    public T get() throws ExecutionException, InterruptedException {
        return (T)this.promise.get();
    }

    public T get(long timeout, TimeUnit unit) throws ExecutionException, InterruptedException, TimeoutException {
        return (T)this.promise.get(timeout, unit);
    }

    public boolean isCancelled() {
        return this.promise.isCancelled();
    }

    public boolean isDone() {
        return this.promise.isDone();
    }

    protected T result() {
        return (T)this.promise.getNow();
    }

    protected Throwable error() {
        return this.promise.cause();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setSuccess(Object result) {
        List list = this.listeners;
        synchronized (list) {
            this.promise.setSuccess(result);
            this.changeState(JobHandle.State.SUCCEEDED);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setFailure(Throwable error) {
        List list = this.listeners;
        synchronized (list) {
            this.promise.setFailure(error);
            this.changeState(JobHandle.State.FAILED);
        }
    }
}

