/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.livy.rsc;

import com.cloudera.livy.Job;
import com.cloudera.livy.rsc.Utils;
import com.cloudera.livy.rsc.rpc.RpcDispatcher;

public abstract class BaseProtocol
extends RpcDispatcher {

    public static class InitializationError {
        public final String stackTrace;

        public InitializationError(String stackTrace) {
            this.stackTrace = stackTrace;
        }

        public InitializationError() {
            this(null);
        }
    }

    public static class GetReplState {
    }

    public static class GetReplJobResults {
        public boolean allResults;
        public Integer from;
        public Integer size;

        public GetReplJobResults(Integer from, Integer size) {
            this.allResults = false;
            this.from = from;
            this.size = size;
        }

        public GetReplJobResults() {
            this.allResults = true;
            this.from = null;
            this.size = null;
        }
    }

    public static class ReplJobRequest {
        public final String code;

        public ReplJobRequest(String code) {
            this.code = code;
        }

        public ReplJobRequest() {
            this(null);
        }
    }

    public static class RemoteDriverAddress {
        public final String host;
        public final int port;

        public RemoteDriverAddress(String host, int port) {
            this.host = host;
            this.port = port;
        }

        public RemoteDriverAddress() {
            this(null, -1);
        }
    }

    protected static class SyncJobRequest<T> {
        public final Job<T> job;

        public SyncJobRequest(Job<T> job) {
            this.job = job;
        }

        public SyncJobRequest() {
            this(null);
        }
    }

    protected static class JobStarted {
        public final String id;

        public JobStarted(String id) {
            this.id = id;
        }

        public JobStarted() {
            this(null);
        }
    }

    protected static class JobResult<T> {
        public final String id;
        public final T result;
        public final String error;

        public JobResult(String id, T result, Throwable error) {
            this.id = id;
            this.result = result;
            this.error = error != null ? Utils.stackTraceAsString(error) : null;
        }

        public JobResult() {
            this(null, null, null);
        }
    }

    protected static class JobRequest<T> {
        public final String id;
        public final Job<T> job;

        public JobRequest(String id, Job<T> job) {
            this.id = id;
            this.job = job;
        }

        public JobRequest() {
            this(null, null);
        }
    }

    protected static class GetBypassJobStatus {
        public final String id;

        public GetBypassJobStatus(String id) {
            this.id = id;
        }

        public GetBypassJobStatus() {
            this(null);
        }
    }

    public static class BypassJobRequest {
        public final String id;
        public final byte[] serializedJob;
        public final boolean synchronous;

        public BypassJobRequest(String id, byte[] serializedJob, boolean synchronous) {
            this.id = id;
            this.serializedJob = serializedJob;
            this.synchronous = synchronous;
        }

        public BypassJobRequest() {
            this(null, null, false);
        }
    }

    protected static class Error {
        public final String cause;

        public Error(Throwable cause) {
            this.cause = cause == null ? "" : Utils.stackTraceAsString(cause);
        }

        public Error() {
            this(null);
        }
    }

    protected static class EndSession {
        protected EndSession() {
        }
    }

    protected static class CancelJob {
        public final String id;

        CancelJob(String id) {
            this.id = id;
        }

        CancelJob() {
            this(null);
        }
    }
}

