/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.livy.client.http;

import com.cloudera.livy.JobHandle;
import com.cloudera.livy.client.common.AbstractJobHandle;
import com.cloudera.livy.client.common.BufferUtils;
import com.cloudera.livy.client.common.HttpMessages;
import com.cloudera.livy.client.common.Serializer;
import com.cloudera.livy.client.http.HttpConf;
import com.cloudera.livy.client.http.LivyConnection;
import java.nio.ByteBuffer;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

class JobHandleImpl<T>
extends AbstractJobHandle<T> {
    private final long sessionId;
    private final LivyConnection conn;
    private final ScheduledExecutorService executor;
    private final Object lock;
    private final Serializer serializer;
    private final long initialPollInterval;
    private final long maxPollInterval;
    private long jobId;
    private T result;
    private Throwable error;
    private volatile boolean isDone;
    private volatile boolean isCancelled;
    private volatile boolean isCancelPending;
    private volatile ScheduledFuture<?> pollTask;

    JobHandleImpl(HttpConf config, LivyConnection conn, long sessionId, ScheduledExecutorService executor, Serializer s) {
        this.conn = conn;
        this.sessionId = sessionId;
        this.executor = executor;
        this.lock = new Object();
        this.serializer = s;
        this.isDone = false;
        this.initialPollInterval = config.getTimeAsMs(HttpConf.Entry.JOB_INITIAL_POLL_INTERVAL);
        this.maxPollInterval = config.getTimeAsMs(HttpConf.Entry.JOB_MAX_POLL_INTERVAL);
        if (this.initialPollInterval <= 0L) {
            throw new IllegalArgumentException("Invalid initial poll interval.");
        }
        if (this.maxPollInterval <= 0L || this.maxPollInterval < this.initialPollInterval) {
            throw new IllegalArgumentException("Invalid max poll interval, or lower than initial interval.");
        }
        this.isCancelPending = false;
        this.jobId = -1L;
    }

    public T get() throws ExecutionException, InterruptedException {
        try {
            return this.get(true, -1L, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException te) {
            throw new RuntimeException(te);
        }
    }

    public T get(long timeout, TimeUnit unit) throws ExecutionException, InterruptedException, TimeoutException {
        return this.get(false, timeout, unit);
    }

    public boolean isDone() {
        return this.isDone;
    }

    public boolean isCancelled() {
        return this.isCancelled;
    }

    public boolean cancel(boolean mayInterrupt) {
        if (!this.isCancelled && !this.isCancelPending) {
            this.isCancelPending = true;
            if (this.jobId > -1L) {
                this.sendCancelRequest(this.jobId);
            }
            return true;
        }
        return false;
    }

    @Override
    protected T result() {
        return this.result;
    }

    @Override
    protected Throwable error() {
        return this.error;
    }

    void start(final String command, final ByteBuffer serializedJob) {
        Runnable task = new Runnable(){

            @Override
            public void run() {
                try {
                    HttpMessages.SerializedJob msg = new HttpMessages.SerializedJob(BufferUtils.toByteArray(serializedJob));
                    HttpMessages.JobStatus status = JobHandleImpl.this.conn.post(msg, HttpMessages.JobStatus.class, "/%d/%s", JobHandleImpl.this.sessionId, command);
                    if (JobHandleImpl.this.isCancelPending) {
                        JobHandleImpl.this.sendCancelRequest(status.id);
                    }
                    JobHandleImpl.this.jobId = status.id;
                    JobHandleImpl.this.pollTask = JobHandleImpl.this.executor.schedule(new JobPollTask(JobHandleImpl.this.initialPollInterval), JobHandleImpl.this.initialPollInterval, TimeUnit.MILLISECONDS);
                }
                catch (Exception e) {
                    JobHandleImpl.this.setResult(null, e, JobHandle.State.FAILED);
                }
            }
        };
        this.executor.submit(task);
    }

    private void sendCancelRequest(final long id) {
        this.executor.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    JobHandleImpl.this.conn.post(null, Void.class, "/%d/jobs/%d/cancel", JobHandleImpl.this.sessionId, id);
                }
                catch (Exception e) {
                    JobHandleImpl.this.setResult(null, e, JobHandle.State.FAILED);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private T get(boolean waitIndefinitely, long timeout, TimeUnit unit) throws ExecutionException, InterruptedException, TimeoutException {
        if (!this.isDone) {
            Object object = this.lock;
            synchronized (object) {
                if (waitIndefinitely) {
                    while (!this.isDone) {
                        this.lock.wait();
                    }
                } else {
                    long now = System.nanoTime();
                    long deadline = now + unit.toNanos(timeout);
                    while (!this.isDone && deadline > now) {
                        this.lock.wait(TimeUnit.NANOSECONDS.toMillis(deadline - now));
                        now = System.nanoTime();
                    }
                    if (!this.isDone) {
                        throw new TimeoutException();
                    }
                }
            }
        }
        if (this.isCancelled) {
            throw new CancellationException();
        }
        if (this.error != null) {
            throw new ExecutionException(this.error);
        }
        return this.result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setResult(T result, Throwable error, JobHandle.State newState) {
        if (!this.isDone) {
            Object object = this.lock;
            synchronized (object) {
                if (!this.isDone) {
                    this.result = result;
                    this.error = error;
                    this.isDone = true;
                    this.changeState(newState);
                }
                this.lock.notifyAll();
            }
        }
    }

    private class JobPollTask
    implements Runnable {
        private long currentInterval;

        JobPollTask(long currentInterval) {
            this.currentInterval = currentInterval;
        }

        @Override
        public void run() {
            try {
                HttpMessages.JobStatus status = JobHandleImpl.this.conn.get(HttpMessages.JobStatus.class, "/%d/jobs/%d", JobHandleImpl.this.sessionId, JobHandleImpl.this.jobId);
                Object result = null;
                RuntimeException error = null;
                boolean finished = false;
                switch (status.state) {
                    case SUCCEEDED: {
                        if (status.result != null) {
                            Object localResult;
                            result = localResult = JobHandleImpl.this.serializer.deserialize(ByteBuffer.wrap(status.result));
                        }
                        finished = true;
                        break;
                    }
                    case FAILED: {
                        error = new RuntimeException(status.error);
                        finished = true;
                        break;
                    }
                    case CANCELLED: {
                        JobHandleImpl.this.isCancelled = true;
                        finished = true;
                        break;
                    }
                }
                if (finished) {
                    JobHandleImpl.this.setResult(result, error, status.state);
                } else if (status.state != JobHandleImpl.this.state) {
                    JobHandleImpl.this.changeState(status.state);
                }
                if (!finished) {
                    this.currentInterval = Math.min(this.currentInterval * 2L, JobHandleImpl.this.maxPollInterval);
                    JobHandleImpl.this.pollTask = JobHandleImpl.this.executor.schedule(this, this.currentInterval, TimeUnit.MILLISECONDS);
                }
            }
            catch (Exception e) {
                JobHandleImpl.this.setResult(null, e, JobHandle.State.FAILED);
            }
        }
    }
}

