/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.livy.shaded.kryo.kryo.util;

import com.cloudera.livy.shaded.kryo.kryo.util.Util;
import com.cloudera.livy.shaded.kryo.minlog.Log;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import sun.misc.Cleaner;
import sun.misc.Unsafe;
import sun.nio.ch.DirectBuffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnsafeUtil {
    private static final Unsafe _unsafe;
    public static final long byteArrayBaseOffset;
    public static final long floatArrayBaseOffset;
    public static final long doubleArrayBaseOffset;
    public static final long intArrayBaseOffset;
    public static final long longArrayBaseOffset;
    public static final long shortArrayBaseOffset;
    public static final long charArrayBaseOffset;
    static Constructor<? extends ByteBuffer> directByteBufferConstr;

    public static final Unsafe unsafe() {
        return _unsafe;
    }

    public static Field[] sortFieldsByOffset(List<Field> allFields) {
        Field[] allFieldsArray = allFields.toArray(new Field[0]);
        Comparator<Field> fieldOffsetComparator = new Comparator<Field>(){

            @Override
            public int compare(Field f1, Field f2) {
                long offset2;
                long offset1 = UnsafeUtil.unsafe().objectFieldOffset(f1);
                if (offset1 < (offset2 = UnsafeUtil.unsafe().objectFieldOffset(f2))) {
                    return -1;
                }
                if (offset1 == offset2) {
                    return 0;
                }
                return 1;
            }
        };
        Arrays.sort(allFieldsArray, fieldOffsetComparator);
        for (Field f : allFields) {
            if (!Log.TRACE) continue;
            Log.trace("kryo", "Field '" + f.getName() + "' at offset " + UnsafeUtil.unsafe().objectFieldOffset(f));
        }
        return allFieldsArray;
    }

    public static final ByteBuffer getDirectBufferAt(long address, int maxBufferSize) {
        if (directByteBufferConstr == null) {
            return null;
        }
        try {
            return directByteBufferConstr.newInstance(address, maxBufferSize, null);
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot allocate ByteBuffer at a given address: " + address, e);
        }
    }

    public static void releaseBuffer(ByteBuffer niobuffer) {
        if (niobuffer != null && niobuffer.isDirect()) {
            Cleaner cleaner = ((DirectBuffer)((Object)niobuffer)).cleaner();
            if (cleaner != null) {
                cleaner.clean();
            }
            niobuffer = null;
        }
    }

    static {
        try {
            if (!Util.isAndroid) {
                Field field = Unsafe.class.getDeclaredField("theUnsafe");
                field.setAccessible(true);
                _unsafe = (Unsafe)field.get(null);
                byteArrayBaseOffset = _unsafe.arrayBaseOffset(byte[].class);
                charArrayBaseOffset = _unsafe.arrayBaseOffset(char[].class);
                shortArrayBaseOffset = _unsafe.arrayBaseOffset(short[].class);
                intArrayBaseOffset = _unsafe.arrayBaseOffset(int[].class);
                floatArrayBaseOffset = _unsafe.arrayBaseOffset(float[].class);
                longArrayBaseOffset = _unsafe.arrayBaseOffset(long[].class);
                doubleArrayBaseOffset = _unsafe.arrayBaseOffset(double[].class);
            } else {
                byteArrayBaseOffset = 0L;
                charArrayBaseOffset = 0L;
                shortArrayBaseOffset = 0L;
                intArrayBaseOffset = 0L;
                floatArrayBaseOffset = 0L;
                longArrayBaseOffset = 0L;
                doubleArrayBaseOffset = 0L;
                _unsafe = null;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        ByteBuffer buf = ByteBuffer.allocateDirect(1);
        try {
            directByteBufferConstr = buf.getClass().getDeclaredConstructor(Long.TYPE, Integer.TYPE, Object.class);
            directByteBufferConstr.setAccessible(true);
        }
        catch (Exception e) {
            directByteBufferConstr = null;
        }
    }
}

