/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.livy.shaded.kryo.kryo.serializers;

import com.cloudera.livy.shaded.kryo.kryo.Kryo;
import com.cloudera.livy.shaded.kryo.kryo.KryoException;
import com.cloudera.livy.shaded.kryo.kryo.Serializer;
import com.cloudera.livy.shaded.kryo.kryo.io.Input;
import com.cloudera.livy.shaded.kryo.kryo.io.InputChunked;
import com.cloudera.livy.shaded.kryo.kryo.io.Output;
import com.cloudera.livy.shaded.kryo.kryo.io.OutputChunked;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;

public class DeflateSerializer
extends Serializer {
    private final Serializer serializer;
    private boolean noHeaders = true;
    private int compressionLevel = 4;

    public DeflateSerializer(Serializer serializer) {
        this.serializer = serializer;
    }

    public void write(Kryo kryo, Output output, Object object) {
        Deflater deflater = new Deflater(this.compressionLevel, this.noHeaders);
        OutputChunked outputChunked = new OutputChunked(output, 256);
        DeflaterOutputStream deflaterStream = new DeflaterOutputStream((OutputStream)outputChunked, deflater);
        Output deflaterOutput = new Output(deflaterStream, 256);
        kryo.writeObject(deflaterOutput, object, this.serializer);
        deflaterOutput.flush();
        try {
            deflaterStream.finish();
        }
        catch (IOException ex) {
            throw new KryoException(ex);
        }
        outputChunked.endChunks();
    }

    public Object read(Kryo kryo, Input input, Class type) {
        InflaterInputStream inflaterStream = new InflaterInputStream(new InputChunked(input, 256), new Inflater(this.noHeaders));
        return kryo.readObject(new Input(inflaterStream, 256), type, this.serializer);
    }

    public void setNoHeaders(boolean noHeaders) {
        this.noHeaders = noHeaders;
    }

    public void setCompressionLevel(int compressionLevel) {
        this.compressionLevel = compressionLevel;
    }

    public Object copy(Kryo kryo, Object original) {
        return this.serializer.copy(kryo, original);
    }
}

