/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.livy.client.common;

import com.cloudera.livy.JobHandle;
import com.cloudera.livy.annotations.Private;
import java.util.LinkedList;
import java.util.List;

@Private
public abstract class AbstractJobHandle<T>
implements JobHandle<T> {
    protected final List<JobHandle.Listener<T>> listeners = new LinkedList<JobHandle.Listener<T>>();
    protected volatile JobHandle.State state = JobHandle.State.SENT;

    protected AbstractJobHandle() {
    }

    public JobHandle.State getState() {
        return this.state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(JobHandle.Listener<T> l) {
        List<JobHandle.Listener<T>> list = this.listeners;
        synchronized (list) {
            this.listeners.add(l);
            this.fireStateChange(this.state, l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean changeState(JobHandle.State newState) {
        List<JobHandle.Listener<T>> list = this.listeners;
        synchronized (list) {
            if (newState.ordinal() > this.state.ordinal() && this.state.ordinal() < JobHandle.State.CANCELLED.ordinal()) {
                this.state = newState;
                for (JobHandle.Listener<T> l : this.listeners) {
                    this.fireStateChange(newState, l);
                }
                return true;
            }
            return false;
        }
    }

    protected abstract T result();

    protected abstract Throwable error();

    private void fireStateChange(JobHandle.State s, JobHandle.Listener<T> l) {
        switch (s) {
            case SENT: {
                break;
            }
            case QUEUED: {
                l.onJobQueued((JobHandle)this);
                break;
            }
            case STARTED: {
                l.onJobStarted((JobHandle)this);
                break;
            }
            case CANCELLED: {
                l.onJobCancelled((JobHandle)this);
                break;
            }
            case FAILED: {
                l.onJobFailed((JobHandle)this, this.error());
                break;
            }
            case SUCCEEDED: {
                try {
                    l.onJobSucceeded((JobHandle)this, this.result());
                    break;
                }
                catch (Exception e) {
                    throw new IllegalStateException(e);
                }
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }
}

