/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.metrics.prometheus;

import io.prometheus.client.CollectorRegistry;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.zookeeper.metrics.Counter;
import org.apache.zookeeper.metrics.CounterSet;
import org.apache.zookeeper.metrics.Gauge;
import org.apache.zookeeper.metrics.GaugeSet;
import org.apache.zookeeper.metrics.MetricsContext;
import org.apache.zookeeper.metrics.Summary;
import org.apache.zookeeper.metrics.SummarySet;
import org.apache.zookeeper.metrics.prometheus.PrometheusMetricsProvider;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class PrometheusMetricsProviderTest {
    private PrometheusMetricsProvider provider;

    @BeforeEach
    public void setup() throws Exception {
        CollectorRegistry.defaultRegistry.clear();
        this.provider = new PrometheusMetricsProvider();
        Properties configuration = new Properties();
        configuration.setProperty("numWorkerThreads", "0");
        configuration.setProperty("httpHost", "127.0.0.1");
        configuration.setProperty("httpPort", "0");
        configuration.setProperty("exportJvmInfo", "false");
        this.provider.configure(configuration);
        this.provider.start();
    }

    @AfterEach
    public void tearDown() {
        if (this.provider != null) {
            this.provider.stop();
        }
        CollectorRegistry.defaultRegistry.clear();
    }

    @Test
    public void testCounters() throws Exception {
        Counter counter = this.provider.getRootContext().getCounter("cc");
        counter.add(10L);
        int[] count = new int[]{0};
        this.provider.dump((k, v) -> {
            Assertions.assertEquals((Object)"cc", (Object)k);
            Assertions.assertEquals((int)10, (int)((Number)v).intValue());
            count[0] = count[0] + 1;
        });
        Assertions.assertEquals((int)1, (int)count[0]);
        count[0] = 0;
        counter.add(-1L);
        this.provider.dump((k, v) -> {
            Assertions.assertEquals((Object)"cc", (Object)k);
            Assertions.assertEquals((int)10, (int)((Number)v).intValue());
            count[0] = count[0] + 1;
        });
        Assertions.assertEquals((int)1, (int)count[0]);
        Assertions.assertSame((Object)counter, (Object)this.provider.getRootContext().getCounter("cc"));
        String res = this.callServlet();
        MatcherAssert.assertThat((Object)res, (Matcher)CoreMatchers.containsString((String)"# TYPE cc counter"));
        MatcherAssert.assertThat((Object)res, (Matcher)CoreMatchers.containsString((String)"cc 10.0"));
    }

    @Test
    public void testCounterSet_single() throws Exception {
        String name = "quota_exceeded_error_per_namespace";
        CounterSet counterSet = this.provider.getRootContext().getCounterSet("quota_exceeded_error_per_namespace");
        String[] keys = new String[]{"ns1", "ns2"};
        int count = 3;
        for (int i = 0; i < 3; ++i) {
            Arrays.asList(keys).forEach(key -> counterSet.inc(key));
            Arrays.asList(keys).forEach(key -> counterSet.add(key, 2L));
        }
        HashMap<String, Number> expectedMetricsMap = new HashMap<String, Number>();
        for (String key2 : keys) {
            expectedMetricsMap.put(String.format("%s{key=\"%s\"}", "quota_exceeded_error_per_namespace", key2), 9.0);
        }
        this.validateWithDump(expectedMetricsMap);
        List<String> expectedNames = Collections.singletonList(String.format("# TYPE %s count", "quota_exceeded_error_per_namespace"));
        ArrayList<String> expectedMetrics = new ArrayList<String>();
        for (String key3 : keys) {
            expectedMetrics.add(String.format("%s{key=\"%s\",} %s", "quota_exceeded_error_per_namespace", key3, 9.0));
        }
        this.validateWithServletCall(expectedNames, expectedMetrics);
        Assertions.assertSame((Object)counterSet, (Object)this.provider.getRootContext().getCounterSet("quota_exceeded_error_per_namespace"));
    }

    @Test
    public void testCounterSet_multiple() throws Exception {
        int i;
        String name = "quota_exceeded_error_per_namespace";
        String[] names = new String[]{"quota_exceeded_error_per_namespace_1", "quota_exceeded_error_per_namespace_2"};
        String[] keys = new String[]{"ns21", "ns22"};
        int[] counts = new int[]{3, 5};
        int length = names.length;
        CounterSet[] counterSets = new CounterSet[length];
        for (i = 0; i < length; ++i) {
            counterSets[i] = this.provider.getRootContext().getCounterSet(names[i]);
        }
        for (i = 0; i < length; ++i) {
            for (int j = 0; j < counts[i]; ++j) {
                counterSets[i].inc(keys[i]);
            }
        }
        HashMap<String, Number> expectedMetricsMap = new HashMap<String, Number>();
        for (int i2 = 0; i2 < length; ++i2) {
            expectedMetricsMap.put(String.format("%s{key=\"%s\"}", names[i2], keys[i2]), (double)counts[i2] * 1.0);
        }
        this.validateWithDump(expectedMetricsMap);
        ArrayList<String> expectedNames = new ArrayList<String>();
        ArrayList<String> expectedMetrics = new ArrayList<String>();
        for (int i3 = 0; i3 < length; ++i3) {
            expectedNames.add(String.format("# TYPE %s count", names[i3]));
            expectedMetrics.add(String.format("%s{key=\"%s\",} %s", names[i3], keys[i3], (double)counts[i3] * 1.0));
        }
        this.validateWithServletCall(expectedNames, expectedMetrics);
    }

    @Test
    public void testCounterSet_registerWithNullName() {
        Assertions.assertThrows(NullPointerException.class, () -> this.provider.getRootContext().getCounterSet(null));
    }

    @Test
    public void testCounterSet_negativeValue() {
        String name = "quota_exceeded_error_per_namespace";
        CounterSet counterSet = this.provider.getRootContext().getCounterSet("quota_exceeded_error_per_namespace");
        counterSet.add("ns1", -1L);
    }

    @Test
    public void testCounterSet_nullKey() {
        String name = "quota_exceeded_error_per_namespace";
        CounterSet counterSet = this.provider.getRootContext().getCounterSet("quota_exceeded_error_per_namespace");
        counterSet.inc(null);
        counterSet.add(null, 2L);
    }

    @Test
    public void testGauge() throws Exception {
        int[] values = new int[]{78, -89};
        int[] callCounts = new int[]{0, 0};
        Gauge gauge0 = () -> {
            callCounts[0] = callCounts[0] + 1;
            return values[0];
        };
        Gauge gauge1 = () -> {
            callCounts[1] = callCounts[1] + 1;
            return values[1];
        };
        this.provider.getRootContext().registerGauge("gg", gauge0);
        int[] count = new int[]{0};
        this.provider.dump((k, v) -> {
            Assertions.assertEquals((Object)"gg", (Object)k);
            Assertions.assertEquals((int)values[0], (int)((Number)v).intValue());
            count[0] = count[0] + 1;
        });
        Assertions.assertEquals((int)1, (int)callCounts[0]);
        Assertions.assertEquals((int)0, (int)callCounts[1]);
        Assertions.assertEquals((int)1, (int)count[0]);
        count[0] = 0;
        String res2 = this.callServlet();
        MatcherAssert.assertThat((Object)res2, (Matcher)CoreMatchers.containsString((String)"# TYPE gg gauge"));
        MatcherAssert.assertThat((Object)res2, (Matcher)CoreMatchers.containsString((String)"gg 78.0"));
        this.provider.getRootContext().unregisterGauge("gg");
        this.provider.dump((k, v) -> {
            count[0] = count[0] + 1;
        });
        Assertions.assertEquals((int)2, (int)callCounts[0]);
        Assertions.assertEquals((int)0, (int)callCounts[1]);
        Assertions.assertEquals((int)0, (int)count[0]);
        String res3 = this.callServlet();
        Assertions.assertTrue((boolean)res3.isEmpty());
        this.provider.getRootContext().registerGauge("gg", gauge1);
        this.provider.dump((k, v) -> {
            Assertions.assertEquals((Object)"gg", (Object)k);
            Assertions.assertEquals((int)values[1], (int)((Number)v).intValue());
            count[0] = count[0] + 1;
        });
        Assertions.assertEquals((int)2, (int)callCounts[0]);
        Assertions.assertEquals((int)1, (int)callCounts[1]);
        Assertions.assertEquals((int)1, (int)count[0]);
        count[0] = 0;
        String res4 = this.callServlet();
        MatcherAssert.assertThat((Object)res4, (Matcher)CoreMatchers.containsString((String)"# TYPE gg gauge"));
        MatcherAssert.assertThat((Object)res4, (Matcher)CoreMatchers.containsString((String)"gg -89.0"));
        Assertions.assertEquals((int)2, (int)callCounts[0]);
        Assertions.assertEquals((int)2, (int)callCounts[1]);
        this.provider.getRootContext().registerGauge("gg", gauge0);
        this.provider.dump((k, v) -> {
            count[0] = count[0] + 1;
        });
        Assertions.assertEquals((int)1, (int)count[0]);
        Assertions.assertEquals((int)3, (int)callCounts[0]);
        Assertions.assertEquals((int)2, (int)callCounts[1]);
    }

    @Test
    public void testBasicSummary() throws Exception {
        Summary summary = this.provider.getRootContext().getSummary("cc", MetricsContext.DetailLevel.BASIC);
        summary.add(10L);
        summary.add(10L);
        int[] count = new int[]{0};
        this.provider.dump((k, v) -> {
            count[0] = count[0] + 1;
            int value = ((Number)v).intValue();
            switch (k) {
                case "cc{quantile=\"0.5\"}": {
                    Assertions.assertEquals((int)10, (int)value);
                    break;
                }
                case "cc_count": {
                    Assertions.assertEquals((int)2, (int)value);
                    break;
                }
                case "cc_sum": {
                    Assertions.assertEquals((int)20, (int)value);
                    break;
                }
                default: {
                    Assertions.fail((String)("unespected key " + k));
                }
            }
        });
        Assertions.assertEquals((int)3, (int)count[0]);
        count[0] = 0;
        Assertions.assertSame((Object)summary, (Object)this.provider.getRootContext().getSummary("cc", MetricsContext.DetailLevel.BASIC));
        try {
            this.provider.getRootContext().getSummary("cc", MetricsContext.DetailLevel.ADVANCED);
            Assertions.fail((String)"Can't get the same summary with a different DetailLevel");
        }
        catch (IllegalArgumentException err) {
            MatcherAssert.assertThat((Object)err.getMessage(), (Matcher)CoreMatchers.containsString((String)"Already registered"));
        }
        String res = this.callServlet();
        MatcherAssert.assertThat((Object)res, (Matcher)CoreMatchers.containsString((String)"# TYPE cc summary"));
        MatcherAssert.assertThat((Object)res, (Matcher)CoreMatchers.containsString((String)"cc_sum 20.0"));
        MatcherAssert.assertThat((Object)res, (Matcher)CoreMatchers.containsString((String)"cc_count 2.0"));
        MatcherAssert.assertThat((Object)res, (Matcher)CoreMatchers.containsString((String)"cc{quantile=\"0.5\",} 10.0"));
    }

    @Test
    public void testAdvancedSummary() throws Exception {
        Summary summary = this.provider.getRootContext().getSummary("cc", MetricsContext.DetailLevel.ADVANCED);
        summary.add(10L);
        summary.add(10L);
        int[] count = new int[]{0};
        this.provider.dump((k, v) -> {
            count[0] = count[0] + 1;
            int value = ((Number)v).intValue();
            switch (k) {
                case "cc{quantile=\"0.5\"}": {
                    Assertions.assertEquals((int)10, (int)value);
                    break;
                }
                case "cc{quantile=\"0.9\"}": {
                    Assertions.assertEquals((int)10, (int)value);
                    break;
                }
                case "cc{quantile=\"0.99\"}": {
                    Assertions.assertEquals((int)10, (int)value);
                    break;
                }
                case "cc_count": {
                    Assertions.assertEquals((int)2, (int)value);
                    break;
                }
                case "cc_sum": {
                    Assertions.assertEquals((int)20, (int)value);
                    break;
                }
                default: {
                    Assertions.fail((String)("unespected key " + k));
                }
            }
        });
        Assertions.assertEquals((int)5, (int)count[0]);
        count[0] = 0;
        Assertions.assertSame((Object)summary, (Object)this.provider.getRootContext().getSummary("cc", MetricsContext.DetailLevel.ADVANCED));
        try {
            this.provider.getRootContext().getSummary("cc", MetricsContext.DetailLevel.BASIC);
            Assertions.fail((String)"Can't get the same summary with a different DetailLevel");
        }
        catch (IllegalArgumentException err) {
            MatcherAssert.assertThat((Object)err.getMessage(), (Matcher)CoreMatchers.containsString((String)"Already registered"));
        }
        String res = this.callServlet();
        MatcherAssert.assertThat((Object)res, (Matcher)CoreMatchers.containsString((String)"# TYPE cc summary"));
        MatcherAssert.assertThat((Object)res, (Matcher)CoreMatchers.containsString((String)"cc_sum 20.0"));
        MatcherAssert.assertThat((Object)res, (Matcher)CoreMatchers.containsString((String)"cc_count 2.0"));
        MatcherAssert.assertThat((Object)res, (Matcher)CoreMatchers.containsString((String)"cc{quantile=\"0.5\",} 10.0"));
        MatcherAssert.assertThat((Object)res, (Matcher)CoreMatchers.containsString((String)"cc{quantile=\"0.9\",} 10.0"));
        MatcherAssert.assertThat((Object)res, (Matcher)CoreMatchers.containsString((String)"cc{quantile=\"0.99\",} 10.0"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSummary_asyncAndExceedMaxQueueSize() throws Exception {
        Properties config = new Properties();
        config.setProperty("numWorkerThreads", "1");
        config.setProperty("maxQueueSize", "1");
        config.setProperty("httpPort", "0");
        config.setProperty("exportJvmInfo", "false");
        PrometheusMetricsProvider metricsProvider = null;
        try {
            metricsProvider = new PrometheusMetricsProvider();
            metricsProvider.configure(config);
            metricsProvider.start();
            Summary summary = metricsProvider.getRootContext().getSummary("cc", MetricsContext.DetailLevel.ADVANCED);
            for (int i = 0; i < 10; ++i) {
                summary.add(10L);
            }
        }
        finally {
            if (metricsProvider != null) {
                metricsProvider.stop();
            }
        }
    }

    @Test
    public void testSummarySet() throws Exception {
        String name = "ss";
        String[] keys = new String[]{"ns1", "ns2"};
        double count = 3.0;
        SummarySet summarySet = this.provider.getRootContext().getSummarySet("ss", MetricsContext.DetailLevel.BASIC);
        int i = 0;
        while ((double)i < 3.0) {
            Arrays.asList(keys).forEach(key -> summarySet.add(key, 1L));
            ++i;
        }
        HashMap<String, Number> expectedMetricsMap = new HashMap<String, Number>();
        for (String key2 : keys) {
            expectedMetricsMap.put(String.format("%s{key=\"%s\",quantile=\"0.5\"}", "ss", key2), 1.0);
            expectedMetricsMap.put(String.format("%s_count{key=\"%s\"}", "ss", key2), 3.0);
            expectedMetricsMap.put(String.format("%s_sum{key=\"%s\"}", "ss", key2), 3.0);
        }
        this.validateWithDump(expectedMetricsMap);
        List<String> expectedNames = Collections.singletonList(String.format("# TYPE %s summary", "ss"));
        ArrayList<String> expectedMetrics = new ArrayList<String>();
        for (String key3 : keys) {
            expectedMetrics.add(String.format("%s{key=\"%s\",quantile=\"0.5\",} %s", "ss", key3, 1.0));
            expectedMetrics.add(String.format("%s_count{key=\"%s\",} %s", "ss", key3, 3.0));
            expectedMetrics.add(String.format("%s_sum{key=\"%s\",} %s", "ss", key3, 3.0));
        }
        this.validateWithServletCall(expectedNames, expectedMetrics);
        Assertions.assertSame((Object)summarySet, (Object)this.provider.getRootContext().getSummarySet("ss", MetricsContext.DetailLevel.BASIC));
        try {
            this.provider.getRootContext().getSummarySet("ss", MetricsContext.DetailLevel.ADVANCED);
            Assertions.fail((String)"Can't get the same summarySet with a different DetailLevel");
        }
        catch (IllegalArgumentException e) {
            MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"Already registered"));
        }
    }

    private String callServlet() throws ServletException, IOException {
        StringWriter writer = new StringWriter();
        HttpServletResponse response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        Mockito.when((Object)response.getWriter()).thenReturn((Object)new PrintWriter(writer));
        HttpServletRequest req = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        this.provider.getServlet().doGet(req, response);
        String res = writer.toString();
        return res;
    }

    @Test
    public void testGaugeSet_singleGaugeSet() throws Exception {
        String name = "quota_bytes_limit_per_namespace";
        Number[] values = new Number[]{10.0, 100.0};
        String[] keys = new String[]{"ns11", "ns12"};
        HashMap<String, Number> metricsMap = new HashMap<String, Number>();
        for (int i = 0; i < values.length; ++i) {
            metricsMap.put(keys[i], values[i]);
        }
        AtomicInteger callCount = new AtomicInteger(0);
        this.createAndRegisterGaugeSet("quota_bytes_limit_per_namespace", metricsMap, callCount);
        HashMap<String, Number> expectedMetricsMap = new HashMap<String, Number>();
        for (int i = 0; i < values.length; ++i) {
            expectedMetricsMap.put(String.format("%s{key=\"%s\"}", "quota_bytes_limit_per_namespace", keys[i]), values[i]);
        }
        this.validateWithDump(expectedMetricsMap);
        Assertions.assertEquals((int)1, (int)callCount.get());
        List<String> expectedNames = Collections.singletonList(String.format("# TYPE %s gauge", "quota_bytes_limit_per_namespace"));
        ArrayList<String> expectedMetrics = new ArrayList<String>();
        for (int i = 0; i < values.length; ++i) {
            expectedMetrics.add(String.format("%s{key=\"%s\",} %s", "quota_bytes_limit_per_namespace", keys[i], values[i]));
        }
        this.validateWithServletCall(expectedNames, expectedMetrics);
        Assertions.assertEquals((int)2, (int)callCount.get());
        callCount.set(0);
        this.provider.getRootContext().unregisterGaugeSet("quota_bytes_limit_per_namespace");
        this.validateWithDump(Collections.emptyMap());
        Assertions.assertEquals((int)0, (int)callCount.get());
        this.validateWithServletCall(new ArrayList<String>(), new ArrayList<String>());
        Assertions.assertEquals((int)0, (int)callCount.get());
    }

    @Test
    public void testGaugeSet_multipleGaugeSets() throws Exception {
        int i;
        int i2;
        String[] names = new String[]{"quota_count_limit_per_namespace", "quota_count_usage_per_namespace"};
        Number[] values = new Number[]{20.0, 200.0};
        String[] keys = new String[]{"ns21", "ns22"};
        int count = names.length;
        AtomicInteger[] callCounts = new AtomicInteger[count];
        for (int i3 = 0; i3 < count; ++i3) {
            HashMap<String, Number> metricsMap = new HashMap<String, Number>();
            metricsMap.put(keys[i3], values[i3]);
            callCounts[i3] = new AtomicInteger(0);
            this.createAndRegisterGaugeSet(names[i3], metricsMap, callCounts[i3]);
        }
        HashMap<String, Number> expectedMetricsMap = new HashMap<String, Number>();
        for (i2 = 0; i2 < count; ++i2) {
            expectedMetricsMap.put(String.format("%s{key=\"%s\"}", names[i2], keys[i2]), values[i2]);
        }
        this.validateWithDump(expectedMetricsMap);
        for (i2 = 0; i2 < count; ++i2) {
            Assertions.assertEquals((int)1, (int)callCounts[i2].get());
        }
        ArrayList<String> expectedNames = new ArrayList<String>();
        ArrayList<String> expectedMetrics = new ArrayList<String>();
        for (i = 0; i < count; ++i) {
            expectedNames.add(String.format("# TYPE %s gauge", names[i]));
            expectedMetrics.add(String.format("%s{key=\"%s\",} %s", names[i], keys[i], values[i]));
        }
        this.validateWithServletCall(expectedNames, expectedMetrics);
        for (i = 0; i < count; ++i) {
            Assertions.assertEquals((int)2, (int)callCounts[i].get());
        }
        for (i = 0; i < count; ++i) {
            callCounts[i].set(0);
            this.provider.getRootContext().unregisterGaugeSet(names[i]);
        }
        this.validateWithDump(Collections.emptyMap());
        for (i = 0; i < count; ++i) {
            Assertions.assertEquals((int)0, (int)callCounts[i].get());
        }
        this.validateWithServletCall(new ArrayList<String>(), new ArrayList<String>());
        for (i = 0; i < count; ++i) {
            Assertions.assertEquals((int)0, (int)callCounts[i].get());
        }
    }

    @Test
    public void testGaugeSet_overwriteRegister() {
        String[] names = new String[]{"quota_count_limit_per_namespace", "quota_count_usage_per_namespace"};
        int count = names.length;
        Number[] values = new Number[]{30.0, 300.0};
        String[] keys = new String[]{"ns31", "ns32"};
        AtomicInteger[] callCounts = new AtomicInteger[count];
        for (int i = 0; i < count; ++i) {
            HashMap<String, Number> metricsMap = new HashMap<String, Number>();
            metricsMap.put(keys[i], values[i]);
            callCounts[i] = new AtomicInteger(0);
            this.createAndRegisterGaugeSet(names[0], metricsMap, callCounts[i]);
        }
        HashMap<String, Number> expectedMetricsMap = new HashMap<String, Number>();
        expectedMetricsMap.put(String.format("%s{key=\"%s\"}", names[0], keys[1]), values[1]);
        this.validateWithDump(expectedMetricsMap);
        Assertions.assertEquals((int)0, (int)callCounts[0].get());
        Assertions.assertEquals((int)1, (int)callCounts[1].get());
    }

    @Test
    public void testGaugeSet_nullKey() {
        String name = "quota_count_limit_per_namespace";
        HashMap<String, Number> metricsMap = new HashMap<String, Number>();
        metricsMap.put(null, 10.0);
        AtomicInteger callCount = new AtomicInteger(0);
        this.createAndRegisterGaugeSet("quota_count_limit_per_namespace", metricsMap, callCount);
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.provider.dump(new HashMap()::put));
        Assertions.assertThrows(IllegalArgumentException.class, this::callServlet);
    }

    @Test
    public void testGaugeSet_registerWithNullGaugeSet() {
        Assertions.assertThrows(NullPointerException.class, () -> this.provider.getRootContext().registerGaugeSet("name", null));
        Assertions.assertThrows(NullPointerException.class, () -> this.provider.getRootContext().registerGaugeSet(null, HashMap::new));
    }

    @Test
    public void testGaugeSet_unregisterNull() {
        Assertions.assertThrows(NullPointerException.class, () -> this.provider.getRootContext().unregisterGaugeSet(null));
    }

    private void createAndRegisterGaugeSet(String name, Map<String, Number> metricsMap, AtomicInteger callCount) {
        GaugeSet gaugeSet = () -> {
            callCount.addAndGet(1);
            return metricsMap;
        };
        this.provider.getRootContext().registerGaugeSet(name, gaugeSet);
    }

    private void validateWithDump(Map<String, Number> expectedMetrics) {
        HashMap returnedMetrics = new HashMap();
        this.provider.dump(returnedMetrics::put);
        Assertions.assertEquals((int)expectedMetrics.size(), (int)returnedMetrics.size());
        expectedMetrics.forEach((key, value) -> Assertions.assertEquals((Object)value, returnedMetrics.get(key)));
    }

    private void validateWithServletCall(List<String> expectedNames, List<String> expectedMetrics) throws Exception {
        String response = this.callServlet();
        if (expectedNames.isEmpty() && expectedMetrics.isEmpty()) {
            Assertions.assertTrue((boolean)response.isEmpty());
        } else {
            expectedNames.forEach(name -> MatcherAssert.assertThat((Object)response, (Matcher)CoreMatchers.containsString((String)name)));
            expectedMetrics.forEach(metric -> MatcherAssert.assertThat((Object)response, (Matcher)CoreMatchers.containsString((String)metric)));
        }
    }
}

