/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.history.logging.ats;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.timeline.TimelineEntity;
import org.apache.hadoop.yarn.api.records.timeline.TimelineEvent;
import org.apache.tez.common.VersionInfo;
import org.apache.tez.common.counters.TezCounters;
import org.apache.tez.dag.api.EdgeManagerPluginDescriptor;
import org.apache.tez.dag.api.EdgeProperty;
import org.apache.tez.dag.api.InputDescriptor;
import org.apache.tez.dag.api.OutputDescriptor;
import org.apache.tez.dag.api.oldrecords.TaskAttemptState;
import org.apache.tez.dag.api.oldrecords.TaskState;
import org.apache.tez.dag.api.records.DAGProtos;
import org.apache.tez.dag.app.dag.DAGState;
import org.apache.tez.dag.app.dag.VertexState;
import org.apache.tez.dag.app.dag.impl.ServicePluginInfo;
import org.apache.tez.dag.app.dag.impl.TaskAttemptImpl;
import org.apache.tez.dag.app.dag.impl.VertexStats;
import org.apache.tez.dag.history.HistoryEvent;
import org.apache.tez.dag.history.HistoryEventType;
import org.apache.tez.dag.history.events.AMLaunchedEvent;
import org.apache.tez.dag.history.events.AMStartedEvent;
import org.apache.tez.dag.history.events.AppLaunchedEvent;
import org.apache.tez.dag.history.events.ContainerLaunchedEvent;
import org.apache.tez.dag.history.events.ContainerStoppedEvent;
import org.apache.tez.dag.history.events.DAGCommitStartedEvent;
import org.apache.tez.dag.history.events.DAGFinishedEvent;
import org.apache.tez.dag.history.events.DAGInitializedEvent;
import org.apache.tez.dag.history.events.DAGKillRequestEvent;
import org.apache.tez.dag.history.events.DAGRecoveredEvent;
import org.apache.tez.dag.history.events.DAGStartedEvent;
import org.apache.tez.dag.history.events.DAGSubmittedEvent;
import org.apache.tez.dag.history.events.TaskAttemptFinishedEvent;
import org.apache.tez.dag.history.events.TaskAttemptStartedEvent;
import org.apache.tez.dag.history.events.TaskFinishedEvent;
import org.apache.tez.dag.history.events.TaskStartedEvent;
import org.apache.tez.dag.history.events.VertexCommitStartedEvent;
import org.apache.tez.dag.history.events.VertexConfigurationDoneEvent;
import org.apache.tez.dag.history.events.VertexFinishedEvent;
import org.apache.tez.dag.history.events.VertexGroupCommitFinishedEvent;
import org.apache.tez.dag.history.events.VertexGroupCommitStartedEvent;
import org.apache.tez.dag.history.events.VertexInitializedEvent;
import org.apache.tez.dag.history.events.VertexStartedEvent;
import org.apache.tez.dag.history.logging.EntityTypes;
import org.apache.tez.dag.history.logging.ats.HistoryEventTimelineConversion;
import org.apache.tez.dag.records.TaskAttemptTerminationCause;
import org.apache.tez.dag.records.TezDAGID;
import org.apache.tez.dag.records.TezTaskAttemptID;
import org.apache.tez.dag.records.TezTaskID;
import org.apache.tez.dag.records.TezVertexID;
import org.apache.tez.runtime.api.TaskFailureType;
import org.codehaus.jettison.json.JSONException;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestHistoryEventTimelineConversion {
    private ApplicationAttemptId applicationAttemptId;
    private ApplicationId applicationId;
    private String user = "user";
    private Random random = new Random();
    private TezDAGID tezDAGID;
    private TezVertexID tezVertexID;
    private TezTaskID tezTaskID;
    private TezTaskAttemptID tezTaskAttemptID;
    private DAGProtos.DAGPlan dagPlan;
    private ContainerId containerId;
    private NodeId nodeId;
    private String containerLogs = "containerLogs";

    @Before
    public void setup() {
        this.applicationId = ApplicationId.newInstance((long)9999L, (int)1);
        this.applicationAttemptId = ApplicationAttemptId.newInstance((ApplicationId)this.applicationId, (int)1);
        this.tezDAGID = TezDAGID.getInstance((ApplicationId)this.applicationId, (int)this.random.nextInt());
        this.tezVertexID = TezVertexID.getInstance((TezDAGID)this.tezDAGID, (int)this.random.nextInt());
        this.tezTaskID = TezTaskID.getInstance((TezVertexID)this.tezVertexID, (int)this.random.nextInt());
        this.tezTaskAttemptID = TezTaskAttemptID.getInstance((TezTaskID)this.tezTaskID, (int)this.random.nextInt());
        DAGProtos.CallerContextProto.Builder callerContextProto = DAGProtos.CallerContextProto.newBuilder();
        callerContextProto.setContext("ctxt");
        callerContextProto.setCallerId("Caller_ID");
        callerContextProto.setCallerType("Caller_Type");
        callerContextProto.setBlob("Desc_1");
        this.dagPlan = DAGProtos.DAGPlan.newBuilder().setName("DAGPlanMock").setCallerContext(callerContextProto).build();
        this.containerId = ContainerId.newInstance((ApplicationAttemptId)this.applicationAttemptId, (int)111);
        this.nodeId = NodeId.newInstance((String)"node", (int)13435);
    }

    @Test(timeout=5000L)
    public void testHandlerExists() throws JSONException {
        for (HistoryEventType eventType : HistoryEventType.values()) {
            DAGCommitStartedEvent event = null;
            switch (eventType) {
                case APP_LAUNCHED: {
                    event = new AppLaunchedEvent(this.applicationId, (long)this.random.nextInt(), (long)this.random.nextInt(), this.user, new Configuration(false), null);
                    break;
                }
                case AM_LAUNCHED: {
                    event = new AMLaunchedEvent(this.applicationAttemptId, (long)this.random.nextInt(), (long)this.random.nextInt(), this.user);
                    break;
                }
                case AM_STARTED: {
                    event = new AMStartedEvent(this.applicationAttemptId, (long)this.random.nextInt(), this.user);
                    break;
                }
                case DAG_SUBMITTED: {
                    event = new DAGSubmittedEvent(this.tezDAGID, (long)this.random.nextInt(), this.dagPlan, this.applicationAttemptId, null, this.user, null, this.containerLogs, null);
                    break;
                }
                case DAG_INITIALIZED: {
                    event = new DAGInitializedEvent(this.tezDAGID, (long)this.random.nextInt(), this.user, this.dagPlan.getName(), null);
                    break;
                }
                case DAG_STARTED: {
                    event = new DAGStartedEvent(this.tezDAGID, (long)this.random.nextInt(), this.user, this.dagPlan.getName());
                    break;
                }
                case DAG_FINISHED: {
                    event = new DAGFinishedEvent(this.tezDAGID, (long)this.random.nextInt(), (long)this.random.nextInt(), DAGState.ERROR, null, null, this.user, this.dagPlan.getName(), null, this.applicationAttemptId, this.dagPlan);
                    break;
                }
                case VERTEX_INITIALIZED: {
                    event = new VertexInitializedEvent(this.tezVertexID, "v1", (long)this.random.nextInt(), (long)this.random.nextInt(), this.random.nextInt(), "proc", null, null, null);
                    break;
                }
                case VERTEX_STARTED: {
                    event = new VertexStartedEvent(this.tezVertexID, (long)this.random.nextInt(), (long)this.random.nextInt());
                    break;
                }
                case VERTEX_CONFIGURE_DONE: {
                    event = new VertexConfigurationDoneEvent(this.tezVertexID, 0L, 1, null, null, null, true);
                    break;
                }
                case VERTEX_FINISHED: {
                    event = new VertexFinishedEvent(this.tezVertexID, "v1", 1, (long)this.random.nextInt(), (long)this.random.nextInt(), (long)this.random.nextInt(), (long)this.random.nextInt(), (long)this.random.nextInt(), VertexState.ERROR, null, null, null, null, null);
                    break;
                }
                case TASK_STARTED: {
                    event = new TaskStartedEvent(this.tezTaskID, "v1", (long)this.random.nextInt(), (long)this.random.nextInt());
                    break;
                }
                case TASK_FINISHED: {
                    event = new TaskFinishedEvent(this.tezTaskID, "v1", (long)this.random.nextInt(), (long)this.random.nextInt(), this.tezTaskAttemptID, TaskState.FAILED, null, null, 0);
                    break;
                }
                case TASK_ATTEMPT_STARTED: {
                    event = new TaskAttemptStartedEvent(this.tezTaskAttemptID, "v1", (long)this.random.nextInt(), this.containerId, this.nodeId, null, null, "nodeHttpAddress");
                    break;
                }
                case TASK_ATTEMPT_FINISHED: {
                    event = new TaskAttemptFinishedEvent(this.tezTaskAttemptID, "v1", (long)this.random.nextInt(), (long)this.random.nextInt(), TaskAttemptState.FAILED, TaskFailureType.NON_FATAL, TaskAttemptTerminationCause.OUTPUT_LOST, null, null, null, null, 0L, null, 0L, this.containerId, this.nodeId, null, null, "nodeHttpAddress");
                    break;
                }
                case CONTAINER_LAUNCHED: {
                    event = new ContainerLaunchedEvent(this.containerId, (long)this.random.nextInt(), this.applicationAttemptId);
                    break;
                }
                case CONTAINER_STOPPED: {
                    event = new ContainerStoppedEvent(this.containerId, (long)this.random.nextInt(), -1, this.applicationAttemptId);
                    break;
                }
                case DAG_COMMIT_STARTED: {
                    event = new DAGCommitStartedEvent();
                    break;
                }
                case VERTEX_COMMIT_STARTED: {
                    event = new VertexCommitStartedEvent();
                    break;
                }
                case VERTEX_GROUP_COMMIT_STARTED: {
                    event = new VertexGroupCommitStartedEvent();
                    break;
                }
                case VERTEX_GROUP_COMMIT_FINISHED: {
                    event = new VertexGroupCommitFinishedEvent();
                    break;
                }
                case DAG_RECOVERED: {
                    event = new DAGRecoveredEvent(this.applicationAttemptId, this.tezDAGID, this.dagPlan.getName(), this.user, this.random.nextLong(), this.containerLogs);
                    break;
                }
                case DAG_KILL_REQUEST: {
                    event = new DAGKillRequestEvent();
                    break;
                }
                default: {
                    Assert.fail((String)("Unhandled event type " + eventType));
                }
            }
            if (event == null || !event.isHistoryEvent()) continue;
            HistoryEventTimelineConversion.convertToTimelineEntities((HistoryEvent)event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=5000L)
    public void testConvertAppLaunchedEventConcurrentModificationException() throws InterruptedException {
        long launchTime = this.random.nextLong();
        long submitTime = this.random.nextLong();
        final Configuration conf = new Configuration(false);
        conf.set("foo", "bar");
        conf.set("applicationId", "1234");
        final AtomicBoolean shutdown = new AtomicBoolean(false);
        Thread confChanger = new Thread(){

            @Override
            public void run() {
                int i = 1;
                while (!shutdown.get()) {
                    conf.set("test" + i++, "test");
                }
            }
        };
        confChanger.start();
        try {
            MockVersionInfo mockVersionInfo = new MockVersionInfo();
            AppLaunchedEvent event = new AppLaunchedEvent(this.applicationId, launchTime, submitTime, this.user, conf, (VersionInfo)mockVersionInfo);
            HistoryEventTimelineConversion.convertToTimelineEntities((HistoryEvent)event);
        }
        finally {
            shutdown.set(true);
            confChanger.join();
        }
    }

    @Test(timeout=5000L)
    public void testConvertAppLaunchedEvent() {
        long launchTime = this.random.nextLong();
        long submitTime = this.random.nextLong();
        Configuration conf = new Configuration(false);
        conf.set("foo", "bar");
        conf.set("applicationId", "1234");
        MockVersionInfo mockVersionInfo = new MockVersionInfo();
        AppLaunchedEvent event = new AppLaunchedEvent(this.applicationId, launchTime, submitTime, this.user, conf, (VersionInfo)mockVersionInfo);
        List entities = HistoryEventTimelineConversion.convertToTimelineEntities((HistoryEvent)event);
        Assert.assertEquals((long)1L, (long)entities.size());
        TimelineEntity timelineEntity = (TimelineEntity)entities.get(0);
        Assert.assertEquals((long)launchTime, (long)timelineEntity.getStartTime());
        Assert.assertEquals((Object)EntityTypes.TEZ_APPLICATION.name(), (Object)timelineEntity.getEntityType());
        Assert.assertEquals((Object)("tez_" + this.applicationId.toString()), (Object)timelineEntity.getEntityId());
        Assert.assertEquals((long)0L, (long)timelineEntity.getRelatedEntities().size());
        Assert.assertEquals((long)1L, (long)timelineEntity.getPrimaryFilters().size());
        Assert.assertTrue((boolean)((Set)timelineEntity.getPrimaryFilters().get("user")).contains(this.user));
        Assert.assertEquals((long)5L, (long)timelineEntity.getOtherInfo().size());
        Assert.assertTrue((boolean)timelineEntity.getOtherInfo().containsKey("config"));
        Assert.assertTrue((boolean)timelineEntity.getOtherInfo().containsKey("tezVersion"));
        Assert.assertEquals((Object)this.user, timelineEntity.getOtherInfo().get("user"));
        Assert.assertEquals((Object)this.applicationId.toString(), timelineEntity.getOtherInfo().get("applicationId"));
        Assert.assertEquals((Object)"2", timelineEntity.getOtherInfo().get("amWebServiceVersion"));
        Map config = (Map)timelineEntity.getOtherInfo().get("config");
        Assert.assertEquals((Object)conf.get("foo"), config.get("foo"));
        Assert.assertEquals((Object)conf.get("applicationId"), config.get("applicationId"));
        Map versionInfo = (Map)timelineEntity.getOtherInfo().get("tezVersion");
        Assert.assertEquals((Object)mockVersionInfo.getVersion(), versionInfo.get("version"));
        Assert.assertEquals((Object)mockVersionInfo.getRevision(), versionInfo.get("revision"));
        Assert.assertEquals((Object)mockVersionInfo.getBuildTime(), versionInfo.get("buildTime"));
    }

    @Test(timeout=5000L)
    public void testConvertAMLaunchedEvent() {
        long launchTime = this.random.nextLong();
        long submitTime = this.random.nextLong();
        AMLaunchedEvent event = new AMLaunchedEvent(this.applicationAttemptId, launchTime, submitTime, this.user);
        List entities = HistoryEventTimelineConversion.convertToTimelineEntities((HistoryEvent)event);
        Assert.assertEquals((long)1L, (long)entities.size());
        TimelineEntity timelineEntity = (TimelineEntity)entities.get(0);
        Assert.assertEquals((Object)("tez_" + this.applicationAttemptId.toString()), (Object)timelineEntity.getEntityId());
        Assert.assertEquals((Object)EntityTypes.TEZ_APPLICATION_ATTEMPT.name(), (Object)timelineEntity.getEntityType());
        Map relatedEntities = timelineEntity.getRelatedEntities();
        Assert.assertEquals((long)0L, (long)relatedEntities.size());
        Map primaryFilters = timelineEntity.getPrimaryFilters();
        Assert.assertEquals((long)2L, (long)primaryFilters.size());
        Assert.assertTrue((boolean)((Set)primaryFilters.get("user")).contains(this.user));
        Assert.assertTrue((boolean)((Set)primaryFilters.get("applicationId")).contains(this.applicationId.toString()));
        Assert.assertEquals((long)launchTime, (long)timelineEntity.getStartTime());
        Assert.assertEquals((long)1L, (long)timelineEntity.getEvents().size());
        TimelineEvent evt = (TimelineEvent)timelineEntity.getEvents().get(0);
        Assert.assertEquals((Object)HistoryEventType.AM_LAUNCHED.name(), (Object)evt.getEventType());
        Assert.assertEquals((long)launchTime, (long)evt.getTimestamp());
        Map otherInfo = timelineEntity.getOtherInfo();
        Assert.assertEquals((long)4L, (long)otherInfo.size());
        Assert.assertEquals((Object)submitTime, otherInfo.get("appSubmitTime"));
        Assert.assertEquals((Object)this.applicationId.toString(), otherInfo.get("applicationId"));
        Assert.assertEquals((Object)this.applicationAttemptId.toString(), otherInfo.get("applicationAttemptId"));
        Assert.assertEquals((Object)this.user, otherInfo.get("user"));
    }

    @Test(timeout=5000L)
    public void testConvertAMStartedEvent() {
        long startTime = this.random.nextLong();
        AMStartedEvent event = new AMStartedEvent(this.applicationAttemptId, startTime, this.user);
        List entities = HistoryEventTimelineConversion.convertToTimelineEntities((HistoryEvent)event);
        Assert.assertEquals((long)1L, (long)entities.size());
        TimelineEntity timelineEntity = (TimelineEntity)entities.get(0);
        Assert.assertEquals((Object)("tez_" + this.applicationAttemptId.toString()), (Object)timelineEntity.getEntityId());
        Assert.assertEquals((Object)EntityTypes.TEZ_APPLICATION_ATTEMPT.name(), (Object)timelineEntity.getEntityType());
        Map relatedEntities = timelineEntity.getRelatedEntities();
        Assert.assertEquals((long)0L, (long)relatedEntities.size());
        Map primaryFilters = timelineEntity.getPrimaryFilters();
        Assert.assertEquals((long)2L, (long)primaryFilters.size());
        Assert.assertTrue((boolean)((Set)primaryFilters.get("user")).contains(this.user));
        Assert.assertTrue((boolean)((Set)primaryFilters.get("applicationId")).contains(this.applicationId.toString()));
        Assert.assertEquals((long)1L, (long)timelineEntity.getEvents().size());
        TimelineEvent evt = (TimelineEvent)timelineEntity.getEvents().get(0);
        Assert.assertEquals((Object)HistoryEventType.AM_STARTED.name(), (Object)evt.getEventType());
        Assert.assertEquals((long)startTime, (long)evt.getTimestamp());
    }

    @Test(timeout=5000L)
    public void testConvertContainerLaunchedEvent() {
        long launchTime = this.random.nextLong();
        ContainerLaunchedEvent event = new ContainerLaunchedEvent(this.containerId, launchTime, this.applicationAttemptId);
        List entities = HistoryEventTimelineConversion.convertToTimelineEntities((HistoryEvent)event);
        Assert.assertEquals((long)1L, (long)entities.size());
        TimelineEntity timelineEntity = (TimelineEntity)entities.get(0);
        Assert.assertEquals((Object)EntityTypes.TEZ_CONTAINER_ID.name(), (Object)timelineEntity.getEntityType());
        Assert.assertEquals((Object)("tez_" + this.containerId.toString()), (Object)timelineEntity.getEntityId());
        Assert.assertEquals((long)1L, (long)timelineEntity.getRelatedEntities().size());
        Assert.assertTrue((boolean)((Set)timelineEntity.getRelatedEntities().get(EntityTypes.TEZ_APPLICATION_ATTEMPT.name())).contains("tez_" + this.applicationAttemptId.toString()));
        Assert.assertEquals((long)1L, (long)timelineEntity.getPrimaryFilters().size());
        Assert.assertTrue((boolean)((Set)timelineEntity.getPrimaryFilters().get("applicationId")).contains(this.applicationAttemptId.getApplicationId().toString()));
        Assert.assertEquals((Object)this.containerId.toString(), timelineEntity.getOtherInfo().get("containerId"));
        Assert.assertEquals((long)launchTime, (long)timelineEntity.getStartTime());
        Assert.assertEquals((long)1L, (long)timelineEntity.getEvents().size());
        Assert.assertEquals((Object)HistoryEventType.CONTAINER_LAUNCHED.name(), (Object)((TimelineEvent)timelineEntity.getEvents().get(0)).getEventType());
        Assert.assertEquals((long)launchTime, (long)((TimelineEvent)timelineEntity.getEvents().get(0)).getTimestamp());
    }

    @Test(timeout=5000L)
    public void testConvertContainerStoppedEvent() {
        long stopTime = this.random.nextLong();
        int exitStatus = this.random.nextInt();
        ContainerStoppedEvent event = new ContainerStoppedEvent(this.containerId, stopTime, exitStatus, this.applicationAttemptId);
        List entities = HistoryEventTimelineConversion.convertToTimelineEntities((HistoryEvent)event);
        Assert.assertEquals((long)1L, (long)entities.size());
        TimelineEntity timelineEntity = (TimelineEntity)entities.get(0);
        Assert.assertEquals((Object)("tez_" + this.containerId.toString()), (Object)timelineEntity.getEntityId());
        Assert.assertEquals((Object)EntityTypes.TEZ_CONTAINER_ID.name(), (Object)timelineEntity.getEntityType());
        Map relatedEntities = timelineEntity.getRelatedEntities();
        Assert.assertEquals((long)1L, (long)relatedEntities.size());
        Assert.assertTrue((boolean)((Set)relatedEntities.get(EntityTypes.TEZ_APPLICATION_ATTEMPT.name())).contains("tez_" + this.applicationAttemptId.toString()));
        Map primaryFilters = timelineEntity.getPrimaryFilters();
        Assert.assertEquals((long)2L, (long)primaryFilters.size());
        Assert.assertTrue((boolean)((Set)primaryFilters.get("applicationId")).contains(this.applicationId.toString()));
        Assert.assertTrue((boolean)((Set)primaryFilters.get("exitStatus")).contains(exitStatus));
        Assert.assertEquals((long)1L, (long)timelineEntity.getEvents().size());
        TimelineEvent evt = (TimelineEvent)timelineEntity.getEvents().get(0);
        Assert.assertEquals((Object)HistoryEventType.CONTAINER_STOPPED.name(), (Object)evt.getEventType());
        Assert.assertEquals((long)stopTime, (long)evt.getTimestamp());
        Map otherInfo = timelineEntity.getOtherInfo();
        Assert.assertEquals((long)2L, (long)otherInfo.size());
        Assert.assertEquals((Object)exitStatus, otherInfo.get("exitStatus"));
        Assert.assertEquals((Object)stopTime, otherInfo.get("endTime"));
    }

    @Test(timeout=5000L)
    public void testConvertDAGStartedEvent() {
        long startTime = this.random.nextLong();
        String dagName = "testDagName";
        DAGStartedEvent event = new DAGStartedEvent(this.tezDAGID, startTime, this.user, dagName);
        List entities = HistoryEventTimelineConversion.convertToTimelineEntities((HistoryEvent)event);
        Assert.assertEquals((long)1L, (long)entities.size());
        TimelineEntity timelineEntity = (TimelineEntity)entities.get(0);
        Assert.assertEquals((Object)this.tezDAGID.toString(), (Object)timelineEntity.getEntityId());
        Assert.assertEquals((Object)EntityTypes.TEZ_DAG_ID.name(), (Object)timelineEntity.getEntityType());
        Assert.assertEquals((long)1L, (long)timelineEntity.getEvents().size());
        TimelineEvent evt = (TimelineEvent)timelineEntity.getEvents().get(0);
        Assert.assertEquals((Object)HistoryEventType.DAG_STARTED.name(), (Object)evt.getEventType());
        Assert.assertEquals((long)startTime, (long)evt.getTimestamp());
        Map primaryFilters = timelineEntity.getPrimaryFilters();
        Assert.assertEquals((long)3L, (long)primaryFilters.size());
        Assert.assertTrue((boolean)((Set)primaryFilters.get("user")).contains(this.user));
        Assert.assertTrue((boolean)((Set)primaryFilters.get("applicationId")).contains(this.applicationId.toString()));
        Assert.assertTrue((boolean)((Set)primaryFilters.get("dagName")).contains(dagName));
        Map otherInfo = timelineEntity.getOtherInfo();
        Assert.assertEquals((long)2L, (long)otherInfo.size());
        Assert.assertEquals((Object)startTime, otherInfo.get("startTime"));
        Assert.assertEquals((Object)DAGState.RUNNING.name(), otherInfo.get("status"));
    }

    @Test(timeout=5000L)
    public void testConvertDAGSubmittedEvent() {
        long submitTime = this.random.nextLong();
        String queueName = "TEST_DAG_SUBMITTED";
        DAGSubmittedEvent event = new DAGSubmittedEvent(this.tezDAGID, submitTime, this.dagPlan, this.applicationAttemptId, null, this.user, null, this.containerLogs, "TEST_DAG_SUBMITTED");
        List entities = HistoryEventTimelineConversion.convertToTimelineEntities((HistoryEvent)event);
        Assert.assertEquals((long)2L, (long)entities.size());
        if (((TimelineEntity)entities.get(0)).getEntityType().equals(EntityTypes.TEZ_DAG_ID.name())) {
            this.assertDagSubmittedEntity(submitTime, event, (TimelineEntity)entities.get(0));
            this.assertDagSubmittedExtraInfoEntity(submitTime, event, (TimelineEntity)entities.get(1));
        } else {
            this.assertDagSubmittedExtraInfoEntity(submitTime, event, (TimelineEntity)entities.get(0));
            this.assertDagSubmittedEntity(submitTime, event, (TimelineEntity)entities.get(1));
        }
    }

    private void assertDagSubmittedEntity(long submitTime, DAGSubmittedEvent event, TimelineEntity timelineEntity) {
        Assert.assertEquals((Object)EntityTypes.TEZ_DAG_ID.name(), (Object)timelineEntity.getEntityType());
        Assert.assertEquals((Object)this.tezDAGID.toString(), (Object)timelineEntity.getEntityId());
        Assert.assertEquals((long)2L, (long)timelineEntity.getRelatedEntities().size());
        Assert.assertTrue((boolean)((Set)timelineEntity.getRelatedEntities().get(EntityTypes.TEZ_APPLICATION.name())).contains("tez_" + this.applicationId.toString()));
        Assert.assertTrue((boolean)((Set)timelineEntity.getRelatedEntities().get(EntityTypes.TEZ_APPLICATION_ATTEMPT.name())).contains("tez_" + this.applicationAttemptId.toString()));
        Assert.assertEquals((long)1L, (long)timelineEntity.getEvents().size());
        TimelineEvent timelineEvent = (TimelineEvent)timelineEntity.getEvents().get(0);
        Assert.assertEquals((Object)HistoryEventType.DAG_SUBMITTED.name(), (Object)timelineEvent.getEventType());
        Assert.assertEquals((long)submitTime, (long)timelineEvent.getTimestamp());
        Assert.assertEquals((long)submitTime, (long)timelineEntity.getStartTime());
        Assert.assertEquals((long)5L, (long)timelineEntity.getPrimaryFilters().size());
        Assert.assertTrue((boolean)((Set)timelineEntity.getPrimaryFilters().get("dagName")).contains(this.dagPlan.getName()));
        Assert.assertTrue((boolean)((Set)timelineEntity.getPrimaryFilters().get("callerId")).contains(this.dagPlan.getCallerContext().getCallerId()));
        Assert.assertTrue((boolean)((Set)timelineEntity.getPrimaryFilters().get("applicationId")).contains(this.applicationAttemptId.getApplicationId().toString()));
        Assert.assertTrue((boolean)((Set)timelineEntity.getPrimaryFilters().get("user")).contains(this.user));
        Assert.assertTrue((boolean)((Set)timelineEntity.getPrimaryFilters().get("queueName")).contains(event.getQueueName()));
        Assert.assertEquals((long)9L, (long)timelineEntity.getOtherInfo().size());
        Assert.assertEquals((Object)this.applicationId.toString(), timelineEntity.getOtherInfo().get("applicationId"));
        Assert.assertEquals((Object)this.applicationAttemptId.toString(), timelineEntity.getOtherInfo().get("applicationAttemptId"));
        Assert.assertEquals((Object)this.applicationAttemptId.getApplicationId().toString(), timelineEntity.getOtherInfo().get("applicationId"));
        Assert.assertEquals((Object)"2", timelineEntity.getOtherInfo().get("amWebServiceVersion"));
        Assert.assertEquals((Object)this.user, timelineEntity.getOtherInfo().get("user"));
        Assert.assertEquals((Object)this.containerLogs, timelineEntity.getOtherInfo().get("inProgressLogsURL_" + this.applicationAttemptId.getAttemptId()));
        Assert.assertEquals(timelineEntity.getOtherInfo().get("callerId"), (Object)this.dagPlan.getCallerContext().getCallerId());
        Assert.assertEquals(timelineEntity.getOtherInfo().get("callerType"), (Object)this.dagPlan.getCallerContext().getCallerType());
        Assert.assertEquals((Object)this.dagPlan.getCallerContext().getContext(), timelineEntity.getOtherInfo().get("callerContext"));
        Assert.assertEquals((Object)event.getQueueName(), timelineEntity.getOtherInfo().get("queueName"));
    }

    private void assertDagSubmittedExtraInfoEntity(long submitTime, DAGSubmittedEvent event, TimelineEntity timelineEntity) {
        Assert.assertEquals((Object)EntityTypes.TEZ_DAG_EXTRA_INFO.name(), (Object)timelineEntity.getEntityType());
        Assert.assertEquals((Object)this.tezDAGID.toString(), (Object)timelineEntity.getEntityId());
        Assert.assertEquals((long)1L, (long)timelineEntity.getRelatedEntities().size());
        Assert.assertTrue((boolean)((Set)timelineEntity.getRelatedEntities().get(EntityTypes.TEZ_DAG_ID.name())).contains(this.tezDAGID.toString()));
        Assert.assertEquals((long)1L, (long)timelineEntity.getEvents().size());
        TimelineEvent timelineEvent = (TimelineEvent)timelineEntity.getEvents().get(0);
        Assert.assertEquals((Object)HistoryEventType.DAG_SUBMITTED.name(), (Object)timelineEvent.getEventType());
        Assert.assertEquals((long)submitTime, (long)timelineEvent.getTimestamp());
        Assert.assertEquals((long)submitTime, (long)timelineEntity.getStartTime());
        Assert.assertEquals((long)0L, (long)timelineEntity.getPrimaryFilters().size());
        Assert.assertEquals((long)1L, (long)timelineEntity.getOtherInfo().size());
        Assert.assertTrue((boolean)timelineEntity.getOtherInfo().containsKey("dagPlan"));
    }

    @Test(timeout=5000L)
    public void testConvertTaskAttemptFinishedEvent() {
        String vertexName = "testVertex";
        long creationTime = this.random.nextLong();
        long startTime = creationTime + 1000L;
        long allocationTime = creationTime + 1001L;
        long finishTime = startTime + 1002L;
        TaskAttemptState state = TaskAttemptState.values()[this.random.nextInt(TaskAttemptState.values().length)];
        TaskAttemptTerminationCause error = TaskAttemptTerminationCause.values()[this.random.nextInt(TaskAttemptTerminationCause.values().length)];
        String diagnostics = "random diagnostics message";
        TezCounters counters = new TezCounters();
        long lastDataEventTime = finishTime - 1L;
        ArrayList events = Lists.newArrayList();
        events.add(new TaskAttemptImpl.DataEventDependencyInfo(lastDataEventTime, this.tezTaskAttemptID));
        events.add(new TaskAttemptImpl.DataEventDependencyInfo(lastDataEventTime, this.tezTaskAttemptID));
        TaskAttemptFinishedEvent event = new TaskAttemptFinishedEvent(this.tezTaskAttemptID, vertexName, startTime, finishTime, state, TaskFailureType.FATAL, error, diagnostics, counters, (List)events, null, creationTime, this.tezTaskAttemptID, allocationTime, this.containerId, this.nodeId, "inProgressURL", "logsURL", "nodeHttpAddress");
        List entities = HistoryEventTimelineConversion.convertToTimelineEntities((HistoryEvent)event);
        Assert.assertEquals((long)1L, (long)entities.size());
        TimelineEntity timelineEntity = (TimelineEntity)entities.get(0);
        Assert.assertEquals((Object)this.tezTaskAttemptID.toString(), (Object)timelineEntity.getEntityId());
        Assert.assertEquals((Object)EntityTypes.TEZ_TASK_ATTEMPT_ID.name(), (Object)timelineEntity.getEntityType());
        Map primaryFilters = timelineEntity.getPrimaryFilters();
        Assert.assertEquals((long)5L, (long)primaryFilters.size());
        Assert.assertTrue((boolean)((Set)primaryFilters.get("applicationId")).contains(this.applicationId.toString()));
        Assert.assertTrue((boolean)((Set)primaryFilters.get(EntityTypes.TEZ_DAG_ID.name())).contains(this.tezDAGID.toString()));
        Assert.assertTrue((boolean)((Set)primaryFilters.get(EntityTypes.TEZ_VERTEX_ID.name())).contains(this.tezVertexID.toString()));
        Assert.assertTrue((boolean)((Set)primaryFilters.get(EntityTypes.TEZ_TASK_ID.name())).contains(this.tezTaskID.toString()));
        Assert.assertTrue((boolean)((Set)primaryFilters.get("status")).contains(state.toString()));
        Assert.assertEquals((long)1L, (long)timelineEntity.getEvents().size());
        TimelineEvent evt = (TimelineEvent)timelineEntity.getEvents().get(0);
        Assert.assertEquals((Object)HistoryEventType.TASK_ATTEMPT_FINISHED.name(), (Object)evt.getEventType());
        Assert.assertEquals((long)finishTime, (long)evt.getTimestamp());
        Map otherInfo = timelineEntity.getOtherInfo();
        Assert.assertEquals((long)17L, (long)otherInfo.size());
        Assert.assertEquals((Object)this.tezTaskAttemptID.toString(), timelineEntity.getOtherInfo().get("creationCausalAttempt"));
        Assert.assertEquals((Object)creationTime, timelineEntity.getOtherInfo().get("creationTime"));
        Assert.assertEquals((Object)allocationTime, timelineEntity.getOtherInfo().get("allocationTime"));
        Assert.assertEquals((Object)startTime, timelineEntity.getOtherInfo().get("startTime"));
        Assert.assertEquals((Object)finishTime, otherInfo.get("endTime"));
        Assert.assertEquals((Object)(finishTime - startTime), otherInfo.get("timeTaken"));
        Assert.assertEquals((Object)state.name(), otherInfo.get("status"));
        Assert.assertEquals((Object)TaskFailureType.FATAL.name(), otherInfo.get("taskFailureType"));
        Assert.assertEquals((Object)error.name(), otherInfo.get("taskAttemptErrorEnum"));
        Assert.assertEquals((Object)diagnostics, otherInfo.get("diagnostics"));
        Map obj1 = (Map)otherInfo.get("lastDataEvents");
        List obj2 = (List)obj1.get("lastDataEvents");
        Assert.assertEquals((long)2L, (long)obj2.size());
        Map obj3 = (Map)obj2.get(0);
        Assert.assertEquals((Object)((TaskAttemptImpl.DataEventDependencyInfo)events.get(0)).getTimestamp(), obj3.get("ts"));
        Assert.assertTrue((boolean)otherInfo.containsKey("counters"));
        Assert.assertEquals((Object)"inProgressURL", otherInfo.get("inProgressLogsURL"));
        Assert.assertEquals((Object)"logsURL", otherInfo.get("completedLogsURL"));
        Assert.assertEquals((Object)this.nodeId.toString(), otherInfo.get("nodeId"));
        Assert.assertEquals((Object)this.containerId.toString(), otherInfo.get("containerId"));
        Assert.assertEquals((Object)"nodeHttpAddress", otherInfo.get("nodeHttpAddress"));
        TaskAttemptFinishedEvent eventWithNullFailureType = new TaskAttemptFinishedEvent(this.tezTaskAttemptID, vertexName, startTime, finishTime, state, null, error, diagnostics, counters, (List)events, null, creationTime, this.tezTaskAttemptID, allocationTime, this.containerId, this.nodeId, "inProgressURL", "logsURL", "nodeHttpAddress");
        List evtEntities = HistoryEventTimelineConversion.convertToTimelineEntities((HistoryEvent)eventWithNullFailureType);
        Assert.assertEquals((long)1L, (long)evtEntities.size());
        TimelineEntity timelineEntityWithNullFailureType = (TimelineEntity)evtEntities.get(0);
        Assert.assertNull(timelineEntityWithNullFailureType.getOtherInfo().get("taskFailureType"));
    }

    @Test(timeout=5000L)
    public void testConvertDAGInitializedEvent() {
        long initTime = this.random.nextLong();
        HashMap<String, TezVertexID> nameIdMap = new HashMap<String, TezVertexID>();
        nameIdMap.put("foo", this.tezVertexID);
        DAGInitializedEvent event = new DAGInitializedEvent(this.tezDAGID, initTime, "user", "dagName", nameIdMap);
        List entities = HistoryEventTimelineConversion.convertToTimelineEntities((HistoryEvent)event);
        Assert.assertEquals((long)1L, (long)entities.size());
        TimelineEntity timelineEntity = (TimelineEntity)entities.get(0);
        Assert.assertEquals((Object)EntityTypes.TEZ_DAG_ID.name(), (Object)timelineEntity.getEntityType());
        Assert.assertEquals((Object)this.tezDAGID.toString(), (Object)timelineEntity.getEntityId());
        Assert.assertEquals((long)0L, (long)timelineEntity.getRelatedEntities().size());
        Assert.assertEquals((long)1L, (long)timelineEntity.getEvents().size());
        TimelineEvent timelineEvent = (TimelineEvent)timelineEntity.getEvents().get(0);
        Assert.assertEquals((Object)HistoryEventType.DAG_INITIALIZED.name(), (Object)timelineEvent.getEventType());
        Assert.assertEquals((long)initTime, (long)timelineEvent.getTimestamp());
        Assert.assertEquals((long)3L, (long)timelineEntity.getPrimaryFilters().size());
        Assert.assertTrue((boolean)((Set)timelineEntity.getPrimaryFilters().get("applicationId")).contains(this.applicationId.toString()));
        Assert.assertTrue((boolean)((Set)timelineEntity.getPrimaryFilters().get("dagName")).contains("dagName"));
        Assert.assertTrue((boolean)((Set)timelineEntity.getPrimaryFilters().get("user")).contains(this.user));
        Assert.assertTrue((boolean)timelineEntity.getOtherInfo().containsKey("vertexNameIdMapping"));
        Map vIdMap = (Map)timelineEntity.getOtherInfo().get("vertexNameIdMapping");
        Assert.assertEquals((long)1L, (long)vIdMap.size());
        Assert.assertNotNull((Object)vIdMap.containsKey("foo"));
        Assert.assertEquals((Object)this.tezVertexID.toString(), vIdMap.get("foo"));
    }

    @Test(timeout=5000L)
    public void testConvertDAGFinishedEvent() {
        long finishTime = this.random.nextLong();
        long startTime = this.random.nextLong();
        HashMap<String, Integer> taskStats = new HashMap<String, Integer>();
        taskStats.put("FOO", 100);
        taskStats.put("BAR", 200);
        DAGFinishedEvent event = new DAGFinishedEvent(this.tezDAGID, startTime, finishTime, DAGState.ERROR, "diagnostics", null, this.user, this.dagPlan.getName(), taskStats, this.applicationAttemptId, this.dagPlan);
        List entities = HistoryEventTimelineConversion.convertToTimelineEntities((HistoryEvent)event);
        Assert.assertEquals((long)2L, (long)entities.size());
        if (((TimelineEntity)entities.get(0)).getEntityType().equals(EntityTypes.TEZ_DAG_ID.name())) {
            this.assertDagFinishedEntity(finishTime, startTime, event, (TimelineEntity)entities.get(0));
            this.assertDagFinishedExtraInfoEntity(finishTime, (TimelineEntity)entities.get(1));
        } else {
            this.assertDagFinishedExtraInfoEntity(finishTime, (TimelineEntity)entities.get(0));
            this.assertDagFinishedEntity(finishTime, startTime, event, (TimelineEntity)entities.get(1));
        }
    }

    private void assertDagFinishedEntity(long finishTime, long startTime, DAGFinishedEvent event, TimelineEntity timelineEntity) {
        Assert.assertEquals((Object)EntityTypes.TEZ_DAG_ID.name(), (Object)timelineEntity.getEntityType());
        Assert.assertEquals((Object)this.tezDAGID.toString(), (Object)timelineEntity.getEntityId());
        Assert.assertEquals((long)0L, (long)timelineEntity.getRelatedEntities().size());
        Assert.assertEquals((long)1L, (long)timelineEntity.getEvents().size());
        TimelineEvent timelineEvent = (TimelineEvent)timelineEntity.getEvents().get(0);
        Assert.assertEquals((Object)HistoryEventType.DAG_FINISHED.name(), (Object)timelineEvent.getEventType());
        Assert.assertEquals((long)finishTime, (long)timelineEvent.getTimestamp());
        Assert.assertEquals((long)5L, (long)timelineEntity.getPrimaryFilters().size());
        Assert.assertTrue((boolean)((Set)timelineEntity.getPrimaryFilters().get("applicationId")).contains(this.applicationId.toString()));
        Assert.assertTrue((boolean)((Set)timelineEntity.getPrimaryFilters().get("dagName")).contains(this.dagPlan.getName()));
        Assert.assertTrue((boolean)((Set)timelineEntity.getPrimaryFilters().get("user")).contains(this.user));
        Assert.assertTrue((boolean)((Set)timelineEntity.getPrimaryFilters().get("status")).contains(DAGState.ERROR.name()));
        Assert.assertTrue((boolean)((Set)timelineEntity.getPrimaryFilters().get("callerId")).contains(this.dagPlan.getCallerContext().getCallerId()));
        Assert.assertEquals((long)startTime, (long)((Long)timelineEntity.getOtherInfo().get("startTime")));
        Assert.assertEquals((long)finishTime, (long)((Long)timelineEntity.getOtherInfo().get("endTime")));
        Assert.assertEquals((long)(finishTime - startTime), (long)((Long)timelineEntity.getOtherInfo().get("timeTaken")));
        Assert.assertEquals((Object)DAGState.ERROR.name(), timelineEntity.getOtherInfo().get("status"));
        Assert.assertEquals((Object)"diagnostics", timelineEntity.getOtherInfo().get("diagnostics"));
        Assert.assertEquals((Object)this.applicationAttemptId.toString(), timelineEntity.getOtherInfo().get("completionApplicationAttemptId"));
        Assert.assertEquals((long)100L, (long)((Integer)timelineEntity.getOtherInfo().get("FOO")).intValue());
        Assert.assertEquals((long)200L, (long)((Integer)timelineEntity.getOtherInfo().get("BAR")).intValue());
    }

    private void assertDagFinishedExtraInfoEntity(long finishTime, TimelineEntity timelineEntity) {
        Assert.assertEquals((Object)EntityTypes.TEZ_DAG_EXTRA_INFO.name(), (Object)timelineEntity.getEntityType());
        Assert.assertEquals((Object)this.tezDAGID.toString(), (Object)timelineEntity.getEntityId());
        Assert.assertEquals((long)1L, (long)timelineEntity.getRelatedEntities().size());
        Assert.assertTrue((boolean)((Set)timelineEntity.getRelatedEntities().get("TEZ_DAG_ID")).contains(this.tezDAGID.toString()));
        Assert.assertEquals((long)1L, (long)timelineEntity.getEvents().size());
        TimelineEvent timelineEvent = (TimelineEvent)timelineEntity.getEvents().get(0);
        Assert.assertEquals((Object)HistoryEventType.DAG_FINISHED.name(), (Object)timelineEvent.getEventType());
        Assert.assertEquals((long)finishTime, (long)timelineEvent.getTimestamp());
        Assert.assertTrue((boolean)timelineEntity.getOtherInfo().containsKey("counters"));
    }

    @Test(timeout=5000L)
    public void testConvertVertexInitializedEvent() {
        long initRequestedTime = this.random.nextLong();
        long initedTime = this.random.nextLong();
        int numTasks = this.random.nextInt();
        VertexInitializedEvent event = new VertexInitializedEvent(this.tezVertexID, "v1", initRequestedTime, initedTime, numTasks, "proc", null, null, new ServicePluginInfo().setContainerLauncherName("abc").setTaskSchedulerName("def").setTaskCommunicatorName("ghi").setContainerLauncherClassName("abc1").setTaskSchedulerClassName("def1").setTaskCommunicatorClassName("ghi1"));
        List entities = HistoryEventTimelineConversion.convertToTimelineEntities((HistoryEvent)event);
        Assert.assertEquals((long)1L, (long)entities.size());
        TimelineEntity timelineEntity = (TimelineEntity)entities.get(0);
        Assert.assertEquals((Object)EntityTypes.TEZ_VERTEX_ID.name(), (Object)timelineEntity.getEntityType());
        Assert.assertEquals((Object)this.tezVertexID.toString(), (Object)timelineEntity.getEntityId());
        Assert.assertEquals((long)initedTime, (long)timelineEntity.getStartTime());
        Assert.assertEquals((long)1L, (long)timelineEntity.getRelatedEntities().size());
        Assert.assertTrue((boolean)((Set)timelineEntity.getRelatedEntities().get(EntityTypes.TEZ_DAG_ID.name())).contains(this.tezDAGID.toString()));
        Assert.assertEquals((long)2L, (long)timelineEntity.getPrimaryFilters().size());
        Assert.assertTrue((boolean)((Set)timelineEntity.getPrimaryFilters().get("applicationId")).contains(this.applicationId.toString()));
        Assert.assertTrue((boolean)((Set)timelineEntity.getPrimaryFilters().get(EntityTypes.TEZ_DAG_ID.name())).contains(this.tezDAGID.toString()));
        Assert.assertEquals((long)1L, (long)timelineEntity.getEvents().size());
        TimelineEvent timelineEvent = (TimelineEvent)timelineEntity.getEvents().get(0);
        Assert.assertEquals((Object)HistoryEventType.VERTEX_INITIALIZED.name(), (Object)timelineEvent.getEventType());
        Assert.assertEquals((long)initedTime, (long)timelineEvent.getTimestamp());
        Assert.assertEquals((Object)"v1", timelineEntity.getOtherInfo().get("vertexName"));
        Assert.assertEquals((Object)"proc", timelineEntity.getOtherInfo().get("processorClassName"));
        Assert.assertEquals((long)initedTime, (long)((Long)timelineEntity.getOtherInfo().get("initTime")));
        Assert.assertEquals((long)initRequestedTime, (long)((Long)timelineEntity.getOtherInfo().get("initRequestedTime")));
        Assert.assertEquals((long)initedTime, (long)((Long)timelineEntity.getOtherInfo().get("initTime")));
        Assert.assertEquals((long)numTasks, (long)((Integer)timelineEntity.getOtherInfo().get("numTasks")).intValue());
        Assert.assertNotNull(timelineEntity.getOtherInfo().get("servicePlugin"));
        Assert.assertEquals((Object)"abc", ((Map)timelineEntity.getOtherInfo().get("servicePlugin")).get("containerLauncherName"));
        Assert.assertEquals((Object)"def", ((Map)timelineEntity.getOtherInfo().get("servicePlugin")).get("taskSchedulerName"));
        Assert.assertEquals((Object)"ghi", ((Map)timelineEntity.getOtherInfo().get("servicePlugin")).get("taskCommunicatorName"));
        Assert.assertEquals((Object)"abc1", ((Map)timelineEntity.getOtherInfo().get("servicePlugin")).get("containerLauncherClassName"));
        Assert.assertEquals((Object)"def1", ((Map)timelineEntity.getOtherInfo().get("servicePlugin")).get("taskSchedulerClassName"));
        Assert.assertEquals((Object)"ghi1", ((Map)timelineEntity.getOtherInfo().get("servicePlugin")).get("taskCommunicatorClassName"));
    }

    @Test(timeout=5000L)
    public void testConvertVertexStartedEvent() {
        long startRequestedTime = this.random.nextLong();
        long startTime = this.random.nextLong();
        VertexStartedEvent event = new VertexStartedEvent(this.tezVertexID, startRequestedTime, startTime);
        List entities = HistoryEventTimelineConversion.convertToTimelineEntities((HistoryEvent)event);
        Assert.assertEquals((long)1L, (long)entities.size());
        TimelineEntity timelineEntity = (TimelineEntity)entities.get(0);
        Assert.assertEquals((Object)EntityTypes.TEZ_VERTEX_ID.name(), (Object)timelineEntity.getEntityType());
        Assert.assertEquals((Object)this.tezVertexID.toString(), (Object)timelineEntity.getEntityId());
        Assert.assertEquals((long)0L, (long)timelineEntity.getRelatedEntities().size());
        Assert.assertEquals((long)2L, (long)timelineEntity.getPrimaryFilters().size());
        Assert.assertTrue((boolean)((Set)timelineEntity.getPrimaryFilters().get("applicationId")).contains(this.applicationId.toString()));
        Assert.assertTrue((boolean)((Set)timelineEntity.getPrimaryFilters().get(EntityTypes.TEZ_DAG_ID.name())).contains(this.tezDAGID.toString()));
        Assert.assertEquals((long)1L, (long)timelineEntity.getEvents().size());
        TimelineEvent timelineEvent = (TimelineEvent)timelineEntity.getEvents().get(0);
        Assert.assertEquals((Object)HistoryEventType.VERTEX_STARTED.name(), (Object)timelineEvent.getEventType());
        Assert.assertEquals((long)startTime, (long)timelineEvent.getTimestamp());
        Assert.assertEquals((long)3L, (long)timelineEntity.getOtherInfo().size());
        Assert.assertEquals((long)startRequestedTime, (long)((Long)timelineEntity.getOtherInfo().get("startRequestedTime")));
        Assert.assertEquals((long)startTime, (long)((Long)timelineEntity.getOtherInfo().get("startTime")));
        Assert.assertEquals((Object)VertexState.RUNNING.name(), timelineEntity.getOtherInfo().get("status"));
    }

    @Test(timeout=5000L)
    public void testConvertVertexFinishedEvent() {
        String vertexName = "v1";
        long initRequestedTime = this.random.nextLong();
        long initedTime = this.random.nextLong();
        long startRequestedTime = this.random.nextLong();
        long startTime = this.random.nextLong();
        long finishTime = this.random.nextLong();
        HashMap<String, Integer> taskStats = new HashMap<String, Integer>();
        taskStats.put("FOO", 100);
        taskStats.put("BAR", 200);
        VertexStats vertexStats = new VertexStats();
        VertexFinishedEvent event = new VertexFinishedEvent(this.tezVertexID, vertexName, 1, initRequestedTime, initedTime, startRequestedTime, startTime, finishTime, VertexState.ERROR, "diagnostics", null, vertexStats, taskStats, new ServicePluginInfo().setContainerLauncherName("abc").setTaskSchedulerName("def").setTaskCommunicatorName("ghi").setContainerLauncherClassName("abc1").setTaskSchedulerClassName("def1").setTaskCommunicatorClassName("ghi1"));
        List entities = HistoryEventTimelineConversion.convertToTimelineEntities((HistoryEvent)event);
        Assert.assertEquals((long)1L, (long)entities.size());
        TimelineEntity timelineEntity = (TimelineEntity)entities.get(0);
        Assert.assertEquals((Object)EntityTypes.TEZ_VERTEX_ID.name(), (Object)timelineEntity.getEntityType());
        Assert.assertEquals((Object)this.tezVertexID.toString(), (Object)timelineEntity.getEntityId());
        Assert.assertEquals((long)0L, (long)timelineEntity.getRelatedEntities().size());
        Assert.assertEquals((long)3L, (long)timelineEntity.getPrimaryFilters().size());
        Assert.assertTrue((boolean)((Set)timelineEntity.getPrimaryFilters().get("applicationId")).contains(this.applicationId.toString()));
        Assert.assertTrue((boolean)((Set)timelineEntity.getPrimaryFilters().get(EntityTypes.TEZ_DAG_ID.name())).contains(this.tezDAGID.toString()));
        Assert.assertTrue((boolean)((Set)timelineEntity.getPrimaryFilters().get("status")).contains(VertexState.ERROR.name()));
        Assert.assertEquals((long)1L, (long)timelineEntity.getEvents().size());
        TimelineEvent timelineEvent = (TimelineEvent)timelineEntity.getEvents().get(0);
        Assert.assertEquals((Object)HistoryEventType.VERTEX_FINISHED.name(), (Object)timelineEvent.getEventType());
        Assert.assertEquals((long)finishTime, (long)timelineEvent.getTimestamp());
        Assert.assertEquals((Object)vertexName, timelineEntity.getOtherInfo().get("vertexName"));
        Assert.assertEquals((long)finishTime, (long)((Long)timelineEntity.getOtherInfo().get("endTime")));
        Assert.assertEquals((long)(finishTime - startTime), (long)((Long)timelineEntity.getOtherInfo().get("timeTaken")));
        Assert.assertEquals((Object)VertexState.ERROR.name(), timelineEntity.getOtherInfo().get("status"));
        Assert.assertEquals((Object)"diagnostics", timelineEntity.getOtherInfo().get("diagnostics"));
        Assert.assertNotNull(timelineEntity.getOtherInfo().get("servicePlugin"));
        Assert.assertEquals((Object)"abc", ((Map)timelineEntity.getOtherInfo().get("servicePlugin")).get("containerLauncherName"));
        Assert.assertEquals((Object)"def", ((Map)timelineEntity.getOtherInfo().get("servicePlugin")).get("taskSchedulerName"));
        Assert.assertEquals((Object)"ghi", ((Map)timelineEntity.getOtherInfo().get("servicePlugin")).get("taskCommunicatorName"));
        Assert.assertEquals((Object)"abc1", ((Map)timelineEntity.getOtherInfo().get("servicePlugin")).get("containerLauncherClassName"));
        Assert.assertEquals((Object)"def1", ((Map)timelineEntity.getOtherInfo().get("servicePlugin")).get("taskSchedulerClassName"));
        Assert.assertEquals((Object)"ghi1", ((Map)timelineEntity.getOtherInfo().get("servicePlugin")).get("taskCommunicatorClassName"));
        Assert.assertTrue((boolean)timelineEntity.getOtherInfo().containsKey("stats"));
        Assert.assertEquals((long)100L, (long)((Integer)timelineEntity.getOtherInfo().get("FOO")).intValue());
        Assert.assertEquals((long)200L, (long)((Integer)timelineEntity.getOtherInfo().get("BAR")).intValue());
    }

    @Test(timeout=5000L)
    public void testConvertTaskStartedEvent() {
        long scheduleTime = this.random.nextLong();
        long startTime = this.random.nextLong();
        TaskStartedEvent event = new TaskStartedEvent(this.tezTaskID, "v1", scheduleTime, startTime);
        List entities = HistoryEventTimelineConversion.convertToTimelineEntities((HistoryEvent)event);
        Assert.assertEquals((long)1L, (long)entities.size());
        TimelineEntity timelineEntity = (TimelineEntity)entities.get(0);
        Assert.assertEquals((Object)EntityTypes.TEZ_TASK_ID.name(), (Object)timelineEntity.getEntityType());
        Assert.assertEquals((Object)this.tezTaskID.toString(), (Object)timelineEntity.getEntityId());
        Assert.assertEquals((long)startTime, (long)timelineEntity.getStartTime());
        Assert.assertEquals((long)1L, (long)timelineEntity.getRelatedEntities().size());
        Assert.assertTrue((boolean)((Set)timelineEntity.getRelatedEntities().get(EntityTypes.TEZ_VERTEX_ID.name())).contains(this.tezVertexID.toString()));
        Assert.assertEquals((long)3L, (long)timelineEntity.getPrimaryFilters().size());
        Assert.assertTrue((boolean)((Set)timelineEntity.getPrimaryFilters().get("applicationId")).contains(this.applicationId.toString()));
        Assert.assertTrue((boolean)((Set)timelineEntity.getPrimaryFilters().get(EntityTypes.TEZ_DAG_ID.name())).contains(this.tezDAGID.toString()));
        Assert.assertTrue((boolean)((Set)timelineEntity.getPrimaryFilters().get(EntityTypes.TEZ_VERTEX_ID.name())).contains(this.tezVertexID.toString()));
        Assert.assertEquals((long)1L, (long)timelineEntity.getEvents().size());
        TimelineEvent timelineEvent = (TimelineEvent)timelineEntity.getEvents().get(0);
        Assert.assertEquals((Object)HistoryEventType.TASK_STARTED.name(), (Object)timelineEvent.getEventType());
        Assert.assertEquals((long)startTime, (long)timelineEvent.getTimestamp());
        Assert.assertTrue((boolean)timelineEntity.getOtherInfo().containsKey("scheduledTime"));
        Assert.assertTrue((boolean)timelineEntity.getOtherInfo().containsKey("startTime"));
        Assert.assertEquals((long)scheduleTime, (long)((Long)timelineEntity.getOtherInfo().get("scheduledTime")));
        Assert.assertEquals((long)startTime, (long)((Long)timelineEntity.getOtherInfo().get("startTime")));
        Assert.assertTrue((boolean)TaskState.SCHEDULED.name().equals(timelineEntity.getOtherInfo().get("status")));
    }

    @Test(timeout=5000L)
    public void testConvertTaskAttemptStartedEvent() {
        long startTime = this.random.nextLong();
        TaskAttemptStartedEvent event = new TaskAttemptStartedEvent(this.tezTaskAttemptID, "v1", startTime, this.containerId, this.nodeId, "inProgressURL", "logsURL", "nodeHttpAddress");
        List entities = HistoryEventTimelineConversion.convertToTimelineEntities((HistoryEvent)event);
        Assert.assertEquals((long)1L, (long)entities.size());
        TimelineEntity timelineEntity = (TimelineEntity)entities.get(0);
        Assert.assertEquals((Object)EntityTypes.TEZ_TASK_ATTEMPT_ID.name(), (Object)timelineEntity.getEntityType());
        Assert.assertEquals((Object)this.tezTaskAttemptID.toString(), (Object)timelineEntity.getEntityId());
        Assert.assertEquals((long)startTime, (long)timelineEntity.getStartTime());
        Assert.assertEquals((long)1L, (long)timelineEntity.getRelatedEntities().size());
        Assert.assertTrue((boolean)((Set)timelineEntity.getRelatedEntities().get(EntityTypes.TEZ_TASK_ID.name())).contains(this.tezTaskID.toString()));
        Assert.assertEquals((long)1L, (long)timelineEntity.getEvents().size());
        TimelineEvent timelineEvent = (TimelineEvent)timelineEntity.getEvents().get(0);
        Assert.assertEquals((Object)HistoryEventType.TASK_ATTEMPT_STARTED.name(), (Object)timelineEvent.getEventType());
        Assert.assertEquals((long)startTime, (long)timelineEvent.getTimestamp());
        Assert.assertEquals((long)4L, (long)timelineEntity.getPrimaryFilters().size());
        Assert.assertTrue((boolean)((Set)timelineEntity.getPrimaryFilters().get("applicationId")).contains(this.applicationId.toString()));
        Assert.assertTrue((boolean)((Set)timelineEntity.getPrimaryFilters().get(EntityTypes.TEZ_DAG_ID.name())).contains(this.tezDAGID.toString()));
        Assert.assertTrue((boolean)((Set)timelineEntity.getPrimaryFilters().get(EntityTypes.TEZ_VERTEX_ID.name())).contains(this.tezVertexID.toString()));
        Assert.assertTrue((boolean)((Set)timelineEntity.getPrimaryFilters().get(EntityTypes.TEZ_TASK_ID.name())).contains(this.tezTaskID.toString()));
        Assert.assertTrue((boolean)timelineEntity.getOtherInfo().containsKey("startTime"));
        Assert.assertEquals((Object)"inProgressURL", timelineEntity.getOtherInfo().get("inProgressLogsURL"));
        Assert.assertEquals((Object)"logsURL", timelineEntity.getOtherInfo().get("completedLogsURL"));
        Assert.assertEquals((Object)this.nodeId.toString(), timelineEntity.getOtherInfo().get("nodeId"));
        Assert.assertEquals((Object)this.containerId.toString(), timelineEntity.getOtherInfo().get("containerId"));
        Assert.assertEquals((Object)"nodeHttpAddress", timelineEntity.getOtherInfo().get("nodeHttpAddress"));
        Assert.assertTrue((boolean)TaskAttemptState.RUNNING.name().equals(timelineEntity.getOtherInfo().get("status")));
    }

    @Test(timeout=5000L)
    public void testConvertTaskFinishedEvent() {
        String vertexName = "testVertexName";
        long startTime = this.random.nextLong();
        long finishTime = this.random.nextLong();
        TaskState state = TaskState.values()[this.random.nextInt(TaskState.values().length)];
        String diagnostics = "diagnostics message";
        TezCounters counters = new TezCounters();
        TaskFinishedEvent event = new TaskFinishedEvent(this.tezTaskID, vertexName, startTime, finishTime, this.tezTaskAttemptID, state, diagnostics, counters, 3);
        List entities = HistoryEventTimelineConversion.convertToTimelineEntities((HistoryEvent)event);
        Assert.assertEquals((long)1L, (long)entities.size());
        TimelineEntity timelineEntity = (TimelineEntity)entities.get(0);
        Assert.assertEquals((Object)this.tezTaskID.toString(), (Object)timelineEntity.getEntityId());
        Assert.assertEquals((Object)EntityTypes.TEZ_TASK_ID.name(), (Object)timelineEntity.getEntityType());
        Map primaryFilters = timelineEntity.getPrimaryFilters();
        Assert.assertEquals((long)4L, (long)primaryFilters.size());
        Assert.assertTrue((boolean)((Set)primaryFilters.get("applicationId")).contains(this.applicationId.toString()));
        Assert.assertTrue((boolean)((Set)primaryFilters.get(EntityTypes.TEZ_DAG_ID.name())).contains(this.tezDAGID.toString()));
        Assert.assertTrue((boolean)((Set)primaryFilters.get(EntityTypes.TEZ_VERTEX_ID.name())).contains(this.tezVertexID.toString()));
        Assert.assertTrue((boolean)((Set)primaryFilters.get("status")).contains(state.name()));
        Assert.assertEquals((long)1L, (long)timelineEntity.getEvents().size());
        TimelineEvent evt = (TimelineEvent)timelineEntity.getEvents().get(0);
        Assert.assertEquals((Object)HistoryEventType.TASK_FINISHED.name(), (Object)evt.getEventType());
        Assert.assertEquals((long)finishTime, (long)evt.getTimestamp());
        Map otherInfo = timelineEntity.getOtherInfo();
        Assert.assertEquals((long)7L, (long)otherInfo.size());
        Assert.assertEquals((Object)finishTime, otherInfo.get("endTime"));
        Assert.assertEquals((Object)(finishTime - startTime), otherInfo.get("timeTaken"));
        Assert.assertEquals((Object)state.name(), otherInfo.get("status"));
        Assert.assertEquals((Object)this.tezTaskAttemptID.toString(), otherInfo.get("successfulAttemptId"));
        Assert.assertEquals((Object)3, otherInfo.get("numFailedTaskAttempts"));
        Assert.assertEquals((Object)diagnostics, otherInfo.get("diagnostics"));
        Assert.assertTrue((boolean)otherInfo.containsKey("counters"));
    }

    @Test(timeout=5000L)
    public void testConvertVertexReconfigreDoneEvent() {
        TezVertexID vId = this.tezVertexID;
        HashMap<String, EdgeProperty> edgeMgrs = new HashMap<String, EdgeProperty>();
        edgeMgrs.put("a", EdgeProperty.create((EdgeManagerPluginDescriptor)((EdgeManagerPluginDescriptor)EdgeManagerPluginDescriptor.create((String)"a.class").setHistoryText("text")), (EdgeProperty.DataSourceType)EdgeProperty.DataSourceType.PERSISTED, (EdgeProperty.SchedulingType)EdgeProperty.SchedulingType.SEQUENTIAL, (OutputDescriptor)OutputDescriptor.create((String)"Out"), (InputDescriptor)InputDescriptor.create((String)"In")));
        VertexConfigurationDoneEvent event = new VertexConfigurationDoneEvent(vId, 0L, 1, null, edgeMgrs, null, true);
        List entities = HistoryEventTimelineConversion.convertToTimelineEntities((HistoryEvent)event);
        Assert.assertEquals((long)1L, (long)entities.size());
        TimelineEntity timelineEntity = (TimelineEntity)entities.get(0);
        Assert.assertEquals((Object)"TEZ_VERTEX_ID", (Object)timelineEntity.getEntityType());
        Assert.assertEquals((Object)vId.toString(), (Object)timelineEntity.getEntityId());
        Assert.assertEquals((long)1L, (long)timelineEntity.getEvents().size());
        Map primaryFilters = timelineEntity.getPrimaryFilters();
        Assert.assertEquals((long)2L, (long)primaryFilters.size());
        Assert.assertTrue((boolean)((Set)primaryFilters.get("applicationId")).contains(this.applicationId.toString()));
        Assert.assertTrue((boolean)((Set)primaryFilters.get(EntityTypes.TEZ_DAG_ID.name())).contains(this.tezDAGID.toString()));
        TimelineEvent evt = (TimelineEvent)timelineEntity.getEvents().get(0);
        Assert.assertEquals((Object)HistoryEventType.VERTEX_CONFIGURE_DONE.name(), (Object)evt.getEventType());
        Assert.assertEquals((Object)1, evt.getEventInfo().get("numTasks"));
        Assert.assertNotNull(evt.getEventInfo().get("updatedEdgeManagers"));
        Map updatedEdgeMgrs = (Map)evt.getEventInfo().get("updatedEdgeManagers");
        Assert.assertEquals((long)1L, (long)updatedEdgeMgrs.size());
        Assert.assertTrue((boolean)updatedEdgeMgrs.containsKey("a"));
        Map updatedEdgeMgr = (Map)updatedEdgeMgrs.get("a");
        Assert.assertEquals((Object)EdgeProperty.DataMovementType.CUSTOM.name(), updatedEdgeMgr.get("dataMovementType"));
        Assert.assertEquals((Object)"In", updatedEdgeMgr.get("edgeDestinationClass"));
        Assert.assertEquals((Object)"a.class", updatedEdgeMgr.get("edgeManagerClass"));
        Assert.assertEquals((Object)1, timelineEntity.getOtherInfo().get("numTasks"));
    }

    @Test(timeout=5000L)
    public void testConvertDAGRecoveredEvent() {
        long recoverTime = this.random.nextLong();
        DAGRecoveredEvent event = new DAGRecoveredEvent(this.applicationAttemptId, this.tezDAGID, this.dagPlan.getName(), this.user, recoverTime, this.containerLogs);
        List entities = HistoryEventTimelineConversion.convertToTimelineEntities((HistoryEvent)event);
        Assert.assertEquals((long)1L, (long)entities.size());
        TimelineEntity timelineEntity = (TimelineEntity)entities.get(0);
        Assert.assertEquals((Object)EntityTypes.TEZ_DAG_ID.name(), (Object)timelineEntity.getEntityType());
        Assert.assertEquals((Object)this.tezDAGID.toString(), (Object)timelineEntity.getEntityId());
        Assert.assertEquals((long)0L, (long)timelineEntity.getRelatedEntities().size());
        Assert.assertEquals((long)1L, (long)timelineEntity.getEvents().size());
        TimelineEvent timelineEvent = (TimelineEvent)timelineEntity.getEvents().get(0);
        Assert.assertEquals((Object)HistoryEventType.DAG_RECOVERED.name(), (Object)timelineEvent.getEventType());
        Assert.assertEquals((long)recoverTime, (long)timelineEvent.getTimestamp());
        Assert.assertTrue((boolean)timelineEvent.getEventInfo().containsKey("applicationAttemptId"));
        Assert.assertEquals((Object)this.applicationAttemptId.toString(), timelineEvent.getEventInfo().get("applicationAttemptId"));
        Assert.assertEquals((long)3L, (long)timelineEntity.getPrimaryFilters().size());
        Assert.assertTrue((boolean)((Set)timelineEntity.getPrimaryFilters().get("applicationId")).contains(this.applicationId.toString()));
        Assert.assertTrue((boolean)((Set)timelineEntity.getPrimaryFilters().get("dagName")).contains("DAGPlanMock"));
        Assert.assertTrue((boolean)((Set)timelineEntity.getPrimaryFilters().get("user")).contains(this.user));
        Assert.assertEquals((Object)this.containerLogs, timelineEntity.getOtherInfo().get("inProgressLogsURL_" + this.applicationAttemptId.getAttemptId()));
    }

    @Test(timeout=5000L)
    public void testConvertDAGRecoveredEvent2() {
        long recoverTime = this.random.nextLong();
        DAGRecoveredEvent event = new DAGRecoveredEvent(this.applicationAttemptId, this.tezDAGID, this.dagPlan.getName(), this.user, recoverTime, DAGState.ERROR, "mock reason", this.containerLogs);
        List entities = HistoryEventTimelineConversion.convertToTimelineEntities((HistoryEvent)event);
        Assert.assertEquals((long)1L, (long)entities.size());
        TimelineEntity timelineEntity = (TimelineEntity)entities.get(0);
        Assert.assertEquals((Object)EntityTypes.TEZ_DAG_ID.name(), (Object)timelineEntity.getEntityType());
        Assert.assertEquals((Object)this.tezDAGID.toString(), (Object)timelineEntity.getEntityId());
        Assert.assertEquals((long)0L, (long)timelineEntity.getRelatedEntities().size());
        Assert.assertEquals((long)1L, (long)timelineEntity.getEvents().size());
        TimelineEvent timelineEvent = (TimelineEvent)timelineEntity.getEvents().get(0);
        Assert.assertEquals((Object)HistoryEventType.DAG_RECOVERED.name(), (Object)timelineEvent.getEventType());
        Assert.assertEquals((long)recoverTime, (long)timelineEvent.getTimestamp());
        Assert.assertTrue((boolean)timelineEvent.getEventInfo().containsKey("applicationAttemptId"));
        Assert.assertEquals((Object)this.applicationAttemptId.toString(), timelineEvent.getEventInfo().get("applicationAttemptId"));
        Assert.assertEquals((Object)DAGState.ERROR.name(), timelineEvent.getEventInfo().get("dagState"));
        Assert.assertEquals((Object)"mock reason", timelineEvent.getEventInfo().get("recoveryFailureReason"));
        Assert.assertEquals((long)3L, (long)timelineEntity.getPrimaryFilters().size());
        Assert.assertTrue((boolean)((Set)timelineEntity.getPrimaryFilters().get("applicationId")).contains(this.applicationId.toString()));
        Assert.assertTrue((boolean)((Set)timelineEntity.getPrimaryFilters().get("dagName")).contains("DAGPlanMock"));
        Assert.assertTrue((boolean)((Set)timelineEntity.getPrimaryFilters().get("user")).contains(this.user));
        Assert.assertEquals((Object)this.containerLogs, timelineEntity.getOtherInfo().get("inProgressLogsURL_" + this.applicationAttemptId.getAttemptId()));
    }

    static class MockVersionInfo
    extends VersionInfo {
        MockVersionInfo() {
            super("component", "1.1.0", "rev1", "20120101", "git.apache.org");
        }
    }
}

