/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.history.logging.ats;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.timeline.TimelineEntity;
import org.apache.hadoop.yarn.api.records.timeline.TimelineEntityGroupId;
import org.apache.hadoop.yarn.api.records.timeline.TimelinePutResponse;
import org.apache.hadoop.yarn.client.api.TimelineClient;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.tez.common.security.DAGAccessControls;
import org.apache.tez.common.security.HistoryACLPolicyManager;
import org.apache.tez.dag.api.records.DAGProtos;
import org.apache.tez.dag.app.AppContext;
import org.apache.tez.dag.history.DAGHistoryEvent;
import org.apache.tez.dag.history.HistoryEvent;
import org.apache.tez.dag.history.events.AMStartedEvent;
import org.apache.tez.dag.history.events.DAGSubmittedEvent;
import org.apache.tez.dag.history.events.TaskAttemptStartedEvent;
import org.apache.tez.dag.history.events.TaskStartedEvent;
import org.apache.tez.dag.history.events.VertexStartedEvent;
import org.apache.tez.dag.history.logging.ats.ATSV15HistoryLoggingService;
import org.apache.tez.dag.records.TezDAGID;
import org.apache.tez.dag.records.TezTaskAttemptID;
import org.apache.tez.dag.records.TezTaskID;
import org.apache.tez.dag.records.TezVertexID;
import org.apache.tez.hadoop.shim.HadoopShim;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;

public class TestATSV15HistoryLoggingService {
    private static ApplicationId appId = ApplicationId.newInstance((long)1000L, (int)1);
    private static ApplicationAttemptId attemptId = ApplicationAttemptId.newInstance((ApplicationId)appId, (int)1);
    private static String user = "TEST_USER";
    private TimelineClient timelineClient;
    Map<TimelineEntityGroupId, List<TimelineEntity>> entityLog;
    final TimelineEntityGroupId DEFAULT_GROUP_ID = TimelineEntityGroupId.newInstance((ApplicationId)ApplicationId.newInstance((long)0L, (int)-1), (String)"");
    private AppContext appContext;

    @Test(timeout=2000L)
    public void testDAGGroupingDefault() throws Exception {
        ATSV15HistoryLoggingService service = this.createService(-1);
        service.start();
        TezDAGID dagId1 = TezDAGID.getInstance((ApplicationId)appId, (int)0);
        for (DAGHistoryEvent event : this.makeHistoryEvents(dagId1, service)) {
            service.handle(event);
        }
        while (!service.eventQueue.isEmpty()) {
            Thread.sleep(100L);
        }
        Assert.assertEquals((long)2L, (long)this.entityLog.size());
        List<TimelineEntity> amEvents = this.entityLog.get(TimelineEntityGroupId.newInstance((ApplicationId)appId, (String)appId.toString()));
        Assert.assertNotNull(amEvents);
        Assert.assertEquals((long)1L, (long)amEvents.size());
        List<TimelineEntity> nonGroupedDagEvents = this.entityLog.get(TimelineEntityGroupId.newInstance((ApplicationId)appId, (String)dagId1.toString()));
        Assert.assertNotNull(nonGroupedDagEvents);
        Assert.assertEquals((long)5L, (long)nonGroupedDagEvents.size());
        service.stop();
    }

    @Test(timeout=2000L)
    public void testDAGGroupingDisabled() throws Exception {
        ATSV15HistoryLoggingService service = this.createService(1);
        service.start();
        TezDAGID dagId1 = TezDAGID.getInstance((ApplicationId)appId, (int)0);
        for (DAGHistoryEvent event : this.makeHistoryEvents(dagId1, service)) {
            service.handle(event);
        }
        while (!service.eventQueue.isEmpty()) {
            Thread.sleep(100L);
        }
        Assert.assertEquals((long)2L, (long)this.entityLog.size());
        List<TimelineEntity> amEvents = this.entityLog.get(TimelineEntityGroupId.newInstance((ApplicationId)appId, (String)appId.toString()));
        Assert.assertNotNull(amEvents);
        Assert.assertEquals((long)1L, (long)amEvents.size());
        List<TimelineEntity> nonGroupedDagEvents = this.entityLog.get(TimelineEntityGroupId.newInstance((ApplicationId)appId, (String)dagId1.toString()));
        Assert.assertNotNull(nonGroupedDagEvents);
        Assert.assertEquals((long)5L, (long)nonGroupedDagEvents.size());
        service.stop();
    }

    @Test(timeout=2000L)
    public void testDAGGroupingGroupingEnabled() throws Exception {
        int numDagsPerGroup = 100;
        ATSV15HistoryLoggingService service = this.createService(numDagsPerGroup);
        service.start();
        TezDAGID dagId1 = TezDAGID.getInstance((ApplicationId)appId, (int)1);
        for (DAGHistoryEvent dAGHistoryEvent : this.makeHistoryEvents(dagId1, service)) {
            service.handle(dAGHistoryEvent);
        }
        TezDAGID dagId2 = TezDAGID.getInstance((ApplicationId)appId, (int)numDagsPerGroup);
        for (DAGHistoryEvent dAGHistoryEvent : this.makeHistoryEvents(dagId2, service)) {
            service.handle(dAGHistoryEvent);
        }
        TezDAGID tezDAGID = TezDAGID.getInstance((ApplicationId)appId, (int)(numDagsPerGroup + 1));
        for (DAGHistoryEvent event : this.makeHistoryEvents(tezDAGID, service)) {
            service.handle(event);
        }
        while (!service.eventQueue.isEmpty()) {
            Thread.sleep(100L);
        }
        Assert.assertEquals((Object)dagId1.getGroupId(numDagsPerGroup), (Object)dagId2.getGroupId(numDagsPerGroup));
        Assert.assertNotEquals((Object)dagId2.getGroupId(numDagsPerGroup), (Object)tezDAGID.getGroupId(numDagsPerGroup));
        Assert.assertEquals((long)3L, (long)this.entityLog.size());
        List<TimelineEntity> list = this.entityLog.get(TimelineEntityGroupId.newInstance((ApplicationId)appId, (String)appId.toString()));
        Assert.assertNotNull(list);
        Assert.assertEquals((long)3L, (long)list.size());
        List<TimelineEntity> nonGroupedDagEvents = this.entityLog.get(TimelineEntityGroupId.newInstance((ApplicationId)appId, (String)dagId1.toString()));
        Assert.assertNull(nonGroupedDagEvents);
        List<TimelineEntity> groupedDagEvents = this.entityLog.get(TimelineEntityGroupId.newInstance((ApplicationId)appId, (String)dagId1.getGroupId(numDagsPerGroup)));
        Assert.assertNotNull(groupedDagEvents);
        Assert.assertEquals((long)10L, (long)groupedDagEvents.size());
        nonGroupedDagEvents = this.entityLog.get(TimelineEntityGroupId.newInstance((ApplicationId)appId, (String)tezDAGID.toString()));
        Assert.assertNull(nonGroupedDagEvents);
        groupedDagEvents = this.entityLog.get(TimelineEntityGroupId.newInstance((ApplicationId)appId, (String)tezDAGID.getGroupId(numDagsPerGroup)));
        Assert.assertNotNull(groupedDagEvents);
        Assert.assertEquals((long)5L, (long)groupedDagEvents.size());
        service.stop();
    }

    @Test
    public void testNonSessionDomains() throws Exception {
        HistoryACLPolicyManager historyACLPolicyManager;
        ATSV15HistoryLoggingService service = this.createService(-1);
        service.historyACLPolicyManager = historyACLPolicyManager = (HistoryACLPolicyManager)Mockito.mock(HistoryACLPolicyManager.class);
        Mockito.when((Object)historyACLPolicyManager.setupSessionACLs((Configuration)Mockito.any(), (ApplicationId)Mockito.eq((Object)appId))).thenReturn(Collections.singletonMap("tez.yarn.ats.acl.session.domain.id", "session-id"));
        service.start();
        ((HistoryACLPolicyManager)Mockito.verify((Object)historyACLPolicyManager, (VerificationMode)Mockito.times((int)1))).setupSessionACLs((Configuration)Mockito.any(), (ApplicationId)Mockito.eq((Object)appId));
        TezDAGID dagId1 = TezDAGID.getInstance((ApplicationId)appId, (int)0);
        for (DAGHistoryEvent event : this.makeHistoryEvents(dagId1, service)) {
            service.handle(event);
        }
        while (!service.eventQueue.isEmpty()) {
            Thread.sleep(100L);
        }
        ((HistoryACLPolicyManager)Mockito.verify((Object)historyACLPolicyManager, (VerificationMode)Mockito.times((int)0))).setupSessionDAGACLs((Configuration)Mockito.any(), (ApplicationId)Mockito.eq((Object)appId), (String)Mockito.eq((Object)"0"), (DAGAccessControls)Mockito.any());
        ((HistoryACLPolicyManager)Mockito.verify((Object)historyACLPolicyManager, (VerificationMode)Mockito.times((int)6))).updateTimelineEntityDomain(Mockito.any(), (String)Mockito.eq((Object)"session-id"));
        Assert.assertTrue((this.entityLog.size() > 0 ? 1 : 0) != 0);
        service.stop();
    }

    @Test
    public void testNonSessionDomainsFailed() throws Exception {
        HistoryACLPolicyManager historyACLPolicyManager;
        ATSV15HistoryLoggingService service = this.createService(-1);
        service.historyACLPolicyManager = historyACLPolicyManager = (HistoryACLPolicyManager)Mockito.mock(HistoryACLPolicyManager.class);
        Mockito.when((Object)historyACLPolicyManager.setupSessionACLs((Configuration)Mockito.any(), (ApplicationId)Mockito.eq((Object)appId))).thenThrow(new Throwable[]{new IOException()});
        service.start();
        ((HistoryACLPolicyManager)Mockito.verify((Object)historyACLPolicyManager, (VerificationMode)Mockito.times((int)1))).setupSessionACLs((Configuration)Mockito.any(), (ApplicationId)Mockito.eq((Object)appId));
        TezDAGID dagId1 = TezDAGID.getInstance((ApplicationId)appId, (int)0);
        for (DAGHistoryEvent event : this.makeHistoryEvents(dagId1, service)) {
            service.handle(event);
        }
        while (!service.eventQueue.isEmpty()) {
            Thread.sleep(100L);
        }
        ((HistoryACLPolicyManager)Mockito.verify((Object)historyACLPolicyManager, (VerificationMode)Mockito.times((int)0))).setupSessionDAGACLs((Configuration)Mockito.any(), (ApplicationId)Mockito.eq((Object)appId), (String)Mockito.eq((Object)"0"), (DAGAccessControls)Mockito.any());
        ((HistoryACLPolicyManager)Mockito.verify((Object)historyACLPolicyManager, (VerificationMode)Mockito.times((int)0))).updateTimelineEntityDomain(Mockito.any(), (String)Mockito.any());
        Assert.assertEquals((long)0L, (long)this.entityLog.size());
        service.stop();
    }

    @Test
    public void testNonSessionDomainsAclNull() throws Exception {
        HistoryACLPolicyManager historyACLPolicyManager;
        ATSV15HistoryLoggingService service = this.createService(-1);
        service.historyACLPolicyManager = historyACLPolicyManager = (HistoryACLPolicyManager)Mockito.mock(HistoryACLPolicyManager.class);
        Mockito.when((Object)historyACLPolicyManager.setupSessionACLs((Configuration)Mockito.any(), (ApplicationId)Mockito.eq((Object)appId))).thenReturn(null);
        service.start();
        ((HistoryACLPolicyManager)Mockito.verify((Object)historyACLPolicyManager, (VerificationMode)Mockito.times((int)1))).setupSessionACLs((Configuration)Mockito.any(), (ApplicationId)Mockito.eq((Object)appId));
        TezDAGID dagId1 = TezDAGID.getInstance((ApplicationId)appId, (int)0);
        for (DAGHistoryEvent event : this.makeHistoryEvents(dagId1, service)) {
            service.handle(event);
        }
        while (!service.eventQueue.isEmpty()) {
            Thread.sleep(100L);
        }
        ((HistoryACLPolicyManager)Mockito.verify((Object)historyACLPolicyManager, (VerificationMode)Mockito.times((int)0))).setupSessionDAGACLs((Configuration)Mockito.any(), (ApplicationId)Mockito.eq((Object)appId), (String)Mockito.eq((Object)"0"), (DAGAccessControls)Mockito.any());
        ((HistoryACLPolicyManager)Mockito.verify((Object)historyACLPolicyManager, (VerificationMode)Mockito.times((int)0))).updateTimelineEntityDomain(Mockito.any(), (String)Mockito.any());
        Assert.assertTrue((this.entityLog.size() > 0 ? 1 : 0) != 0);
        service.stop();
    }

    @Test
    public void testSessionDomains() throws Exception {
        HistoryACLPolicyManager historyACLPolicyManager;
        ATSV15HistoryLoggingService service = this.createService(-1);
        Mockito.when((Object)this.appContext.isSession()).thenReturn((Object)true);
        service.historyACLPolicyManager = historyACLPolicyManager = (HistoryACLPolicyManager)Mockito.mock(HistoryACLPolicyManager.class);
        Mockito.when((Object)historyACLPolicyManager.setupSessionACLs((Configuration)Mockito.any(), (ApplicationId)Mockito.eq((Object)appId))).thenReturn(Collections.singletonMap("tez.yarn.ats.acl.session.domain.id", "session-id"));
        service.start();
        ((HistoryACLPolicyManager)Mockito.verify((Object)historyACLPolicyManager, (VerificationMode)Mockito.times((int)1))).setupSessionACLs((Configuration)Mockito.any(), (ApplicationId)Mockito.eq((Object)appId));
        Mockito.when((Object)historyACLPolicyManager.setupSessionDAGACLs((Configuration)Mockito.any(), (ApplicationId)Mockito.eq((Object)appId), (String)Mockito.eq((Object)"0"), (DAGAccessControls)Mockito.any())).thenReturn(Collections.singletonMap("tez.yarn.ats.acl.dag.domain.id", "dag-id"));
        TezDAGID dagId1 = TezDAGID.getInstance((ApplicationId)appId, (int)0);
        for (DAGHistoryEvent event : this.makeHistoryEvents(dagId1, service)) {
            service.handle(event);
        }
        while (!service.eventQueue.isEmpty()) {
            Thread.sleep(100L);
        }
        ((HistoryACLPolicyManager)Mockito.verify((Object)historyACLPolicyManager, (VerificationMode)Mockito.times((int)1))).setupSessionDAGACLs((Configuration)Mockito.any(), (ApplicationId)Mockito.eq((Object)appId), (String)Mockito.eq((Object)"0"), (DAGAccessControls)Mockito.any());
        ((HistoryACLPolicyManager)Mockito.verify((Object)historyACLPolicyManager, (VerificationMode)Mockito.times((int)1))).updateTimelineEntityDomain(Mockito.any(), (String)Mockito.eq((Object)"session-id"));
        ((HistoryACLPolicyManager)Mockito.verify((Object)historyACLPolicyManager, (VerificationMode)Mockito.times((int)5))).updateTimelineEntityDomain(Mockito.any(), (String)Mockito.eq((Object)"dag-id"));
        service.stop();
    }

    @Test
    public void testSessionDomainsFailed() throws Exception {
        HistoryACLPolicyManager historyACLPolicyManager;
        ATSV15HistoryLoggingService service = this.createService(-1);
        Mockito.when((Object)this.appContext.isSession()).thenReturn((Object)true);
        service.historyACLPolicyManager = historyACLPolicyManager = (HistoryACLPolicyManager)Mockito.mock(HistoryACLPolicyManager.class);
        Mockito.when((Object)historyACLPolicyManager.setupSessionACLs((Configuration)Mockito.any(), (ApplicationId)Mockito.eq((Object)appId))).thenThrow(new Throwable[]{new IOException()});
        service.start();
        ((HistoryACLPolicyManager)Mockito.verify((Object)historyACLPolicyManager, (VerificationMode)Mockito.times((int)1))).setupSessionACLs((Configuration)Mockito.any(), (ApplicationId)Mockito.eq((Object)appId));
        Mockito.when((Object)historyACLPolicyManager.setupSessionDAGACLs((Configuration)Mockito.any(), (ApplicationId)Mockito.eq((Object)appId), (String)Mockito.eq((Object)"0"), (DAGAccessControls)Mockito.any())).thenReturn(Collections.singletonMap("tez.yarn.ats.acl.dag.domain.id", "dag-id"));
        TezDAGID dagId1 = TezDAGID.getInstance((ApplicationId)appId, (int)0);
        for (DAGHistoryEvent event : this.makeHistoryEvents(dagId1, service)) {
            service.handle(event);
        }
        while (!service.eventQueue.isEmpty()) {
            Thread.sleep(100L);
        }
        ((HistoryACLPolicyManager)Mockito.verify((Object)historyACLPolicyManager, (VerificationMode)Mockito.times((int)0))).setupSessionDAGACLs((Configuration)Mockito.any(), (ApplicationId)Mockito.eq((Object)appId), (String)Mockito.eq((Object)"0"), (DAGAccessControls)Mockito.any());
        ((HistoryACLPolicyManager)Mockito.verify((Object)historyACLPolicyManager, (VerificationMode)Mockito.times((int)0))).updateTimelineEntityDomain(Mockito.any(), (String)Mockito.any());
        Assert.assertEquals((long)0L, (long)this.entityLog.size());
        service.stop();
    }

    @Test
    public void testSessionDomainsDagFailed() throws Exception {
        HistoryACLPolicyManager historyACLPolicyManager;
        ATSV15HistoryLoggingService service = this.createService(-1);
        Mockito.when((Object)this.appContext.isSession()).thenReturn((Object)true);
        service.historyACLPolicyManager = historyACLPolicyManager = (HistoryACLPolicyManager)Mockito.mock(HistoryACLPolicyManager.class);
        Mockito.when((Object)historyACLPolicyManager.setupSessionACLs((Configuration)Mockito.any(), (ApplicationId)Mockito.eq((Object)appId))).thenReturn(Collections.singletonMap("tez.yarn.ats.acl.session.domain.id", "session-id"));
        service.start();
        ((HistoryACLPolicyManager)Mockito.verify((Object)historyACLPolicyManager, (VerificationMode)Mockito.times((int)1))).setupSessionACLs((Configuration)Mockito.any(), (ApplicationId)Mockito.eq((Object)appId));
        Mockito.when((Object)historyACLPolicyManager.setupSessionDAGACLs((Configuration)Mockito.any(), (ApplicationId)Mockito.eq((Object)appId), (String)Mockito.eq((Object)"0"), (DAGAccessControls)Mockito.any())).thenThrow(new Throwable[]{new IOException()});
        TezDAGID dagId1 = TezDAGID.getInstance((ApplicationId)appId, (int)0);
        for (DAGHistoryEvent event : this.makeHistoryEvents(dagId1, service)) {
            service.handle(event);
        }
        while (!service.eventQueue.isEmpty()) {
            Thread.sleep(100L);
        }
        ((HistoryACLPolicyManager)Mockito.verify((Object)historyACLPolicyManager, (VerificationMode)Mockito.times((int)1))).setupSessionDAGACLs((Configuration)Mockito.any(), (ApplicationId)Mockito.eq((Object)appId), (String)Mockito.eq((Object)"0"), (DAGAccessControls)Mockito.any());
        ((HistoryACLPolicyManager)Mockito.verify((Object)historyACLPolicyManager, (VerificationMode)Mockito.times((int)1))).updateTimelineEntityDomain(Mockito.any(), (String)Mockito.eq((Object)"session-id"));
        ((HistoryACLPolicyManager)Mockito.verify((Object)historyACLPolicyManager, (VerificationMode)Mockito.times((int)0))).updateTimelineEntityDomain(Mockito.any(), (String)Mockito.eq((Object)"dag-id"));
        Assert.assertEquals((long)1L, (long)this.entityLog.size());
        service.stop();
    }

    private ATSV15HistoryLoggingService createService(int numDagsPerGroup) throws IOException, YarnException {
        ATSV15HistoryLoggingService service = new ATSV15HistoryLoggingService();
        this.appContext = (AppContext)Mockito.mock(AppContext.class);
        Mockito.when((Object)this.appContext.getApplicationID()).thenReturn((Object)appId);
        Mockito.when((Object)this.appContext.getHadoopShim()).thenReturn((Object)new HadoopShim(){});
        service.setAppContext(this.appContext);
        Configuration conf = new Configuration(false);
        if (numDagsPerGroup != -1) {
            conf.setInt("tez.history.logging.timeline.num-dags-per-group", numDagsPerGroup);
        }
        service.init(conf);
        this.timelineClient = (TimelineClient)Mockito.mock(TimelineClient.class);
        this.entityLog = new HashMap<TimelineEntityGroupId, List<TimelineEntity>>();
        Mockito.when((Object)this.timelineClient.getDelegationToken(Mockito.anyString())).thenReturn(null);
        Mockito.when((Object)this.timelineClient.renewDelegationToken((Token)Mockito.any())).thenReturn((Object)0L);
        Mockito.when((Object)this.timelineClient.putEntities((TimelineEntity[])Mockito.any())).thenAnswer(new Answer(){

            public TimelinePutResponse answer(InvocationOnMock invocation) throws Throwable {
                return TestATSV15HistoryLoggingService.this.putEntityHelper(TestATSV15HistoryLoggingService.this.DEFAULT_GROUP_ID, invocation.getArguments(), 0);
            }
        });
        Mockito.when((Object)this.timelineClient.putEntities((ApplicationAttemptId)Mockito.any(), (TimelineEntityGroupId)Mockito.any(), (TimelineEntity[])Mockito.any())).thenAnswer(new Answer(){

            public TimelinePutResponse answer(InvocationOnMock invocation) throws Throwable {
                return TestATSV15HistoryLoggingService.this.putEntityHelper((TimelineEntityGroupId)invocation.getArgument(1, TimelineEntityGroupId.class), invocation.getArguments(), 2);
            }
        });
        service.timelineClient = this.timelineClient;
        return service;
    }

    private TimelinePutResponse putEntityHelper(TimelineEntityGroupId groupId, Object[] args, int firstEntityIdx) {
        List<TimelineEntity> groupEntities = this.entityLog.get(groupId);
        if (groupEntities == null) {
            groupEntities = new ArrayList<TimelineEntity>();
            this.entityLog.put(groupId, groupEntities);
        }
        for (int i = firstEntityIdx; i < args.length; ++i) {
            groupEntities.add((TimelineEntity)args[i]);
        }
        return null;
    }

    private List<DAGHistoryEvent> makeHistoryEvents(TezDAGID dagId, ATSV15HistoryLoggingService service) {
        ArrayList<DAGHistoryEvent> historyEvents = new ArrayList<DAGHistoryEvent>();
        long time = System.currentTimeMillis();
        Configuration conf = new Configuration(service.getConfig());
        historyEvents.add(new DAGHistoryEvent(null, (HistoryEvent)new AMStartedEvent(attemptId, time, user)));
        historyEvents.add(new DAGHistoryEvent(dagId, (HistoryEvent)new DAGSubmittedEvent(dagId, time, DAGProtos.DAGPlan.getDefaultInstance(), attemptId, null, user, conf, null, "default")));
        TezVertexID vertexID = TezVertexID.getInstance((TezDAGID)dagId, (int)1);
        historyEvents.add(new DAGHistoryEvent(dagId, (HistoryEvent)new VertexStartedEvent(vertexID, time, time)));
        TezTaskID tezTaskID = TezTaskID.getInstance((TezVertexID)vertexID, (int)1);
        historyEvents.add(new DAGHistoryEvent(dagId, (HistoryEvent)new TaskStartedEvent(tezTaskID, "test", time, time)));
        historyEvents.add(new DAGHistoryEvent(dagId, (HistoryEvent)new TaskAttemptStartedEvent(TezTaskAttemptID.getInstance((TezTaskID)tezTaskID, (int)1), "test", time, ContainerId.newContainerId((ApplicationAttemptId)attemptId, (long)1L), NodeId.newInstance((String)"localhost", (int)8765), null, null, null)));
        return historyEvents;
    }
}

