/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.history.logging.ats;

import com.google.common.collect.Sets;
import java.lang.invoke.CallSite;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.timeline.TimelineEntityGroupId;
import org.apache.hadoop.yarn.server.timeline.NameValuePair;
import org.apache.tez.dag.history.logging.EntityTypes;
import org.apache.tez.dag.history.logging.ats.TimelineCachePluginImpl;
import org.apache.tez.dag.records.TezDAGID;
import org.apache.tez.dag.records.TezTaskAttemptID;
import org.apache.tez.dag.records.TezTaskID;
import org.apache.tez.dag.records.TezVertexID;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestTimelineCachePluginImpl {
    static ApplicationId appId1;
    static ApplicationAttemptId appAttemptId1;
    static ApplicationId appId2;
    static TezDAGID dagID1;
    static TezVertexID vertexID1;
    static TezTaskID taskID1;
    static TezTaskAttemptID attemptID1;
    static TezDAGID dagID2;
    static TezVertexID vertexID2;
    static TezTaskID taskID2;
    static TezTaskAttemptID attemptID2;
    static ContainerId cId1;
    static ContainerId cId2;
    static Map<String, String> typeIdMap1;
    static Map<String, String> typeIdMap2;

    private static TimelineCachePluginImpl createPlugin(int numDagsPerGroup, String usedNumDagsPerGroup) {
        Configuration conf = new Configuration(false);
        if (numDagsPerGroup > 0) {
            conf.setInt("tez.history.logging.timeline.num-dags-per-group", numDagsPerGroup);
        }
        if (usedNumDagsPerGroup != null) {
            conf.set("tez.history.logging.timeline-cache-plugin.old-num-dags-per-group", usedNumDagsPerGroup);
        }
        if (numDagsPerGroup > 0 || usedNumDagsPerGroup != null) {
            return (TimelineCachePluginImpl)ReflectionUtils.newInstance(TimelineCachePluginImpl.class, (Configuration)conf);
        }
        return new TimelineCachePluginImpl();
    }

    @BeforeClass
    public static void beforeClass() {
        appId1 = ApplicationId.newInstance((long)1000L, (int)111);
        appId2 = ApplicationId.newInstance((long)1001L, (int)121);
        appAttemptId1 = ApplicationAttemptId.newInstance((ApplicationId)appId1, (int)11);
        dagID1 = TezDAGID.getInstance((ApplicationId)appId1, (int)1);
        vertexID1 = TezVertexID.getInstance((TezDAGID)dagID1, (int)12);
        taskID1 = TezTaskID.getInstance((TezVertexID)vertexID1, (int)11144);
        attemptID1 = TezTaskAttemptID.getInstance((TezTaskID)taskID1, (int)4);
        dagID2 = TezDAGID.getInstance((ApplicationId)appId2, (int)111);
        vertexID2 = TezVertexID.getInstance((TezDAGID)dagID2, (int)121);
        taskID2 = TezTaskID.getInstance((TezVertexID)vertexID2, (int)113344);
        attemptID2 = TezTaskAttemptID.getInstance((TezTaskID)taskID2, (int)14);
        cId1 = ContainerId.newContainerId((ApplicationAttemptId)appAttemptId1, (long)1L);
        cId2 = ContainerId.newContainerId((ApplicationAttemptId)ApplicationAttemptId.newInstance((ApplicationId)appId2, (int)1), (long)22L);
        typeIdMap1 = new HashMap<String, String>();
        typeIdMap1.put(EntityTypes.TEZ_DAG_ID.name(), dagID1.toString());
        typeIdMap1.put(EntityTypes.TEZ_DAG_EXTRA_INFO.name(), dagID1.toString());
        typeIdMap1.put(EntityTypes.TEZ_VERTEX_ID.name(), vertexID1.toString());
        typeIdMap1.put(EntityTypes.TEZ_TASK_ID.name(), taskID1.toString());
        typeIdMap1.put(EntityTypes.TEZ_TASK_ATTEMPT_ID.name(), attemptID1.toString());
        typeIdMap2 = new HashMap<String, String>();
        typeIdMap2.put(EntityTypes.TEZ_DAG_ID.name(), dagID2.toString());
        typeIdMap2.put(EntityTypes.TEZ_DAG_EXTRA_INFO.name(), dagID2.toString());
        typeIdMap2.put(EntityTypes.TEZ_VERTEX_ID.name(), vertexID2.toString());
        typeIdMap2.put(EntityTypes.TEZ_TASK_ID.name(), taskID2.toString());
        typeIdMap2.put(EntityTypes.TEZ_TASK_ATTEMPT_ID.name(), attemptID2.toString());
    }

    @Test
    public void testGetTimelineEntityGroupIdByPrimaryFilter() {
        TimelineCachePluginImpl plugin = TestTimelineCachePluginImpl.createPlugin(100, null);
        for (Map.Entry<String, String> entry : typeIdMap1.entrySet()) {
            NameValuePair primaryFilter = new NameValuePair(entry.getKey(), (Object)entry.getValue());
            Assert.assertNull((Object)plugin.getTimelineEntityGroupId(EntityTypes.TEZ_APPLICATION.name(), primaryFilter, null));
            Set groupIds = plugin.getTimelineEntityGroupId(entry.getKey(), primaryFilter, null);
            if (entry.getKey().equals(EntityTypes.TEZ_DAG_ID.name())) {
                Assert.assertNull((Object)groupIds);
                continue;
            }
            Assert.assertEquals((long)2L, (long)groupIds.size());
            for (TimelineEntityGroupId groupId : groupIds) {
                Assert.assertEquals((Object)appId1, (Object)groupId.getApplicationId());
                Assert.assertTrue((boolean)this.getGroupIds(dagID1, 100).contains(groupId.getTimelineEntityGroupId()));
            }
        }
    }

    @Test
    public void testGetTimelineEntityGroupIdByIdDefaultConfig() {
        TimelineCachePluginImpl plugin = TestTimelineCachePluginImpl.createPlugin(-1, null);
        for (Map.Entry<String, String> entry : typeIdMap1.entrySet()) {
            Set groupIds = plugin.getTimelineEntityGroupId(entry.getValue(), entry.getKey());
            if (entry.getKey().equals(EntityTypes.TEZ_DAG_ID.name())) {
                Assert.assertNull((Object)groupIds);
                continue;
            }
            Assert.assertEquals((long)1L, (long)groupIds.size());
            for (TimelineEntityGroupId groupId : groupIds) {
                Assert.assertEquals((Object)appId1, (Object)groupId.getApplicationId());
                Assert.assertTrue((boolean)this.getGroupIds(dagID1, new int[0]).contains(groupId.getTimelineEntityGroupId()));
            }
        }
    }

    @Test
    public void testGetTimelineEntityGroupIdByIdNoGroupingConf() {
        TimelineCachePluginImpl plugin = TestTimelineCachePluginImpl.createPlugin(1, null);
        for (Map.Entry<String, String> entry : typeIdMap1.entrySet()) {
            Set groupIds = plugin.getTimelineEntityGroupId(entry.getValue(), entry.getKey());
            if (entry.getKey().equals(EntityTypes.TEZ_DAG_ID.name())) {
                Assert.assertNull((Object)groupIds);
                continue;
            }
            Assert.assertEquals((long)1L, (long)groupIds.size());
            for (TimelineEntityGroupId groupId : groupIds) {
                Assert.assertEquals((Object)appId1, (Object)groupId.getApplicationId());
                Assert.assertTrue((boolean)this.getGroupIds(dagID1, new int[0]).contains(groupId.getTimelineEntityGroupId()));
            }
        }
    }

    @Test
    public void testGetTimelineEntityGroupIdById() {
        TimelineCachePluginImpl plugin = TestTimelineCachePluginImpl.createPlugin(100, null);
        for (Map.Entry<String, String> entry : typeIdMap1.entrySet()) {
            Set groupIds = plugin.getTimelineEntityGroupId(entry.getValue(), entry.getKey());
            if (entry.getKey().equals(EntityTypes.TEZ_DAG_ID.name())) {
                Assert.assertNull((Object)groupIds);
                continue;
            }
            Assert.assertEquals((long)2L, (long)groupIds.size());
            for (TimelineEntityGroupId groupId : groupIds) {
                Assert.assertEquals((Object)appId1, (Object)groupId.getApplicationId());
                Assert.assertTrue((boolean)this.getGroupIds(dagID1, 100).contains(groupId.getTimelineEntityGroupId()));
            }
        }
    }

    @Test
    public void testGetTimelineEntityGroupIdByIdWithOldGroupIdsSingle() {
        TimelineCachePluginImpl plugin = TestTimelineCachePluginImpl.createPlugin(100, "50");
        for (Map.Entry<String, String> entry : typeIdMap2.entrySet()) {
            Set groupIds = plugin.getTimelineEntityGroupId(entry.getValue(), entry.getKey());
            if (entry.getKey().equals(EntityTypes.TEZ_DAG_ID.name())) {
                Assert.assertNull((Object)groupIds);
                continue;
            }
            Assert.assertEquals((long)3L, (long)groupIds.size());
            for (TimelineEntityGroupId groupId : groupIds) {
                Assert.assertEquals((Object)appId2, (Object)groupId.getApplicationId());
                Assert.assertTrue((boolean)this.getGroupIds(dagID2, 100, 50).contains(groupId.getTimelineEntityGroupId()));
            }
        }
    }

    @Test
    public void testGetTimelineEntityGroupIdByIdWithOldGroupIdsMultiple() {
        TimelineCachePluginImpl plugin = TestTimelineCachePluginImpl.createPlugin(100, "25, 50");
        for (Map.Entry<String, String> entry : typeIdMap2.entrySet()) {
            Set groupIds = plugin.getTimelineEntityGroupId(entry.getValue(), entry.getKey());
            if (entry.getKey().equals(EntityTypes.TEZ_DAG_ID.name())) {
                Assert.assertNull((Object)groupIds);
                continue;
            }
            Assert.assertEquals((long)4L, (long)groupIds.size());
            for (TimelineEntityGroupId groupId : groupIds) {
                Assert.assertEquals((Object)appId2, (Object)groupId.getApplicationId());
                Assert.assertTrue((boolean)this.getGroupIds(dagID2, 100, 25, 50).contains(groupId.getTimelineEntityGroupId()));
            }
        }
    }

    @Test
    public void testGetTimelineEntityGroupIdByIdWithOldGroupIdsEmpty() {
        TimelineCachePluginImpl plugin = TestTimelineCachePluginImpl.createPlugin(100, "");
        for (Map.Entry<String, String> entry : typeIdMap2.entrySet()) {
            Set groupIds = plugin.getTimelineEntityGroupId(entry.getValue(), entry.getKey());
            if (entry.getKey().equals(EntityTypes.TEZ_DAG_ID.name())) {
                Assert.assertNull((Object)groupIds);
                continue;
            }
            Assert.assertEquals((long)2L, (long)groupIds.size());
            for (TimelineEntityGroupId groupId : groupIds) {
                Assert.assertEquals((Object)appId2, (Object)groupId.getApplicationId());
                Assert.assertTrue((boolean)this.getGroupIds(dagID2, 100).contains(groupId.getTimelineEntityGroupId()));
            }
        }
    }

    @Test
    public void testGetTimelineEntityGroupIdByIds() {
        TimelineCachePluginImpl plugin = TestTimelineCachePluginImpl.createPlugin(100, null);
        for (Map.Entry<String, String> entry : typeIdMap1.entrySet()) {
            TreeSet<String> entityIds = new TreeSet<String>();
            entityIds.add(entry.getValue());
            entityIds.add(typeIdMap2.get(entry.getKey()));
            Set groupIds = plugin.getTimelineEntityGroupId(entry.getKey(), entityIds, null);
            if (entry.getKey().equals(EntityTypes.TEZ_DAG_ID.name())) {
                Assert.assertNull((Object)groupIds);
                continue;
            }
            Assert.assertEquals((long)4L, (long)groupIds.size());
            int found = 0;
            for (TimelineEntityGroupId groupId : groupIds) {
                String entityGroupId;
                if (groupId.getApplicationId().equals((Object)appId1)) {
                    entityGroupId = groupId.getTimelineEntityGroupId();
                    if (this.getGroupIds(dagID1, 100).contains(entityGroupId)) {
                        ++found;
                        continue;
                    }
                    Assert.fail((String)("Unexpected group id: " + entityGroupId));
                    continue;
                }
                if (groupId.getApplicationId().equals((Object)appId2)) {
                    entityGroupId = groupId.getTimelineEntityGroupId();
                    if (this.getGroupIds(dagID2, 100).contains(entityGroupId)) {
                        ++found;
                        continue;
                    }
                    Assert.fail((String)("Unexpected group id: " + entityGroupId));
                    continue;
                }
                Assert.fail((String)("Unexpected appId: " + groupId.getApplicationId()));
            }
            Assert.assertEquals((String)"All groupIds not returned", (long)4L, (long)found);
        }
    }

    @Test
    public void testInvalidIds() {
        TimelineCachePluginImpl plugin = TestTimelineCachePluginImpl.createPlugin(-1, null);
        Assert.assertNull((Object)plugin.getTimelineEntityGroupId(EntityTypes.TEZ_DAG_ID.name(), vertexID1.toString()));
        Assert.assertNull((Object)plugin.getTimelineEntityGroupId(EntityTypes.TEZ_VERTEX_ID.name(), taskID1.toString()));
        Assert.assertNull((Object)plugin.getTimelineEntityGroupId(EntityTypes.TEZ_TASK_ID.name(), attemptID1.toString()));
        Assert.assertNull((Object)plugin.getTimelineEntityGroupId(EntityTypes.TEZ_TASK_ATTEMPT_ID.name(), dagID1.toString()));
        Assert.assertNull((Object)plugin.getTimelineEntityGroupId("", ""));
        Assert.assertNull((Object)plugin.getTimelineEntityGroupId(null, null));
        Assert.assertNull((Object)plugin.getTimelineEntityGroupId("adadasd", EntityTypes.TEZ_DAG_ID.name()));
    }

    @Test
    public void testInvalidTypeRequests() {
        TimelineCachePluginImpl plugin = TestTimelineCachePluginImpl.createPlugin(-1, null);
        Assert.assertNull((Object)plugin.getTimelineEntityGroupId(EntityTypes.TEZ_APPLICATION.name(), appId1.toString()));
        Assert.assertNull((Object)plugin.getTimelineEntityGroupId(EntityTypes.TEZ_APPLICATION_ATTEMPT.name(), appAttemptId1.toString()));
        Assert.assertNull((Object)plugin.getTimelineEntityGroupId(EntityTypes.TEZ_CONTAINER_ID.name(), appId1.toString()));
        Assert.assertNull((Object)plugin.getTimelineEntityGroupId(EntityTypes.TEZ_TASK_ID.name(), null, new HashSet()));
        Assert.assertNull((Object)plugin.getTimelineEntityGroupId(EntityTypes.TEZ_TASK_ID.name(), null, new HashSet()));
    }

    @Test
    public void testContainerIdConversion() {
        TimelineCachePluginImpl plugin = TestTimelineCachePluginImpl.createPlugin(-1, null);
        String entityType = EntityTypes.TEZ_CONTAINER_ID.name();
        TreeSet<CallSite> entityIds = new TreeSet<CallSite>();
        entityIds.add((CallSite)((Object)("tez_" + cId1.toString())));
        entityIds.add((CallSite)((Object)("tez_" + cId2.toString())));
        Set groupIds = plugin.getTimelineEntityGroupId(entityType, entityIds, null);
        Assert.assertEquals((long)2L, (long)groupIds.size());
        int found = 0;
        for (TimelineEntityGroupId groupId : groupIds) {
            if (groupId.getApplicationId().equals((Object)appId1) && groupId.getTimelineEntityGroupId().equals(appId1.toString())) {
                ++found;
                continue;
            }
            if (!groupId.getApplicationId().equals((Object)appId2) || !groupId.getTimelineEntityGroupId().equals(appId2.toString())) continue;
            ++found;
        }
        Assert.assertEquals((String)"All groupIds not returned", (long)2L, (long)found);
        groupIds.clear();
        groupIds = plugin.getTimelineEntityGroupId(cId1.toString(), entityType);
        Assert.assertEquals((long)1L, (long)groupIds.size());
        found = 0;
        for (TimelineEntityGroupId groupId : groupIds) {
            if (!groupId.getApplicationId().equals((Object)appId1) || !groupId.getTimelineEntityGroupId().equals(appId1.toString())) continue;
            ++found;
        }
        Assert.assertEquals((String)"All groupIds not returned", (long)1L, (long)found);
        groupIds.clear();
        groupIds = plugin.getTimelineEntityGroupId("tez_" + cId2.toString(), entityType);
        Assert.assertEquals((long)1L, (long)groupIds.size());
        found = 0;
        for (TimelineEntityGroupId groupId : groupIds) {
            if (!groupId.getApplicationId().equals((Object)appId2) || !groupId.getTimelineEntityGroupId().equals(appId2.toString())) continue;
            ++found;
        }
        Assert.assertEquals((String)"All groupIds not returned", (long)1L, (long)found);
    }

    private Set<String> getGroupIds(TezDAGID dagId, int ... allNumDagsPerGroup) {
        HashSet groupIds = Sets.newHashSet((Object[])new String[]{dagId.toString()});
        for (int numDagsPerGroup : allNumDagsPerGroup) {
            groupIds.add(dagId.getGroupId(numDagsPerGroup));
        }
        return groupIds;
    }
}

