/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.ui.filter;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Properties;
import java.util.Set;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.tez.ui.util.TezSiteReaderUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

/*
 * Exception performing whole class analysis ignored.
 */
public class CustomHeadersFilter
implements Filter {
    private static final String HEADERS = "tez.ui.tomcat.response.headers.file";
    private static final String MAPR_HOME_ENV = "MAPR_HOME";
    private static final String DEFAULT_MAPR_HOME = "/opt/mapr";
    private final Properties properties = new Properties();
    private static final String MAPR_HOME = CustomHeadersFilter.getMaprHomeEnv();
    private static final String TEZ_VERSION = CustomHeadersFilter.getTezVersion();
    private static final String TEZ_SITE_PATH = MAPR_HOME + "/tez/tez-" + TEZ_VERSION + "/conf/tez-site.xml";
    private static final Logger LOG = LoggerFactory.getLogger(CustomHeadersFilter.class);

    public void init(FilterConfig filterConfig) {
        try {
            File headersFile;
            String headers = TezSiteReaderUtil.getProperty((String)TEZ_SITE_PATH, (String)"tez.ui.tomcat.response.headers.file");
            if (headers != null && !headers.trim().isEmpty() && (headersFile = new File(this.toAbsolutePath(headers))).exists()) {
                this.loadFromFile(headersFile);
                LOG.info(String.format("Loaded headers from file: %s", headersFile.getAbsolutePath()));
            }
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            LOG.error(String.format("Fail to read from file: %s", TEZ_SITE_PATH));
        }
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        if (servletResponse instanceof HttpServletResponse) {
            HttpServletResponse httpServletResponse = (HttpServletResponse)servletResponse;
            if (servletResponse.isCommitted()) {
                throw new ServletException("customHeadersFilter.committed");
            }
            Set<String> keys = this.properties.stringPropertyNames();
            for (String key : keys) {
                httpServletResponse.setHeader(key, this.properties.getProperty(key));
            }
        }
        filterChain.doFilter(servletRequest, servletResponse);
    }

    public void destroy() {
    }

    private static String getMaprHomeEnv() {
        String maprHome = System.getenv("MAPR_HOME");
        if (maprHome == null || maprHome.trim().isEmpty()) {
            return "/opt/mapr";
        }
        return maprHome;
    }

    private static String getTezVersion() {
        byte[] encoded = new byte[]{};
        try {
            encoded = Files.readAllBytes(Paths.get(CustomHeadersFilter.getMaprHomeEnv() + "/tez/tezversion", new String[0]));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return new String(encoded, Charset.defaultCharset()).replace("\n", "").replace("\r", "");
    }

    private String toAbsolutePath(String path) {
        Path headersPath = Paths.get(path, new String[0]);
        if (!headersPath.isAbsolute()) {
            Path tezSiteDir = Paths.get(TEZ_SITE_PATH, new String[0]).getParent();
            return tezSiteDir.toString() + File.separator + path;
        }
        return path;
    }

    private void loadFromFile(File headers) {
        try {
            this.properties.loadFromXML(new FileInputStream(headers));
        }
        catch (IOException e) {
            LOG.error(e.toString());
        }
    }
}

