/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.ui.servlet;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.SystemUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.webapp.util.WebAppUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class ActiveResourceManagerServlet
extends HttpServlet {
    private static final Logger LOGGER = LoggerFactory.getLogger(ActiveResourceManagerServlet.class);

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        YarnConfiguration yarnConfiguration = new YarnConfiguration();
        String maprHome = ActiveResourceManagerServlet.getMaprHomeEnv().trim();
        String hadoopVersion = "";
        String hadoopVersionPath = maprHome + File.separator + "hadoop" + File.separator + "hadoopversion";
        try (FileInputStream inputStream = new FileInputStream(hadoopVersionPath);){
            hadoopVersion = IOUtils.toString((InputStream)inputStream, (String)StandardCharsets.UTF_8.name());
        }
        catch (IOException e) {
            LOGGER.error("hadoopversion could not be found: " + e.getMessage());
            e.getStackTrace();
        }
        String yarnSiteXmlPath = maprHome + File.separator + "hadoop" + File.separator + "hadoop-" + hadoopVersion.trim() + File.separator + "etc" + File.separator + "hadoop" + File.separator + "yarn-site.xml";
        yarnConfiguration.addResource(new Path(yarnSiteXmlPath));
        LOGGER.info("yarn-site.xml config file has been loaded for Tez UI.");
        String schemePrefix = WebAppUtils.getHttpSchemePrefix((Configuration)yarnConfiguration);
        String proxyAddress = WebAppUtils.getProxyHostAndPort((Configuration)yarnConfiguration);
        String activeResourceManagerUrl = schemePrefix + proxyAddress;
        resp.setContentType("text/html;" + StandardCharsets.UTF_8.name());
        try (PrintWriter writer = resp.getWriter();){
            writer.println(activeResourceManagerUrl);
        }
    }

    private static String getMaprHomeEnv() {
        String maprHome = System.getenv("MAPR_HOME");
        if (maprHome == null) {
            LOGGER.warn("Environment variable MAPR_HOME is null");
            maprHome = System.getProperty("mapr.home.dir");
            if (maprHome == null) {
                LOGGER.warn("System property mapr.home.dir is null");
                maprHome = SystemUtils.IS_OS_WINDOWS ? "C:/opt/mapr" : "/opt/mapr";
                LOGGER.warn("Setting MapR home as {} by default", (Object)maprHome);
            }
        }
        return maprHome;
    }
}

