/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.test;

import java.io.File;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.tez.client.TezClient;
import org.apache.tez.dag.api.DAG;
import org.apache.tez.dag.api.ProcessorDescriptor;
import org.apache.tez.dag.api.TezConfiguration;
import org.apache.tez.dag.api.TezException;
import org.apache.tez.dag.api.Vertex;
import org.apache.tez.dag.api.client.DAGClient;
import org.apache.tez.dag.api.client.DAGStatus;
import org.apache.tez.runtime.library.processor.SleepProcessor;
import org.apache.tez.test.MiniTezCluster;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestAM {
    private static final Logger LOG = LoggerFactory.getLogger(TestAM.class);
    private static MiniTezCluster tezCluster;
    private static MiniDFSCluster dfsCluster;
    private static Configuration conf;
    private static FileSystem remoteFs;
    private static final String TEST_ROOT_DIR;

    @BeforeClass
    public static void setup() throws IOException {
        try {
            conf.set("hdfs.minidfs.basedir", TEST_ROOT_DIR);
            dfsCluster = new MiniDFSCluster.Builder(conf).numDataNodes(2).format(true).racks(null).build();
            remoteFs = dfsCluster.getFileSystem();
        }
        catch (IOException io) {
            throw new RuntimeException("problem starting mini dfs cluster", io);
        }
        if (tezCluster == null) {
            tezCluster = new MiniTezCluster(TestAM.class.getName(), 1, 1, 1);
            Configuration tezClusterConf = new Configuration();
            tezClusterConf.set("fs.defaultFS", remoteFs.getUri().toString());
            tezClusterConf.setInt("yarn.nodemanager.delete.debug-delay-sec", 20000);
            tezClusterConf.setLong("tez.am.sleep.time.before.exit.millis", 2000L);
            tezClusterConf.set("yarn.web-proxy.address", "localhost");
            File profiler = TestAM.getProfiler();
            profiler.createNewFile();
            profiler.setExecutable(true, false);
            tezClusterConf.set("tez.am.launch.cmd-opts", "-Dasync.profiler.home=" + TestAM.getProfilerHomePath());
            tezCluster.init(tezClusterConf);
            tezCluster.start();
        }
    }

    @AfterClass
    public static void tearDown() {
        if (tezCluster != null) {
            tezCluster.stop();
            tezCluster = null;
        }
        if (dfsCluster != null) {
            dfsCluster.shutdown();
            dfsCluster = null;
        }
        TestAM.getProfiler().delete();
    }

    @Test(timeout=60000L)
    public void testAMWebUIService() throws TezException, IOException, InterruptedException {
        SleepProcessor.SleepProcessorConfig spConf = new SleepProcessor.SleepProcessorConfig(1);
        DAG dag = DAG.create((String)"TezSleepProcessor");
        Vertex vertex = Vertex.create((String)"SleepVertex", (ProcessorDescriptor)((ProcessorDescriptor)ProcessorDescriptor.create((String)SleepProcessor.class.getName()).setUserPayload(spConf.toUserPayload())), (int)1, (Resource)Resource.newInstance((int)1024, (int)1));
        dag.addVertex(vertex);
        TezConfiguration tezConf = new TezConfiguration(tezCluster.getConfig());
        TezClient tezSession = TezClient.create((String)"TezSleepProcessor", (TezConfiguration)tezConf, (boolean)false);
        tezSession.start();
        DAGClient dagClient = tezSession.submitDAG(dag);
        DAGStatus dagStatus = dagClient.getDAGStatus(null);
        while (!dagStatus.isCompleted()) {
            Thread.sleep(500L);
            dagStatus = dagClient.getDAGStatus(null);
        }
        String webUIAddress = dagClient.getWebUIAddress();
        Assert.assertNotNull((String)"getWebUIAddress should return TezAM's web UI address", (Object)webUIAddress);
        LOG.info("TezAM webUI address: " + webUIAddress);
        this.checkAddress(webUIAddress + "/jmx");
        this.checkAddress(webUIAddress + "/conf");
        this.checkAddress(webUIAddress + "/stacks");
        this.checkAddress(webUIAddress + "/prof", 202);
        this.checkAddress(webUIAddress + "/prof-output");
        URL url = new URL(webUIAddress);
        Configuration.IntegerRanges portRange = conf.getRange("tez.am.tez-ui.webservice.port-range", "50000-50050");
        Assert.assertTrue((String)("WebUIService port should be in the defined range (got: " + url.getPort() + ")"), (portRange.getRangeStart() <= url.getPort() ? 1 : 0) != 0);
        tezSession.stop();
    }

    private void checkAddress(String url) {
        this.checkAddress(url, 200);
    }

    private void checkAddress(String url, int expectedCode) {
        boolean success = false;
        try {
            HttpURLConnection connection = (HttpURLConnection)new URL(url).openConnection();
            connection.connect();
            success = connection.getResponseCode() == expectedCode;
        }
        catch (Exception e) {
            LOG.error("Error while checking url: " + url, (Throwable)e);
        }
        Assert.assertTrue((String)(url + " should be available"), (boolean)success);
    }

    private static File getProfiler() {
        return new File(TestAM.getProfilerHomePath(), "profiler.sh");
    }

    private static String getProfilerHomePath() {
        return System.getProperty("java.io.tmpdir");
    }

    static {
        conf = new Configuration();
        TEST_ROOT_DIR = "target/" + TestAM.class.getName() + "-tmpDir";
    }
}

