/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.runtime.library.cartesianproduct;

import com.google.common.annotations.VisibleForTesting;
import com.google.protobuf.ByteString;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.tez.common.Preconditions;
import org.apache.tez.dag.api.EdgeManagerPluginDescriptor;
import org.apache.tez.dag.api.EdgeProperty;
import org.apache.tez.dag.api.InputDescriptor;
import org.apache.tez.dag.api.TezException;
import org.apache.tez.dag.api.VertexManagerPlugin;
import org.apache.tez.dag.api.VertexManagerPluginContext;
import org.apache.tez.dag.api.event.VertexStateUpdate;
import org.apache.tez.runtime.api.Event;
import org.apache.tez.runtime.api.TaskAttemptIdentifier;
import org.apache.tez.runtime.api.events.VertexManagerEvent;
import org.apache.tez.runtime.library.cartesianproduct.CartesianProductEdgeManager;
import org.apache.tez.runtime.library.cartesianproduct.CartesianProductUserPayload;
import org.apache.tez.runtime.library.cartesianproduct.CartesianProductVertexManagerPartitioned;
import org.apache.tez.runtime.library.cartesianproduct.CartesianProductVertexManagerReal;
import org.apache.tez.runtime.library.cartesianproduct.FairCartesianProductVertexManager;

public class CartesianProductVertexManager
extends VertexManagerPlugin {
    public static final String TEZ_CARTESIAN_PRODUCT_SLOW_START_MIN_FRACTION = "tez.cartesian-product.min-src-fraction";
    public static final float TEZ_CARTESIAN_PRODUCT_SLOW_START_MIN_FRACTION_DEFAULT = 0.25f;
    public static final String TEZ_CARTESIAN_PRODUCT_SLOW_START_MAX_FRACTION = "tez.cartesian-product.max-src-fraction";
    public static final float TEZ_CARTESIAN_PRODUCT_SLOW_START_MAX_FRACTION_DEFAULT = 0.75f;
    public static final String TEZ_CARTESIAN_PRODUCT_NUM_PARTITIONS = "tez.cartesian-product.num-partitions";
    public static final String TEZ_CARTESIAN_PRODUCT_ENABLE_GROUPING = "tez.cartesian-product.disable-grouping";
    public static final boolean TEZ_CARTESIAN_PRODUCT_ENABLE_GROUPING_DEFAULT = true;
    public static final String TEZ_CARTESIAN_PRODUCT_GROUPING_FRACTION = "tez.cartesian-product.grouping-fraction";
    public static final String TEZ_CARTESIAN_PRODUCT_MAX_PARALLELISM = "tez.cartesian-product.max-parallelism";
    public static final int TEZ_CARTESIAN_PRODUCT_MAX_PARALLELISM_DEFAULT = 1000;
    public static final String TEZ_CARTESIAN_PRODUCT_MIN_OPS_PER_WORKER = "tez.cartesian-product.min-ops-per-worker";
    public static final long TEZ_CARTESIAN_PRODUCT_MIN_OPS_PER_WORKER_DEFAULT = 1000000L;
    private CartesianProductVertexManagerReal vertexManagerReal = null;

    public CartesianProductVertexManager(VertexManagerPluginContext context) {
        super(context);
        Preconditions.checkArgument((context.getVertexNumTasks(context.getVertexName()) == -1 ? 1 : 0) != 0, (Object)"Vertex with CartesianProductVertexManager cannot use pre-defined parallelism");
    }

    public void initialize() throws Exception {
        CartesianProductUserPayload.CartesianProductConfigProto config = CartesianProductUserPayload.CartesianProductConfigProto.parseFrom(ByteString.copyFrom((ByteBuffer)this.getContext().getUserPayload().getPayload()));
        Map edgePropertyMap = this.getContext().getInputVertexEdgeProperties();
        Set sourceVerticesDAG = edgePropertyMap.keySet();
        HashSet sourceVerticesConfig = new HashSet(config.getSourcesList());
        Map vertexGroups = this.getContext().getInputVertexGroups();
        HashMap<String, String> vertexToGroup = new HashMap<String, String>();
        for (Map.Entry group : vertexGroups.entrySet()) {
            for (String vertex : (List)group.getValue()) {
                vertexToGroup.put(vertex, (String)group.getKey());
            }
        }
        for (Map.Entry entry : edgePropertyMap.entrySet()) {
            String vertex = (String)entry.getKey();
            String group = (String)vertexToGroup.get(vertex);
            EdgeProperty edgeProperty = (EdgeProperty)entry.getValue();
            EdgeManagerPluginDescriptor empDescriptor = edgeProperty.getEdgeManagerDescriptor();
            if (empDescriptor != null && empDescriptor.getClassName().equals(CartesianProductEdgeManager.class.getName())) {
                Preconditions.checkArgument((sourceVerticesConfig.contains(vertex) || sourceVerticesConfig.contains(group) ? 1 : 0) != 0, (Object)(vertex + " has CartesianProductEdgeManager but isn't in CartesianProductVertexManagerConfig"));
            } else {
                Preconditions.checkArgument((!sourceVerticesConfig.contains(vertex) && !sourceVerticesConfig.contains(group) ? 1 : 0) != 0, (Object)(vertex + " has no CartesianProductEdgeManager but is in CartesianProductVertexManagerConfig"));
            }
            if (edgeProperty.getDataMovementType() == EdgeProperty.DataMovementType.CUSTOM) {
                Preconditions.checkArgument((sourceVerticesConfig.contains(vertex) || sourceVerticesConfig.contains(group) ? 1 : 0) != 0, (Object)"Only broadcast and cartesian product edges are allowed in cartesian product vertex");
                continue;
            }
            Preconditions.checkArgument((edgeProperty.getDataMovementType() == EdgeProperty.DataMovementType.BROADCAST ? 1 : 0) != 0, (Object)"Only broadcast and cartesian product edges are allowed in cartesian product vertex");
        }
        for (String src : sourceVerticesConfig) {
            List vertices = vertexGroups.containsKey(src) ? (List)vertexGroups.get(src) : Collections.singletonList(src);
            for (String v : vertices) {
                Preconditions.checkArgument((boolean)sourceVerticesDAG.contains(v), (Object)(v + " is in CartesianProductVertexManagerConfig but not a source vertex in DAG"));
                Preconditions.checkArgument((boolean)((EdgeProperty)edgePropertyMap.get(v)).getEdgeManagerDescriptor().getClassName().equals(CartesianProductEdgeManager.class.getName()), (Object)(v + " is in CartesianProductVertexManagerConfig and a source vertex, but has no CartesianProductEdgeManager"));
            }
        }
        this.vertexManagerReal = config.getIsPartitioned() ? new CartesianProductVertexManagerPartitioned(this.getContext()) : new FairCartesianProductVertexManager(this.getContext());
        this.vertexManagerReal.initialize(config);
    }

    @VisibleForTesting
    protected CartesianProductVertexManagerReal getVertexManagerReal() {
        return this.vertexManagerReal;
    }

    public void onVertexManagerEventReceived(VertexManagerEvent vmEvent) throws Exception {
        this.vertexManagerReal.onVertexManagerEventReceived(vmEvent);
    }

    public void onRootVertexInitialized(String inputName, InputDescriptor inputDescriptor, List<Event> events) throws Exception {
        throw new TezException("Direct input to cartesian product vertex is not supported yet");
    }

    public void onVertexStarted(List<TaskAttemptIdentifier> completions) throws Exception {
        this.vertexManagerReal.onVertexStarted(completions);
    }

    public void onVertexStateUpdated(VertexStateUpdate stateUpdate) throws Exception {
        this.vertexManagerReal.onVertexStateUpdated(stateUpdate);
    }

    public void onSourceTaskCompleted(TaskAttemptIdentifier attempt) throws Exception {
        this.vertexManagerReal.onSourceTaskCompleted(attempt);
    }
}

