/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.runtime.library.common.sort.impl;

import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.TreeMultimap;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.BoundedByteArrayOutputStream;
import org.apache.hadoop.io.DataInputBuffer;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.RawComparator;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.WritableComparator;
import org.apache.hadoop.io.serializer.Serialization;
import org.apache.hadoop.io.serializer.WritableSerialization;
import org.apache.hadoop.util.Progress;
import org.apache.hadoop.util.Progressable;
import org.apache.tez.common.Preconditions;
import org.apache.tez.runtime.library.common.ConfigUtils;
import org.apache.tez.runtime.library.common.serializer.SerializationContext;
import org.apache.tez.runtime.library.common.shuffle.orderedgrouped.InMemoryReader;
import org.apache.tez.runtime.library.common.shuffle.orderedgrouped.InMemoryWriter;
import org.apache.tez.runtime.library.common.shuffle.orderedgrouped.MergeManager;
import org.apache.tez.runtime.library.common.shuffle.orderedgrouped.TestMergeManager;
import org.apache.tez.runtime.library.common.sort.impl.IFile;
import org.apache.tez.runtime.library.common.sort.impl.TezMerger;
import org.apache.tez.runtime.library.common.sort.impl.TezRawKeyValueIterator;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestTezMerger {
    private static final Logger LOG = LoggerFactory.getLogger(TestTezMerger.class);
    private static Configuration defaultConf = new Configuration();
    private static FileSystem localFs = null;
    private static Path workDir = null;
    private static RawComparator comparator = null;
    private static Random rnd = new Random();
    private static final String SAME_KEY = "SAME_KEY";
    private static final String DIFF_KEY = "DIFF_KEY";
    private static ListMultimap<Integer, Long> verificationDataSet = LinkedListMultimap.create();
    private MergeManager merger = (MergeManager)Mockito.mock(MergeManager.class);

    @AfterClass
    public static void cleanup() throws Exception {
        localFs.delete(workDir, true);
    }

    @Test(timeout=80000L)
    public void testMerge() throws Exception {
        this.merge(1, 0, 1);
        this.merge(100, 0, 5);
        this.merge(12, 4, 2);
        this.merge(2, 10, 2);
        this.merge(1, 10, 1);
        this.merge(5, 10, 3);
        this.merge(200, 10, 100);
        this.merge(5, 100, 5);
        this.merge(5, 1000, 5);
        this.merge(5, 1000, 10);
        this.merge(5, 1000, 100);
        LinkedList<Path> pathList = new LinkedList<Path>();
        pathList.clear();
        pathList.addAll(this.createIFiles(Math.max(2, rnd.nextInt(20)), 0));
        pathList.addAll(this.createIFiles(Math.max(2, rnd.nextInt(20)), Math.max(2, rnd.nextInt(10))));
        this.merge(pathList, Math.max(2, rnd.nextInt(10)));
    }

    private Path createIFileWithTextData(List<String> data) throws IOException {
        Path path = new Path(workDir + "/src", "data_" + System.nanoTime() + ".out");
        FSDataOutputStream out = localFs.create(path);
        IFile.Writer writer = new IFile.Writer((Serialization)new WritableSerialization(), (Serialization)new WritableSerialization(), out, Text.class, Text.class, null, null, null, true);
        for (String key : data) {
            writer.append((Object)new Text(key), (Object)new Text(key + "_" + System.nanoTime()));
        }
        writer.close();
        out.close();
        return path;
    }

    private void verify(TezRawKeyValueIterator records, String[][] expectedResult) throws IOException {
        int i = 0;
        while (records.next()) {
            DataInputBuffer key = records.getKey();
            DataInputBuffer value = records.getValue();
            Text k = new Text();
            k.readFields((DataInput)key);
            Text v = new Text();
            v.readFields((DataInput)value);
            Assert.assertTrue((boolean)k.toString().equals(expectedResult[i][0]));
            String correctResult = expectedResult[i][1];
            if (records.isSameKey()) {
                Assert.assertTrue((String)("Expected " + correctResult), (boolean)correctResult.equalsIgnoreCase(SAME_KEY));
                LOG.info("\tSame Key : key=" + k + ", val=" + v);
            } else {
                Assert.assertTrue((String)("Expected " + correctResult), (boolean)correctResult.equalsIgnoreCase(DIFF_KEY));
                LOG.info("key=" + k + ", val=" + v);
            }
            ++i;
        }
    }

    @Test(timeout=5000L)
    public void testWithCustomComparator_WithEmptyStrings() throws Exception {
        LinkedList<Path> pathList = new LinkedList<Path>();
        LinkedList data = Lists.newLinkedList();
        CustomComparator rc = new CustomComparator();
        LOG.info("Test with custom comparator with empty strings in middle");
        data.add("0");
        data.add("0");
        pathList.add(this.createIFileWithTextData(data));
        data.clear();
        data.add("");
        pathList.add(this.createIFileWithTextData(data));
        data.clear();
        data.add("0");
        data.add("0");
        pathList.add(this.createIFileWithTextData(data));
        data.clear();
        data.add("1");
        data.add("2");
        pathList.add(this.createIFileWithTextData(data));
        TezRawKeyValueIterator records = this.merge(pathList, (RawComparator)rc);
        String[][] expectedResult = new String[][]{{"", DIFF_KEY}, {"0", DIFF_KEY}, {"0", SAME_KEY}, {"0", SAME_KEY}, {"0", SAME_KEY}, {"1", DIFF_KEY}, {"2", DIFF_KEY}};
        this.verify(records, expectedResult);
        pathList.clear();
        data.clear();
    }

    @Test(timeout=5000L)
    public void testWithCustomComparator_No_RLE() throws Exception {
        LinkedList<Path> pathList = new LinkedList<Path>();
        LinkedList data = Lists.newLinkedList();
        CustomComparator rc = new CustomComparator();
        LOG.info("Test with custom comparator with no RLE");
        data.add("1");
        data.add("4");
        data.add("5");
        pathList.add(this.createIFileWithTextData(data));
        data.clear();
        data.add("2");
        data.add("6");
        data.add("7");
        pathList.add(this.createIFileWithTextData(data));
        data.clear();
        data.add("3");
        data.add("8");
        data.add("9");
        pathList.add(this.createIFileWithTextData(data));
        TezRawKeyValueIterator records = this.merge(pathList, (RawComparator)rc);
        String[][] expectedResult = new String[][]{{"1", DIFF_KEY}, {"2", DIFF_KEY}, {"3", DIFF_KEY}, {"4", DIFF_KEY}, {"5", DIFF_KEY}, {"6", DIFF_KEY}, {"7", DIFF_KEY}, {"8", DIFF_KEY}, {"9", DIFF_KEY}};
        this.verify(records, expectedResult);
        pathList.clear();
        data.clear();
    }

    @Test(timeout=5000L)
    public void testWithCustomComparator_RLE_acrossFiles() throws Exception {
        LinkedList<Path> pathList = new LinkedList<Path>();
        LinkedList data = Lists.newLinkedList();
        LOG.info("Test with custom comparator with RLE spanning across segment boundaries");
        data.clear();
        data.add("0");
        data.add("0");
        pathList.add(this.createIFileWithTextData(data));
        data.clear();
        data.add("0");
        data.add("1");
        pathList.add(this.createIFileWithTextData(data));
        CustomComparator rc = new CustomComparator();
        TezRawKeyValueIterator records = this.merge(pathList, (RawComparator)rc);
        String[][] expectedResult = new String[][]{{"0", DIFF_KEY}, {"0", SAME_KEY}, {"0", SAME_KEY}, {"1", DIFF_KEY}};
        this.verify(records, expectedResult);
        pathList.clear();
        data.clear();
    }

    @Test(timeout=5000L)
    public void testWithCustomComparator_mixedFiles() throws Exception {
        LinkedList<Path> pathList = new LinkedList<Path>();
        LinkedList data = Lists.newLinkedList();
        LOG.info("Test with custom comparator with mixed set of segments (empty, non-empty etc)");
        data.clear();
        data.add("0");
        pathList.add(this.createIFileWithTextData(data));
        data.clear();
        pathList.add(this.createIFileWithTextData(data));
        data.clear();
        data.add("");
        pathList.add(this.createIFileWithTextData(data));
        data.clear();
        data.add("0");
        data.add("0");
        data.add("0");
        pathList.add(this.createIFileWithTextData(data));
        CustomComparator rc = new CustomComparator();
        TezRawKeyValueIterator records = this.merge(pathList, (RawComparator)rc);
        String[][] expectedResult = new String[][]{{"", DIFF_KEY}, {"0", DIFF_KEY}, {"0", SAME_KEY}, {"0", SAME_KEY}, {"0", SAME_KEY}};
        this.verify(records, expectedResult);
        pathList.clear();
        data.clear();
    }

    @Test(timeout=5000L)
    public void testWithCustomComparator_RLE() throws Exception {
        LinkedList<Path> pathList = new LinkedList<Path>();
        LinkedList data = Lists.newLinkedList();
        LOG.info("Test with custom comparator 2 files one containing RLE and also other segment starting with same key");
        data.clear();
        data.add("1");
        data.add("2");
        data.add("2");
        pathList.add(this.createIFileWithTextData(data));
        data.clear();
        data.add("2");
        data.add("3");
        pathList.add(this.createIFileWithTextData(data));
        TezRawKeyValueIterator records = this.merge(pathList, (RawComparator)new CustomComparator());
        String[][] expectedResult = new String[][]{{"1", DIFF_KEY}, {"2", DIFF_KEY}, {"2", SAME_KEY}, {"2", SAME_KEY}, {"3", DIFF_KEY}};
        this.verify(records, expectedResult);
        pathList.clear();
        data.clear();
    }

    @Test(timeout=5000L)
    public void testWithCustomComparator_RLE2() throws Exception {
        LinkedList<Path> pathList = new LinkedList<Path>();
        LinkedList data = Lists.newLinkedList();
        LOG.info("Test with custom comparator 3 files with RLE (starting keys) spanning across boundaries");
        data.clear();
        data.add("0");
        data.add("1");
        data.add("1");
        pathList.add(this.createIFileWithTextData(data));
        data.clear();
        data.add("0");
        data.add("1");
        pathList.add(this.createIFileWithTextData(data));
        data.clear();
        data.add("0");
        data.add("1");
        data.add("1");
        pathList.add(this.createIFileWithTextData(data));
        TezRawKeyValueIterator records = this.merge(pathList, (RawComparator)new CustomComparator());
        String[][] expectedResult = new String[][]{{"0", DIFF_KEY}, {"0", SAME_KEY}, {"0", SAME_KEY}, {"1", DIFF_KEY}, {"1", SAME_KEY}, {"1", SAME_KEY}, {"1", SAME_KEY}, {"1", SAME_KEY}};
        this.verify(records, expectedResult);
        pathList.clear();
        data.clear();
    }

    @Test(timeout=5000L)
    public void testWithCustomComparator() throws Exception {
        LinkedList<Path> pathList = new LinkedList<Path>();
        LinkedList data = Lists.newLinkedList();
        LOG.info("Test with custom comparator 3 files with RLE (starting keys) spanning across boundaries");
        data.clear();
        data.add("0");
        pathList.add(this.createIFileWithTextData(data));
        data.clear();
        data.add("0");
        pathList.add(this.createIFileWithTextData(data));
        data.clear();
        data.add("1");
        pathList.add(this.createIFileWithTextData(data));
        TezRawKeyValueIterator records = this.merge(pathList, (RawComparator)new CustomComparator());
        String[][] expectedResult = new String[][]{{"0", DIFF_KEY}, {"0", SAME_KEY}, {"1", DIFF_KEY}};
        this.verify(records, expectedResult);
        pathList.clear();
        data.clear();
    }

    @Test(timeout=5000L)
    public void testWithCustomComparator_RLE3() throws Exception {
        LinkedList<Path> pathList = new LinkedList<Path>();
        LinkedList data = Lists.newLinkedList();
        LOG.info("Test with custom comparator");
        data.clear();
        data.add("0");
        pathList.add(this.createIFileWithTextData(data));
        data.clear();
        data.add("0");
        data.add("1");
        data.add("1");
        pathList.add(this.createIFileWithTextData(data));
        TezRawKeyValueIterator records = this.merge(pathList, (RawComparator)new CustomComparator());
        String[][] expectedResult = new String[][]{{"0", DIFF_KEY}, {"0", SAME_KEY}, {"1", DIFF_KEY}, {"1", SAME_KEY}};
        this.verify(records, expectedResult);
        pathList.clear();
        data.clear();
    }

    @Test(timeout=5000L)
    public void testWithCustomComparator_allEmptyFiles() throws Exception {
        LinkedList<Path> pathList = new LinkedList<Path>();
        LinkedList data = Lists.newLinkedList();
        LOG.info("Test with custom comparator where all files are empty");
        pathList.add(this.createIFileWithTextData(data));
        pathList.add(this.createIFileWithTextData(data));
        pathList.add(this.createIFileWithTextData(data));
        pathList.add(this.createIFileWithTextData(data));
        TezRawKeyValueIterator records = this.merge(pathList, (RawComparator)new CustomComparator());
        String[][] expectedResult = new String[0][0];
        this.verify(records, expectedResult);
    }

    private TezRawKeyValueIterator merge(List<Path> pathList, RawComparator rc) throws IOException, InterruptedException {
        TezMerger merger = new TezMerger();
        TezRawKeyValueIterator records = TezMerger.merge((Configuration)defaultConf, (FileSystem)localFs, (SerializationContext)new SerializationContext(IntWritable.class, LongWritable.class, (Serialization)new WritableSerialization(), (Serialization)new WritableSerialization()), null, (boolean)false, (int)0, (int)1024, (Path[])pathList.toArray(new Path[pathList.size()]), (boolean)true, (int)4, (Path)new Path(workDir, "tmp_" + System.nanoTime()), (RawComparator)(rc == null ? comparator : rc), (Progressable)new Reporter(), null, null, null, (Progress)new Progress());
        return records;
    }

    private void merge(List<Path> pathList, int mergeFactor) throws Exception {
        this.merge(pathList, mergeFactor, null);
    }

    private void merge(int fileCount, int keysPerFile, int mergeFactor) throws Exception {
        List<Path> pathList = this.createIFiles(fileCount, keysPerFile);
        this.merge(pathList, mergeFactor, null);
    }

    private void merge(List<Path> pathList, int mergeFactor, RawComparator rc) throws Exception {
        TezMerger merger = new TezMerger();
        TezRawKeyValueIterator records = TezMerger.merge((Configuration)defaultConf, (FileSystem)localFs, (SerializationContext)new SerializationContext(IntWritable.class, LongWritable.class, (Serialization)new WritableSerialization(), (Serialization)new WritableSerialization()), null, (boolean)false, (int)0, (int)1024, (Path[])pathList.toArray(new Path[pathList.size()]), (boolean)true, (int)mergeFactor, (Path)new Path(workDir, "tmp_" + System.nanoTime()), (RawComparator)(rc == null ? comparator : rc), (Progressable)new Reporter(), null, null, null, (Progress)new Progress());
        this.verifyData(records);
        verificationDataSet.clear();
    }

    private void verifyData(TezRawKeyValueIterator records) throws IOException {
        HashMap dataMap = Maps.newHashMap();
        int pk = -1;
        while (records.next()) {
            DataInputBuffer key = records.getKey();
            DataInputBuffer dataInputBuffer = records.getValue();
            IntWritable k = new IntWritable();
            k.readFields((DataInput)key);
            LongWritable v = new LongWritable();
            v.readFields((DataInput)dataInputBuffer);
            if (records.isSameKey()) {
                LOG.info("\tSame Key : key=" + k.get() + ", val=" + v.get());
                Assert.assertTrue((verificationDataSet.get((Object)k.get()).size() > 1 ? 1 : 0) != 0);
                Assert.assertTrue((String)("previousKey=" + pk + ", current=" + k.get()), (pk == k.get() ? 1 : 0) != 0);
            } else {
                LOG.info("key=" + k.get() + ", val=" + v.get());
            }
            pk = k.get();
            int keyCount = dataMap.containsKey(k.get()) ? (Integer)dataMap.get(k.get()) + 1 : 1;
            dataMap.put(k.get(), keyCount);
        }
        Assert.assertTrue((String)("dataMap=" + dataMap.keySet().size() + ", verificationSet=" + verificationDataSet.keySet().size()), (dataMap.keySet().size() == verificationDataSet.keySet().size() ? 1 : 0) != 0);
        for (Integer n : verificationDataSet.keySet()) {
            Assert.assertTrue((String)("Data size for " + n + " not matching with source; dataSize:" + (Integer)dataMap.get(n) + ", source:" + verificationDataSet.get((Object)n).size()), (((Integer)dataMap.get(n)).intValue() == verificationDataSet.get((Object)n).size() ? 1 : 0) != 0);
        }
        for (Map.Entry entry : dataMap.entrySet()) {
            Assert.assertTrue((String)("" + entry.getKey()), (verificationDataSet.get((Object)((Integer)entry.getKey())).size() == ((Integer)entry.getValue()).intValue() ? 1 : 0) != 0);
        }
        LOG.info("******************");
    }

    private List<Path> createIFiles(int fileCount, int keysPerFile) throws IOException {
        LinkedList pathList = Lists.newLinkedList();
        Random rnd = new Random();
        for (int i = 0; i < fileCount; ++i) {
            int repeatCount = i % 2 == 0 && keysPerFile > 0 ? rnd.nextInt(keysPerFile) : 0;
            Path ifilePath = TestTezMerger.writeIFile(keysPerFile, repeatCount);
            pathList.add(ifilePath);
        }
        return pathList;
    }

    @Test(timeout=20000L)
    public void testMergeSegments() throws Exception {
        LinkedList segments = Lists.newLinkedList();
        segments.addAll(this.createInMemorySegments(10, 100));
        segments.addAll(this.createDiskSegments(10, 100));
        this.mergeSegments(segments, 5, true);
        verificationDataSet.clear();
        segments.clear();
        segments.addAll(this.createDiskSegments(10, 100));
        this.mergeSegments(segments, 5, true);
        verificationDataSet.clear();
        segments.clear();
        segments.addAll(this.createInMemorySegments(3, 100));
        this.mergeSegments(segments, 5, false);
        verificationDataSet.clear();
        segments.clear();
    }

    private void mergeSegments(List<TezMerger.Segment> segmentList, int mergeFactor, boolean hasDiskSegments) throws Exception {
        TezMerger.MergeQueue mergeQueue = new TezMerger.MergeQueue(defaultConf, localFs, segmentList, comparator, (Progressable)new Reporter(), false, false);
        TezRawKeyValueIterator records = mergeQueue.merge(new SerializationContext(IntWritable.class, LongWritable.class, (Serialization)new WritableSerialization(), (Serialization)new WritableSerialization()), mergeFactor, new Path(workDir, "tmp_" + System.nanoTime()), null, null, null, null);
        this.verifyData(records);
        int diskBufLen = mergeQueue.diskIFileValue.getLength();
        Assert.assertTrue((String)(diskBufLen + " disk buf length should be > 0"), (hasDiskSegments == diskBufLen > 0 ? 1 : 0) != 0);
        verificationDataSet.clear();
    }

    private List<TezMerger.Segment> createInMemorySegments(int segmentCount, int keysPerSegment) throws IOException {
        LinkedList segmentList = Lists.newLinkedList();
        Random rnd = new Random();
        DataInputBuffer key = new DataInputBuffer();
        DataInputBuffer value = new DataInputBuffer();
        for (int i = 0; i < segmentCount; ++i) {
            BoundedByteArrayOutputStream stream = new BoundedByteArrayOutputStream(10000);
            InMemoryWriter writer = new InMemoryWriter(stream);
            for (int j = 0; j < keysPerSegment; ++j) {
                this.populateData(new IntWritable(rnd.nextInt()), new LongWritable(rnd.nextLong()), key, value);
                writer.append(key, value);
            }
            writer.close();
            InMemoryReader reader = new InMemoryReader(this.merger, null, stream.getBuffer(), 0, stream.getLimit());
            segmentList.add(new TezMerger.Segment((IFile.Reader)reader, null));
        }
        return segmentList;
    }

    private void populateData(IntWritable intKey, LongWritable longVal, DataInputBuffer key, DataInputBuffer value) throws IOException {
        DataOutputBuffer k = new DataOutputBuffer();
        DataOutputBuffer v = new DataOutputBuffer();
        intKey.write((DataOutput)k);
        longVal.write((DataOutput)v);
        key.reset(k.getData(), 0, k.getLength());
        value.reset(v.getData(), 0, v.getLength());
        verificationDataSet.put((Object)intKey.get(), (Object)longVal.get());
    }

    private List<TezMerger.Segment> createDiskSegments(int segmentCount, int keysPerSegment) throws IOException {
        LinkedList segmentList = Lists.newLinkedList();
        Random rnd = new Random();
        for (int i = 0; i < segmentCount; ++i) {
            int repeatCount = i % 2 == 0 && keysPerSegment > 0 ? rnd.nextInt(keysPerSegment) : 0;
            Path ifilePath = TestTezMerger.writeIFile(keysPerSegment, repeatCount);
            segmentList.add(new TezMerger.DiskSegment(localFs, ifilePath, 0L, localFs.getFileStatus(ifilePath).getLen(), null, false, 1024, 1024, false, null));
        }
        return segmentList;
    }

    static Path writeIFile(int keysPerFile, int repeatCount) throws IOException {
        TreeMultimap<Integer, Long> dataSet = TestTezMerger.createDataForIFile(keysPerFile, repeatCount);
        LOG.info("DataSet size : " + dataSet.size());
        Path path = new Path(workDir + "/src", "data_" + System.nanoTime() + ".out");
        FSDataOutputStream out = localFs.create(path);
        IFile.Writer writer = new IFile.Writer((Serialization)new WritableSerialization(), (Serialization)new WritableSerialization(), out, IntWritable.class, LongWritable.class, null, null, null, true);
        for (Integer key : dataSet.keySet()) {
            for (Long value : dataSet.get((Object)key)) {
                writer.append((Object)new IntWritable(key.intValue()), (Object)new LongWritable(value.longValue()));
                verificationDataSet.put((Object)key, (Object)value);
            }
        }
        writer.close();
        out.close();
        return path;
    }

    static TreeMultimap<Integer, Long> createDataForIFile(int keyCount, int repeatCount) {
        TreeMultimap dataSet = TreeMultimap.create();
        Random rnd = new Random();
        for (int i = 0; i < keyCount; ++i) {
            if (repeatCount > 0 && rnd.nextInt(keyCount) % 2 == 0) {
                for (int j = 0; j < repeatCount; ++j) {
                    IntWritable key = new IntWritable(rnd.nextInt(keyCount));
                    Long value = new LongWritable(System.nanoTime());
                    dataSet.put((Object)key.get(), (Object)value.get());
                }
                i += repeatCount;
                LOG.info("Repeated key count=" + repeatCount);
                continue;
            }
            IntWritable key = new IntWritable(rnd.nextInt(keyCount));
            LongWritable value = new LongWritable(System.nanoTime());
            dataSet.put((Object)key.get(), (Object)value.get());
        }
        for (Integer key : dataSet.keySet()) {
            for (Long value : dataSet.get((Object)key)) {
                LOG.info("Key=" + key + ", val=" + value);
            }
        }
        LOG.info("=============");
        return dataSet;
    }

    static {
        defaultConf.set("fs.defaultFS", "file:///");
        try {
            localFs = FileSystem.getLocal((Configuration)defaultConf);
            workDir = new Path(new Path(System.getProperty("test.build.data", "/tmp")), TestTezMerger.class.getName()).makeQualified(localFs.getUri(), localFs.getWorkingDirectory());
            LOG.info("Using workDir: " + workDir);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        defaultConf.set("tez.runtime.key.class", IntWritable.class.getName());
        defaultConf.set("tez.runtime.value.class", LongWritable.class.getName());
        Path baseDir = new Path(workDir, TestMergeManager.class.getName());
        String localDirs = baseDir.toString();
        defaultConf.setStrings("tez.runtime.framework.local.dirs", new String[]{localDirs});
        comparator = ConfigUtils.getIntermediateInputKeyComparator((Configuration)defaultConf);
    }

    private static class Reporter
    implements Progressable {
        private Reporter() {
        }

        public void progress() {
        }
    }

    static class CustomComparator
    extends WritableComparator {
        CustomComparator() {
        }

        public int compare(byte[] b1, int s1, int l1, byte[] b2, int s2, int l2) {
            Preconditions.checkArgument((l2 > 0 && l1 > 0 ? 1 : 0) != 0, (Object)("l2=" + l2 + ",l1=" + l1));
            ByteBuffer bb1 = ByteBuffer.wrap(b1, s1, l1);
            ByteBuffer bb2 = ByteBuffer.wrap(b2, s2, l2);
            return bb1.compareTo(bb2);
        }
    }
}

