/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.runtime.library.cartesianproduct;

import org.apache.tez.dag.api.EdgeManagerPluginContext;
import org.apache.tez.dag.api.EdgeManagerPluginOnDemand;
import org.apache.tez.runtime.library.cartesianproduct.CartesianProductUserPayload;
import org.apache.tez.runtime.library.cartesianproduct.FairCartesianProductEdgeManager;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class TestFairCartesianProductEdgeManager {
    private EdgeManagerPluginContext mockContext;
    private FairCartesianProductEdgeManager edgeManager;

    @Before
    public void setup() {
        this.mockContext = (EdgeManagerPluginContext)Mockito.mock(EdgeManagerPluginContext.class);
        this.edgeManager = new FairCartesianProductEdgeManager(this.mockContext);
    }

    private TestData dataForRouting(int srcId, int destId, Object expected) {
        return new TestData(srcId, destId, -1, expected);
    }

    private TestData dataForInputError(int destId, int inputId, Object expected) {
        return new TestData(-1, destId, inputId, expected);
    }

    private TestData dataForSrc(int srcId, Object expected) {
        return new TestData(srcId, -1, -1, expected);
    }

    private TestData dataForDest(int destId, Object expected) {
        return new TestData(-1, destId, -1, expected);
    }

    private void testEdgeManager(CartesianProductUserPayload.CartesianProductConfigProto conf, String vName, int numTask, String groupName, TestData cDMEInvalid, TestData cDMEValid, TestData srcFailInvalid, TestData srcFailValid, TestData inputError, TestData numDestInput, TestData numSrcOutputTest, TestData numConsumerTest) throws Exception {
        EdgeManagerPluginOnDemand.EventRouteMetadata dme;
        EdgeManagerPluginOnDemand.CompositeEventRouteMetadata cDME;
        Mockito.when((Object)this.mockContext.getSourceVertexName()).thenReturn((Object)vName);
        Mockito.when((Object)this.mockContext.getSourceVertexNumTasks()).thenReturn((Object)numTask);
        Mockito.when((Object)this.mockContext.getVertexGroupName()).thenReturn((Object)groupName);
        this.edgeManager.initialize(conf);
        if (cDMEInvalid != null) {
            cDME = this.edgeManager.routeCompositeDataMovementEventToDestination(cDMEInvalid.srcId, cDMEInvalid.destId);
            Assert.assertNull((Object)cDME);
        }
        cDME = this.edgeManager.routeCompositeDataMovementEventToDestination(cDMEValid.srcId, cDMEValid.destId);
        Assert.assertNotNull((Object)cDME);
        EdgeManagerPluginOnDemand.CompositeEventRouteMetadata expectedCDME = (EdgeManagerPluginOnDemand.CompositeEventRouteMetadata)cDMEValid.expected;
        Assert.assertEquals((long)expectedCDME.getCount(), (long)cDME.getCount());
        Assert.assertEquals((long)expectedCDME.getTarget(), (long)cDME.getTarget());
        Assert.assertEquals((long)expectedCDME.getSource(), (long)cDME.getSource());
        if (srcFailInvalid != null) {
            dme = this.edgeManager.routeInputSourceTaskFailedEventToDestination(srcFailInvalid.srcId, srcFailInvalid.destId);
            Assert.assertNull((Object)dme);
        }
        dme = this.edgeManager.routeInputSourceTaskFailedEventToDestination(srcFailValid.srcId, srcFailValid.destId);
        Assert.assertNotNull((Object)dme);
        EdgeManagerPluginOnDemand.EventRouteMetadata expectedDME = (EdgeManagerPluginOnDemand.EventRouteMetadata)srcFailValid.expected;
        Assert.assertEquals((long)expectedDME.getNumEvents(), (long)dme.getNumEvents());
        Assert.assertArrayEquals((int[])expectedDME.getTargetIndices(), (int[])dme.getTargetIndices());
        Assert.assertEquals((Object)inputError.expected, (Object)this.edgeManager.routeInputErrorEventToSource(inputError.destId, inputError.inputId));
        Assert.assertEquals((Object)numDestInput.expected, (Object)this.edgeManager.getNumDestinationTaskPhysicalInputs(numDestInput.destId));
        Assert.assertEquals((Object)numSrcOutputTest.expected, (Object)this.edgeManager.getNumSourceTaskPhysicalOutputs(numSrcOutputTest.srcId));
        Assert.assertEquals((Object)numConsumerTest.expected, (Object)this.edgeManager.getNumDestinationConsumerTasks(numConsumerTest.srcId));
    }

    @Test(timeout=5000L)
    public void testTwoWayAllVertex() throws Exception {
        CartesianProductUserPayload.CartesianProductConfigProto.Builder builder = CartesianProductUserPayload.CartesianProductConfigProto.newBuilder();
        builder.setIsPartitioned(false).addSources("v0").addSources("v1").addNumChunks(2).addNumChunks(3).setMaxParallelism(10).setNumPartitionsForFairCase(10);
        CartesianProductUserPayload.CartesianProductConfigProto config = builder.build();
        this.testEdgeManager(config, "v0", 2, null, this.dataForRouting(1, 1, null), this.dataForRouting(1, 3, EdgeManagerPluginOnDemand.CompositeEventRouteMetadata.create((int)10, (int)0, (int)0)), this.dataForRouting(1, 1, null), this.dataForRouting(1, 3, EdgeManagerPluginOnDemand.EventRouteMetadata.create((int)10, (int[])new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9})), this.dataForInputError(1, 0, 0), this.dataForDest(1, 10), this.dataForSrc(1, 10), this.dataForSrc(1, 3));
        this.testEdgeManager(config, "v1", 30, null, this.dataForRouting(1, 2, null), this.dataForRouting(1, 0, EdgeManagerPluginOnDemand.CompositeEventRouteMetadata.create((int)10, (int)10, (int)0)), this.dataForRouting(1, 2, null), this.dataForRouting(1, 0, EdgeManagerPluginOnDemand.EventRouteMetadata.create((int)10, (int[])new int[]{10, 11, 12, 13, 14, 15, 16, 17, 18, 19})), this.dataForInputError(1, 0, 10), this.dataForDest(1, 100), this.dataForSrc(1, 10), this.dataForSrc(1, 2));
    }

    @Test(timeout=5000L)
    public void testThreeWayAllVertex() throws Exception {
        CartesianProductUserPayload.CartesianProductConfigProto.Builder builder = CartesianProductUserPayload.CartesianProductConfigProto.newBuilder();
        builder.setIsPartitioned(false).addSources("v0").addSources("v1").addSources("v2").addNumChunks(2).addNumChunks(3).addNumChunks(4).setMaxParallelism(12).setNumPartitionsForFairCase(12);
        CartesianProductUserPayload.CartesianProductConfigProto config = builder.build();
        this.testEdgeManager(config, "v0", 2, null, this.dataForRouting(1, 1, null), this.dataForRouting(1, 12, EdgeManagerPluginOnDemand.CompositeEventRouteMetadata.create((int)12, (int)0, (int)0)), this.dataForRouting(1, 1, null), this.dataForRouting(1, 12, EdgeManagerPluginOnDemand.EventRouteMetadata.create((int)12, (int[])new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11})), this.dataForInputError(1, 0, 0), this.dataForDest(1, 12), this.dataForSrc(1, 12), this.dataForSrc(1, 12));
        this.testEdgeManager(config, "v1", 30, null, this.dataForRouting(1, 4, null), this.dataForRouting(1, 13, EdgeManagerPluginOnDemand.CompositeEventRouteMetadata.create((int)12, (int)12, (int)0)), this.dataForRouting(1, 4, null), this.dataForRouting(1, 13, EdgeManagerPluginOnDemand.EventRouteMetadata.create((int)12, (int[])new int[]{12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23})), this.dataForInputError(1, 0, 0), this.dataForDest(1, 120), this.dataForSrc(1, 12), this.dataForSrc(1, 8));
        this.testEdgeManager(config, "v2", 1, null, null, this.dataForRouting(0, 13, EdgeManagerPluginOnDemand.CompositeEventRouteMetadata.create((int)3, (int)0, (int)3)), null, this.dataForRouting(0, 13, EdgeManagerPluginOnDemand.EventRouteMetadata.create((int)3, (int[])new int[]{0, 1, 2})), this.dataForInputError(1, 0, 0), this.dataForDest(1, 3), this.dataForSrc(0, 12), this.dataForSrc(0, 24));
    }

    @Test(timeout=5000L)
    public void testTwoWayVertexWithVertexGroup() throws Exception {
        CartesianProductUserPayload.CartesianProductConfigProto.Builder builder = CartesianProductUserPayload.CartesianProductConfigProto.newBuilder();
        builder.setIsPartitioned(false).addSources("v0").addSources("g0").addNumChunks(2).addNumChunks(3).setPositionInGroup(10).setNumPartitionsForFairCase(10).addNumTaskPerVertexInGroup(10).addNumTaskPerVertexInGroup(20).setPositionInGroup(0);
        this.testEdgeManager(builder.build(), "v1", 10, "g0", this.dataForRouting(0, 4, null), this.dataForRouting(0, 3, EdgeManagerPluginOnDemand.CompositeEventRouteMetadata.create((int)10, (int)0, (int)0)), this.dataForRouting(0, 4, null), this.dataForRouting(0, 3, EdgeManagerPluginOnDemand.EventRouteMetadata.create((int)10, (int[])new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9})), this.dataForInputError(3, 0, 0), this.dataForDest(2, 34), this.dataForSrc(0, 10), this.dataForSrc(0, 2));
        builder.setPositionInGroup(1);
        this.testEdgeManager(builder.build(), "v2", 20, "g0", this.dataForRouting(1, 1, null), this.dataForRouting(6, 1, EdgeManagerPluginOnDemand.CompositeEventRouteMetadata.create((int)4, (int)33, (int)6)), this.dataForRouting(1, 1, null), this.dataForRouting(6, 1, EdgeManagerPluginOnDemand.EventRouteMetadata.create((int)4, (int[])new int[]{33, 34, 35, 36})), this.dataForInputError(1, 33, 6), this.dataForDest(0, 66), this.dataForSrc(1, 10), this.dataForSrc(6, 4));
    }

    @Test(timeout=5000L)
    public void testTwoWayAllVertexGroup() throws Exception {
        CartesianProductUserPayload.CartesianProductConfigProto.Builder builder = CartesianProductUserPayload.CartesianProductConfigProto.newBuilder();
        builder.setIsPartitioned(false).addSources("g0").addSources("g1").addNumChunks(2).addNumChunks(3).setMaxParallelism(10).setNumPartitionsForFairCase(10).addNumTaskPerVertexInGroup(2).addNumTaskPerVertexInGroup(5).setPositionInGroup(0);
        this.testEdgeManager(builder.build(), "v0", 2, "g0", this.dataForRouting(1, 1, null), this.dataForRouting(0, 1, EdgeManagerPluginOnDemand.CompositeEventRouteMetadata.create((int)10, (int)0, (int)0)), this.dataForRouting(1, 1, null), this.dataForRouting(0, 1, EdgeManagerPluginOnDemand.EventRouteMetadata.create((int)10, (int[])new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9})), this.dataForInputError(1, 0, 0), this.dataForDest(1, 10), this.dataForSrc(1, 10), this.dataForSrc(1, 3));
        builder.setPositionInGroup(1);
        this.testEdgeManager(builder.build(), "v1", 5, "g0", this.dataForRouting(3, 1, null), this.dataForRouting(1, 1, EdgeManagerPluginOnDemand.CompositeEventRouteMetadata.create((int)10, (int)20, (int)0)), this.dataForRouting(3, 1, null), this.dataForRouting(1, 1, EdgeManagerPluginOnDemand.EventRouteMetadata.create((int)10, (int[])new int[]{20, 21, 22, 23, 24, 25, 26, 27, 28, 29})), this.dataForInputError(1, 15, 0), this.dataForDest(1, 25), this.dataForSrc(1, 10), this.dataForSrc(1, 3));
    }

    @Test(timeout=5000L)
    public void testNumPartition() throws Exception {
        Mockito.when((Object)this.mockContext.getSourceVertexName()).thenReturn((Object)"source");
        Mockito.when((Object)this.mockContext.getSourceVertexNumTasks()).thenReturn((Object)10);
        Mockito.when((Object)this.mockContext.getVertexGroupName()).thenReturn(null);
        CartesianProductUserPayload.CartesianProductConfigProto.Builder builder = CartesianProductUserPayload.CartesianProductConfigProto.newBuilder();
        builder.setIsPartitioned(false).addSources("v0").addSources("v1").setMaxParallelism(100);
        this.edgeManager.initialize(builder.build());
        Assert.assertEquals((long)10L, (long)this.edgeManager.getNumSourceTaskPhysicalOutputs(0));
        builder.setNumPartitionsForFairCase(20);
        this.edgeManager = new FairCartesianProductEdgeManager(this.mockContext);
        this.edgeManager.initialize(builder.build());
        Assert.assertEquals((long)20L, (long)this.edgeManager.getNumSourceTaskPhysicalOutputs(0));
    }

    static class TestData {
        int srcId;
        int destId;
        int inputId;
        Object expected;

        public TestData(int srcId, int destId, int inputId, Object expected) {
            this.srcId = srcId;
            this.destId = destId;
            this.inputId = inputId;
            this.expected = expected;
        }
    }
}

