/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.runtime.library.cartesianproduct;

import com.google.protobuf.ByteString;
import java.nio.ByteBuffer;
import java.util.Map;
import org.apache.tez.dag.api.EdgeManagerPluginContext;
import org.apache.tez.dag.api.EdgeManagerPluginOnDemand;
import org.apache.tez.dag.api.UserPayload;
import org.apache.tez.runtime.library.cartesianproduct.CartesianProductEdgeManagerPartitioned;
import org.apache.tez.runtime.library.cartesianproduct.CartesianProductFilter;
import org.apache.tez.runtime.library.cartesianproduct.CartesianProductUserPayload;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class TestCartesianProductEdgeManagerPartitioned {
    private EdgeManagerPluginContext mockContext;
    private CartesianProductEdgeManagerPartitioned edgeManager;

    @Before
    public void setup() {
        this.mockContext = (EdgeManagerPluginContext)Mockito.mock(EdgeManagerPluginContext.class);
        this.edgeManager = new CartesianProductEdgeManagerPartitioned(this.mockContext);
    }

    @Test(timeout=5000L)
    public void testTwoWay() throws Exception {
        CartesianProductUserPayload.CartesianProductConfigProto.Builder builder = CartesianProductUserPayload.CartesianProductConfigProto.newBuilder();
        builder.setIsPartitioned(true).addSources("v0").addSources("v1").addNumPartitions(3).addNumPartitions(4);
        Mockito.when((Object)this.mockContext.getDestinationVertexNumTasks()).thenReturn((Object)12);
        CartesianProductUserPayload.CartesianProductConfigProto config = builder.build();
        this.testTwoWayV0(config);
        this.testTwoWayV1(config);
    }

    private void testTwoWayV0(CartesianProductUserPayload.CartesianProductConfigProto config) throws Exception {
        Mockito.when((Object)this.mockContext.getSourceVertexName()).thenReturn((Object)"v0");
        Mockito.when((Object)this.mockContext.getSourceVertexNumTasks()).thenReturn((Object)2);
        this.edgeManager.initialize(config);
        EdgeManagerPluginOnDemand.CompositeEventRouteMetadata compositeRoutingData = this.edgeManager.routeCompositeDataMovementEventToDestination(1, 1);
        Assert.assertNotNull((Object)compositeRoutingData);
        Assert.assertEquals((long)1L, (long)compositeRoutingData.getCount());
        Assert.assertEquals((long)0L, (long)compositeRoutingData.getSource());
        Assert.assertEquals((long)1L, (long)compositeRoutingData.getTarget());
        EdgeManagerPluginOnDemand.EventRouteMetadata routingData = this.edgeManager.routeDataMovementEventToDestination(1, 0, 1);
        Assert.assertNotNull((Object)routingData);
        Assert.assertEquals((long)1L, (long)routingData.getNumEvents());
        Assert.assertArrayEquals((int[])new int[]{1}, (int[])routingData.getTargetIndices());
        routingData = this.edgeManager.routeDataMovementEventToDestination(1, 1, 1);
        Assert.assertNull((Object)routingData);
        routingData = this.edgeManager.routeInputSourceTaskFailedEventToDestination(1, 1);
        Assert.assertNotNull((Object)routingData);
        Assert.assertEquals((long)1L, (long)routingData.getNumEvents());
        Assert.assertArrayEquals((int[])new int[]{1}, (int[])routingData.getTargetIndices());
        Assert.assertEquals((long)1L, (long)this.edgeManager.routeInputErrorEventToSource(1, 1));
        Assert.assertEquals((long)12L, (long)this.edgeManager.getNumDestinationConsumerTasks(1));
        Assert.assertEquals((long)2L, (long)this.edgeManager.getNumDestinationTaskPhysicalInputs(10));
        Assert.assertEquals((long)3L, (long)this.edgeManager.getNumSourceTaskPhysicalOutputs(2));
    }

    private void testTwoWayV1(CartesianProductUserPayload.CartesianProductConfigProto config) throws Exception {
        Mockito.when((Object)this.mockContext.getSourceVertexName()).thenReturn((Object)"v1");
        Mockito.when((Object)this.mockContext.getSourceVertexNumTasks()).thenReturn((Object)3);
        this.edgeManager.initialize(config);
        EdgeManagerPluginOnDemand.CompositeEventRouteMetadata compositeRoutingData = this.edgeManager.routeCompositeDataMovementEventToDestination(1, 1);
        Assert.assertNotNull((Object)compositeRoutingData);
        Assert.assertEquals((long)1L, (long)compositeRoutingData.getCount());
        Assert.assertEquals((long)1L, (long)compositeRoutingData.getSource());
        Assert.assertEquals((long)1L, (long)compositeRoutingData.getTarget());
        EdgeManagerPluginOnDemand.EventRouteMetadata routingData = this.edgeManager.routeInputSourceTaskFailedEventToDestination(1, 1);
        Assert.assertNotNull((Object)routingData);
        Assert.assertEquals((long)1L, (long)routingData.getNumEvents());
        Assert.assertArrayEquals((int[])new int[]{1}, (int[])routingData.getTargetIndices());
        Assert.assertEquals((long)2L, (long)this.edgeManager.routeInputErrorEventToSource(1, 2));
        Assert.assertEquals((long)12L, (long)this.edgeManager.getNumDestinationConsumerTasks(1));
        Assert.assertEquals((long)3L, (long)this.edgeManager.getNumDestinationTaskPhysicalInputs(10));
        Assert.assertEquals((long)4L, (long)this.edgeManager.getNumSourceTaskPhysicalOutputs(2));
    }

    @Test(timeout=5000L)
    public void testTwoWayWithFilter() throws Exception {
        CartesianProductUserPayload.CartesianProductConfigProto.Builder builder = CartesianProductUserPayload.CartesianProductConfigProto.newBuilder();
        ByteBuffer buffer = ByteBuffer.allocate(2).putChar('>');
        buffer.flip();
        builder.setIsPartitioned(true).addSources("v0").addSources("v1").addNumPartitions(3).addNumPartitions(4).setFilterClassName(TestFilter.class.getName()).setFilterUserPayload(ByteString.copyFrom((ByteBuffer)buffer));
        CartesianProductUserPayload.CartesianProductConfigProto config = builder.build();
        Mockito.when((Object)this.mockContext.getDestinationVertexNumTasks()).thenReturn((Object)3);
        this.testTwoWayV0WithFilter(config);
        this.testTwoWayV1WithFilter(config);
    }

    private void testTwoWayV0WithFilter(CartesianProductUserPayload.CartesianProductConfigProto config) throws Exception {
        Mockito.when((Object)this.mockContext.getSourceVertexName()).thenReturn((Object)"v0");
        Mockito.when((Object)this.mockContext.getSourceVertexNumTasks()).thenReturn((Object)2);
        this.edgeManager.initialize(config);
        EdgeManagerPluginOnDemand.CompositeEventRouteMetadata compositeRoutingData = this.edgeManager.routeCompositeDataMovementEventToDestination(1, 1);
        Assert.assertNotNull((Object)compositeRoutingData);
        Assert.assertEquals((long)1L, (long)compositeRoutingData.getCount());
        Assert.assertEquals((long)2L, (long)compositeRoutingData.getSource());
        Assert.assertEquals((long)1L, (long)compositeRoutingData.getTarget());
        EdgeManagerPluginOnDemand.EventRouteMetadata routingData = this.edgeManager.routeInputSourceTaskFailedEventToDestination(1, 1);
        Assert.assertNotNull((Object)routingData);
        Assert.assertEquals((long)1L, (long)routingData.getNumEvents());
        Assert.assertArrayEquals((int[])new int[]{1}, (int[])routingData.getTargetIndices());
        Assert.assertEquals((long)1L, (long)this.edgeManager.routeInputErrorEventToSource(1, 1));
        Assert.assertEquals((long)3L, (long)this.edgeManager.getNumDestinationConsumerTasks(1));
        Assert.assertEquals((long)2L, (long)this.edgeManager.getNumDestinationTaskPhysicalInputs(1));
        Assert.assertEquals((long)3L, (long)this.edgeManager.getNumSourceTaskPhysicalOutputs(2));
    }

    private void testTwoWayV1WithFilter(CartesianProductUserPayload.CartesianProductConfigProto config) throws Exception {
        Mockito.when((Object)this.mockContext.getSourceVertexName()).thenReturn((Object)"v1");
        Mockito.when((Object)this.mockContext.getSourceVertexNumTasks()).thenReturn((Object)3);
        this.edgeManager.initialize(config);
        EdgeManagerPluginOnDemand.CompositeEventRouteMetadata compositeRoutingData = this.edgeManager.routeCompositeDataMovementEventToDestination(1, 1);
        Assert.assertNotNull((Object)compositeRoutingData);
        Assert.assertEquals((long)1L, (long)compositeRoutingData.getCount());
        Assert.assertEquals((long)0L, (long)compositeRoutingData.getSource());
        Assert.assertEquals((long)1L, (long)compositeRoutingData.getTarget());
        EdgeManagerPluginOnDemand.EventRouteMetadata routingData = this.edgeManager.routeInputSourceTaskFailedEventToDestination(1, 1);
        Assert.assertNotNull((Object)routingData);
        Assert.assertEquals((long)1L, (long)routingData.getNumEvents());
        Assert.assertArrayEquals((int[])new int[]{1}, (int[])routingData.getTargetIndices());
        Assert.assertEquals((long)2L, (long)this.edgeManager.routeInputErrorEventToSource(1, 2));
        Assert.assertEquals((long)3L, (long)this.edgeManager.getNumDestinationConsumerTasks(1));
        Assert.assertEquals((long)3L, (long)this.edgeManager.getNumDestinationTaskPhysicalInputs(10));
        Assert.assertEquals((long)4L, (long)this.edgeManager.getNumSourceTaskPhysicalOutputs(2));
    }

    @Test(timeout=5000L)
    public void testThreeWay() throws Exception {
        CartesianProductUserPayload.CartesianProductConfigProto.Builder builder = CartesianProductUserPayload.CartesianProductConfigProto.newBuilder();
        builder.setIsPartitioned(true).addSources("v0").addSources("v1").addSources("v2").addNumPartitions(4).addNumPartitions(3).addNumPartitions(2);
        CartesianProductUserPayload.CartesianProductConfigProto config = builder.build();
        Mockito.when((Object)this.mockContext.getDestinationVertexNumTasks()).thenReturn((Object)24);
        this.testThreeWayV0(config);
        this.testThreeWayV1(config);
        this.testThreeWayV2(config);
    }

    private void testThreeWayV0(CartesianProductUserPayload.CartesianProductConfigProto config) throws Exception {
        Mockito.when((Object)this.mockContext.getSourceVertexName()).thenReturn((Object)"v0");
        Mockito.when((Object)this.mockContext.getSourceVertexNumTasks()).thenReturn((Object)2);
        this.edgeManager.initialize(config);
        EdgeManagerPluginOnDemand.CompositeEventRouteMetadata compositeRoutingData = this.edgeManager.routeCompositeDataMovementEventToDestination(1, 1);
        Assert.assertNotNull((Object)compositeRoutingData);
        Assert.assertEquals((long)1L, (long)compositeRoutingData.getCount());
        Assert.assertEquals((long)0L, (long)compositeRoutingData.getSource());
        Assert.assertEquals((long)1L, (long)compositeRoutingData.getTarget());
        EdgeManagerPluginOnDemand.EventRouteMetadata routingData = this.edgeManager.routeInputSourceTaskFailedEventToDestination(1, 1);
        Assert.assertNotNull((Object)routingData);
        Assert.assertEquals((long)1L, (long)routingData.getNumEvents());
        Assert.assertArrayEquals((int[])new int[]{1}, (int[])routingData.getTargetIndices());
        Assert.assertEquals((long)1L, (long)this.edgeManager.routeInputErrorEventToSource(1, 1));
        Assert.assertEquals((long)24L, (long)this.edgeManager.getNumDestinationConsumerTasks(1));
        Assert.assertEquals((long)2L, (long)this.edgeManager.getNumDestinationTaskPhysicalInputs(10));
        Assert.assertEquals((long)4L, (long)this.edgeManager.getNumSourceTaskPhysicalOutputs(2));
    }

    private void testThreeWayV1(CartesianProductUserPayload.CartesianProductConfigProto config) throws Exception {
        Mockito.when((Object)this.mockContext.getSourceVertexName()).thenReturn((Object)"v1");
        Mockito.when((Object)this.mockContext.getSourceVertexNumTasks()).thenReturn((Object)3);
        this.edgeManager.initialize(config);
        EdgeManagerPluginOnDemand.CompositeEventRouteMetadata compositeRoutingData = this.edgeManager.routeCompositeDataMovementEventToDestination(1, 1);
        Assert.assertNotNull((Object)compositeRoutingData);
        Assert.assertEquals((long)1L, (long)compositeRoutingData.getCount());
        Assert.assertEquals((long)0L, (long)compositeRoutingData.getSource());
        Assert.assertEquals((long)1L, (long)compositeRoutingData.getTarget());
        EdgeManagerPluginOnDemand.EventRouteMetadata routingData = this.edgeManager.routeInputSourceTaskFailedEventToDestination(1, 1);
        Assert.assertNotNull((Object)routingData);
        Assert.assertEquals((long)1L, (long)routingData.getNumEvents());
        Assert.assertArrayEquals((int[])new int[]{1}, (int[])routingData.getTargetIndices());
        Assert.assertEquals((long)2L, (long)this.edgeManager.routeInputErrorEventToSource(1, 2));
        Assert.assertEquals((long)24L, (long)this.edgeManager.getNumDestinationConsumerTasks(1));
        Assert.assertEquals((long)3L, (long)this.edgeManager.getNumDestinationTaskPhysicalInputs(10));
        Assert.assertEquals((long)3L, (long)this.edgeManager.getNumSourceTaskPhysicalOutputs(2));
    }

    private void testThreeWayV2(CartesianProductUserPayload.CartesianProductConfigProto config) throws Exception {
        Mockito.when((Object)this.mockContext.getSourceVertexName()).thenReturn((Object)"v2");
        Mockito.when((Object)this.mockContext.getSourceVertexNumTasks()).thenReturn((Object)4);
        this.edgeManager.initialize(config);
        EdgeManagerPluginOnDemand.CompositeEventRouteMetadata compositeRoutingData = this.edgeManager.routeCompositeDataMovementEventToDestination(1, 1);
        Assert.assertNotNull((Object)compositeRoutingData);
        Assert.assertEquals((long)1L, (long)compositeRoutingData.getCount());
        Assert.assertEquals((long)1L, (long)compositeRoutingData.getSource());
        Assert.assertEquals((long)1L, (long)compositeRoutingData.getTarget());
        EdgeManagerPluginOnDemand.EventRouteMetadata routingData = this.edgeManager.routeInputSourceTaskFailedEventToDestination(1, 1);
        Assert.assertNotNull((Object)routingData);
        Assert.assertEquals((long)1L, (long)routingData.getNumEvents());
        Assert.assertArrayEquals((int[])new int[]{1}, (int[])routingData.getTargetIndices());
        Assert.assertEquals((long)2L, (long)this.edgeManager.routeInputErrorEventToSource(1, 2));
        Assert.assertEquals((long)24L, (long)this.edgeManager.getNumDestinationConsumerTasks(1));
        Assert.assertEquals((long)4L, (long)this.edgeManager.getNumDestinationTaskPhysicalInputs(10));
        Assert.assertEquals((long)2L, (long)this.edgeManager.getNumSourceTaskPhysicalOutputs(2));
    }

    public static class TestFilter
    extends CartesianProductFilter {
        char op;

        public TestFilter(UserPayload payload) {
            super(payload);
            this.op = payload.getPayload().getChar();
        }

        public boolean isValidCombination(Map<String, Integer> vertexPartitionMap) {
            switch (this.op) {
                case '>': {
                    return vertexPartitionMap.get("v0") > vertexPartitionMap.get("v1");
                }
                case '<': {
                    return vertexPartitionMap.get("v0") < vertexPartitionMap.get("v1");
                }
            }
            return true;
        }
    }
}

