/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.runtime.library.common.shuffle.orderedgrouped;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Comparator;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.FileChunk;
import org.apache.tez.runtime.library.common.InputAttemptIdentifier;
import org.apache.tez.runtime.library.common.shuffle.orderedgrouped.FetchedInputAllocatorOrderedGrouped;
import org.apache.tez.runtime.library.common.task.local.output.TezTaskOutputFiles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class MapOutput {
    private static final Logger LOG = LoggerFactory.getLogger(MapOutput.class);
    private static AtomicInteger ID = new AtomicInteger(0);
    private final int id = ID.incrementAndGet();
    private InputAttemptIdentifier attemptIdentifier;
    private final boolean primaryMapOutput;
    protected final FetchedInputAllocatorOrderedGrouped callback;

    private MapOutput(InputAttemptIdentifier attemptIdentifier, FetchedInputAllocatorOrderedGrouped callback, boolean primaryMapOutput) {
        this.attemptIdentifier = attemptIdentifier;
        this.callback = callback;
        this.primaryMapOutput = primaryMapOutput;
    }

    public static MapOutput createDiskMapOutput(InputAttemptIdentifier attemptIdentifier, FetchedInputAllocatorOrderedGrouped callback, long size, Configuration conf, int fetcher, boolean primaryMapOutput, TezTaskOutputFiles mapOutputFile) throws IOException {
        FileSystem fs = FileSystem.getLocal((Configuration)conf).getRaw();
        Path outputPath = mapOutputFile.getInputFileForWrite(attemptIdentifier.getInputIdentifier(), attemptIdentifier.getSpillEventId(), size);
        Path tmpOutputPath = outputPath.suffix(String.valueOf(fetcher));
        long offset = 0L;
        DiskMapOutput mapOutput = new DiskMapOutput(attemptIdentifier, callback, size, outputPath, offset, primaryMapOutput, tmpOutputPath);
        mapOutput.disk = fs.create(tmpOutputPath);
        return mapOutput;
    }

    public static MapOutput createLocalDiskMapOutput(InputAttemptIdentifier attemptIdentifier, FetchedInputAllocatorOrderedGrouped callback, Path path, long offset, long size, boolean primaryMapOutput) {
        return new DiskDirectMapOutput(attemptIdentifier, callback, size, path, offset, primaryMapOutput);
    }

    public static MapOutput createMemoryMapOutput(InputAttemptIdentifier attemptIdentifier, FetchedInputAllocatorOrderedGrouped callback, int size, boolean primaryMapOutput) {
        return new InMemoryMapOutput(attemptIdentifier, callback, size, primaryMapOutput);
    }

    public static MapOutput createWaitMapOutput(InputAttemptIdentifier attemptIdentifier) {
        return new WaitMapOutput(attemptIdentifier);
    }

    public boolean isPrimaryMapOutput() {
        return this.primaryMapOutput;
    }

    public boolean equals(Object obj) {
        if (obj instanceof MapOutput) {
            return this.id == ((MapOutput)obj).id;
        }
        return false;
    }

    public int hashCode() {
        return this.id;
    }

    public FileChunk getOutputPath() {
        return null;
    }

    public byte[] getMemory() {
        return null;
    }

    public OutputStream getDisk() {
        return null;
    }

    public InputAttemptIdentifier getAttemptIdentifier() {
        return this.attemptIdentifier;
    }

    public abstract Type getType();

    public long getSize() {
        return -1L;
    }

    public void commit() throws IOException {
    }

    public void abort() {
    }

    public String toString() {
        return "MapOutput( AttemptIdentifier: " + this.attemptIdentifier + ", Type: " + this.getType() + ")";
    }

    private static class WaitMapOutput
    extends MapOutput {
        private WaitMapOutput(InputAttemptIdentifier attemptIdentifier) {
            super(attemptIdentifier, null, false);
        }

        @Override
        public void commit() throws IOException {
            throw new IOException("Cannot commit MapOutput of type WAIT!");
        }

        @Override
        public void abort() {
            throw new IllegalArgumentException("Cannot commit MapOutput of type WAIT!");
        }

        @Override
        public Type getType() {
            return Type.WAIT;
        }
    }

    private static class InMemoryMapOutput
    extends MapOutput {
        private byte[] byteArray;

        private InMemoryMapOutput(InputAttemptIdentifier attemptIdentifier, FetchedInputAllocatorOrderedGrouped callback, long size, boolean primaryMapOutput) {
            super(attemptIdentifier, callback, primaryMapOutput);
            this.byteArray = new byte[(int)size];
        }

        @Override
        public byte[] getMemory() {
            return this.byteArray;
        }

        @Override
        public long getSize() {
            return this.byteArray.length;
        }

        @Override
        public void commit() throws IOException {
            this.callback.closeInMemoryFile(this);
        }

        @Override
        public void abort() {
            this.callback.unreserve(this.byteArray.length);
        }

        @Override
        public Type getType() {
            return Type.MEMORY;
        }
    }

    private static class DiskMapOutput
    extends MapOutput {
        private final Path tmpOutputPath;
        private final FileChunk outputPath;
        private OutputStream disk;

        private DiskMapOutput(InputAttemptIdentifier attemptIdentifier, FetchedInputAllocatorOrderedGrouped callback, long size, Path outputPath, long offset, boolean primaryMapOutput, Path tmpOutputPath) {
            super(attemptIdentifier, callback, primaryMapOutput);
            this.tmpOutputPath = tmpOutputPath;
            this.disk = null;
            this.outputPath = new FileChunk(outputPath, offset, size, false, attemptIdentifier);
        }

        @Override
        public FileChunk getOutputPath() {
            return this.outputPath;
        }

        @Override
        public OutputStream getDisk() {
            return this.disk;
        }

        @Override
        public long getSize() {
            return this.outputPath.getLength();
        }

        @Override
        public void commit() throws IOException {
            this.callback.getLocalFileSystem().rename(this.tmpOutputPath, this.outputPath.getPath());
            this.callback.closeOnDiskFile(this.outputPath);
        }

        @Override
        public void abort() {
            try {
                this.callback.getLocalFileSystem().delete(this.tmpOutputPath, true);
            }
            catch (IOException ie) {
                LOG.info("failure to clean up " + this.tmpOutputPath, (Throwable)ie);
            }
        }

        @Override
        public Type getType() {
            return Type.DISK;
        }
    }

    private static class DiskDirectMapOutput
    extends MapOutput {
        private final FileChunk outputPath;

        private DiskDirectMapOutput(InputAttemptIdentifier attemptIdentifier, FetchedInputAllocatorOrderedGrouped callback, long size, Path outputPath, long offset, boolean primaryMapOutput) {
            super(attemptIdentifier, callback, primaryMapOutput);
            this.outputPath = new FileChunk(outputPath, offset, size, true, attemptIdentifier);
        }

        @Override
        public FileChunk getOutputPath() {
            return this.outputPath;
        }

        @Override
        public long getSize() {
            return this.outputPath.getLength();
        }

        @Override
        public void commit() throws IOException {
            this.callback.closeOnDiskFile(this.outputPath);
        }

        @Override
        public void abort() {
        }

        @Override
        public Type getType() {
            return Type.DISK_DIRECT;
        }
    }

    public static class MapOutputComparator
    implements Comparator<MapOutput> {
        @Override
        public int compare(MapOutput o1, MapOutput o2) {
            if (o1.id == o2.id) {
                return 0;
            }
            if (o1.getSize() < o2.getSize()) {
                return -1;
            }
            if (o1.getSize() > o2.getSize()) {
                return 1;
            }
            if (o1.id < o2.id) {
                return -1;
            }
            return 1;
        }
    }

    public static enum Type {
        WAIT,
        MEMORY,
        DISK,
        DISK_DIRECT;

    }
}

