/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.runtime.library.common.shuffle.impl;

import java.io.File;
import java.io.IOException;
import java.util.UUID;
import org.apache.hadoop.conf.Configuration;
import org.apache.tez.runtime.library.common.InputAttemptIdentifier;
import org.apache.tez.runtime.library.common.shuffle.FetchedInput;
import org.apache.tez.runtime.library.common.shuffle.impl.SimpleFetchedInputAllocator;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestSimpleFetchedInputAllocator {
    private static final Logger LOG = LoggerFactory.getLogger(TestSimpleFetchedInputAllocator.class);

    @Test(timeout=5000L)
    public void testInMemAllocation() throws IOException {
        File localDirs = new File(System.getProperty("test.build.data", "/tmp"), this.getClass().getName());
        Configuration conf = new Configuration();
        long jvmMax = Runtime.getRuntime().maxMemory();
        LOG.info("jvmMax: " + jvmMax);
        float bufferPercent = 0.1f;
        conf.setFloat("tez.runtime.shuffle.fetch.buffer.percent", bufferPercent);
        conf.setFloat("tez.runtime.shuffle.memory.limit.percent", 1.0f);
        conf.setStrings("tez.runtime.framework.local.dirs", new String[]{localDirs.getAbsolutePath()});
        long inMemThreshold = (long)(bufferPercent * (float)jvmMax);
        LOG.info("InMemThreshold: " + inMemThreshold);
        SimpleFetchedInputAllocator inputManager = new SimpleFetchedInputAllocator("srcName", UUID.randomUUID().toString(), 123, conf, Runtime.getRuntime().maxMemory(), inMemThreshold);
        long requestSize = (long)(0.4f * (float)inMemThreshold);
        long compressedSize = 1L;
        LOG.info("RequestSize: " + requestSize);
        FetchedInput fi1 = inputManager.allocate(requestSize, compressedSize, new InputAttemptIdentifier(1, 1));
        Assert.assertEquals((Object)FetchedInput.Type.MEMORY, (Object)fi1.getType());
        FetchedInput fi2 = inputManager.allocate(requestSize, compressedSize, new InputAttemptIdentifier(2, 1));
        Assert.assertEquals((Object)FetchedInput.Type.MEMORY, (Object)fi2.getType());
        FetchedInput fi3 = inputManager.allocate(requestSize, compressedSize, new InputAttemptIdentifier(3, 1));
        Assert.assertEquals((Object)FetchedInput.Type.DISK, (Object)fi3.getType());
        fi1.abort();
        fi1.free();
        FetchedInput fi4 = inputManager.allocate(requestSize, compressedSize, new InputAttemptIdentifier(4, 1));
        Assert.assertEquals((Object)FetchedInput.Type.MEMORY, (Object)fi4.getType());
        fi3.abort();
        fi3.free();
        FetchedInput fi5 = inputManager.allocate(requestSize, compressedSize, new InputAttemptIdentifier(4, 1));
        Assert.assertEquals((Object)FetchedInput.Type.DISK, (Object)fi5.getType());
    }
}

