/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.http;

import com.google.common.base.Throwables;
import java.io.IOException;
import java.net.ConnectException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.channels.ClosedByInterruptException;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import org.apache.tez.common.security.JobTokenSecretManager;
import org.apache.tez.http.BaseHttpConnection;
import org.apache.tez.http.HttpConnection;
import org.apache.tez.http.HttpConnectionParams;
import org.apache.tez.http.async.netty.AsyncHttpConnection;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.Mockito;

public class TestHttpConnection {
    private static int connTimeout = 5000;
    private static int readTimeout = 5000;
    private static final String NOT_HOSTED_URL = "http://240.0.0.1:10221";
    private static ExecutorService executorService;
    private static URL url;
    private static JobTokenSecretManager tokenSecretManager;
    private Thread currentThread;

    @BeforeClass
    public static void setup() throws IOException, URISyntaxException {
        executorService = Executors.newFixedThreadPool(1, new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread t = Executors.defaultThreadFactory().newThread(r);
                t.setDaemon(true);
                return t;
            }
        });
        url = new URL(NOT_HOSTED_URL);
        tokenSecretManager = (JobTokenSecretManager)Mockito.mock(JobTokenSecretManager.class);
        Mockito.when((Object)tokenSecretManager.computeHash((byte[])Mockito.any())).thenReturn((Object)"1234".getBytes());
    }

    @AfterClass
    public static void cleanup() throws Exception {
        executorService.shutdownNow();
    }

    public void baseTest(Callable<Void> worker, CountDownLatch latch, String message) throws InterruptedException {
        long startTime = System.currentTimeMillis();
        try {
            Future<Void> future = executorService.submit(worker);
            future.get();
        }
        catch (ExecutionException e) {
            Assert.assertTrue((boolean)(e.getCause().getCause() instanceof IOException));
            Assert.assertTrue((String)e.getMessage(), (boolean)e.getMessage().contains(message));
            long elapsedTime = System.currentTimeMillis() - startTime;
            Assert.assertTrue((String)("elapasedTime=" + elapsedTime + " should be greater than " + connTimeout), (elapsedTime > (long)connTimeout ? 1 : 0) != 0);
        }
        Assert.assertTrue((latch.getCount() == 0L ? 1 : 0) != 0);
    }

    @Test(timeout=20000L)
    public void testConnectionTimeout() throws IOException, InterruptedException {
        HttpConnectionParams params = this.getConnectionParams();
        CountDownLatch latch = new CountDownLatch(1);
        HttpConnection httpConn = this.getHttpConnection(params);
        this.baseTest(new Worker(latch, (BaseHttpConnection)httpConn, false), latch, "Failed to connect");
        latch = new CountDownLatch(1);
        AsyncHttpConnection asyncHttpConn = this.getAsyncHttpConnection(params);
        this.baseTest(new Worker(latch, (BaseHttpConnection)asyncHttpConn, false), latch, "connection timed out");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=20000L)
    public void testAsyncHttpConnectionInterrupt() throws IOException, InterruptedException, ExecutionException {
        CountDownLatch latch = new CountDownLatch(1);
        HttpConnectionParams params = this.getConnectionParams();
        AsyncHttpConnection asyncHttpConn = this.getAsyncHttpConnection(params);
        Future<Void> future = executorService.submit(new Worker(latch, (BaseHttpConnection)asyncHttpConn, true));
        while (this.currentThread == null) {
            TestHttpConnection testHttpConnection = this;
            synchronized (testHttpConnection) {
                this.wait(100L);
            }
        }
        Assert.assertTrue((String)"currentThread is still null", (this.currentThread != null ? 1 : 0) != 0);
        Thread.sleep(1000L);
        this.currentThread.interrupt();
        future.get();
        Assert.assertTrue((latch.getCount() == 0L ? 1 : 0) != 0);
    }

    HttpConnectionParams getConnectionParams() {
        HttpConnectionParams params = (HttpConnectionParams)Mockito.mock(HttpConnectionParams.class);
        Mockito.when((Object)params.getBufferSize()).thenReturn((Object)8192);
        Mockito.when((Object)params.getKeepAliveMaxConnections()).thenReturn((Object)1);
        Mockito.when((Object)params.getConnectionTimeout()).thenReturn((Object)connTimeout);
        Mockito.when((Object)params.getReadTimeout()).thenReturn((Object)readTimeout);
        return params;
    }

    HttpConnection getHttpConnection(HttpConnectionParams params) throws IOException {
        HttpConnection realConn = new HttpConnection(url, params, "log", tokenSecretManager);
        HttpConnection connection = (HttpConnection)Mockito.spy((Object)realConn);
        realConn.computeEncHash();
        return connection;
    }

    AsyncHttpConnection getAsyncHttpConnection(HttpConnectionParams params) throws IOException {
        AsyncHttpConnection realConn = new AsyncHttpConnection(url, params, "log", tokenSecretManager);
        AsyncHttpConnection connection = (AsyncHttpConnection)Mockito.spy((Object)realConn);
        realConn.computeEncHash();
        return connection;
    }

    class Worker
    implements Callable<Void> {
        private CountDownLatch latch;
        private BaseHttpConnection connection;
        private boolean expectingInterrupt;

        public Worker(CountDownLatch latch, BaseHttpConnection connection, boolean expectingInterrupt) {
            this.latch = latch;
            this.connection = connection;
            this.expectingInterrupt = expectingInterrupt;
        }

        @Override
        public Void call() throws Exception {
            try {
                TestHttpConnection.this.currentThread = Thread.currentThread();
                this.connection.connect();
                Assert.fail();
            }
            catch (Throwable t) {
                if (this.expectingInterrupt) {
                    if (t instanceof ConnectException) {
                        Assert.assertTrue((String)("Expected ClosedByInterruptException, received " + Throwables.getStackTraceAsString((Throwable)t.getCause())), (boolean)(t.getCause() instanceof ClosedByInterruptException));
                    } else {
                        Assert.assertTrue((boolean)(t instanceof InterruptedException));
                    }
                }
            }
            finally {
                this.latch.countDown();
                if (this.connection != null) {
                    this.connection.cleanup(true);
                }
            }
            return null;
        }
    }
}

