/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.library.vertexmanager;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.tez.dag.api.EdgeProperty;
import org.apache.tez.dag.api.InputDescriptor;
import org.apache.tez.dag.api.OutputDescriptor;
import org.apache.tez.dag.api.TezUncheckedException;
import org.apache.tez.dag.api.VertexLocationHint;
import org.apache.tez.dag.api.VertexManagerPluginContext;
import org.apache.tez.dag.api.event.VertexState;
import org.apache.tez.dag.api.event.VertexStateUpdate;
import org.apache.tez.dag.library.vertexmanager.InputReadyVertexManager;
import org.apache.tez.dag.library.vertexmanager.TestShuffleVertexManager;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;

public class TestInputReadyVertexManager {
    @Captor
    ArgumentCaptor<List<VertexManagerPluginContext.ScheduleTaskRequest>> requestCaptor;

    @Before
    public void init() {
        MockitoAnnotations.initMocks((Object)this);
    }

    @Test(timeout=5000L)
    public void testBasicScatterGather() throws Exception {
        HashMap<String, EdgeProperty> mockInputVertices = new HashMap<String, EdgeProperty>();
        String mockSrcVertexId1 = "Vertex1";
        EdgeProperty eProp1 = EdgeProperty.create((EdgeProperty.DataMovementType)EdgeProperty.DataMovementType.SCATTER_GATHER, (EdgeProperty.DataSourceType)EdgeProperty.DataSourceType.PERSISTED, (EdgeProperty.SchedulingType)EdgeProperty.SchedulingType.SEQUENTIAL, (OutputDescriptor)OutputDescriptor.create((String)"out"), (InputDescriptor)InputDescriptor.create((String)"in"));
        String mockManagedVertexId = "Vertex";
        VertexManagerPluginContext mockContext = (VertexManagerPluginContext)Mockito.mock(VertexManagerPluginContext.class);
        Mockito.when((Object)mockContext.getInputVertexEdgeProperties()).thenReturn(mockInputVertices);
        Mockito.when((Object)mockContext.getVertexName()).thenReturn((Object)mockManagedVertexId);
        Mockito.when((Object)mockContext.getVertexNumTasks(mockManagedVertexId)).thenReturn((Object)2);
        Mockito.when((Object)mockContext.getVertexNumTasks(mockSrcVertexId1)).thenReturn((Object)3);
        mockInputVertices.put(mockSrcVertexId1, eProp1);
        InputReadyVertexManager manager = new InputReadyVertexManager(mockContext);
        manager.initialize();
        ((VertexManagerPluginContext)Mockito.verify((Object)mockContext, (VerificationMode)Mockito.times((int)1))).vertexReconfigurationPlanned();
        manager.onVertexStateUpdated(new VertexStateUpdate(mockSrcVertexId1, VertexState.CONFIGURED));
        ((VertexManagerPluginContext)Mockito.verify((Object)mockContext, (VerificationMode)Mockito.times((int)1))).doneReconfiguringVertex();
        ((VertexManagerPluginContext)Mockito.verify((Object)mockContext, (VerificationMode)Mockito.times((int)0))).scheduleTasks((List)this.requestCaptor.capture());
        manager.onVertexStarted(Collections.singletonList(TestShuffleVertexManager.createTaskAttemptIdentifier(mockSrcVertexId1, 0)));
        manager.onSourceTaskCompleted(TestShuffleVertexManager.createTaskAttemptIdentifier(mockSrcVertexId1, 1));
        ((VertexManagerPluginContext)Mockito.verify((Object)mockContext, (VerificationMode)Mockito.times((int)0))).scheduleTasks(Mockito.anyList());
        manager.onSourceTaskCompleted(TestShuffleVertexManager.createTaskAttemptIdentifier(mockSrcVertexId1, 2));
        ((VertexManagerPluginContext)Mockito.verify((Object)mockContext, (VerificationMode)Mockito.times((int)1))).scheduleTasks((List)this.requestCaptor.capture());
        Assert.assertEquals((long)2L, (long)((List)this.requestCaptor.getValue()).size());
    }

    @Test(timeout=5000L)
    public void testBasicOneToOne() throws Exception {
        HashMap<String, EdgeProperty> mockInputVertices = new HashMap<String, EdgeProperty>();
        String mockSrcVertexId1 = "Vertex1";
        EdgeProperty eProp1 = EdgeProperty.create((EdgeProperty.DataMovementType)EdgeProperty.DataMovementType.ONE_TO_ONE, (EdgeProperty.DataSourceType)EdgeProperty.DataSourceType.PERSISTED, (EdgeProperty.SchedulingType)EdgeProperty.SchedulingType.SEQUENTIAL, (OutputDescriptor)OutputDescriptor.create((String)"out"), (InputDescriptor)InputDescriptor.create((String)"in"));
        String mockManagedVertexId = "Vertex";
        VertexManagerPluginContext mockContext = (VertexManagerPluginContext)Mockito.mock(VertexManagerPluginContext.class);
        Mockito.when((Object)mockContext.getInputVertexEdgeProperties()).thenReturn(mockInputVertices);
        Mockito.when((Object)mockContext.getVertexName()).thenReturn((Object)mockManagedVertexId);
        Mockito.when((Object)mockContext.getVertexNumTasks(mockManagedVertexId)).thenReturn((Object)3);
        Mockito.when((Object)mockContext.getVertexNumTasks(mockSrcVertexId1)).thenReturn((Object)3);
        mockInputVertices.put(mockSrcVertexId1, eProp1);
        InputReadyVertexManager manager = new InputReadyVertexManager(mockContext);
        manager.initialize();
        ((VertexManagerPluginContext)Mockito.verify((Object)mockContext, (VerificationMode)Mockito.times((int)1))).vertexReconfigurationPlanned();
        manager.onVertexStateUpdated(new VertexStateUpdate(mockSrcVertexId1, VertexState.CONFIGURED));
        ((VertexManagerPluginContext)Mockito.verify((Object)mockContext, (VerificationMode)Mockito.times((int)1))).doneReconfiguringVertex();
        ((VertexManagerPluginContext)Mockito.verify((Object)mockContext, (VerificationMode)Mockito.times((int)0))).scheduleTasks((List)this.requestCaptor.capture());
        manager.onVertexStarted(Collections.singletonList(TestShuffleVertexManager.createTaskAttemptIdentifier(mockSrcVertexId1, 0)));
        ((VertexManagerPluginContext)Mockito.verify((Object)mockContext, (VerificationMode)Mockito.times((int)1))).scheduleTasks((List)this.requestCaptor.capture());
        Assert.assertEquals((long)1L, (long)((List)this.requestCaptor.getValue()).size());
        Assert.assertEquals((long)0L, (long)((VertexManagerPluginContext.ScheduleTaskRequest)((List)this.requestCaptor.getValue()).get(0)).getTaskIndex());
        Assert.assertEquals((Object)mockSrcVertexId1, (Object)((VertexManagerPluginContext.ScheduleTaskRequest)((List)this.requestCaptor.getValue()).get(0)).getTaskLocationHint().getAffinitizedTask().getVertexName());
        Assert.assertEquals((long)0L, (long)((VertexManagerPluginContext.ScheduleTaskRequest)((List)this.requestCaptor.getValue()).get(0)).getTaskLocationHint().getAffinitizedTask().getTaskIndex());
        manager.onSourceTaskCompleted(TestShuffleVertexManager.createTaskAttemptIdentifier(mockSrcVertexId1, 1));
        ((VertexManagerPluginContext)Mockito.verify((Object)mockContext, (VerificationMode)Mockito.times((int)2))).scheduleTasks((List)this.requestCaptor.capture());
        Assert.assertEquals((long)1L, (long)((List)this.requestCaptor.getValue()).size());
        Assert.assertEquals((long)1L, (long)((VertexManagerPluginContext.ScheduleTaskRequest)((List)this.requestCaptor.getValue()).get(0)).getTaskIndex());
        Assert.assertEquals((Object)mockSrcVertexId1, (Object)((VertexManagerPluginContext.ScheduleTaskRequest)((List)this.requestCaptor.getValue()).get(0)).getTaskLocationHint().getAffinitizedTask().getVertexName());
        Assert.assertEquals((long)1L, (long)((VertexManagerPluginContext.ScheduleTaskRequest)((List)this.requestCaptor.getValue()).get(0)).getTaskLocationHint().getAffinitizedTask().getTaskIndex());
        manager.onSourceTaskCompleted(TestShuffleVertexManager.createTaskAttemptIdentifier(mockSrcVertexId1, 2));
        ((VertexManagerPluginContext)Mockito.verify((Object)mockContext, (VerificationMode)Mockito.times((int)3))).scheduleTasks((List)this.requestCaptor.capture());
        Assert.assertEquals((long)1L, (long)((List)this.requestCaptor.getValue()).size());
        Assert.assertEquals((long)2L, (long)((VertexManagerPluginContext.ScheduleTaskRequest)((List)this.requestCaptor.getValue()).get(0)).getTaskIndex());
        Assert.assertEquals((Object)mockSrcVertexId1, (Object)((VertexManagerPluginContext.ScheduleTaskRequest)((List)this.requestCaptor.getValue()).get(0)).getTaskLocationHint().getAffinitizedTask().getVertexName());
        Assert.assertEquals((long)2L, (long)((VertexManagerPluginContext.ScheduleTaskRequest)((List)this.requestCaptor.getValue()).get(0)).getTaskLocationHint().getAffinitizedTask().getTaskIndex());
    }

    @Test(timeout=5000L)
    public void testDelayedConfigureOneToOne() throws Exception {
        HashMap<String, EdgeProperty> mockInputVertices = new HashMap<String, EdgeProperty>();
        String mockSrcVertexId1 = "Vertex1";
        EdgeProperty eProp1 = EdgeProperty.create((EdgeProperty.DataMovementType)EdgeProperty.DataMovementType.ONE_TO_ONE, (EdgeProperty.DataSourceType)EdgeProperty.DataSourceType.PERSISTED, (EdgeProperty.SchedulingType)EdgeProperty.SchedulingType.SEQUENTIAL, (OutputDescriptor)OutputDescriptor.create((String)"out"), (InputDescriptor)InputDescriptor.create((String)"in"));
        String mockManagedVertexId = "Vertex";
        VertexManagerPluginContext mockContext = (VertexManagerPluginContext)Mockito.mock(VertexManagerPluginContext.class);
        Mockito.when((Object)mockContext.getInputVertexEdgeProperties()).thenReturn(mockInputVertices);
        Mockito.when((Object)mockContext.getVertexName()).thenReturn((Object)mockManagedVertexId);
        Mockito.when((Object)mockContext.getVertexNumTasks(mockManagedVertexId)).thenReturn((Object)3);
        Mockito.when((Object)mockContext.getVertexNumTasks(mockSrcVertexId1)).thenReturn((Object)3);
        mockInputVertices.put(mockSrcVertexId1, eProp1);
        InputReadyVertexManager manager = new InputReadyVertexManager(mockContext);
        manager.initialize();
        ((VertexManagerPluginContext)Mockito.verify((Object)mockContext, (VerificationMode)Mockito.times((int)1))).vertexReconfigurationPlanned();
        ((VertexManagerPluginContext)Mockito.verify((Object)mockContext, (VerificationMode)Mockito.times((int)0))).scheduleTasks((List)this.requestCaptor.capture());
        manager.onSourceTaskCompleted(TestShuffleVertexManager.createTaskAttemptIdentifier(mockSrcVertexId1, 1));
        manager.onVertexStarted(Collections.singletonList(TestShuffleVertexManager.createTaskAttemptIdentifier(mockSrcVertexId1, 0)));
        ((VertexManagerPluginContext)Mockito.verify((Object)mockContext, (VerificationMode)Mockito.times((int)0))).scheduleTasks((List)this.requestCaptor.capture());
        manager.onVertexStateUpdated(new VertexStateUpdate(mockSrcVertexId1, VertexState.CONFIGURED));
        ((VertexManagerPluginContext)Mockito.verify((Object)mockContext, (VerificationMode)Mockito.times((int)1))).doneReconfiguringVertex();
        ((VertexManagerPluginContext)Mockito.verify((Object)mockContext, (VerificationMode)Mockito.times((int)2))).scheduleTasks((List)this.requestCaptor.capture());
        manager.onSourceTaskCompleted(TestShuffleVertexManager.createTaskAttemptIdentifier(mockSrcVertexId1, 2));
        ((VertexManagerPluginContext)Mockito.verify((Object)mockContext, (VerificationMode)Mockito.times((int)3))).scheduleTasks((List)this.requestCaptor.capture());
        Assert.assertEquals((long)1L, (long)((List)this.requestCaptor.getValue()).size());
        Assert.assertEquals((long)2L, (long)((VertexManagerPluginContext.ScheduleTaskRequest)((List)this.requestCaptor.getValue()).get(0)).getTaskIndex());
        Assert.assertEquals((Object)mockSrcVertexId1, (Object)((VertexManagerPluginContext.ScheduleTaskRequest)((List)this.requestCaptor.getValue()).get(0)).getTaskLocationHint().getAffinitizedTask().getVertexName());
        Assert.assertEquals((long)2L, (long)((VertexManagerPluginContext.ScheduleTaskRequest)((List)this.requestCaptor.getValue()).get(0)).getTaskLocationHint().getAffinitizedTask().getTaskIndex());
    }

    @Test(timeout=5000L)
    public void testComplex() throws Exception {
        HashMap<String, EdgeProperty> mockInputVertices = new HashMap<String, EdgeProperty>();
        String mockSrcVertexId1 = "Vertex1";
        EdgeProperty eProp1 = EdgeProperty.create((EdgeProperty.DataMovementType)EdgeProperty.DataMovementType.SCATTER_GATHER, (EdgeProperty.DataSourceType)EdgeProperty.DataSourceType.PERSISTED, (EdgeProperty.SchedulingType)EdgeProperty.SchedulingType.SEQUENTIAL, (OutputDescriptor)OutputDescriptor.create((String)"out"), (InputDescriptor)InputDescriptor.create((String)"in"));
        String mockSrcVertexId2 = "Vertex2";
        EdgeProperty eProp2 = EdgeProperty.create((EdgeProperty.DataMovementType)EdgeProperty.DataMovementType.ONE_TO_ONE, (EdgeProperty.DataSourceType)EdgeProperty.DataSourceType.PERSISTED, (EdgeProperty.SchedulingType)EdgeProperty.SchedulingType.SEQUENTIAL, (OutputDescriptor)OutputDescriptor.create((String)"out"), (InputDescriptor)InputDescriptor.create((String)"in"));
        String mockSrcVertexId3 = "Vertex3";
        EdgeProperty eProp3 = EdgeProperty.create((EdgeProperty.DataMovementType)EdgeProperty.DataMovementType.ONE_TO_ONE, (EdgeProperty.DataSourceType)EdgeProperty.DataSourceType.PERSISTED, (EdgeProperty.SchedulingType)EdgeProperty.SchedulingType.SEQUENTIAL, (OutputDescriptor)OutputDescriptor.create((String)"out"), (InputDescriptor)InputDescriptor.create((String)"in"));
        String mockManagedVertexId = "Vertex";
        Container mockContainer2 = (Container)Mockito.mock(Container.class);
        ContainerId mockCId2 = (ContainerId)Mockito.mock(ContainerId.class);
        Mockito.when((Object)mockContainer2.getId()).thenReturn((Object)mockCId2);
        Container mockContainer3 = (Container)Mockito.mock(Container.class);
        ContainerId mockCId3 = (ContainerId)Mockito.mock(ContainerId.class);
        Mockito.when((Object)mockContainer3.getId()).thenReturn((Object)mockCId3);
        VertexManagerPluginContext mockContext = (VertexManagerPluginContext)Mockito.mock(VertexManagerPluginContext.class);
        Mockito.when((Object)mockContext.getInputVertexEdgeProperties()).thenReturn(mockInputVertices);
        Mockito.when((Object)mockContext.getVertexName()).thenReturn((Object)mockManagedVertexId);
        Mockito.when((Object)mockContext.getVertexNumTasks(mockSrcVertexId1)).thenReturn((Object)3);
        Mockito.when((Object)mockContext.getVertexNumTasks(mockSrcVertexId2)).thenReturn((Object)3);
        Mockito.when((Object)mockContext.getVertexNumTasks(mockSrcVertexId3)).thenReturn((Object)3);
        mockInputVertices.put(mockSrcVertexId1, eProp1);
        mockInputVertices.put(mockSrcVertexId2, eProp2);
        mockInputVertices.put(mockSrcVertexId3, eProp3);
        ArrayList initialCompletions = Lists.newArrayList();
        Mockito.when((Object)mockContext.getVertexNumTasks(mockManagedVertexId)).thenReturn((Object)4);
        InputReadyVertexManager manager = new InputReadyVertexManager(mockContext);
        manager.initialize();
        ((VertexManagerPluginContext)Mockito.verify((Object)mockContext, (VerificationMode)Mockito.times((int)1))).vertexReconfigurationPlanned();
        manager.onVertexStateUpdated(new VertexStateUpdate(mockSrcVertexId1, VertexState.CONFIGURED));
        manager.onVertexStateUpdated(new VertexStateUpdate(mockSrcVertexId2, VertexState.CONFIGURED));
        manager.onVertexStateUpdated(new VertexStateUpdate(mockSrcVertexId3, VertexState.CONFIGURED));
        ((VertexManagerPluginContext)Mockito.verify((Object)mockContext, (VerificationMode)Mockito.times((int)1))).reconfigureVertex(3, null, null);
        ((VertexManagerPluginContext)Mockito.verify((Object)mockContext, (VerificationMode)Mockito.times((int)1))).doneReconfiguringVertex();
        manager.onVertexStarted((List)initialCompletions);
        Mockito.when((Object)mockContext.getVertexNumTasks(mockManagedVertexId)).thenReturn((Object)3);
        Mockito.when((Object)mockContext.getVertexNumTasks(mockSrcVertexId3)).thenReturn((Object)4);
        manager = new InputReadyVertexManager(mockContext);
        manager.initialize();
        ((VertexManagerPluginContext)Mockito.verify((Object)mockContext, (VerificationMode)Mockito.times((int)2))).vertexReconfigurationPlanned();
        manager.onVertexStateUpdated(new VertexStateUpdate(mockSrcVertexId1, VertexState.CONFIGURED));
        manager.onVertexStateUpdated(new VertexStateUpdate(mockSrcVertexId2, VertexState.CONFIGURED));
        try {
            manager.onVertexStateUpdated(new VertexStateUpdate(mockSrcVertexId3, VertexState.CONFIGURED));
            Assert.assertTrue((String)"Should have exception", (boolean)false);
        }
        catch (TezUncheckedException e) {
            e.getMessage().contains("1-1 source vertices must have identical concurrency");
        }
        ((VertexManagerPluginContext)Mockito.verify((Object)mockContext, (VerificationMode)Mockito.times((int)1))).reconfigureVertex(Mockito.anyInt(), (VertexLocationHint)Mockito.any(), (Map)Mockito.any());
        Mockito.when((Object)mockContext.getVertexNumTasks(mockSrcVertexId3)).thenReturn((Object)3);
        initialCompletions.add(TestShuffleVertexManager.createTaskAttemptIdentifier(mockSrcVertexId1, 0));
        initialCompletions.add(TestShuffleVertexManager.createTaskAttemptIdentifier(mockSrcVertexId2, 0));
        manager = new InputReadyVertexManager(mockContext);
        manager.initialize();
        ((VertexManagerPluginContext)Mockito.verify((Object)mockContext, (VerificationMode)Mockito.times((int)3))).vertexReconfigurationPlanned();
        manager.onVertexStateUpdated(new VertexStateUpdate(mockSrcVertexId1, VertexState.CONFIGURED));
        manager.onVertexStateUpdated(new VertexStateUpdate(mockSrcVertexId2, VertexState.CONFIGURED));
        manager.onVertexStateUpdated(new VertexStateUpdate(mockSrcVertexId3, VertexState.CONFIGURED));
        ((VertexManagerPluginContext)Mockito.verify((Object)mockContext, (VerificationMode)Mockito.times((int)1))).reconfigureVertex(Mockito.anyInt(), (VertexLocationHint)Mockito.any(), (Map)Mockito.any());
        ((VertexManagerPluginContext)Mockito.verify((Object)mockContext, (VerificationMode)Mockito.times((int)2))).doneReconfiguringVertex();
        manager.onVertexStarted((List)initialCompletions);
        manager.onSourceTaskCompleted(TestShuffleVertexManager.createTaskAttemptIdentifier(mockSrcVertexId3, 0));
        manager.onSourceTaskCompleted(TestShuffleVertexManager.createTaskAttemptIdentifier(mockSrcVertexId1, 1));
        manager.onSourceTaskCompleted(TestShuffleVertexManager.createTaskAttemptIdentifier(mockSrcVertexId1, 1));
        manager.onSourceTaskCompleted(TestShuffleVertexManager.createTaskAttemptIdentifier(mockSrcVertexId2, 1));
        ((VertexManagerPluginContext)Mockito.verify((Object)mockContext, (VerificationMode)Mockito.times((int)0))).scheduleTasks(Mockito.anyList());
        manager.onSourceTaskCompleted(TestShuffleVertexManager.createTaskAttemptIdentifier(mockSrcVertexId1, 2));
        ((VertexManagerPluginContext)Mockito.verify((Object)mockContext, (VerificationMode)Mockito.times((int)1))).scheduleTasks((List)this.requestCaptor.capture());
        Assert.assertEquals((long)1L, (long)((List)this.requestCaptor.getValue()).size());
        Assert.assertEquals((long)0L, (long)((VertexManagerPluginContext.ScheduleTaskRequest)((List)this.requestCaptor.getValue()).get(0)).getTaskIndex());
        Assert.assertEquals((Object)mockSrcVertexId3, (Object)((VertexManagerPluginContext.ScheduleTaskRequest)((List)this.requestCaptor.getValue()).get(0)).getTaskLocationHint().getAffinitizedTask().getVertexName());
        Assert.assertEquals((long)0L, (long)((VertexManagerPluginContext.ScheduleTaskRequest)((List)this.requestCaptor.getValue()).get(0)).getTaskLocationHint().getAffinitizedTask().getTaskIndex());
        manager.onSourceTaskCompleted(TestShuffleVertexManager.createTaskAttemptIdentifier(mockSrcVertexId3, 1));
        ((VertexManagerPluginContext)Mockito.verify((Object)mockContext, (VerificationMode)Mockito.times((int)2))).scheduleTasks((List)this.requestCaptor.capture());
        Assert.assertEquals((long)1L, (long)((List)this.requestCaptor.getValue()).size());
        Assert.assertEquals((long)1L, (long)((VertexManagerPluginContext.ScheduleTaskRequest)((List)this.requestCaptor.getValue()).get(0)).getTaskIndex());
        Assert.assertEquals((Object)mockSrcVertexId3, (Object)((VertexManagerPluginContext.ScheduleTaskRequest)((List)this.requestCaptor.getValue()).get(0)).getTaskLocationHint().getAffinitizedTask().getVertexName());
        Assert.assertEquals((long)1L, (long)((VertexManagerPluginContext.ScheduleTaskRequest)((List)this.requestCaptor.getValue()).get(0)).getTaskLocationHint().getAffinitizedTask().getTaskIndex());
        manager.onSourceTaskCompleted(TestShuffleVertexManager.createTaskAttemptIdentifier(mockSrcVertexId3, 2));
        ((VertexManagerPluginContext)Mockito.verify((Object)mockContext, (VerificationMode)Mockito.times((int)2))).scheduleTasks(Mockito.anyList());
        manager.onSourceTaskCompleted(TestShuffleVertexManager.createTaskAttemptIdentifier(mockSrcVertexId2, 2));
        ((VertexManagerPluginContext)Mockito.verify((Object)mockContext, (VerificationMode)Mockito.times((int)3))).scheduleTasks((List)this.requestCaptor.capture());
        Assert.assertEquals((long)1L, (long)((List)this.requestCaptor.getValue()).size());
        Assert.assertEquals((long)2L, (long)((VertexManagerPluginContext.ScheduleTaskRequest)((List)this.requestCaptor.getValue()).get(0)).getTaskIndex());
        Assert.assertEquals((Object)mockSrcVertexId2, (Object)((VertexManagerPluginContext.ScheduleTaskRequest)((List)this.requestCaptor.getValue()).get(0)).getTaskLocationHint().getAffinitizedTask().getVertexName());
        Assert.assertEquals((long)2L, (long)((VertexManagerPluginContext.ScheduleTaskRequest)((List)this.requestCaptor.getValue()).get(0)).getTaskLocationHint().getAffinitizedTask().getTaskIndex());
        manager.onSourceTaskCompleted(TestShuffleVertexManager.createTaskAttemptIdentifier(mockSrcVertexId3, 2));
        ((VertexManagerPluginContext)Mockito.verify((Object)mockContext, (VerificationMode)Mockito.times((int)3))).scheduleTasks(Mockito.anyList());
    }
}

