/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.runtime.api.impl;

import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.DataInputBuffer;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.tez.common.TezUtils;
import org.apache.tez.dag.api.UserPayload;
import org.apache.tez.dag.records.TezTaskAttemptID;
import org.apache.tez.dag.records.TezTaskID;
import org.apache.tez.runtime.api.Event;
import org.apache.tez.runtime.api.events.DataMovementEvent;
import org.apache.tez.runtime.api.events.TaskAttemptCompletedEvent;
import org.apache.tez.runtime.api.events.TaskStatusUpdateEvent;
import org.apache.tez.runtime.api.impl.EventMetaData;
import org.apache.tez.runtime.api.impl.TezEvent;
import org.junit.Assert;
import org.junit.Test;

public class TestTezEvent {
    @Test
    public void testSerialization() throws IOException {
        ArrayList<TezEvent> events = new ArrayList<TezEvent>();
        Configuration conf = new Configuration(true);
        String confVal = RandomStringUtils.random((int)10000, (boolean)true, (boolean)true);
        conf.set("testKey", confVal);
        UserPayload payload = TezUtils.createUserPayloadFromConf((Configuration)conf);
        TezTaskAttemptID srcTAID = TezTaskAttemptID.getInstance((TezTaskID)TezTaskID.fromString((String)"task_1454468251169_866787_1_02_000000"), (int)1000);
        TezTaskAttemptID destTAID = TezTaskAttemptID.getInstance((TezTaskID)TezTaskID.fromString((String)"task_1454468251169_866787_1_02_000000"), (int)2000);
        EventMetaData srcInfo = new EventMetaData(EventMetaData.EventProducerConsumerType.OUTPUT, "v1", "v2", srcTAID);
        EventMetaData destInfo = new EventMetaData(EventMetaData.EventProducerConsumerType.OUTPUT, "v3", "v4", destTAID);
        events.add(new TezEvent((Event)new TaskAttemptCompletedEvent(), new EventMetaData(EventMetaData.EventProducerConsumerType.PROCESSOR, "v1", "v2", srcTAID)));
        TezEvent dmeEvent = new TezEvent((Event)DataMovementEvent.create((int)1000, (int)3, (int)1, (ByteBuffer)payload.getPayload()), srcInfo, System.currentTimeMillis());
        dmeEvent.setDestinationInfo(destInfo);
        events.add(dmeEvent);
        events.add(new TezEvent((Event)new TaskStatusUpdateEvent(null, 0.1f, null, false), new EventMetaData(EventMetaData.EventProducerConsumerType.PROCESSOR, "v5", "v6", srcTAID)));
        DataOutputBuffer dataout = new DataOutputBuffer();
        ByteArrayDataOutput bout = ByteStreams.newDataOutput();
        this.serializeEvents(events, (DataOutput)dataout);
        this.serializeEvents(events, (DataOutput)bout);
        DataInputBuffer datain = new DataInputBuffer();
        datain.reset(dataout.getData(), dataout.getLength());
        DataInputStream dis = new DataInputStream(new ByteArrayInputStream(dataout.getData(), 0, dataout.getLength()));
        ArrayList<TezEvent> actual1 = this.deserializeEvents((DataInput)datain);
        ArrayList<TezEvent> actual2 = this.deserializeEvents(dis);
        this.assertEventEquals(events, actual1);
        this.assertEventEquals(events, actual2);
        byte[] serializedBytes = bout.toByteArray();
        datain.reset(serializedBytes, serializedBytes.length);
        dis = new DataInputStream(new ByteArrayInputStream(serializedBytes));
        actual1 = this.deserializeEvents((DataInput)datain);
        actual2 = this.deserializeEvents(dis);
        this.assertEventEquals(events, actual1);
        this.assertEventEquals(events, actual2);
    }

    private void serializeEvents(ArrayList<TezEvent> events, DataOutput out) throws IOException {
        out.writeInt(events.size());
        for (TezEvent e : events) {
            e.write(out);
        }
    }

    private ArrayList<TezEvent> deserializeEvents(DataInput in) throws IOException {
        int eventsCount = in.readInt();
        ArrayList<TezEvent> events = new ArrayList<TezEvent>(eventsCount);
        for (int i = 0; i < eventsCount; ++i) {
            TezEvent e = new TezEvent();
            e.readFields(in);
            events.add(e);
        }
        return events;
    }

    private void assertEventEquals(ArrayList<TezEvent> expectedList, ArrayList<TezEvent> actualList) {
        Assert.assertEquals((long)expectedList.size(), (long)actualList.size());
        for (int i = 0; i < expectedList.size(); ++i) {
            TezEvent expected = expectedList.get(i);
            TezEvent actual = actualList.get(i);
            Assert.assertEquals((long)expected.getEventReceivedTime(), (long)actual.getEventReceivedTime());
            Assert.assertEquals((Object)expected.getSourceInfo(), (Object)actual.getSourceInfo());
            Assert.assertEquals((Object)expected.getDestinationInfo(), (Object)actual.getDestinationInfo());
            Assert.assertEquals((Object)expected.getEventType(), (Object)actual.getEventType());
            if (i == 0) {
                Assert.assertTrue((boolean)(actual.getEvent() instanceof TaskAttemptCompletedEvent));
                continue;
            }
            if (i == 1) {
                DataMovementEvent dmeExpected = (DataMovementEvent)expected.getEvent();
                DataMovementEvent dmeActual = (DataMovementEvent)actual.getEvent();
                Assert.assertEquals((long)dmeExpected.getSourceIndex(), (long)dmeActual.getSourceIndex());
                Assert.assertEquals((long)dmeExpected.getTargetIndex(), (long)dmeActual.getTargetIndex());
                Assert.assertEquals((long)dmeExpected.getVersion(), (long)dmeActual.getVersion());
                Assert.assertEquals((Object)dmeExpected.getUserPayload(), (Object)dmeActual.getUserPayload());
                continue;
            }
            TaskStatusUpdateEvent tsuExpected = (TaskStatusUpdateEvent)expected.getEvent();
            TaskStatusUpdateEvent tsuActual = (TaskStatusUpdateEvent)actual.getEvent();
            Assert.assertEquals((Object)tsuExpected.getCounters(), (Object)tsuActual.getCounters());
            Assert.assertEquals((float)tsuExpected.getProgress(), (float)tsuActual.getProgress(), (float)0.0f);
            Assert.assertEquals((Object)tsuExpected.getProgressNotified(), (Object)tsuActual.getProgressNotified());
            Assert.assertEquals((Object)tsuExpected.getStatistics(), (Object)tsuActual.getStatistics());
        }
    }
}

