/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.runtime.task;

import com.google.common.base.Function;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URL;
import java.nio.ByteBuffer;
import java.security.PrivilegedExceptionAction;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nullable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.yarn.YarnUncaughtExceptionHandler;
import org.apache.hadoop.yarn.api.ApplicationConstants;
import org.apache.tez.common.ContainerContext;
import org.apache.tez.common.ContainerTask;
import org.apache.tez.common.Preconditions;
import org.apache.tez.common.TezClassLoader;
import org.apache.tez.common.TezCommonUtils;
import org.apache.tez.common.TezExecutors;
import org.apache.tez.common.TezLocalResource;
import org.apache.tez.common.TezSharedExecutor;
import org.apache.tez.common.TezTaskUmbilicalProtocol;
import org.apache.tez.common.TezUtilsInternal;
import org.apache.tez.common.counters.Limits;
import org.apache.tez.common.security.TokenCache;
import org.apache.tez.dag.api.TezException;
import org.apache.tez.dag.api.records.DAGProtos;
import org.apache.tez.dag.records.TezTaskAttemptID;
import org.apache.tez.dag.records.TezVertexID;
import org.apache.tez.dag.utils.RelocalizationUtils;
import org.apache.tez.hadoop.shim.HadoopShim;
import org.apache.tez.hadoop.shim.HadoopShimsLoader;
import org.apache.tez.runtime.api.ExecutionContext;
import org.apache.tez.runtime.api.impl.ExecutionContextImpl;
import org.apache.tez.runtime.common.objectregistry.ObjectRegistryImpl;
import org.apache.tez.runtime.internals.api.TaskReporterInterface;
import org.apache.tez.runtime.task.ContainerReporter;
import org.apache.tez.runtime.task.TaskReporter;
import org.apache.tez.runtime.task.TaskRunner2Result;
import org.apache.tez.runtime.task.TezTaskRunner2;
import org.apache.tez.util.TezRuntimeShutdownHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TezChild {
    private static final Logger LOG = LoggerFactory.getLogger(TezChild.class);
    private final Configuration defaultConf;
    private final String containerIdString;
    private final int appAttemptNumber;
    private final String[] localDirs;
    private final AtomicLong heartbeatCounter = new AtomicLong(0L);
    private final int getTaskMaxSleepTime;
    private final int amHeartbeatInterval;
    private final long sendCounterInterval;
    private final int maxEventsToGet;
    private final String workingDir;
    private final ListeningExecutorService executor;
    private final ObjectRegistryImpl objectRegistry;
    private final String pid;
    private final ExecutionContext executionContext;
    private final Map<String, ByteBuffer> serviceConsumerMetadata = new HashMap<String, ByteBuffer>();
    private final Map<String, String> serviceProviderEnvMap;
    private final Credentials credentials;
    private final long memAvailable;
    private final AtomicBoolean isShutdown = new AtomicBoolean(false);
    private final String user;
    private final boolean updateSysCounters;
    private Multimap<String, String> startedInputsMap = HashMultimap.create();
    private final boolean ownUmbilical;
    private final TezTaskUmbilicalProtocol umbilical;
    private TaskReporterInterface taskReporter;
    private int taskCount = 0;
    private TezVertexID lastVertexID;
    private final HadoopShim hadoopShim;
    private final TezExecutors sharedExecutor;

    public TezChild(Configuration conf, String host, int port, String containerIdentifier, String tokenIdentifier, int appAttemptNumber, String workingDir, String[] localDirs, Map<String, String> serviceProviderEnvMap, ObjectRegistryImpl objectRegistry, String pid, ExecutionContext executionContext, Credentials credentials, long memAvailable, String user, TezTaskUmbilicalProtocol umbilical, boolean updateSysCounters, HadoopShim hadoopShim) throws IOException, InterruptedException {
        this.defaultConf = conf;
        this.containerIdString = containerIdentifier;
        this.appAttemptNumber = appAttemptNumber;
        this.localDirs = localDirs;
        this.serviceProviderEnvMap = serviceProviderEnvMap;
        this.workingDir = workingDir;
        this.pid = pid;
        this.executionContext = executionContext;
        this.credentials = credentials;
        this.memAvailable = memAvailable;
        this.user = user;
        this.updateSysCounters = updateSysCounters;
        this.hadoopShim = hadoopShim;
        this.sharedExecutor = new TezSharedExecutor(this.defaultConf);
        this.getTaskMaxSleepTime = this.defaultConf.getInt("tez.task.get-task.sleep.interval-ms.max", 200);
        this.amHeartbeatInterval = this.defaultConf.getInt("tez.task.am.heartbeat.interval-ms.max", 100);
        this.sendCounterInterval = this.defaultConf.getLong("tez.task.am.heartbeat.counter.interval-ms.max", 4000L);
        this.maxEventsToGet = this.defaultConf.getInt("tez.task.max-events-per-heartbeat", 500);
        ExecutorService executor = Executors.newFixedThreadPool(1, new ThreadFactoryBuilder().setDaemon(true).setNameFormat("TezChild").build());
        this.executor = MoreExecutors.listeningDecorator((ExecutorService)executor);
        this.objectRegistry = objectRegistry;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Executing with tokens:");
            for (Token token : credentials.getAllTokens()) {
                LOG.debug("", (Object)token);
            }
        }
        UserGroupInformation taskOwner = UserGroupInformation.createRemoteUser((String)tokenIdentifier);
        Token jobToken = TokenCache.getSessionToken((Credentials)credentials);
        String auxiliaryService = this.defaultConf.get("tez.am.shuffle.auxiliary-service.id", "mapreduce_shuffle");
        this.serviceConsumerMetadata.put(auxiliaryService, TezCommonUtils.convertJobTokenToBytes((Token)jobToken));
        if (umbilical == null) {
            final InetSocketAddress address = NetUtils.createSocketAddrForHost((String)host, (int)port);
            SecurityUtil.setTokenService((Token)jobToken, (InetSocketAddress)address);
            taskOwner.addToken(jobToken);
            this.umbilical = (TezTaskUmbilicalProtocol)taskOwner.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<TezTaskUmbilicalProtocol>(){

                @Override
                public TezTaskUmbilicalProtocol run() throws Exception {
                    return (TezTaskUmbilicalProtocol)RPC.getProxy(TezTaskUmbilicalProtocol.class, (long)19L, (InetSocketAddress)address, (Configuration)TezChild.this.defaultConf);
                }
            });
            this.ownUmbilical = true;
        } else {
            this.umbilical = umbilical;
            this.ownUmbilical = false;
        }
        TezCommonUtils.logCredentials((Logger)LOG, (Credentials)credentials, (String)"tezChildInit");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContainerExecutionResult run() throws IOException, InterruptedException, TezException {
        ContainerContext containerContext = new ContainerContext(this.containerIdString);
        ContainerReporter containerReporter = new ContainerReporter(this.umbilical, containerContext, this.getTaskMaxSleepTime);
        this.taskReporter = new TaskReporter(this.umbilical, this.amHeartbeatInterval, this.sendCounterInterval, this.maxEventsToGet, this.heartbeatCounter, this.containerIdString);
        UserGroupInformation childUGI = null;
        while (!this.executor.isTerminated() && !this.isShutdown.get()) {
            Object cause;
            if (this.taskCount > 0) {
                TezUtilsInternal.updateLoggers((String)"");
            }
            ListenableFuture getTaskFuture = this.executor.submit((Callable)((Object)containerReporter));
            boolean error = false;
            ContainerTask containerTask = null;
            try {
                containerTask = (ContainerTask)getTaskFuture.get();
            }
            catch (ExecutionException e) {
                error = true;
                cause = e.getCause();
                LOG.error("Error fetching new work for container {}", (Object)this.containerIdString, cause);
                ContainerExecutionResult containerExecutionResult = new ContainerExecutionResult(ContainerExecutionResult.ExitStatus.EXECUTION_FAILURE, (Throwable)cause, "Execution Exception while fetching new work: " + e.getMessage());
                return containerExecutionResult;
            }
            catch (InterruptedException e) {
                error = true;
                LOG.info("Interrupted while waiting for new work for container {}", (Object)this.containerIdString);
                cause = new ContainerExecutionResult(ContainerExecutionResult.ExitStatus.INTERRUPTED, e, "Interrupted while waiting for new work");
                return cause;
            }
            finally {
                if (error) {
                    this.shutdown();
                }
            }
            TezCommonUtils.logCredentials((Logger)LOG, (Credentials)containerTask.getCredentials(), (String)"containerTask");
            if (containerTask.shouldDie()) {
                LOG.info("ContainerTask returned shouldDie=true for container {}, Exiting", (Object)this.containerIdString);
                this.shutdown();
                return new ContainerExecutionResult(ContainerExecutionResult.ExitStatus.SUCCESS, null, "Asked to die by the AM");
            }
            String loggerAddend = containerTask.getTaskSpec().getTaskAttemptID().toString();
            ++this.taskCount;
            String timeStamp = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(Calendar.getInstance().getTime());
            System.err.println(timeStamp + " Starting to run new task attempt: " + containerTask.getTaskSpec().getTaskAttemptID().toString());
            System.out.println(timeStamp + " Starting to run new task attempt: " + containerTask.getTaskSpec().getTaskAttemptID().toString());
            TezUtilsInternal.setHadoopCallerContext((HadoopShim)this.hadoopShim, (TezTaskAttemptID)containerTask.getTaskSpec().getTaskAttemptID());
            TezUtilsInternal.updateLoggers((String)loggerAddend);
            FileSystem.clearStatistics();
            childUGI = this.handleNewTaskCredentials(containerTask, childUGI);
            TezCommonUtils.logCredentials((Logger)LOG, (Credentials)childUGI.getCredentials(), (String)"taskChildUGI");
            this.handleNewTaskLocalResources(containerTask, childUGI);
            this.cleanupOnTaskChanged(containerTask);
            TezTaskRunner2 taskRunner = new TezTaskRunner2(this.defaultConf, childUGI, this.localDirs, containerTask.getTaskSpec(), this.appAttemptNumber, this.serviceConsumerMetadata, this.serviceProviderEnvMap, this.startedInputsMap, this.taskReporter, (ExecutorService)this.executor, this.objectRegistry, this.pid, this.executionContext, this.memAvailable, this.updateSysCounters, this.hadoopShim, this.sharedExecutor);
            try {
                TaskRunner2Result result = taskRunner.run();
                LOG.info("TaskRunner2Result: {}", (Object)result);
                boolean shouldDie = result.isContainerShutdownRequested();
                if (shouldDie) {
                    LOG.info("Got a shouldDie notification via heartbeats for container {}. Shutting down", (Object)this.containerIdString);
                    this.shutdown();
                    ContainerExecutionResult containerExecutionResult = new ContainerExecutionResult(ContainerExecutionResult.ExitStatus.SUCCESS, null, "Asked to die by the AM");
                    return containerExecutionResult;
                }
                if (result.getError() == null) continue;
                Throwable e = result.getError();
                this.handleError(result.getError());
                ContainerExecutionResult containerExecutionResult = new ContainerExecutionResult(ContainerExecutionResult.ExitStatus.EXECUTION_FAILURE, e, "TaskExecutionFailure: " + e.getMessage());
                return containerExecutionResult;
            }
            finally {
                FileSystem.closeAllForUGI((UserGroupInformation)childUGI);
            }
        }
        return new ContainerExecutionResult(ContainerExecutionResult.ExitStatus.SUCCESS, null, null);
    }

    UserGroupInformation handleNewTaskCredentials(ContainerTask containerTask, UserGroupInformation childUGI) {
        Preconditions.checkState((!containerTask.shouldDie() ? 1 : 0) != 0);
        Preconditions.checkState((containerTask.getTaskSpec() != null ? 1 : 0) != 0);
        if (containerTask.haveCredentialsChanged()) {
            Credentials taskCreds = containerTask.getCredentials();
            if (taskCreds != null) {
                LOG.info("Refreshing UGI since Credentials have changed. Credentials : #Tokens=" + taskCreds.numberOfTokens() + ", #SecretKeys=" + taskCreds.numberOfSecretKeys());
                childUGI = UserGroupInformation.createRemoteUser((String)this.user);
                childUGI.addCredentials(containerTask.getCredentials());
            } else {
                LOG.info("Not loading any credentials, since no credentials provided");
            }
        }
        return childUGI;
    }

    private void handleNewTaskLocalResources(ContainerTask containerTask, UserGroupInformation ugi) throws IOException, TezException {
        final Map<String, TezLocalResource> additionalResources = containerTask.getAdditionalResources();
        LOG.debug("Additional Resources added to container: {}", additionalResources);
        if (additionalResources != null && !additionalResources.isEmpty()) {
            LOG.info("Localizing additional local resources for Task : " + additionalResources);
            try {
                List downloadedUrls = (List)ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<List<URL>>(){

                    @Override
                    public List<URL> run() throws Exception {
                        return RelocalizationUtils.processAdditionalResources((Map)Maps.transformValues((Map)additionalResources, (Function)new Function<TezLocalResource, URI>(){

                            public URI apply(TezLocalResource input) {
                                return input.getUri();
                            }
                        }), (Configuration)TezChild.this.defaultConf, (String)TezChild.this.workingDir);
                    }
                });
                RelocalizationUtils.addUrlsToClassPath((List)downloadedUrls);
            }
            catch (InterruptedException e) {
                throw new TezException((Throwable)e);
            }
            LOG.info("Done localizing additional resources");
        }
    }

    private void cleanupOnTaskChanged(ContainerTask containerTask) {
        Preconditions.checkState((!containerTask.shouldDie() ? 1 : 0) != 0);
        Preconditions.checkState((containerTask.getTaskSpec() != null ? 1 : 0) != 0);
        TezVertexID newVertexID = containerTask.getTaskSpec().getTaskAttemptID().getVertexID();
        if (this.lastVertexID != null) {
            if (!this.lastVertexID.equals((Object)newVertexID)) {
                this.objectRegistry.clearCache(ObjectRegistryImpl.ObjectLifeCycle.VERTEX);
            }
            if (!this.lastVertexID.getDAGID().equals((Object)newVertexID.getDAGID())) {
                this.objectRegistry.clearCache(ObjectRegistryImpl.ObjectLifeCycle.DAG);
                this.startedInputsMap = HashMultimap.create();
            }
        }
        this.lastVertexID = newVertexID;
    }

    public void shutdown() {
        LOG.info("Shutdown invoked for container {}", (Object)this.containerIdString);
        if (!this.isShutdown.getAndSet(true)) {
            LOG.info("Shutting down container {}", (Object)this.containerIdString);
            List pendingRunnables = this.executor.shutdownNow();
            LOG.info("There are {} runnables in shared executor, cancelling those...", (Object)pendingRunnables.size());
            for (Runnable r : pendingRunnables) {
                LOG.info("Cancelling pending runnable ({}) during TezChild shutdown for containerId={}", (Object)r.hashCode(), (Object)this.containerIdString);
                ((FutureTask)r).cancel(false);
            }
            if (this.taskReporter != null) {
                this.taskReporter.shutdown();
            }
            if (this.ownUmbilical) {
                RPC.stopProxy((Object)this.umbilical);
            }
        }
        TezRuntimeShutdownHandler.shutdown();
        LOG.info("TezChild shutdown finished");
    }

    public static TezChild newTezChild(Configuration conf, String host, int port, String containerIdentifier, String tokenIdentifier, int attemptNumber, String[] localDirs, String workingDirectory, Map<String, String> serviceProviderEnvMap, @Nullable String pid, ExecutionContext executionContext, Credentials credentials, long memAvailable, String user, TezTaskUmbilicalProtocol tezUmbilical, boolean updateSysCounters, HadoopShim hadoopShim) throws IOException, InterruptedException, TezException {
        Limits.setConfiguration((Configuration)conf);
        TezUtilsInternal.setSecurityUtilConfigration((Logger)LOG, (Configuration)conf);
        ObjectRegistryImpl objectRegistry = new ObjectRegistryImpl();
        return new TezChild(conf, host, port, containerIdentifier, tokenIdentifier, attemptNumber, workingDirectory, localDirs, serviceProviderEnvMap, objectRegistry, pid, executionContext, credentials, memAvailable, user, tezUmbilical, updateSysCounters, hadoopShim);
    }

    public static void main(String[] args) throws IOException, InterruptedException, TezException {
        String systemPropsToLog;
        TezClassLoader.setupTezClassLoader();
        Configuration defaultConf = new Configuration();
        Thread.setDefaultUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new YarnUncaughtExceptionHandler());
        String pid = System.getenv().get("JVM_PID");
        assert (args.length == 5);
        String host = args[0];
        int port = Integer.parseInt(args[1]);
        String containerIdentifier = args[2];
        String tokenIdentifier = args[3];
        int attemptNumber = Integer.parseInt(args[4]);
        String[] localDirs = TezCommonUtils.getTrimmedStrings((String)System.getenv(ApplicationConstants.Environment.LOCAL_DIRS.name()));
        LOG.info("TezChild starting with PID=" + pid + ", containerIdentifier=" + containerIdentifier);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Info from cmd line: AM-host: " + host + " AM-port: " + port + " containerIdentifier: " + containerIdentifier + " appAttemptNumber: " + attemptNumber + " tokenIdentifier: " + tokenIdentifier);
        }
        DAGProtos.ConfigurationProto confProto = TezUtilsInternal.readUserSpecifiedTezConfiguration((String)System.getenv(ApplicationConstants.Environment.PWD.name()));
        TezUtilsInternal.addUserSpecifiedTezConfiguration((Configuration)defaultConf, (List)confProto.getConfKeyValuesList());
        UserGroupInformation.setConfiguration((Configuration)defaultConf);
        Credentials credentials = UserGroupInformation.getCurrentUser().getCredentials();
        HadoopShim hadoopShim = new HadoopShimsLoader(defaultConf).getHadoopShim();
        if (LOG.isInfoEnabled() && (systemPropsToLog = TezCommonUtils.getSystemPropertiesToLog((Configuration)defaultConf)) != null) {
            LOG.info(systemPropsToLog);
        }
        TezChild tezChild = TezChild.newTezChild(defaultConf, host, port, containerIdentifier, tokenIdentifier, attemptNumber, localDirs, System.getenv(ApplicationConstants.Environment.PWD.name()), System.getenv(), pid, new ExecutionContextImpl(System.getenv(ApplicationConstants.Environment.NM_HOST.name())), credentials, Runtime.getRuntime().maxMemory(), System.getenv(ApplicationConstants.Environment.USER.toString()), null, true, hadoopShim);
        ContainerExecutionResult result = tezChild.run();
        LOG.info("TezChild is about to exit from main(), run() returned result: {}", (Object)result.toString());
    }

    private void handleError(Throwable t) {
        this.shutdown();
    }

    public static class ContainerExecutionResult {
        private final ExitStatus exitStatus;
        private final Throwable throwable;
        private final String errorMessage;

        public ContainerExecutionResult(ExitStatus exitStatus, @Nullable Throwable throwable, @Nullable String errorMessage) {
            this.exitStatus = exitStatus;
            this.throwable = throwable;
            this.errorMessage = errorMessage;
        }

        public ExitStatus getExitStatus() {
            return this.exitStatus;
        }

        public Throwable getThrowable() {
            return this.throwable;
        }

        public String getErrorMessage() {
            return this.errorMessage;
        }

        public String toString() {
            return "ContainerExecutionResult{exitStatus=" + this.exitStatus + ", throwable=" + this.throwable + ", errorMessage='" + this.errorMessage + "'}";
        }

        public static enum ExitStatus {
            SUCCESS(0),
            EXECUTION_FAILURE(1),
            INTERRUPTED(2),
            ASKED_TO_DIE(3);

            private final int exitCode;

            private ExitStatus(int code) {
                this.exitCode = code;
            }

            public int getExitCode() {
                return this.exitCode;
            }
        }
    }
}

