/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.history.logging.proto;

import java.io.Closeable;
import java.io.IOException;
import java.security.PrivilegedAction;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.tez.dag.history.logging.proto.DatePartitionedLogger;
import org.apache.tez.dag.history.logging.proto.HistoryLoggerProtos;
import org.apache.tez.dag.history.logging.proto.ProtoMessageReader;
import org.codehaus.jackson.map.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DagManifesFileScanner
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(DagManifesFileScanner.class);
    private static final int SCANNER_OFFSET_VERSION = 2;
    private static final int MAX_RETRY = 3;
    private final ObjectMapper mapper = new ObjectMapper();
    private final DatePartitionedLogger<HistoryLoggerProtos.ManifestEntryProto> manifestLogger;
    private final long syncTime;
    private final boolean withDoas;
    private String scanDir;
    private Map<String, Long> offsets;
    private Map<String, Integer> retryCount;
    private List<FileStatus> newFiles;
    private ProtoMessageReader<HistoryLoggerProtos.ManifestEntryProto> reader;
    private String currentFilePath;

    public DagManifesFileScanner(DatePartitionedLogger<HistoryLoggerProtos.ManifestEntryProto> manifestLogger) {
        this.manifestLogger = manifestLogger;
        this.syncTime = manifestLogger.getConfig().getLong("tez.history.logging.proto-sync-window-secs", 60L);
        this.withDoas = manifestLogger.getConfig().getBoolean("tez.history.logging.proto-doas", false);
        this.setOffset(LocalDate.ofEpochDay(0L));
    }

    public void setOffset(String offset) {
        try {
            DagManifestOffset dagOffset = (DagManifestOffset)this.mapper.readValue(offset, DagManifestOffset.class);
            if (dagOffset.version > 2) {
                throw new IllegalArgumentException("Version mismatch: " + dagOffset.version);
            }
            this.scanDir = dagOffset.scanDir;
            this.offsets = dagOffset.offsets == null ? new HashMap() : dagOffset.offsets;
            this.retryCount = dagOffset.retryCount == null ? new HashMap() : dagOffset.retryCount;
            this.newFiles = new ArrayList<FileStatus>();
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Invalid offset", e);
        }
    }

    public void setOffset(LocalDate date) {
        this.scanDir = this.manifestLogger.getDirForDate(date);
        this.offsets = new HashMap<String, Long>();
        this.retryCount = new HashMap<String, Integer>();
        this.newFiles = new ArrayList<FileStatus>();
    }

    public String getOffset() {
        try {
            DagManifestOffset offset = new DagManifestOffset();
            offset.version = 2;
            offset.scanDir = this.scanDir;
            offset.offsets = this.offsets;
            offset.retryCount = this.retryCount;
            return this.mapper.writeValueAsString((Object)offset);
        }
        catch (IOException e) {
            throw new RuntimeException("Unexpected exception while converting to json.", e);
        }
    }

    public HistoryLoggerProtos.ManifestEntryProto getNext() throws IOException {
        while (true) {
            if (this.reader != null) {
                HistoryLoggerProtos.ManifestEntryProto evt = null;
                try {
                    evt = this.reader.readEvent();
                    this.retryCount.remove(this.currentFilePath);
                }
                catch (IOException e) {
                    LOG.error("Error trying to read event from file: {}", (Object)this.currentFilePath, (Object)e);
                    this.incrementError(this.currentFilePath);
                }
                if (evt != null) {
                    this.offsets.put(this.reader.getFilePath().getName(), this.reader.getOffset());
                    return evt;
                }
                IOUtils.closeQuietly(this.reader);
                this.reader = null;
                this.currentFilePath = null;
            }
            if (!this.newFiles.isEmpty()) {
                this.reader = this.getNextReader();
                this.currentFilePath = this.reader != null ? this.reader.getFilePath().toString() : null;
                continue;
            }
            if (!this.loadMore()) break;
        }
        return null;
    }

    private void incrementError(String path) {
        int count = this.retryCount.getOrDefault(path, 0);
        this.retryCount.put(path, count + 1);
    }

    private ProtoMessageReader<HistoryLoggerProtos.ManifestEntryProto> getNextReader() throws IOException {
        FileStatus status = this.newFiles.remove(0);
        PrivilegedAction<ProtoMessageReader> action = () -> {
            try {
                return this.manifestLogger.getReader(status.getPath());
            }
            catch (IOException e) {
                String path = status.getPath().toString();
                LOG.error("Error trying to open file: {}", (Object)path, (Object)e);
                this.incrementError(path);
                return null;
            }
        };
        if (this.withDoas) {
            UserGroupInformation proxyUser = UserGroupInformation.createProxyUser((String)status.getOwner(), (UserGroupInformation)UserGroupInformation.getCurrentUser());
            return (ProtoMessageReader)proxyUser.doAs(action);
        }
        return action.run();
    }

    @Override
    public void close() throws IOException {
        if (this.reader != null) {
            this.reader.close();
            this.reader = null;
        }
    }

    private void filterErrors(List<FileStatus> files) {
        Iterator<FileStatus> iter = files.iterator();
        while (iter.hasNext()) {
            FileStatus status = iter.next();
            String path = status.getPath().toString();
            if (this.retryCount.getOrDefault(path, 0) <= 3) continue;
            LOG.warn("Removing file {}, too many errors", (Object)path);
            iter.remove();
        }
    }

    private void loadNewFiles(String todayDir) throws IOException {
        this.newFiles = this.manifestLogger.scanForChangedFiles(this.scanDir, this.offsets);
        if (!this.scanDir.equals(todayDir)) {
            this.filterErrors(this.newFiles);
        }
    }

    private boolean loadMore() throws IOException {
        LocalDateTime now = this.manifestLogger.getNow();
        LocalDate today = now.toLocalDate();
        String todayDir = this.manifestLogger.getDirForDate(today);
        this.loadNewFiles(todayDir);
        while (this.newFiles.isEmpty()) {
            if ((long)(now.getHour() * 3600 + now.getMinute() * 60 + now.getSecond()) < this.syncTime && this.scanDir.equals(this.manifestLogger.getDirForDate(today.minusDays(1L)))) {
                return false;
            }
            String nextDir = this.manifestLogger.getNextDirectory(this.scanDir);
            if (nextDir == null) {
                return false;
            }
            this.scanDir = nextDir;
            this.offsets = new HashMap<String, Long>();
            this.retryCount = new HashMap<String, Integer>();
            this.loadNewFiles(todayDir);
        }
        return true;
    }

    public static class DagManifestOffset {
        public int version;
        public String scanDir;
        public Map<String, Long> offsets;
        public Map<String, Integer> retryCount;
    }
}

