/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.history.logging.proto;

import com.google.protobuf.MessageLite;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.util.Clock;
import org.apache.tez.dag.history.logging.proto.DagManifesFileScanner;
import org.apache.tez.dag.history.logging.proto.DatePartitionedLogger;
import org.apache.tez.dag.history.logging.proto.HistoryLoggerProtos;
import org.apache.tez.dag.history.logging.proto.ProtoMessageWriter;
import org.apache.tez.dag.history.logging.proto.TezProtoLoggers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class TestDagManifestFileScanner {
    private MockClock clock;
    private DatePartitionedLogger<HistoryLoggerProtos.ManifestEntryProto> manifestLogger;
    @Rule
    public TemporaryFolder tempFolder = new TemporaryFolder();
    private Path deleteFilePath = null;

    @Before
    public void setupTest() throws Exception {
        String basePath = this.tempFolder.newFolder().getAbsolutePath();
        this.clock = new MockClock();
        Configuration conf = new Configuration(false);
        conf.set("tez.history.logging.proto-base-dir", basePath);
        conf.set("fs.file.impl", "org.apache.hadoop.fs.RawLocalFileSystem");
        TezProtoLoggers loggers = new TezProtoLoggers();
        loggers.setup(conf, (Clock)this.clock);
        this.manifestLogger = loggers.getManifestEventsLogger();
    }

    @Test(timeout=5000L)
    public void testNormal() throws Exception {
        this.clock.setTime(0L);
        this.createManifestEvents(0L, 8);
        this.clock.setTime(86401000L);
        this.createManifestEvents(86400L, 5);
        DagManifesFileScanner scanner = new DagManifesFileScanner(this.manifestLogger);
        int count = 0;
        while (scanner.getNext() != null) {
            ++count;
        }
        Assert.assertEquals((long)8L, (long)count);
        String offset = scanner.getOffset();
        this.clock.setTime(86461000L);
        count = 0;
        while (scanner.getNext() != null) {
            ++count;
        }
        Assert.assertEquals((long)5L, (long)count);
        scanner.setOffset(offset);
        count = 0;
        while (scanner.getNext() != null) {
            ++count;
        }
        Assert.assertEquals((long)5L, (long)count);
        scanner.close();
    }

    @Test(timeout=5000L)
    public void testError() throws Exception {
        this.clock.setTime(0L);
        this.createManifestEvents(0L, 4);
        this.corruptFiles();
        this.clock.setTime(86401000L);
        this.createManifestEvents(86400L, 1);
        DagManifesFileScanner scanner = new DagManifesFileScanner(this.manifestLogger);
        Assert.assertNotNull((Object)scanner.getNext());
        this.deleteFilePath.getFileSystem(this.manifestLogger.getConfig()).delete(this.deleteFilePath, false);
        Assert.assertNull((Object)scanner.getNext());
        String offset = scanner.getOffset();
        this.clock.setTime(86461000L);
        Assert.assertNotNull((Object)scanner.getNext());
        Assert.assertNull((Object)scanner.getNext());
        scanner.setOffset(offset);
        Assert.assertNotNull((Object)scanner.getNext());
        Assert.assertNull((Object)scanner.getNext());
        scanner.close();
    }

    private void createManifestEvents(long time, int numEvents) throws IOException {
        for (int i = 0; i < numEvents; ++i) {
            ApplicationId appId = ApplicationId.newInstance((long)1000L, (int)i);
            HistoryLoggerProtos.ManifestEntryProto proto = HistoryLoggerProtos.ManifestEntryProto.newBuilder().setAppId(appId.toString()).setDagFilePath("dummy_dag_path_" + i).setDagSubmittedEventOffset(0L).setDagFinishedEventOffset(1L).setAppFilePath("dummp_app_path_" + i).setAppLaunchedEventOffset(2L).setWriteTime(this.clock.getTime()).build();
            ProtoMessageWriter writer = this.manifestLogger.getWriter(appId.toString());
            writer.writeProto((MessageLite)proto);
            writer.close();
        }
    }

    private void corruptFiles() throws IOException {
        int op = 0;
        Configuration conf = this.manifestLogger.getConfig();
        Path base = new Path(conf.get("tez.history.logging.proto-base-dir") + "/dag_meta");
        FileSystem fs = base.getFileSystem(conf);
        for (FileStatus status : fs.listStatus(base)) {
            if (!status.isDirectory()) continue;
            for (FileStatus file : fs.listStatus(status.getPath())) {
                if (!file.getPath().getName().startsWith("application_")) continue;
                switch (op) {
                    case 0: 
                    case 1: {
                        fs.truncate(file.getPath(), op == 1 ? 0L : file.getLen() - 20L);
                        break;
                    }
                    case 3: {
                        this.deleteFilePath = file.getPath();
                    }
                }
                ++op;
            }
        }
    }

    private static class MockClock
    implements Clock {
        private long time = 0L;

        private MockClock() {
        }

        void setTime(long time) {
            this.time = time;
        }

        public long getTime() {
            return this.time;
        }
    }
}

