/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.mapreduce.input;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.LinkedList;
import java.util.Random;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.tez.common.counters.TaskCounter;
import org.apache.tez.common.counters.TezCounter;
import org.apache.tez.common.counters.TezCounters;
import org.apache.tez.dag.api.DataSourceDescriptor;
import org.apache.tez.mapreduce.hadoop.MRInputHelpers;
import org.apache.tez.mapreduce.input.MRInput;
import org.apache.tez.mapreduce.input.MRInputForTest;
import org.apache.tez.mapreduce.protos.MRRuntimeProtos;
import org.apache.tez.runtime.api.InputContext;
import org.apache.tez.runtime.api.InputStatisticsReporter;
import org.apache.tez.runtime.api.events.InputDataInformationEvent;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestMRInput {
    private static final String TEST_ATTRIBUTES_DAG_NAME = "dagName";
    private static final String TEST_ATTRIBUTES_VERTEX_NAME = "vertexName";
    private static final String TEST_ATTRIBUTES_INPUT_NAME = "inputName";
    private static final ApplicationId TEST_ATTRIBUTES_APPLICATION_ID = ApplicationId.newInstance((long)0L, (int)0);
    private static final String TEST_ATTRIBUTES_UNIQUE_IDENTIFIER = "uniqueId";
    private static final int TEST_ATTRIBUTES_DAG_INDEX = 1000;
    private static final int TEST_ATTRIBUTES_VERTEX_INDEX = 2000;
    private static final int TEST_ATTRIBUTES_TASK_INDEX = 3000;
    private static final int TEST_ATTRIBUTES_TASK_ATTEMPT_INDEX = 4000;
    private static final int TEST_ATTRIBUTES_INPUT_INDEX = 5000;
    private static final int TEST_ATTRIBUTES_DAG_ATTEMPT_NUMBER = 6000;
    private static final String TEST_ATTRIBUTES_APPLICATION_ID_STRING = "application_0_0000";
    private static final String TEST_ATTRIBUTES_DAG_ID_STRING = "dag_0_0000_1000";
    private static final String TEST_ATTRIBUTES_VERTEX_ID_STRING = "vertex_0_0000_1000_2000";
    private static final String TEST_ATTRIBUTES_TASK_ID_STRING = "task_0_0000_1000_2000_003000";
    private static final String TEST_ATTRIBUTES_TASK_ATTEMPT_ID_STRING = "attempt_0_0000_1000_2000_003000_4000";

    @Test(timeout=5000L)
    public void test0PhysicalInputs() throws IOException {
        InputContext inputContext = (InputContext)Mockito.mock(InputContext.class);
        DataSourceDescriptor dsd = MRInput.createConfigBuilder((Configuration)new Configuration(false), FileInputFormat.class, (String)"testPath").build();
        ApplicationId applicationId = ApplicationId.newInstance((long)1000L, (int)1);
        ((InputContext)Mockito.doReturn((Object)dsd.getInputDescriptor().getUserPayload()).when((Object)inputContext)).getUserPayload();
        ((InputContext)Mockito.doReturn((Object)applicationId).when((Object)inputContext)).getApplicationId();
        ((InputContext)Mockito.doReturn((Object)TEST_ATTRIBUTES_DAG_NAME).when((Object)inputContext)).getDAGName();
        ((InputContext)Mockito.doReturn((Object)TEST_ATTRIBUTES_VERTEX_NAME).when((Object)inputContext)).getTaskVertexName();
        ((InputContext)Mockito.doReturn((Object)TEST_ATTRIBUTES_INPUT_NAME).when((Object)inputContext)).getSourceVertexName();
        ((InputContext)Mockito.doReturn((Object)"uniqueIdentifier").when((Object)inputContext)).getUniqueIdentifier();
        ((InputContext)Mockito.doReturn((Object)1).when((Object)inputContext)).getTaskIndex();
        ((InputContext)Mockito.doReturn((Object)1).when((Object)inputContext)).getTaskAttemptNumber();
        ((InputContext)Mockito.doReturn((Object)new TezCounters()).when((Object)inputContext)).getCounters();
        ((InputContext)Mockito.doReturn((Object)new JobConf(false)).when((Object)inputContext)).getContainerConfiguration();
        MRInput mrInput = new MRInput(inputContext, 0);
        mrInput.initialize();
        mrInput.start();
        Assert.assertFalse((boolean)mrInput.getReader().next());
        ((InputContext)Mockito.verify((Object)inputContext, (VerificationMode)Mockito.times((int)1))).notifyProgress();
        LinkedList events = new LinkedList();
        try {
            mrInput.handleEvents(events);
            Assert.fail((String)"HandleEvents should cause an input with 0 physical inputs to fail");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IllegalStateException));
        }
    }

    @Test(timeout=5000L)
    public void testAttributesInJobConf() throws Exception {
        InputContext inputContext = (InputContext)Mockito.mock(InputContext.class);
        ((InputContext)Mockito.doReturn((Object)1000).when((Object)inputContext)).getDagIdentifier();
        ((InputContext)Mockito.doReturn((Object)2000).when((Object)inputContext)).getTaskVertexIndex();
        ((InputContext)Mockito.doReturn((Object)3000).when((Object)inputContext)).getTaskIndex();
        ((InputContext)Mockito.doReturn((Object)4000).when((Object)inputContext)).getTaskAttemptNumber();
        ((InputContext)Mockito.doReturn((Object)5000).when((Object)inputContext)).getInputIndex();
        ((InputContext)Mockito.doReturn((Object)6000).when((Object)inputContext)).getDAGAttemptNumber();
        ((InputContext)Mockito.doReturn((Object)TEST_ATTRIBUTES_DAG_NAME).when((Object)inputContext)).getDAGName();
        ((InputContext)Mockito.doReturn((Object)TEST_ATTRIBUTES_VERTEX_NAME).when((Object)inputContext)).getTaskVertexName();
        ((InputContext)Mockito.doReturn((Object)TEST_ATTRIBUTES_INPUT_NAME).when((Object)inputContext)).getSourceVertexName();
        ((InputContext)Mockito.doReturn((Object)TEST_ATTRIBUTES_APPLICATION_ID).when((Object)inputContext)).getApplicationId();
        ((InputContext)Mockito.doReturn((Object)TEST_ATTRIBUTES_UNIQUE_IDENTIFIER).when((Object)inputContext)).getUniqueIdentifier();
        ((InputContext)Mockito.doReturn((Object)new Configuration(false)).when((Object)inputContext)).getContainerConfiguration();
        DataSourceDescriptor dsd = MRInput.createConfigBuilder((Configuration)new Configuration(false), TestInputFormat.class).groupSplits(false).build();
        ((InputContext)Mockito.doReturn((Object)dsd.getInputDescriptor().getUserPayload()).when((Object)inputContext)).getUserPayload();
        ((InputContext)Mockito.doReturn((Object)new TezCounters()).when((Object)inputContext)).getCounters();
        MRInput mrInput = new MRInput(inputContext, 1);
        mrInput.initialize();
        MRRuntimeProtos.MRSplitProto splitProto = MRRuntimeProtos.MRSplitProto.newBuilder().setSplitClassName(TestInputSplit.class.getName()).build();
        InputDataInformationEvent diEvent = InputDataInformationEvent.createWithSerializedPayload((int)0, (ByteBuffer)splitProto.toByteString().asReadOnlyByteBuffer());
        LinkedList<InputDataInformationEvent> events = new LinkedList<InputDataInformationEvent>();
        events.add(diEvent);
        mrInput.handleEvents(events);
        TezCounter counter = mrInput.getContext().getCounters().findCounter((Enum)TaskCounter.INPUT_SPLIT_LENGTH_BYTES);
        Assert.assertEquals((long)counter.getValue(), (long)TestInputSplit.length);
        Assert.assertTrue((boolean)TestInputFormat.invoked.get());
    }

    @Test(timeout=5000L)
    public void testConfigMerge() throws Exception {
        JobConf jobConf = new JobConf(false);
        jobConf.set("payload-key", "payload-value");
        Configuration localConfig = new Configuration(false);
        localConfig.set("local-key", "local-value");
        InputContext inputContext = (InputContext)Mockito.mock(InputContext.class);
        DataSourceDescriptor dsd = MRInput.createConfigBuilder((Configuration)jobConf, TestInputFormat.class).groupSplits(false).build();
        ((InputContext)Mockito.doReturn((Object)dsd.getInputDescriptor().getUserPayload()).when((Object)inputContext)).getUserPayload();
        ((InputContext)Mockito.doReturn((Object)1000).when((Object)inputContext)).getDagIdentifier();
        ((InputContext)Mockito.doReturn((Object)2000).when((Object)inputContext)).getTaskVertexIndex();
        ((InputContext)Mockito.doReturn((Object)3000).when((Object)inputContext)).getTaskIndex();
        ((InputContext)Mockito.doReturn((Object)4000).when((Object)inputContext)).getTaskAttemptNumber();
        ((InputContext)Mockito.doReturn((Object)5000).when((Object)inputContext)).getInputIndex();
        ((InputContext)Mockito.doReturn((Object)6000).when((Object)inputContext)).getDAGAttemptNumber();
        ((InputContext)Mockito.doReturn((Object)TEST_ATTRIBUTES_DAG_NAME).when((Object)inputContext)).getDAGName();
        ((InputContext)Mockito.doReturn((Object)TEST_ATTRIBUTES_VERTEX_NAME).when((Object)inputContext)).getTaskVertexName();
        ((InputContext)Mockito.doReturn((Object)TEST_ATTRIBUTES_INPUT_NAME).when((Object)inputContext)).getSourceVertexName();
        ((InputContext)Mockito.doReturn((Object)TEST_ATTRIBUTES_APPLICATION_ID).when((Object)inputContext)).getApplicationId();
        ((InputContext)Mockito.doReturn((Object)TEST_ATTRIBUTES_UNIQUE_IDENTIFIER).when((Object)inputContext)).getUniqueIdentifier();
        ((InputContext)Mockito.doReturn((Object)localConfig).when((Object)inputContext)).getContainerConfiguration();
        ((InputContext)Mockito.doReturn((Object)new TezCounters()).when((Object)inputContext)).getCounters();
        MRInputForTest input = new MRInputForTest(inputContext, 1);
        input.initialize();
        Configuration mergedConfig = input.getConfiguration();
        Assert.assertEquals((Object)"local-value", (Object)mergedConfig.get("local-key"));
        Assert.assertEquals((Object)"payload-value", (Object)mergedConfig.get("payload-key"));
    }

    @Test
    public void testMRInputCloseWithUnintializedReader() throws IOException {
        InputContext inputContext = (InputContext)Mockito.mock(InputContext.class);
        ((InputContext)Mockito.doReturn((Object)new TezCounters()).when((Object)inputContext)).getCounters();
        ((InputContext)Mockito.doReturn((Object)new InputStatisticsReporterImplForTest()).when((Object)inputContext)).getStatisticsReporter();
        MRInput mrInput = new MRInput(inputContext, 0);
        mrInput.close();
    }

    public static class InputStatisticsReporterImplForTest
    implements InputStatisticsReporter {
        public synchronized void reportDataSize(long size) {
        }

        public void reportItemsProcessed(long items) {
        }
    }

    public static class TestInputSplit
    implements InputSplit {
        public static long length = Math.abs(new Random().nextLong());

        public long getLength() throws IOException {
            return length;
        }

        public String[] getLocations() throws IOException {
            return new String[0];
        }

        public void write(DataOutput out) throws IOException {
        }

        public void readFields(DataInput in) throws IOException {
        }
    }

    static class TestInputFormat
    implements InputFormat {
        private static final AtomicBoolean invoked = new AtomicBoolean(false);

        TestInputFormat() {
        }

        public InputSplit[] getSplits(JobConf job, int numSplits) throws IOException {
            return null;
        }

        public RecordReader getRecordReader(InputSplit split, JobConf job, Reporter reporter) throws IOException {
            Assert.assertEquals((Object)TestMRInput.TEST_ATTRIBUTES_DAG_NAME, (Object)MRInputHelpers.getDagName((Configuration)job));
            Assert.assertEquals((Object)TestMRInput.TEST_ATTRIBUTES_VERTEX_NAME, (Object)MRInputHelpers.getVertexName((Configuration)job));
            Assert.assertEquals((Object)TestMRInput.TEST_ATTRIBUTES_INPUT_NAME, (Object)MRInputHelpers.getInputName((Configuration)job));
            Assert.assertEquals((long)1000L, (long)MRInputHelpers.getDagIndex((Configuration)job));
            Assert.assertEquals((long)2000L, (long)MRInputHelpers.getVertexIndex((Configuration)job));
            Assert.assertEquals((Object)TEST_ATTRIBUTES_APPLICATION_ID.toString(), (Object)MRInputHelpers.getApplicationIdString((Configuration)job));
            Assert.assertEquals((Object)TestMRInput.TEST_ATTRIBUTES_UNIQUE_IDENTIFIER, (Object)MRInputHelpers.getUniqueIdentifier((Configuration)job));
            Assert.assertEquals((long)3000L, (long)MRInputHelpers.getTaskIndex((Configuration)job));
            Assert.assertEquals((long)4000L, (long)MRInputHelpers.getTaskAttemptIndex((Configuration)job));
            Assert.assertEquals((long)5000L, (long)MRInputHelpers.getInputIndex((Configuration)job));
            Assert.assertEquals((long)6000L, (long)MRInputHelpers.getDagAttemptNumber((Configuration)job));
            Assert.assertEquals((Object)TestMRInput.TEST_ATTRIBUTES_APPLICATION_ID_STRING, (Object)MRInputHelpers.getApplicationIdString((Configuration)job));
            Assert.assertEquals((Object)TestMRInput.TEST_ATTRIBUTES_DAG_ID_STRING, (Object)MRInputHelpers.getDagIdString((Configuration)job));
            Assert.assertEquals((Object)TestMRInput.TEST_ATTRIBUTES_VERTEX_ID_STRING, (Object)MRInputHelpers.getVertexIdString((Configuration)job));
            Assert.assertEquals((Object)TestMRInput.TEST_ATTRIBUTES_TASK_ID_STRING, (Object)MRInputHelpers.getTaskIdString((Configuration)job));
            Assert.assertEquals((Object)TestMRInput.TEST_ATTRIBUTES_TASK_ATTEMPT_ID_STRING, (Object)MRInputHelpers.getTaskAttemptIdString((Configuration)job));
            invoked.set(true);
            return new RecordReader(){

                public boolean next(Object key, Object value) throws IOException {
                    return false;
                }

                public Object createKey() {
                    return null;
                }

                public Object createValue() {
                    return null;
                }

                public long getPos() throws IOException {
                    return 0L;
                }

                public void close() throws IOException {
                }

                public float getProgress() throws IOException {
                    return 0.0f;
                }
            };
        }
    }
}

